/*----------------------------------------------------------------------------------+
|                                                                                   |
|                  	             DTMF Receiver                                      |
|                                                                                   |
| Name: DTMFReceiver.c                                                              |
| Purpose:                                                                          |
|	DTMF stands for dual tone multiple frequency. When you press a button on a      |
|	telephone keypad, the telephone will generate two sine waves with different     |
|	frequency at the same time, the audible sounds that you hear. The program start |
|   to initalize the transceiver, then set for receiveing the DTMF tone. When valid |
|   tone is received, it will print the tone digit to LCD and RS232 port. If no tone|
|   is received, print nothing out, and wait. The program demonstration the useage  |
|   of DTMF receiver.                                                               |
|                                                                                   |
| By Dillian Wong, last modify data 27/1/04                                         |
+----------------------------------------------------------------------------------*/

/*___________ I N C L U D E S ______________________________________________________*/

#include <reg51.h>
#include <stdio.h>
#include <ctype.h>					//use toint()
#include "MT8880C\configMT8880C.h"
#include "LCDDriver\LCDConfig.h"

sbit toneLamp = P3^7;
#define toneLampOn 	toneLamp=0;
#define toneLampOff toneLamp=1;
/*____________ M A I N  P R O G R A M ______________________________________________*/

// com port with 9600 baud with crystal 11.0592MHz.
void init_uart(void)
{
	SCON  = 0x50;		        
    TMOD |= 0x20;               
    TH1   = 253;                
    TR1   = 1;                 
    TI    = 1; 
}

/*
	main program to implement MT8880C DTMF Transceiver
*/
void main(void)
{
	char chDigit;		// tone digit
	int i=0;
		
	init_uart();		// utilize rs232 port
	turnOnLCD();		// turn on LCD 
	turnOnRS232();		// turn on RS232
	toneLampOff;

	MT8880C_Reset();	//software reset.
	LCD_Locate(1);
	printf("\nDTMF Decoder");
	printf("\nReceived Tone : ");
	while(1){
		chDigit = MT8880C_ReceiveDTMF_tone();	
		if(chDigit!='N')			// if no valid tone, 'N' will return
		{
			toneLampOn;
			printf("%c",chDigit);			
			for(i=0;i<4000;i++);
			toneLampOff;
		}
	}
}