
/*___________ I N C L U D E S ______________________________________________________*/

#include <reg51.h>
#include <stdio.h>
#include <ctype.h>					//use toint()
#include "MT8880C\configMT8880C.h"
#include "Eeprom\EepromConfig.h"
#include "DS1620\Ds1620.h"
#include "config.h"

/*____________ M A I N  P R O G R A M ______________________________________________*/

char code menu[] = // menu of DTMF Transceiver
	"\n--Integrated DTMF Transceiver-1.2-"
	"\n1 Dial a phone by keying"
	"\n2 Dial a phone stored in Eeprom with Temperature Data"
	"\n3 Dial a phone stored in Eeprom"
	"\n4 Save a phone No. to Eeprom"
	"\n5 Load a phone No. in Eeprom"
	"\n6 Init Temperature Sensor"
	"\n7 Read current Temperature"
	"\n8 transmit temperature in DTMF tone"
	;

// com port with 9600 baud with crystal 11.0592MHz.
void init_uart(void)
{
	SCON  = 0x50;		        
    TMOD |= 0x20;               
    TH1   = 253;                
    TR1   = 1;                 
    TI    = 1; 
}

/*
	main program to implement MT8880C DTMF Transceiver
*/
void main(void)
{
	char cmd;		// selection 
	char chDigit;	// tone digit

	init_uart();	// utilize rs232 port
	printf(menu);	// print menu.

	while(1){
		printf( "\n[Enter selection:] " );
		scanf("%c", &cmd);
		switch(cmd)
		{
			case '1':
						printf("\nsoftware reset  :");
						MT8880C_Reset();	// software reset.	
						printf("Dial a phone");
						printf("\n?Digit : ");
						MT8880C_SetForTransmit_tone();		//setting before transmit a tone
						do
						{
							scanf("%c",&chDigit);
							MT8880C_TransDTMF_tone(chDigit);
						}
						while(chDigit!='q');
						printf("\n....ok!");
						break;
		
			case '3':   dialPhoneInEeprom();				break;
			case '4':	savePhoneNotoEeprom();				break;
			case '5':	loadPhoneNofromEeprom();			break;
			case '6':   ds1620_init(10,40);					break;
			case '7':  	printf("\nCurrent temperature is: ");
						printf("%f",ds1620_ReadTemperature());
						break;
			case '8':   dialPhoneAccordingTemperature();	break;				
			case '?':	printf(menu);						break;
		}
	}
	
}