/*------------------------------------------------------------------------------------|
| Name: Eepromconfig.h                                                                |
| Purpose:                                                                            |
| config the hardware setting, define the hardware control pin with a notation name   |
| select the require lib for the MPU, and define the protocal for the program access  |
|------------------------------------------------------------------------------------*/


/*____________ H A R D W A R E  _________________________________________________________________*/

sbit    SCL = P3^4;							// i2c clock pin
sbit    SDA = P3^3;							// i2c data pin

/*____________ M A C R O S ______________________________________________________________________*/

#define setSCL		SCL=1;while(SCL!=1);
#define clrSCL		SCL=0;
#define setSDA		SDA=1;
#define clrSDA		SDA=0;

#define PAGE_SIZE		7					// max no. of page size for read/ write
#define SLAVE_ADDRESS   0x50				// the address of the i2c slave

/*____________ P R O T O C O L _________________________________________________________________*/

// EepromBasic.c
void sendStart(void);
void sendStop(void);      
void sendByte(unsigned char); 
unsigned char getByte(void);  
void sendSlaveAddress(unsigned char b);
void waitAck(void);
void masterAck(void);
void masterNoAck(void);
void sendBitIndicateWrite(void);
void sendBitIndicateRead(void);

// EepromAdvanced.c
void write_Byte(unsigned char eepromAddr, eepromData);
void write_Page(unsigned char eepromAddr, unsigned char wrbuf[PAGE_SIZE]);
unsigned char read_Byte(unsigned char eepromAddr);

// EepromCheck.c
void eepromCheck(void);

// EepromAccess.c
void saveChar(unsigned char addr,unsigned char ch);
unsigned char loadChar(unsigned char addr);
void saveInt(unsigned char addr, int intData);
int loadInt(unsigned char addr);

