/*
	Name : LcdAccess.c
	purpose:
			
	
*/


/*____________ I N C L U D E S ________________________________________________________________*/

#include <reg51.h>
#include <stdio.h>
#include "LCDConfig.h"

/*____________ M A C R O S ____________________________________________________________________*/

#define true 	1
#define	false 	0

/*____________ P R O T O C O L ________________________________________________________________*/

char standard_putchar (char c);
char LCD_putchar(char c);
void disp_init(void);

/*____________ V A R I A B L I E S _____________________________________________________________*/

bit isRS232 = true;
bit isLCD = false;


/*____________ F U N C T I O N ________________________________________________________________*/


/*
	replace the standard putchar by adding a extra instruction.
*/
char putchar(char c) 
{
	char ch;
	if(isRS232)
		ch = standard_putchar(c);
	if(isLCD)
		ch = LCD_putchar(c);
	return c;
}

/*
	flag used to indicate the status of display. Whether the lcd, com port should display the data
	out or not.
*/
void turnOnLCD(void)	{	disp_init(); isLCD=true;		}	// indicate lcd on
void turnOffLCD(void)	{ 	isLCD=false;	}					// indicate lcd off
void turnOnRS232(void)	{	isRS232=true;	}					// indicate com port on
void turnOffRS232(void) {   isRS232=false;	}					// indicate com port off
bit  isLCDOn(void)		{	return isLCD;	}					// indicate where LCD is on or off
bit  isRS232On(void)	{	return isRS232;	}					// indicate where RS232 is on of off.

