/*
  Name :  LCDConfig.h
	
  Header file for Driver_Lcd16x2.c, LCDAccess.c.

*/


/*____________ H A R D W A R E ____________________________________________________*/

sbit ENABLE   =  P0^2; 						// display enable output (EN)
sbit RDWR 	  =  P0^1; 						// display access mode output (RW)
sbit REGSEL   =  P0^0; 						// display register select output (DI)
sfr  DISPDATA =  0xA0; 						// data bus to the display panel,P2

/*____________ P R O T O C O L ____________________________________________________*/

// LCDAccess.c
void turnOnLCD(void);						// turn on LCD, default is off
void turnOffLCD(void);						// turn off LCD
void turnOnRS232(void);						// turn on RS232 port
void turnOffRS232(void);					// turn on RS232 port
bit  isLCDOn(void);							// indicate where LCD is on or off
bit  isRS232On(void);						// indicate where RS232 is on of off.

// Driver_Lcd16x2.c
void LCD_Locate(int p);						// location the DD ram position of LCD
void LCD_Clr(int s, int e);					// clear the DD ram data from position s
											// to e.

