#include <reg51.h>
#include <stdio.h>
#include <ctype.h>					//use toint()
#include "MT8880C\configMT8880C.h"
#include "Eeprom\EepromConfig.h"
#include "rprintf\rprintf.h"
#include "DS1620\Ds1620.h"

/*
	save the digit to Eeprom, until receive a enter key. sAddr stored the total number of
	digit of the phone number.
*/
void savePhoneNotoEeprom(void)
{
	char p,sAddr=0x40,addr;
	int totalDigit=0;
	addr=sAddr;

	printf("\nSave phone no. to Eerpom");
	printf("\nNo? : ");
	do											// save the phone no to Eeprom
	{
		scanf("%c",&p);							// get phone No.
		saveChar(addr+1,p);						// save phone No.
		totalDigit++;
		addr++;
	}while(p!='\n');
	totalDigit--;
	saveChar(sAddr,totalDigit);					// used to stored the total number of digit.
}

/*
	load and print the phone number stored in Eeprom. The start address stored the total
	number of digit. That used to determine how long the phone digit is valid.
*/
void loadPhoneNofromEeprom(void)
{
	char addr=0x40;
	int i=0,totalDigit;

	totalDigit=loadChar(addr);				// starting address stored the total number 
											// of phone digit.
	printf("\nPhone No stored in Eeprom : ");
	do										// load the phone no to Eeprom
	{
		printf("%c",loadChar(addr+1));
		i++;
		addr++;
	}while(i<totalDigit);
}

/*
	dial the phone number that stored in Eeprom. when load a digit, it will transmit a tone 
	and print it out immediately.
*/
void dialPhoneInEeprom(void)
{
	char addr=0x40;
	char chDigit;
	int i=0,j=0,totalDigit;

	printf("\nTransmit the phone\n");
	/* setting before DTMF tone Transmit */
	MT8880C_Reset();						// software reset.
	MT8880C_SetForTransmit_tone();			//setting before transmit a tone

	/* Load & dial */
	totalDigit=loadChar(addr);				// starting address stored the total number 
											// of phone digit.
	do										// load the phone no to Eeprom
	{
		chDigit=loadChar(addr+1);			// load digit
		MT8880C_TransDTMF_tone(chDigit);	// send tone.
		for(j=0;j<30000;j++);
		printf("%c",chDigit);				// digit print out
		i++;
		addr++;	
	}while(i<totalDigit);	
}

/*
	send the tone according the measuring temperature. This function will get the temperature form
	sensor first then convert it to tone digit for transmition.
*/
void dialPhoneAccordingTemperature(void)
{
	float flt;											// floating temperature reading
	int num;											// float--> integer
	unsigned char a,b,c,d;								// for the segment of floating
	char chDigit;
	int j;


	/* setting before DTMF tone Transmit */
	MT8880C_Reset();									// software reset.
	MT8880C_SetForTransmit_tone();						//setting before transmit a tone

	ds1620_init(10,40);									// initalize DS1620
	flt = ds1620_ReadTemperature();						// get temperature reading.

	num=flt*10;		// convert floating digit to integer, as only one floating point

	/* This program code is direct copy from printInt. Change the putChar to chDigit. Then */
	/* use MT8880C.c function to send dtmf tone											   */
	a=num/0x03E8;										// digit 1(MSB)
	b=(num-a*0x03E8)/0x64;								// digit 2
	c=(num-a*0x03E8-b*0x64)/0x0A;						// digit 3
	d=num-a*0x03E8-b*0x64-c*0x0A;						// digit 4(LSB)
	
	printf("\n");
	chDigit = '#';										// indicate the following is temperature
	MT8880C_TransDTMF_tone(chDigit);					// data.
	for(j=0;j<30000;j++);
		printf("%c",chDigit);

	if(a!=0x00){										// no. print out
		chDigit = hex2ascii(a);
		MT8880C_TransDTMF_tone(chDigit);				// send tone.
		for(j=0;j<30000;j++);
		printf("%c",chDigit);	
	}
	if((a+b)!=0x00){
		chDigit = hex2ascii(b);
		MT8880C_TransDTMF_tone(chDigit);				// send tone.
		for(j=0;j<30000;j++);
		printf("%c",chDigit);	
	}
	if((a+b+c)!=0x00){
		chDigit = hex2ascii(c);
		MT8880C_TransDTMF_tone(chDigit);				// send tone.
		for(j=0;j<30000;j++);
		printf("%c",chDigit);	
	}
	if((a+b+c+d)!=0x00){
		chDigit = hex2ascii(d);
		MT8880C_TransDTMF_tone(chDigit);				// send tone.
		for(j=0;j<30000;j++);
		printf("%c",chDigit);	
	}


} 


