/*----------------------------------------------------------------------------------+
|                                                                                   |
|                             Print Integer                                         |
|                                                                                   |
| Name: printInt.c                                                                  |                                                            |
| Purpose:                                                                          |
|   print the integer to  the streaming output.                                     |
+----------------------------------------------------------------------------------*/

/*____________ I N C L U D E S ____________________________________________________*/

#include <reg51.h>
#include <stdio.h>

/*____________ P R O T O C O L ____________________________________________________*/
void printInt(int num);
unsigned char hex2ascii(unsigned char bits_data);

/*____________ F U N C T I O N ____________________________________________________*/
/*
	print interger
*/
void printInt(int num)
{
	unsigned char a,b,c,d;
	if(num<0)											// if num is negative
	{													// take 2 complement
		putchar('-');										
		num=~num+1;
	}
	if(num==0)											// if num is zero, print
	{													// zero
		putchar('0');
	}
	a=num/0x03E8;										// digit 1(MSB)
	b=(num-a*0x03E8)/0x64;								// digit 2
	c=(num-a*0x03E8-b*0x64)/0x0A;						// digit 3
	d=num-a*0x03E8-b*0x64-c*0x0A;						// digit 4(LSB)
	
	if(a!=0x00)											// no. print out
		putchar(hex2ascii(a));
	if((a+b)!=0x00)
		putchar(hex2ascii(b));
	if((a+b+c)!=0x00)
		putchar(hex2ascii(c));
	if((a+b+c+d)!=0x00)
		putchar(hex2ascii(d));
}
/*
	convert the hex data(4 bits) to ascii code(8 bits)
*/
unsigned char hex2ascii(unsigned char bits_data)
{
	if(bits_data >=0x0f)								// all invalid data return 'F'
	{
		return 0x46;
	}
	if (bits_data >=0x00 & bits_data <=0x09)			// return '0'-'9'
	{
		bits_data +=0x30;
		return bits_data;
	}
	if (bits_data >=0x0a & bits_data <=0x0f);			// return 'A'-'F'
	{
		bits_data +=0x37;
		return bits_data;
	}
}
