/*------------------------------------------------------------------------------------|
| Name: advanced.c                                                                    |
| Purpose:                                                                            |
| provide the advanced function of the i2c eeprom. write byte, read byte, write page  |
| and sequential read.(PS: function read_Byte is call by value, read_Page is call by  |
| address)                                                                            |
|------------------------------------------------------------------------------------*/

#include <reg51.h>
#include <stdio.h>
#include "Eepromconfig.h"

/* 
	write a byte to i2c devices.
*/
void write_Byte(unsigned char eepromAddr, wrData) 
{
	sendStart();							// start
	sendSlaveAddress(SLAVE_ADDRESS);		// 7 bit slave address
	sendBitIndicateWrite();					// a bit for write mode
	waitAck();
	sendByte(eepromAddr);					// eeprom address
	waitAck();
	sendByte(wrData);						// a data
	waitAck();
	sendStop();								// byte written completed
}

/* 
	write a page to i2c devices, eepromAddr indicate the starting address for write
	and eepromAddr + PAGE_SIZE is the ending adddress. the data for write is store in
	array wrbuf[]. the array is pass by address that the caller determined.
*/
void write_Page(unsigned char eepromAddr, unsigned char wrbuf[PAGE_SIZE]) 
{
	unsigned int i;
	sendStart();							// start notation
	sendSlaveAddress(SLAVE_ADDRESS);		// 7 bit slave address
	sendBitIndicateWrite();					// a bit for write mode
	waitAck();
	sendByte(eepromAddr);					// eeprom address
	waitAck();
	for(i=0;i<PAGE_SIZE;i++)				// send the data for write
	{
		sendByte(wrbuf[i]);					// some data
		waitAck();
	}
	sendStop();								// page written completed
}

/*
	read a byte in a particular address of eeprom memory, and return a readed value 
	to the caller.
*/
unsigned char read_Byte(unsigned char eepromAddr)
{
	unsigned char rcvdata=0x00;
	
	/* set the ptr of eeprom address */
	sendStart();							// set the eeprom location address	
	sendSlaveAddress(SLAVE_ADDRESS);		// 7 bit address for slave location		
	sendBitIndicateWrite();					// bit indicated for write mode to 			
	waitAck();								// set the memory address of eeprom
	sendByte(eepromAddr);
	waitAck();

	/* current address read */
	sendStart();										
	sendSlaveAddress(SLAVE_ADDRESS);		
	sendBitIndicateRead();				
	waitAck();
	rcvdata=getByte();
	masterNoAck();					
	sendStop();								// read completed
	return rcvdata;
}


