/*------------------------------------------------------------------------------------|
| Name: Eeprombasic.c                                                                 |
| Purpose:                                                                            |
| provide the basic level control for the conbined advanced function. Eg, send a start|
| notation, stop notation, send a slave address, byte and ackledgement.               |
|------------------------------------------------------------------------------------*/

#include <reg51.h>
#include <stdio.h>
#include "Eepromconfig.h"

// a start notation for the i2c slave
void sendStart(void){
	int i;
	setSDA;
	setSCL;
	clrSDA;
	clrSCL;
	for(i=0;i<100;i++);							// delay for work
}

// a stop notation for the i2c slave
void sendStop(void){
	int i;	
	clrSDA;			
	setSCL;			
	setSDA;		
	clrSCL;
	for(i=0;i<100;i++);							// delay for work
}

// sends one byte of data to a i2c slave
void sendByte(unsigned char b){
	unsigned char mask;
	mask = 0x80;
	do{											// send 8 bits 
		if ( b & mask ){					
		  setSDA;								// bit is high
		}
		else{
		  clrSDA;								// bit is low
		}
		setSCL;									// toggle a clock
		clrSCL;		
		mask = mask/2;							// shift mask right
	}while (mask>0);
}

// gets one byte of data from i2c device
unsigned char getByte(void){
	int i;
	unsigned char rcvdata=0x00;
	unsigned char  mask;						// variable for getting the reading data

	mask = 0x80;						
	do{											// store 8 bit data
		setSCL;									// negative edge clock data out 
		for(i=0;i<50;i++);						// delay for work
		if (SDA==1) 					 
		  rcvdata |= mask;
		clrSCL;	
		for(i=0;i<50;i++);						// delay for work						
		mask = mask/2;					
	}while (mask>0);
	return rcvdata;
}

// sends lower 7 bit of data to a i2c slave
void sendSlaveAddress(unsigned char b){
	unsigned char mask;
	mask = 0x80;
	b*=2;										// shift b left
	do{											// send 7 bits 
		if ( b & mask ){					
		  setSDA;								// bit is high
		}
		else{
		  clrSDA;								// bit is low
		}
		setSCL;									// toggle a clock
		clrSCL;		
		mask = mask/2;							// shift mask right
	}while (mask>1);	
}

// wait until acknoledgment is receviced from slave
void waitAck(void){
	int i;
	for(i=0;i<50;i++);							// delay for work
	setSDA;										// realease SDA for acknowledge
  	setSCL;										// send clock for acknowledge
	while(SDA);
  	clrSCL;
	for(i=0;i<50;i++);							// delay for work
}

// master acknoledge by sending a clr bit to slave
void masterAck(void){
	clrSDA;
	setSCL;
	clrSCL;
}

// master disacknoledge by sending a set bit to slave
void masterNoAck(void){
	setSDA;
	setSCL;
	clrSCL;
}

// a bit after the slave address, clr indicate i2c write
void sendBitIndicateWrite(void){
	clrSDA;
	setSCL;	
	clrSCL;									
}

// a bit after the slave address, set indicate i2c read
void sendBitIndicateRead(void){
	setSDA;
	setSCL;	
	clrSCL;								
}
