/*-----------------------------------------------------------------------------------------------|
|                                                                                                |
|                                Eeprom Doctor (AT24C16A)                                        |
|                                                                                                |
|  Name   : EepromCheck.c                                                                        |
|  Purpose:                                                                                      |
|      Provide a interface for easier to check the operation of the eeprom AT24C16A. Via this    |
|      function, user can check the pin connection; read byte; write byte and write page         |
|      operation of I2C device AT24C16. Extra functions are included for better character display|
|      and show the result of checking.                                                          |
|-----------------------------------------------------------------------------------------------*/


/*____________ I N C L U D E S _________________________________________________________________*/

#include <reg51.h>
#include <stdio.h>
#include "Eepromconfig.h"

/*____________ P R O T O C O L _________________________________________________________________*/

void eeprom_printHex8(unsigned char hexdata);
unsigned char eeprom_hex2ascii(unsigned char bits_data);
void eepromCheck(void);


/*_____FUNCTION USED TO CHECK EEPROM OPERATION__________________________________________________*/

/*
	provide a interface for easier to check the operation of the eeprom.
*/
void eepromCheck(void)
{
	unsigned char rcvdata;
	unsigned char databuf[PAGE_SIZE]={0x01,0x02,0x03,0x04,0x05,0x06,0x07};
	char cmd;
	int i;

	printf("\nEeprom Doctor");				// title
	printf("\n1. setSDA"					// menu
		   "\n2. clrSDA"	
		   "\n3. setSCL"
		   "\n4. clrSCL"
		   "\np. write page from address 0x30-0x36"
		   "\nw. write byte from address 0x30-0x36"
		   "\nr. read byte from address 0x30-0x36"
		   );

	while(1)
	{
		printf("\n[Enter selection : ]");
		scanf("%c",&cmd);
	
		switch(cmd)
		{
			case '1':	printf("\nsetSDA");	setSDA;	break;			// pin check.
			case '2':	printf("\nclrSDA");	clrSDA;	break;
			case '3':	printf("\nsetSCL");	setSCL;	break;
			case '4':	printf("\nclrSCL");	clrSCL;	break;

			case 'p':   printf("\nwrite page");						// page write
						write_Page(0x30,databuf);
						printf("....ok!");	
						break;

			case 'w':	printf("\nwrite Byte");						// byte write
						write_Byte(0x30,0x12);
						write_Byte(0x31,0x34);
						write_Byte(0x32,0x56);
						write_Byte(0x33,0x78);
						write_Byte(0x34,0x90);
						write_Byte(0x35,0xab);
						write_Byte(0x36,0xcd);
						printf("....ok");
						break;

		   case 'r':	printf("\nread Byte\n");		// byte read
						for(i=0;i<7;i++)
						{
							rcvdata=read_Byte(0x30+i);
							eeprom_printHex8(rcvdata);
							printf("  ");
						}
						break;
		}//endofswitch
	}//endofwhile
}



/*_____EXTRA FUNCTION FOR PRINTING HEX DATA ____________________________________________________*/

/*
	print 8 bit hex data
*/
void eeprom_printHex8(unsigned char hex8)
{
	char hex8H,hex8L;
	hex8L = eeprom_hex2ascii(hex8&0x0f);				// convert low byte
	hex8H = eeprom_hex2ascii((hex8&0xf0)/0x0f);        	// convert high byte
	putchar(hex8H);										// print out
	putchar(hex8L);
}

/*
	convert the hex data(4 bits) to ascii code(8 bits)
*/
unsigned char eeprom_hex2ascii(unsigned char bits_data)
{
	if(bits_data >=0x0f)								// all invalid data return 'F'
	{
		return 0x46;
	}
	if (bits_data >=0x00 & bits_data <=0x09)			// return '0'-'9'
	{
		bits_data +=0x30;
		return bits_data;
	}
	if (bits_data >=0x0a & bits_data <=0x0f);			// return 'A'-'F'
	{
		bits_data +=0x37;
		return bits_data;
	}
}
