/*____________ I N C L U D E S ____________________________________________________*/

#include <reg51.h>
#include <stdio.h>

/*____________ H A R D W A R E ____________________________________________________*/

sbit CS = P1^5;	// control
sbit RS = P1^4;
sbit RW = P1^7;
sbit b3 = P1^3;	// data 
sbit b2 = P1^2;
sbit b1 = P1^1;
sbit b0 = P1^0;

/* set or clr of important PIN */
#define setCS CS=1;while (CS!=1); // chip select, clr for select
#define clrCS CS=0;
#define setRS RS=1;while (RS!=1); // register select, set for select
#define clrRS RS=0;
#define setRW RW=1;while (RW!=1); // read write, set for read, clr for write
#define clrRW RW=0;

/*____________ P R O T O C O L ____________________________________________________*/

void MT8880C_Reset(void);
void MT8880C_SetForTransmit_tone(void);
void MT8880C_TransDTMF_tone(char ch);
int getToneDigit(char ch);


/*____________ F U N C T I O N ____________________________________________________*/

/*
	A software reset must be included at the beginning of all programs to initialize the 
	control registers after power up. The initialization procedure should be implemented
	100ms after power up.
*/
void MT8880C_Reset(void)
{
	int i;

	setCS;		//1) read status register
	setRS;setRW;
	clrCS;
	for(i=0;i<3;i++);
	setCS;

	setCS;		//2) write to control register
	setRS;clrRW;b3=0;b2=0;b1=0;b0=0;
	clrCS;
	for(i=0;i<3;i++);
	setCS;

	setCS;		//3) write to control register
	setRS;clrRW;b3=0;b2=0;b1=0;b0=0;
	clrCS;
	for(i=0;i<3;i++);
	setCS;

	setCS;		//4) write to control register
	setRS;clrRW;b3=1;b2=0;b1=0;b0=0;
	clrCS;
	for(i=0;i<3;i++);
	setCS;

	setCS;		//5) write to control register
	setRS;clrRW;b3=0;b2=0;b1=0;b0=0;
	clrCS;
	for(i=0;i<3;i++);
	setCS;

	setCS;		//6) read status register
	setRS;setRW;
	clrCS;
	for(i=0;i<3;i++);
	setCS;

}
/*
	setting before transmit a tone.
*/
void MT8880C_SetForTransmit_tone(void)
{
	int m;

	/*tone out, DTMF, IRQ, select control regiser B*/
	setCS;					//write to control register A
	setRS;	clrRW;	b3=1;	b2=1;	b1=0;	b0=1;
	clrCS;					//toggle chip select to fatch the input data
	for(m=0;m<3;m++);
	setCS;
	
	/*burst mode*/
	setCS;					//write to control register B
	setRS;	clrRW;	b3=0;	b2=0;	b1=0;	b0=0;
	clrCS;					//toggle chip select to fatch the input data
	for(m=0;m<3;m++);
	setCS;
}

/*
	Transmit a DTMF tone, ch is the tone digit (0-9,*,#,A-D)
*/
void MT8880C_TransDTMF_tone(char ch)
{
	int m;
	int i=0,j=0,k=0,l=0,digit;

	digit=getToneDigit(ch);	//get the interger that represent the tone

	i=(digit&0x0008)/8;		//calculate the b3,b2,b1,b0
	j=(digit&0x0004)/4;
	k=(digit&0x0002)/2;
	l=(digit&0x0001)/1;

//	printf("\ndigit is : %d",digit);	//check the data bits b3-b0
//	printf("\ni     is : %d",i);
//	printf("\nj     is : %d",j);
//	printf("\nk     is : %d",k);
//	printf("\nl     is : %d",l);

	setCS;					//write to transmit data register
	clrRS;	clrRW;	b3=i;	b2=j;	b1=k;	b0=l;
	clrCS;					//toggle chip select to fatch the input data
	for(m=0;m<3;m++);
	setCS;
}


/*
	return the interger that represent the digal number or character.
	1-9,0,*,#,A-D.
*/
int getToneDigit(char ch)
{
	int digit;

	switch(ch)	
	{
		case '1' :
					digit=1;
					break;
		case '2':
					digit=2;
					break;
		case '3':
					digit=3;
					break;
		case '4':
					digit=4;
					break;
		case '5':
					digit=5;
					break;
		case '6':
					digit=6;
					break;
		case '7':
					digit=7;
					break;
		case '8':
					digit=8;
					break;
		case '9':
					digit=9;
					break;
		case '0':
					digit=10;
					break;
		case '*':
					digit=11;
					break;
		case '#':
					digit=12;
					break;
		case 'A':
					digit=13;
					break;
		case 'B':
					digit=14;
					break;
		case 'C':
					digit=15;
					break;
		case 'D':
					digit=16;
					break;
		default:	
					digit=0;
					break;
	}
	return digit;
}

