/*-----------------------------------------------------------------------------------+
|                                                                                    |
|                       DTMF Transmitter with Temperature sensor                     |
|                                                                                    |
| File Name : digitControl.c                                                         |
| purpose :                                                                          |
|       This program provide the basic interface for the DTMF transmitter, the       |
|       program can send the phone number stored in Eeprom, and send the temperature |
|       data in DTMF tone. of cource, through RS232, Eeprom phone number can be      |
|       changed.                                                                     |
+-----------------------------------------------------------------------------------*/

/*___________ I N C L U D E S ______________________________________________________*/

#include <reg51.h>
#include <stdio.h>
#include <ctype.h>					//use toint()
#include "MT8880C\configMT8880C.h"
#include "Eeprom\EepromConfig.h"
#include "DS1620\Ds1620.h"
#include "config.h"

/*____________ F U N C T I O N  S E L E C T ________________________________________*/

// menu
char code menu[] = // menu of DTMF Transceiver
	"\n--Integrated DTMF Transceiver-1.3-"
	"\n1 Dial a phone digit by keying"
	"\n2 Dial the phone number stored in Eeprom"
	"\n3 transmit temperature data in DTMF tone"
	"\n4 Save a phone No. to Eeprom"
	"\n5 Load a phone No. in Eeprom"
	"\n6 Read current Temperature"
	;

// meun function
void selectFunction (void)
{
	char cmd;		// selection 
	char chDigit;	// tone digit

	scanf("%c", &cmd);	
	switch(cmd)
	{
		case '1':
					turnOffTimer0();
					printf("\nsoftware reset  :");
					MT8880C_Reset();	// software reset.	
					printf("Dial a phone, press 'q' to exit");
					printf("\n?Digit : ");
					MT8880C_SetForTransmit_tone();		//setting before transmit a tone
					do
					{
						scanf("%c",&chDigit);
						MT8880C_TransDTMF_tone(chDigit);
					}
					while(chDigit!='q');
					printf("\n....ok!");
					turnOnTimer0();
					break;
		case '2':   turnOffTimer0();  
					dialPhoneInEeprom();
					turnOnTimer0();		
					break;
		case '3':   turnOffTimer0(); 
	 				dialPhoneAccordingTemperature();
					turnOnTimer0();
					break;		
		case '4':	turnOffTimer0();  
					savePhoneNotoEeprom();     
					turnOnTimer0();			
					break;
		case '5':	turnOffTimer0();  
					loadPhoneNofromEeprom();	
					turnOnTimer0();
					break;
		case '6':   turnOffTimer0();
					ds1620_init(10,40);	
				 	printf("\nCurrent temperature is: ");
					printf("%f",ds1620_ReadTemperature());
					turnOnTimer0();
					break;		
		case '?':	printf(menu);		
	}
}

/*____________ T I M E R 0  &  U A R T _____________________________________________*/

// com port with 9600 baud with crystal 11.0592MHz.
void init_uart(void)
{
	SCON  = 0x50;		        
    TMOD |= 0x20;               
    TH1   = 253;                
    TR1   = 1;                 
    TI    = 1; 
}

// initalize 16 bits timer0, with time interval equal 0.05s
void init_Timer0(void)
{
	TMOD |= 0x01; // set time0 as mode0
	TH0=(65536-46079)/256; // count 46080 machine cycle
	TL0=(65536-46079)%256; // 1 machine cycle = 12/11.0598M = 1.085us
	IE |=0x82; // 46080x1.085u=0.05s
	TR0=1;
}

// turn on timer0
void turnOnTimer0(void)
{
	TR0=1;
}

// turn off timer0
void turnOffTimer0(void)
{
	TR0=0;
}

// when timer0 time up, execute the code.
void timer0_ISR (void) interrupt 1
{
	TH0=(65536-46900)/256; // reset the timer 0.
	TL0=(65536-46900)%256; //fine tune. as crystal may not exactly 11.0598MHz
	P2 = 0xff;;

	/* send current temperature */
	if (P2 ==0xFE) //P2^0 = 0 
	{
	   	 turnOffTimer0();	
		 printf("\nSend data : ");
		 dialPersonID();
		 ds1620_init(10,40);
		 dialPhoneAccordingTemperature();
		 turnOnTimer0();
	}
	/* dial phone stored in Eeprom */
	if (P2 ==0xFD) //P2^1 = 0
	{
		 turnOffTimer0();
		 printf("\nSend phone Number stored in Eeprom : ");
		 dialPhoneInEeprom();
	     turnOnTimer0();
	}
}


/*____________ M A I N  P R O G R A M ______________________________________________*/

/*
	Main program of the DMFT Transmitter.
*/
void main(void)
{
	init_uart();	// utilize rs232 port
	printf(menu);	// print menu.
	init_Timer0(); // 0.05s time interval of time 0;	
	MT8880C_Reset();
	while(1)
	{
		printf("\n[Enter selection : ]");
		selectFunction();
	}
	
}