/* This is a custom procedure for GUI */

int 
d_ghide_proc (int msg, DIALOG * d, int c)
{
  int state1, state2;
  int swap;
  int g;
  int oneclick;

  switch (msg)
    {


    case MSG_WANTFOCUS:
      return D_WANTFOCUS;

    case MSG_KEY:
      /* close dialog? */
      if (d->flags & D_EXIT)
	return D_CLOSE;

      /* or just toggle */
      d->flags ^= D_SELECTED;
      show_mouse (NULL);
      SEND_MESSAGE (d, MSG_DRAW, 0);
      show_mouse (screen);
      break;

    case MSG_CLICK:
      /* what state was the button originally in? */
      state1 = d->flags & D_SELECTED;
      if (d->flags & D_EXIT)
	swap = FALSE;
      else
	swap = state1;

      /* track the mouse until it is released */
      while (mouse_b)
	{
	  state2 = ((mouse_x >= d->x) && (mouse_y >= d->y) &&
		    (mouse_x <= d->x + d->w) && (mouse_y <= d->y + d->h));
	  if (swap)
	    state2 = !state2;

	  /* redraw? */
	  if (((state1) && (!state2)) || ((state2) && (!state1)))
	    {
	      d->flags ^= D_SELECTED;
	      state1 = d->flags & D_SELECTED;
	      show_mouse (NULL);
	      SEND_MESSAGE (d, MSG_DRAW, 0);
	      show_mouse (screen);
	    }
	}

      /* should we close the dialog? */
      if ((d->flags & D_SELECTED) && (d->flags & D_EXIT))
	{
	  d->flags ^= D_SELECTED;
          oneclick=TRUE;
	  return TRUE;
	}
      break;

    case MSG_DCLICK:
      /* what state was the button originally in? */
      state1 = d->flags & D_SELECTED;
      if (d->flags & D_EXIT)
	swap = FALSE;
      else
	swap = state1;

      /* track the mouse until it is released */
      while (mouse_b)
	{
	  state2 = ((mouse_x >= d->x) && (mouse_y >= d->y) &&
		    (mouse_x <= d->x + d->w) && (mouse_y <= d->y + d->h));
	  if (swap)
	    state2 = !state2;

	  /* redraw? */
	  if (((state1) && (!state2)) || ((state2) && (!state1)))
	    {
	      d->flags ^= D_SELECTED;
	      state1 = d->flags & D_SELECTED;
	      show_mouse (NULL);
	      SEND_MESSAGE (d, MSG_DRAW, 0);
	      show_mouse (screen);
	    }
	}

      /* should we close the dialog? */
      if ((d->flags & D_SELECTED) && (d->flags & D_EXIT))
	{
	  d->flags ^= D_SELECTED;
	  return D_CLOSE;
	}
      break;
    }

  return D_O_K;
}
