#include "include/glbtypes.h"
#include "include/glbproto.h"
#include "include/globvars.h"

listnode clean_up_mcode(listnode l)
{
  if(l==NULL)
    return NULL;
  if((l->attr==PARTOFOP)
     &&(l->data==NULL))
    return clean_up_mcode(rm_cdr_next(l));
  else
    l->next=clean_up_mcode(l->next);
  return l;
}
void clean_up_mcode_lst(listnode l)
{
  for(;l!=NULL;l=l->next)
    if((l->attr==TWOLISTS)
       &&(l->data!=NULL))
      l->data=(char *)clean_up_mcode((listnode)l->data);
}

struct vardecl_list * clean_up_vl(struct vardecl_list * vl,int rec_flag)
{
  struct vardecl_list * vltmp;
  
  if(vl==NULL)
    return NULL;

  if((vl->var==NULL)
     &&(vl->next==NULL))
    {
      free(vl);
      return NULL;
    };

  while((vl->var==NULL)
	&&(vl->next!=NULL))
    {
      vltmp=vl->next;
      *vl=*vl->next;
      free(vltmp);
    }

  if(rec_flag)
    clean_up_vl(vl->next,rec_flag);

  return vl;
}

void add_meta_error_handle(enum err_type err,char * errname,listnode handle)
{
  listnode prev_handle=NULL,*err_lst=NULL;

  switch(err)
    {
    case ERR_NOTICE:
      err_lst=&global_meta_err_notice_lst;
      break;
    case ERR_FATAL:
      err_lst=&global_meta_err_notice_lst;
      break;
    case ERR_ERROR:
      err_lst=&global_meta_err_notice_lst;
      break;
    case ERR_WARNING:
      err_lst=&global_meta_err_notice_lst;
      break;
    }
  
  if((*err_lst)!=NULL)
    prev_handle=lnd_find(*err_lst,errname,VARIABLE,0);

  if(prev_handle!=NULL)
    {
      rm_lnd_all(prev_handle->next);
      prev_handle->next=handle;
    }
  else
    *err_lst=mk_head_lnd(*err_lst,mk_head_lnd(handle,strdup(errname),VARIABLE),TWOLISTS);
}

listnode get_meta_error_handle(enum err_type err,char * errname)
{
  listnode *err_lst=NULL;

  switch(err)
    {
    case ERR_NOTICE:
      err_lst=&global_meta_err_notice_lst;
      break;
    case ERR_FATAL:
      err_lst=&global_meta_err_notice_lst;
      break;
    case ERR_ERROR:
      err_lst=&global_meta_err_notice_lst;
      break;
    case ERR_WARNING:
      err_lst=&global_meta_err_notice_lst;
      break;
    }
  
  return lnd_find(*err_lst,errname,VARIABLE,0);
}

void raise_meta_error(enum err_type err,char * errname,listnode args)
{
  listnode err_handle=NULL;

  if((err_handle=get_meta_error_handle(err,errname))==NULL)
    fprintf(stderr,"Unhandled meta error: %s\n",errname);
  else
    global_error_seq=mk_head_lnd(global_error_seq,err_handle->next,TWOLISTS);

  rm_lnd_all(global_meta_err_args);
  global_meta_err_args=copylist(args);
}


listnode line_meta_code(listnode mname,listnode labels,struct vardecl_listoflist * vars,struct type_listoflist * types,listnode dst,listnode inl,defined_op ops,listnode opspec,listnode inl_lab)
{
  listnode l;

  if(mname==NULL)
    return NULL;

  if(mname->attr==FUNCTION)
    {
      interpret_meta_code(mname,labels,vars,types,dst,inl,ops,opspec,inl_lab);
      if((mname->attr==PARTOFOP)
	 &&(mname->next==NULL)
	 &&(mname->data==NULL))
	{
	  free(mname);
	  return NULL;
	};

      return mname;
    };
  
  for(l=mname;l!=NULL;l=l->next)
    if(l->attr==TWOLISTS)
      {
	listnode ltmp;
	
	interpret_meta_code((ltmp=(listnode)l->data),labels,vars,types,dst,inl,ops,opspec,inl_lab);
	
	if((ltmp->attr!=FUNCTION)
	   &&(ltmp->attr!=FUNCAVAR))
	  {
	    l->data=NULL;
	    lnd_rapnde(ltmp,l->next);
	    *l=*ltmp;
	    free(ltmp);
	  }
      }
  return mname;
}


void interpret_meta_code(listnode mcode,listnode labels,struct vardecl_listoflist * vars,struct type_listoflist * types,listnode dst,listnode inl,defined_op ops,listnode opspec,listnode inl_lab)
{
  listnode l;

  if(mcode==NULL)
    return;

  if(mcode->attr==INLINFUN)
    {
      struct vardecl_listoflist l_vl;
      struct type_listoflist l_tl;
      listnode ltmp=NULL;
      
      l_vl.next=vars;
      l_tl.next=types;
      l_vl.vlist=NULL;
      l_tl.tlist=NULL;

      l_vl.ltype=l_tl.ltype=DL_COPY;
      
      for(ltmp=(listnode)mcode->data;ltmp!=NULL;ltmp=ltmp->next)
	{
	  if(ltmp->attr==VARDLIST)
	    {
	      if(l_vl.vlist!=NULL)
		fprintf(stderr,"mk_asm_output:Two var lists\n");
	      else
		l_vl.vlist=((struct vardecl_listoflist *)ltmp->data)->vlist;
	    }
	  else if(ltmp->attr==TYPELIST)
	    {
	       if(l_tl.tlist!=NULL)
		 fprintf(stderr,"mk_asm_output:Two type lists\n");
	       else
		 l_tl.tlist=((struct type_listoflist *)ltmp->data)->tlist;
	    }
	}
      for(ltmp=(listnode)mcode->data;ltmp!=NULL;ltmp=ltmp->next)
	if((ltmp->attr!=VARDLIST)
	   &&(ltmp->attr!=TYPELIST))
	  ltmp->data=(char *)clean_up_mcode(line_meta_code((listnode)ltmp->data,labels,&l_vl,&l_tl,dst,inl,ops,opspec,inl_lab));
      /*	  ltmp->data=(char *)clean_up_mcode(line_meta_code((listnode)ltmp->data,labels,vars,types,dst,inl,ops,opspec,inl_lab));*/
	  
      /* now update types/vars */
      
      for(ltmp=(listnode)mcode->data;ltmp!=NULL;ltmp=ltmp->next)
	if(ltmp->attr==VARDLIST)
	  {
	    ((struct vardecl_listoflist *)ltmp->data)->vlist=l_vl.vlist;
	    break;
	  };
      for(ltmp=(listnode)mcode->data;ltmp!=NULL;ltmp=ltmp->next)
	if(ltmp->attr==TYPELIST)
	  {
	    ((struct type_listoflist *)ltmp->data)->tlist=l_tl.tlist;
	    break;
	  };
      
      return;
    }

  if(mcode->attr==FUNCTION)
    {
      listnode mname=NULL;

      if(mcode->data==NULL)
	return;
      if(*mcode->data!=4)
	{
	  line_meta_code(mcode->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	  mcode->next=clean_up_mcode(mcode->next);
	  return;
	};
      if(!strcmp(mcode->data,"\4add_var_type_layer"))
	{
	  struct vardecl_listoflist * lvars=vars,*lv;	    
	  struct type_listoflist * ltypes=types,*lt;
	  listnode l_ltmp;
	  
	  printf("# Adding var/type layer for META ..\n");
	  for(l_ltmp=mcode->next->next;l_ltmp!=NULL;l_ltmp=l_ltmp->next)
	    {
	      if(l_ltmp->data==NULL)
		continue;
	      switch(l_ltmp->attr)
		{
		case TYPEDEFN:
		case TYPELIST:
		  lt=ltypes;
		  ltypes=my_malloc(sizeof(struct type_listoflist));
		  ltypes->next=lt;
		  ltypes->tlist=((struct type_listoflist *)(l_ltmp->data))->tlist;
		  ltypes->ltype=DL_COPY;
		  break;
		case VARDLIST:
		  lv=lvars;
		  lvars=my_malloc(sizeof(struct vardecl_listoflist));
		  lvars->next=lv;
		  lvars->vlist=((struct vardecl_listoflist *)(l_ltmp->data))->vlist;
		  lvars->ltype=DL_COPY;
		  break;
		default:
		  break;
		};
	    };
	 
	  mcode->next->data=(char *)line_meta_code((listnode)mcode->next->data,labels,lvars,ltypes,dst,inl,ops,opspec,inl_lab);
			 

	  /* AV-NOTE: Look at this agaqin, check for ltype */
	  while(ltypes!=types)
	    {
	      lt=ltypes->next;
	      free(ltypes);
	      ltypes=lt;
	    };
	  while(lvars!=vars)
	    {
	      lv=lvars->next;
	      free(lvars);
	      lvars=lv;
	    };
	  return;
	};
      if(!!strcmp(mcode->data,"\4objpart"))
	{
	  line_meta_code(mcode->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	  mcode->next=clean_up_mcode(mcode->next);
	  return;
	};
      if((mcode->next->attr==TWOLISTS)
	 ||(mcode->next->attr==FUNCAVAR))
	{
	  line_meta_code(mcode->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	  mcode->next=clean_up_mcode(mcode->next);
	  return;
	};
      if(!!strcmp(mcode->next->data,"META"))
	{
	  line_meta_code(mcode->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	  mcode->next=clean_up_mcode(mcode->next);
	  return;
	};
      if((mcode->next->next->attr!=TWOLISTS)
	 &&(mcode->next->next->attr!=FUNCAVAR))
	{
	  listnode resl=NULL;

	  if(((mname=mcode->next->next)->data)==NULL)
	    return;
	  if(!strcmp(mname->data,"nil"))
	    resl=mk_head_lnd(NULL,NULL,PARTOFOP);
	  else if(!strcmp(mname->data,"ErrArgs"))
	    resl=copylist(global_meta_err_args);
	  else
	    fprintf(stderr,"META variable %s unknown !!!\n",mname->data);

	  rm_listnode(mcode);
	  if(mcode->data!=NULL)
	    free(mcode->data);
	  if(resl==NULL)
	    {
	      mcode->data=NULL;
	      mcode->attr=PARTOFOP;
	    }
	  else
	    {
	      *mcode=*resl;
	      free(resl);
	    };

	}
      else
	{
	  listnode resl=NULL;

	  if(((listnode)mcode->next->next->data)->attr!=FUNCTION)
	    {
	      printf("# Weird: META -> part looks like function,have attr %d\n",((listnode)mcode->next->next->data)->attr);
	      printlist2(mcode,0,0);
	      return;
	    };
	  if(((mname=((listnode)mcode->next->next->data))->data)==NULL)
	    return; 

	  if((!strcmp(mname->data,"If"))
	     ||(!strcmp(mname->data,"IfQ")))
	     {
	       if(mname->next!=NULL)
		 {
		   if(mname->next->attr==TWOLISTS)
		     interpret_meta_code((listnode)mname->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		   else if((mname->next->attr!=VARIABLE)
			   &&(mname->next->attr!=ASSOCVAR)
			   &&(mname->next->attr!=PARTOFOP))
		     {
		       fprintf(stderr,"META->%s needs at least 2 args\n",mname->data);
		       return;
		     };
		   
		   if(mname->next->attr==TWOLISTS)
		     mname->next->data=(char *)clean_up_mcode((listnode)mname->next->data);

		   if(mname->next->next==NULL) 
		     resl=NULL; /* null in both cases */
		   else if(mname->next->data!=NULL)
		     {
		       if(mname->next->next->attr==TWOLISTS)
			 {
			   resl=(listnode)mname->next->next->data;
			   mname->next->next->data=NULL;
			 }
		       else
			 {
			   resl=mname->next->next;			   
			   mname->next->next=NULL;
			 }
		     }
		   else /* if nil, return "else" part */
		     {
		       if(mname->next->next->next==NULL)
			 resl=NULL;
		       else if(mname->next->next->next->attr==TWOLISTS)
			 {
			   resl=(listnode)mname->next->next->next->data;
			   mname->next->next->next->data=NULL;
			 }
		       else
			 {
			   resl=mname->next->next->next;			   
			   mname->next->next->next=NULL;
			 }

		     }
		 }
	       if(mname->data[2]!='Q') /* If it's 'If', not 'IfQ', eval the damn thing */
		 if(resl!=NULL)
		   clean_up_mcode_lst(resl=clean_up_mcode(line_meta_code(resl,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	     }
	  else if(!strcmp(mname->data,"Not"))
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));
	      if(mname->next==NULL)
		resl=mk_head_lnd(NULL,"t",VARIABLE);
	      else
		resl=NULL;
	    }
	  else if(!strcmp(mname->data,"Or"))
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));
	      if(mname->next!=NULL)
		{
		  resl=mname->next;
		  mname->next=NULL;
		}
	      else
		resl=NULL;
	    }
	  else if(!strcmp(mname->data,"And"))
	    {
	      listnode lptr=NULL;

	      mname->next=line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);

	      for(lptr=mname->next;lptr!=NULL;lptr=lptr->next)
		if(lptr->data==NULL)
		  break;
	      if(lptr==NULL)
		{
		  resl=mname->next;
		  mname->next=NULL;
		}
	      else
		resl=NULL;
	    }
	  else if(!strcmp(mname->data,"Prog"))
	     {
	       if(mname->next->attr==FUNCTION)
		 interpret_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	       else
		 {
		   for(resl=mname->next;resl!=NULL;resl=resl->next)
		     {
		       if(resl->attr==TWOLISTS)
			 interpret_meta_code((listnode)resl->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		       else
			 fprintf(stderr,"META->Prog:resl->attr==%d!=TWOLISTS\n",resl->attr);
		     }
		 };
	       clean_up_mcode_lst(mname->next=clean_up_mcode(mname->next));
	       resl=mk_head_lnd(mname->next,"\4prog",FUNCTION);
	       mname->next=NULL;
	     }
	  else if(!strcmp(mname->data,"TestFnCall"))	  
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		if((mname->next->attr==TWOLISTS)
		   &&(mname->next->next==NULL))
		  {
		    resl=(listnode)mname->next->data;
		    free(mname->next);
		    mname->next=resl;
		  }
	      if(validate_function(mname->next,vars,types,labels,2)!=NULL)
		{
		  resl=mname->next;
		  mname->next=NULL;
		}
	      else
		resl=NULL;
	    }
	  else if((!strcmp(mname->data,"GetType"))
		  ||(!strcmp(mname->data,"GetTypeLocal")))
	     {
	       struct typerec * type=NULL;
	       
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	       if(mname->next==NULL)
		 {
		   fprintf(stderr,"META->%s needs arg\n",mname->data);
		  return;
		 };
	       
	       if(mname->next->data==NULL)
		 resl=NULL; /* NULL if can't get type and we can't get it now*/
	       else if(mname->next->attr==VARDECL)
		 {
		   if((type=((struct var_decl *)mname->next->data)->type)==NULL)
		     resl=NULL;
		   else
		     resl=mk_head_lnd(NULL,type,TYPEDEFN);
		 }
	       else if ((mname->next->attr!=VARIABLE)
		  &&(mname->next->attr!=ASSOCVAR)
		  &&(mname->next->attr!=PARTOFOP))
		 resl=NULL;
	       else
		 {
		   if(!strcmp(mname->data,"GetTypeLocal"))
		     type=get_type_by_name_local(mname->next->data,NONE,types->tlist);
		   else if(isnum(*mname->next->data))
		     type=get_type_by_id(atol(mname->next->data),types);
		   else if(mname->next->next!=NULL)
		     {
		       long t_id=0;
		       if((mname->next->next->data==NULL)
			  ||((mname->next->next->attr!=ASSOCVAR)
			     &&(mname->next->next->attr!=VARIABLE)
			     &&(mname->next->next->attr!=PARTOFOP)
			     &&(mname->next->next->attr!=TYPEDEFN)))
			 t_id=0;
		       else if(mname->next->next->attr==TYPEDEFN)
			 t_id=((struct typerec *)mname->next->next->data)->typeid;
		       else 
			 t_id=atoi(mname->next->next->data);

		       if(t_id)
			 type=get_type_by_name_skip(t_id,mname->next->data,NONE,types);
		       else
			 type=get_type_by_name(mname->next->data,NONE,types);
		     }
		   else
		     type=get_type_by_name(mname->next->data,NONE,types);
		   
		   if(type==NULL)
		     resl=NULL;
		   else
		     resl=mk_head_lnd(NULL,eval_type_refr(type,vars,types,labels,0,NULL),TYPEDEFN);
		 };
	     }
	  else if(!strcmp(mname->data,"GetTypeId"))
	     {
	       clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	       if(mname->next!=NULL)
		 {
		   if(mname->next->attr!=TYPEDEFN)
		     {
		       fprintf(stderr,"META %s needs arg to be type\n",mname->data);
		       return;
		     };
		   if(mname->next->data!=NULL)
		     {
		       char local_buf[8];
		       memset(local_buf,0,sizeof(local_buf));
		       sprintf(local_buf,"%ld",((struct typerec *)mname->next->data)->typeid);
		       resl=mk_head_lnd(NULL,strdup(local_buf),VARIABLE);
		     };
		 };
	     }
	  else if(!strcmp(mname->data,"AddOpDef"))
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));
	      if(mname->next==NULL)
		resl=NULL;
	      else if(mname->next->next==NULL)
		fprintf(stderr,"META %s: not enough args\n",mname->data);
	      else if(mname->next->next->next==NULL)
		fprintf(stderr,"META %s: not enough args\n",mname->data);
	      else if((mname->next->data==NULL)
		      ||((mname->next->attr!=VARIABLE)
			 &&(mname->next->attr!=ASSOCVAR)
			 &&(mname->next->attr!=PARTOFOP)))
		fprintf(stderr,"META %s: 1st arg must be format spec\n",mname->data);
	      else if(mname->next->next->data==NULL)
		fprintf(stderr,"META %s: 2nd arg must be priority\n",mname->data);
	      else if(!isnum(*mname->next->next->data))
		fprintf(stderr,"META %s: 2nd arg must be priority\n",mname->data);
	      else
		{
		  char * form=NULL,local_buf[34];
		  int pri=0;
		  defined_op res;

		  pri=atoi(mname->next->next->data);
		  form=strdup(mname->next->data);

		  resl=rm_cdr_next(rm_cdr_next(mname->next));
		  mname->next=NULL;

		  if(resl->attr!=TWOLISTS)
		    {
		      fprintf(stderr,"META %s: 3rd arg must list of tokens\n",mname->data);
		      rm_lnd_all(resl);
		      resl=NULL;
		    }
		  else if(resl->next->attr!=TWOLISTS)
		    {
		      fprintf(stderr,"META %s: 4th arg must be function body\n",mname->data);
		      rm_lnd_all(resl);
		      resl=NULL;
		    }
		  else
		    {
		      listnode l_ind=NULL,opdlnd=NULL,opd_cl=NULL;
		      int f_ind;
		      struct typerec * tr=NULL;
		      struct vardecl_list * vlst=NULL;
		      struct type_list * tlst=NULL,* tmp_tl=NULL;

		      for(f_ind=0,l_ind=(listnode)resl->data;(!!form[f_ind])&&(l_ind!=NULL);f_ind++,l_ind=l_ind->next,tr=NULL,opd_cl=NULL)
			switch(form[f_ind])
			  {
			  case 'f':
			    if((l_ind->attr!=VARIABLE)
			       &&(l_ind->attr!=ASSOCVAR)
			       &&(l_ind->attr!=PARTOFOP))
			      {
				fprintf(stderr,"META %s: wrong kind of list entry (attr %d) for 'f' format specifier\n",mname->data,l_ind->attr);
				rm_lnd_all(resl);
				rm_lnd_all(opdlnd);
				return;
			      };
			    if(l_ind->data==NULL)
			      {
				fprintf(stderr,"META %s: NULL list entry for 'f' format specifier\n",mname->data);
				rm_lnd_all(resl);
				rm_lnd_all(opdlnd);
				return;
			      };
			    if(opdlnd==NULL)
			      opdlnd=mk_head_lnd(NULL,l_ind->data,VARIABLE);
			    else
			      mk_set_lnd(opdlnd,l_ind->data,VARIABLE);
			    l_ind->data=NULL;
			    break;
			  case 'X':
			    if(l_ind->data==NULL)
			      {
				fprintf(stderr,"META %s: NULL opdef class list entry for 'X' format specifier\n",mname->data);
				rm_lnd_all(resl);
				rm_lnd_all(opdlnd);
				return;
			      };
			    if((l_ind->attr==VARIABLE)
			       ||(l_ind->attr==ASSOCVAR)
			       ||(l_ind->attr==PARTOFOP))
			      {
				if(opd_cl==NULL)
				  opd_cl=mk_head_lnd(NULL,l_ind->data,VARIABLE);
				else
				  mk_set_lnd(opd_cl,l_ind->data,VARIABLE);
			      } 
			    else if(l_ind->attr==TWOLISTS)
			      opd_cl=(listnode)l_ind->data;
			    
			    l_ind->data=NULL;
			    if((l_ind=l_ind->next)==NULL)
			      {
				fprintf(stderr,"META %s: got only opd class w/o var for 'X' format specifier\n",mname->data);
				rm_lnd_all(resl);
				rm_lnd_all(opdlnd);
				return;
			      };
			  case 'x':
			    if(l_ind->attr==TYPEDEFN)
			      {
				tr=(struct typerec *)l_ind->data;
				if((l_ind=l_ind->next)==NULL)
				  {
				    fprintf(stderr,"META %s: got only type w/o var name for 'x' format specifier\n",mname->data);
				    rm_lnd_all(resl);
				    rm_lnd_all(opdlnd);
				    return;
				  };
			      }
			    if((l_ind->attr!=VARIABLE)
			       &&(l_ind->attr!=ASSOCVAR)
			       &&(l_ind->attr!=PARTOFOP))
			      {
				fprintf(stderr,"META %s: wrong kind of list entry (attr %d) for 'x' format specifier\n",mname->data,l_ind->attr);
				rm_lnd_all(resl);
				rm_lnd_all(opdlnd);
				return;
			      };
			    if(l_ind->data==NULL)
			      {
				fprintf(stderr,"META %s: NULL list entry for 'x' format specifier\n",mname->data);
				rm_lnd_all(resl);
				rm_lnd_all(opdlnd);
				return;
			      };
			    if(tr!=NULL)
			      {
				struct vardecl_list * vptr=NULL;
				if(vlst==NULL)
				  vlst=vptr=insert_var_decl(NULL,l_ind->data,tr,NULL,0);
				else
				  vptr=insert_var_decl(vlst,l_ind->data,tr,NULL,0);
				
				if((tr->typekind==FUN_DEFN)
				   ||(tr->typekind==FUNPROTO))
				  vptr->var->attr=VAR_FUNC;
			      };
			    if(opd_cl!=NULL)
			      {
				if(opdlnd==NULL)
				  opdlnd=mk_head_lnd(NULL,mk_head_lnd(opd_cl,l_ind->data,VARIABLE),TWOLISTS);
				else
				  mk_set_lnd(opdlnd,mk_head_lnd(opd_cl,l_ind->data,VARIABLE),TWOLISTS);
			      }
			    else if(opdlnd==NULL)
			      opdlnd=mk_head_lnd(NULL,l_ind->data,VARIABLE);
			    else
			      mk_set_lnd(opdlnd,l_ind->data,VARIABLE);
			    l_ind->data=NULL;
			    
			    break;
			  case 't':
			    if(l_ind->attr==TYPEDEFN)
			      {
				tr=(struct typerec *)l_ind->data;
				if((l_ind=l_ind->next)==NULL)
				  {
				    fprintf(stderr,"META %s: got only type w/o type var name for 't' format specifier\n",mname->data);
				    rm_lnd_all(resl);
				    rm_lnd_all(opdlnd);
				    return;
				  };
			      }
			    if((l_ind->attr!=VARIABLE)
			       &&(l_ind->attr!=ASSOCVAR)
			       &&(l_ind->attr!=PARTOFOP))
			      {
				fprintf(stderr,"META %s: wrong kind of list entry (attr %d) for 'x' format specifier\n",mname->data,l_ind->attr);
				rm_lnd_all(resl);
				rm_lnd_all(opdlnd);
				return;
			      };
			    if(l_ind->data==NULL)
			      {
				fprintf(stderr,"META %s: NULL list entry for 'x' format specifier\n",mname->data);
				rm_lnd_all(resl);
				rm_lnd_all(opdlnd);
				return;
			      };
			    tmp_tl=my_malloc(sizeof(struct type_list));
			    tmp_tl->next=tlst;
			    tlst=tmp_tl;
			    tlst->type=my_malloc(sizeof(struct typerec));
			    tlst->type->name=strdup(l_ind->data);
			    tlst->type->typemodf=NONE;
			    tlst->type->typekind=MODIFARG;

			    if(tr!=NULL)
			      {
				tlst->type->typebody.class_list=my_malloc(sizeof(struct type_list));
				tlst->type->typebody.class_list->next=NULL;
				tlst->type->typebody.class_list->type=tr;
			      }
			    else
			      tlst->type->typebody.class_list=NULL;

			    if(opdlnd==NULL)
			      opdlnd=mk_head_lnd(NULL,l_ind->data,VARIABLE);
			    else
			      mk_set_lnd(opdlnd,l_ind->data,VARIABLE);
			    l_ind->data=NULL;
			    
			    break;
			  default:
			    fprintf(stderr,"META %s: wrong char '%c' in format specifier\n",mname->data,form[f_ind]);
			    rm_lnd_all(resl);
			    return;
			  }
		      
		      
		      res=my_malloc(sizeof(struct op_definition));
		      res->attr=OPD_NONE;
		      res->prec=pri;
		      res->form=strdup(form);
		      res->vars=vlst;
		      res->types=tlst;
		      res->defn=opdlnd;
		      res->fdef.opdef=(listnode)resl->next->data;
		      resl->data=resl->next->data=NULL;
		      resl=rm_cdr_next(rm_cdr_next(resl));
		      if(resl==NULL)
			res->opd_class=NULL;
		      else if(resl->attr==TWOLISTS)
			{
			  res->opd_class=(listnode)resl->data;
			  resl->data=NULL;
			  resl=rm_cdr_next(resl);
			}
		      else
			{
			  res->opd_class=resl;			  
			  resl=NULL;
			}

		      sprintf(local_buf,"%ld",opdef_ins(res,ops));
		      resl=mk_head_lnd(NULL,strdup(local_buf),VARIABLE);
		    }
		}
	    }
	  else if(!strcmp(mname->data,"AddVar"))
	    {
	      struct typerec * type=NULL;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META->AddVar needs 2 to 3 args, 0 given\n");
		  return;
		}
	      else if(mname->next->next==NULL)
		{
		  fprintf(stderr,"META->AddVar needs 2 to 3 args, 1 given\n");
		  return;
		};

	      if(mname->next->attr!=TYPEDEFN)
		{
		  fprintf(stderr,"META->AddVar needs 1st arg to be type\n");
		  return;
		}
	      else
		{
		  type= (struct typerec *)mname->next->data;
		  mname->next=rm_cdr_next(mname->next);
		};
	      
	      /* this handles insertion in complex structures */
	      if((mname->next->attr==TWOLISTS)
		 &&(mname->next->data!=NULL))
		{
		  listnode lt1=(listnode)mname->next->data;

		  if((lt1->attr==FUNCTION)
		     &&(lt1->data!=NULL)
		     &&(lt1->next!=NULL))
		    if(!strcmp(lt1->data,"\4objpart"))
		      {
			struct typerec * type1=NULL;
			struct vardecl_list * vl_p=NULL;
			
			if(mname->next->next!=NULL)    
			  printf("# Can't add to both complex structure and layer !\n");

			if(lt1->next->next==NULL)
			  {
			    fprintf(stderr,"Complex structure doesn't have var name\n");
			    return;
			  };
			if(lt1->next->next->data==NULL)
			  {
			    fprintf(stderr,"Complex structure doesn't have var name\n");
			    return;
			  };

			if(lt1->next->attr==TWOLISTS)
			  {
			    printf("## Complex object insert, verifying ...\n");
			    type1=validate_function((listnode)lt1->next->data,vars,types,labels,2);
			  }
			else if(lt1->next->attr==TYPEDEFN)
			  type1=(struct typerec *)lt1->next->data;
			else  if(((lt1->next->attr==VARIABLE)
				  ||(lt1->next->attr==ASSOCVAR)
				  ||(lt1->next->attr==PARTOFOP))
				 &&(lt1->next->data!=NULL))
			  if((type1=get_type_by_name(lt1->next->data,NONE,types))!=NULL)
			    if((vl_p=global_find_var_decl(lt1->next->data,vars,0))!=NULL)
			      if(vl_p->var!=NULL)
				type1=vl_p->var->type;

			type1=eval_type_refr(type1,vars,types,labels,0,NULL);

			if(type1==NULL)
			  {
			    fprintf(stderr,"Can't insert var into complex structure\n");
			    return;
			  };
			switch(type1->typekind)
			  {
			  case ISMODIF:
			  case   UNION:
			  case   CLASS:
			    if(type1->typebody.class_def->vars==NULL)
			      type1->typebody.class_def->vars=insert_var_decl(NULL,lt1->next->next->data,type,NULL,0);
			    else
			      insert_var_decl(type1->typebody.class_def->vars,lt1->next->next->data,type,NULL,0);
			    break;
			  case ACTIONCLASS:
			     if(type1->typebody.actionclass->local_vars==NULL)
			      type1->typebody.actionclass->local_vars=insert_var_decl(NULL,lt1->next->next->data,type,NULL,0);
			    else
			      insert_var_decl(type1->typebody.actionclass->local_vars,lt1->next->next->data,type,NULL,0);
			    break;
			  default:
			    fprintf(stderr,"interpret_meta_code():Can't add subcomponent in this type\n");
			    return;
			  };
		      }
		}
	      else
		{
		  if(((mname->next->attr!=VARIABLE)
		      &&(mname->next->attr!=ASSOCVAR)
		      &&(mname->next->attr!=PARTOFOP))
		     ||(mname->next->data==NULL))
		    {
		      fprintf(stderr,"META->AddVar needs 2nd arg to be var name\n");
		      return;
		    };
		  
		  if(mname->next->next==NULL)
		    {
		      if(vars->vlist==NULL)
			vars->vlist=insert_var_decl(NULL,mname->next->data,type,NULL,0);
		      else
			insert_var_decl(vars->vlist,mname->next->data,type,NULL,0);
		    }
		  else if(mname->next->next->data==NULL)
		    {
		      if(vars->vlist==NULL)
			vars->vlist=insert_var_decl(NULL,mname->next->data,type,NULL,0);
		      else
			insert_var_decl(vars->vlist,mname->next->data,type,NULL,0);
		    }
		  else
		    switch(mname->next->next->attr)
		      {
		      case VARDLIST:
			insert_var_decl(((struct vardecl_listoflist *)mname->next->next->data)->vlist,mname->next->data,type,NULL,0);
			clean_up_vl((struct vardecl_list *)mname->next->next->data,0);
			mname->next->next->data=NULL;
			break;
		      case OPDEFPTR:
			if(((defined_op)mname->next->next->data)->vars==NULL)
			  ((defined_op)mname->next->next->data)->vars=insert_var_decl(NULL,mname->next->data,type,NULL,0);
			else
			  insert_var_decl(((defined_op)mname->next->next->data)->vars,mname->next->data,type,NULL,0);
			break;
		      default:
			fprintf(stderr,"META->AddVar needs 3rd arg to be var layer\n");
			return;
		      }  
		}
	    }
	  else if(!strcmp(mname->data,"GetVarDecl"))
	    {
	      struct vardecl_list * vd=NULL;
	      
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META->GetVarDecl needs 1 args, 0 given\n");
		  return;
		};

	      if(((mname->next->attr!=VARIABLE)
		  &&(mname->next->attr!=ASSOCVAR)
		  &&(mname->next->attr!=PARTOFOP))
		 ||(mname->next->data==NULL))
		{
		  fprintf(stderr,"META->GetVarDecl needs 1st arg to be name\n");
		  return;
		}
	      else if((vd=global_find_var_decl(mname->next->data,vars,1))!=NULL)
		if(vd->var!=NULL)
		  resl=mk_head_lnd(NULL,vd->var,VARDECL);
	    }
	  else if(!strcmp(mname->data,"GetVarLayer"))
	    {
	      struct vardecl_listoflist * vl=NULL;
	      
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next==NULL)
		resl=mk_head_lnd(NULL,vars,VARDLIST);
	      else
		{
		  if(mname->next->attr!=VARDECL)
		    {
		      fprintf(stderr,"META->GetVarLayer needs 1st arg to be var decl\n");
		      return;
		    };
		  
		  if((vl=get_vardecl_layer((struct var_decl *)mname->next->data,vars))!=NULL)
		    resl=mk_head_lnd(NULL,vl/*->vlist*/,VARDLIST);
		  else
		    fprintf(stderr,"#META->GetVarLayer can't get layer from var decl\n");
		}
	    }
	  else if(!strcmp(mname->data,"GetTypeLayer"))
	    {
	      struct type_listoflist * tl=NULL;
	      
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next==NULL)
		resl=mk_head_lnd(NULL,types,TYPELIST);
	      else
		{
		  if(mname->next->attr!=TYPEDEFN)
		    {
		      fprintf(stderr,"META->GetTypeLayer needs 1st arg to be type\n");
		      return;
		    }
		  else
		    tl=get_typedef_layer((struct typerec *)mname->next->data,types);
		  
		  resl=mk_head_lnd(NULL,tl,TYPELIST);
		}
	    }
	  else if(!strcmp(mname->data,"MkVarLayer"))
	    {
	      struct vardecl_listoflist * res_vl=NULL;
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      res_vl=my_malloc(sizeof(struct vardecl_listoflist));
	      res_vl->ltype=DL_RUNIN;/*AV-NOTE: investigate */
	      res_vl->next=NULL;
	      res_vl->vlist=NULL;

	      if(mname->next!=NULL)
		{
		  if(mname->next->attr!=VARDLIST)
		    {
		      fprintf(stderr,"META->%s needs arg to be var layer\n",mname->data);
		      free(res_vl);
		      return;
		    };
		  res_vl->vlist=copy_vardecl_list(((struct vardecl_listoflist *)mname->next->data)->vlist);
		}
	      resl=mk_head_lnd(NULL,res_vl,VARDLIST);
	    }
	  else if(!strcmp(mname->data,"MkTypeLayer"))
	    {
	      struct type_listoflist * res_tl=NULL;
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      res_tl=my_malloc(sizeof(struct type_listoflist));
	      res_tl->ltype=DL_RUNIN;/*AV-NOTE: investigate */
	      res_tl->next=NULL;
	      res_tl->tlist=NULL;

	      if(mname->next!=NULL)
		{
		  if(mname->next->attr!=TYPELIST)
		    {
		      fprintf(stderr,"META->%s needs arg to be type layer\n",mname->data);
		      free(res_tl);
		      return;
		    };
		  res_tl->tlist=copy_type_list(((struct type_listoflist *)mname->next->data)->tlist);
		}
	      resl=mk_head_lnd(NULL,res_tl,TYPELIST);
	    }
	  else if(!strcmp(mname->data,"SetVarLayer"))
	    {
	      struct vardecl_listoflist * lr;
	      
	      lr=my_malloc(sizeof(struct vardecl_listoflist));

	      *lr=*vars;
	      vars->next=lr;
	      vars->vlist=NULL;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		{
		  if(mname->next->attr!=VARDLIST)
		    {
		      fprintf(stderr,"META->%s needs arg to be var layer\n",mname->data);
		      return;
		    };
		  vars->vlist=(struct vardecl_list *)mname->next->data;
		}
	      else /* insert dummy varlist entry to allow passing reference to this layer */
		vars->vlist=my_malloc(sizeof(struct vardecl_list));
	    }
	  else if(!strcmp(mname->data,"SetTypeLayer"))
	    {
	      struct type_listoflist * lr;
	      
	      lr=my_malloc(sizeof(struct type_listoflist));

	      *lr=*types;
	      types->next=lr;
	      types->tlist=NULL;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		{
		  if(mname->next->attr!=TYPELIST)
		    {
		      fprintf(stderr,"META->%s needs arg to be type layer\n",mname->data);
		      return;
		    };
		  types->tlist=(struct type_list *)mname->next->data;
		}
	      else /* insert dummy type list entry to allow passing reference to this layer */
		types->tlist=my_malloc(sizeof(struct type_list));	      
	    }
	  else if((!strcmp(mname->data,"AddErrorHandleF"))
		  ||(!strcmp(mname->data,"AddErrorHandleE"))
		  ||(!strcmp(mname->data,"AddErrorHandleW"))
		  ||(!strcmp(mname->data,"AddErrorHandleN")))
	    {
	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META %s requires at least one argument\n",mname->next);
		  return;
		}

	      if(mname->next->attr==TWOLISTS)
		mname->next->data=(char *)clean_up_mcode(line_meta_code((listnode)mname->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab));

	      if(((mname->next->attr!=VARIABLE)
		  &&(mname->next->attr!=ASSOCVAR)
		  &&(mname->next->attr!=PARTOFOP))
		 ||(mname->next->data==NULL))
		{
		  fprintf(stderr,"META %s: error handle must be string\n",mname->data);
		  return;
		}

	      if(mname->next->next!=NULL)
		if((mname->next->next->attr==TWOLISTS)
		   &&(mname->next->next->next==NULL))
		  {
		    listnode ltmp=(listnode)mname->next->next->data;
		    
		    free(mname->next->next);
		    mname->next->next=ltmp;
		  }

	      switch(mname->data[14])
		{
		case 'F':
		  add_meta_error_handle(ERR_FATAL,mname->next->data,mname->next->next);
		  break;
		case 'E':
		  add_meta_error_handle(ERR_ERROR,mname->next->data,mname->next->next);
		  break;
		case 'W':
		  add_meta_error_handle(ERR_WARNING,mname->next->data,mname->next->next);
		  break;
		case 'N':
		  add_meta_error_handle(ERR_NOTICE,mname->next->data,mname->next->next);
		  break;
		}
	      resl=NULL;
	      mname->next->next=NULL;
	    }
	  else if((!strcmp(mname->data,"GetErrorHandleF"))
		  ||(!strcmp(mname->data,"GetErrorHandleE"))
		  ||(!strcmp(mname->data,"GetErrorHandleW"))
		  ||(!strcmp(mname->data,"GetErrorHandleN")))
	    {
	      if(mname->next->attr==TWOLISTS)
		mname->next->data=(char *)clean_up_mcode(line_meta_code((listnode)mname->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab));

	      if(((mname->next->attr!=VARIABLE)
		  &&(mname->next->attr!=ASSOCVAR)
		  &&(mname->next->attr!=PARTOFOP))
		 ||(mname->next->data==NULL))
		{
		  fprintf(stderr,"META %s: error handle must be string\n",mname->data);
		  return;
		}

	      switch(mname->data[14])
		{
		case 'F':
		  resl=get_meta_error_handle(ERR_FATAL,mname->next->data);
		  break;
		case 'E':
		  resl=get_meta_error_handle(ERR_ERROR,mname->next->data);
		  break;
		case 'W':
		  resl=get_meta_error_handle(ERR_WARNING,mname->next->data);
		  break;
		case 'N':
		  resl=get_meta_error_handle(ERR_NOTICE,mname->next->data);
		  break;
		}
	    }
	  else if((!strcmp(mname->data,"RaiseErrorF"))
		  ||(!strcmp(mname->data,"RaiseErrorE"))
		  ||(!strcmp(mname->data,"RaiseErrorW"))
		  ||(!strcmp(mname->data,"RaiseErrorN")))
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(((mname->next->attr!=VARIABLE)
		  &&(mname->next->attr!=ASSOCVAR)
		  &&(mname->next->attr!=PARTOFOP))
		 ||(mname->next->data==NULL))
		{
		  fprintf(stderr,"META %s: error handle must be string\n",mname->data);
		  return;
		}
	      
	      resl=NULL;

	      switch(mname->data[10])
		{
		case 'F':
		  raise_meta_error(ERR_FATAL,mname->next->data,mname->next->next);
		  break;
		case 'E':
		  raise_meta_error(ERR_ERROR,mname->next->data,mname->next->next);
		  break;
		case 'W':
		  raise_meta_error(ERR_WARNING,mname->next->data,mname->next->next);
		  break;
		case 'N':
		  raise_meta_error(ERR_NOTICE,mname->next->data,mname->next->next);
		  break;
		}
	    }
	  else if(!strcmp(mname->data,"PutFuncallHead")
		  ||!strcmp(mname->data,"PutFuncallTail"))	  
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META->%s needs arg\n",mname->data);
		  return;
		};

	      if(mname->next->attr==FUNCTION)
		resl=mname->next; /* weird but well ... */
	      else if(mname->next->attr==TWOLISTS)
		{
		  resl=(listnode)mname->next->data;
		  if(mname->next->next!=NULL)
		    fprintf(stderr,"META->%s needs only one arg\n",mname->data);
		}
	      else
		{
		  fprintf(stderr,"META->%s arg's attr = %d !!!\n",mname->data,mname->next->attr);
		  return;
		};
	      if(mname->data[10]=='H') /* head */
		global_exec_fn_seq=mk_head_lnd(global_exec_fn_seq,resl,TWOLISTS);
	       /* tail */
	      else if(global_exec_fn_seq==NULL)
		global_exec_fn_seq=mk_set_lnd(global_exec_fn_seq,resl,TWOLISTS);
	      else
		mk_set_lnd(global_exec_fn_seq,resl,TWOLISTS);
	      /* cleanup */
	      resl=NULL;
	      mname->next=NULL;
	    }
	  else if((!strcmp(mname->data,"RunInLayer"))
		  ||(!strcmp(mname->data,"DoInLayer")))
	    {
	      struct vardecl_listoflist * lr=NULL;
	      struct vardecl_list * vl=NULL;
	      struct type_listoflist * tr=NULL;
	      struct type_list * tl=NULL;
	      
	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META->%s needs 2 args\n",mname->data);
		  return;
		};

	      if(mname->next->attr==TWOLISTS)
		{
		  listnode ltmp;
		if((ltmp=clean_up_mcode(line_meta_code((listnode)mname->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab)))!=NULL)
		  {
		    if(ltmp->next==NULL)
		      {
			mname->next->data=ltmp->data;
			mname->next->attr=ltmp->attr;
			free(ltmp);
		      }
		    else
		      mname->next->data=(char *)ltmp;
		  }
		else
		  mname->next->data=NULL;
		}
	      
	      if(mname->next->data!=NULL)
		{
		  if(mname->next->attr==VARDLIST)
		    {
		      lr=my_malloc(sizeof(struct vardecl_listoflist));

		      *lr=*vars;
		      vars->next=lr;
		      vars->ltype=DL_RUNIN;
		      vars->vlist=((struct vardecl_listoflist *)mname->next->data)->vlist;
		    }
		  else if(mname->next->attr==TYPELIST)
		    {
		      tr=my_malloc(sizeof(struct type_listoflist));

		      *tr=*types;
		      types->next=tr;
		      types->ltype=DL_RUNIN;		      
		      types->tlist=((struct type_listoflist *)mname->next->data)->tlist;
		    }
		  else
		    {
		      fprintf(stderr,"META->%s needs arg to be var or type layer\n",mname->data);
		      return;
		    };
		}
	      else /* insert dummy varlist entry to allow passing reference to this layer */
		{
		  lr=my_malloc(sizeof(struct vardecl_listoflist));
		      
		  *lr=*vars;
		  vars->next=lr;
		  vars->ltype=DL_RUNIN;
		  vars->vlist=my_malloc(sizeof(struct vardecl_list));
		}

	      resl=line_meta_code(mname->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	      mname->next->next=NULL;
	      mname->next->data=NULL;

	      if(mname->next->attr==VARDLIST)
		/* find our var layer and return it */
		{
		  for(lr=vars;lr!=NULL;lr=lr->next)
		    if(lr->ltype==DL_RUNIN)
		      {
			struct vardecl_listoflist * lr_t;
			if((lr_t=lr->next)!=NULL)
			  {
			    vl=clean_up_vl(lr->vlist,1);
			    *lr=*lr_t;
			    free(lr_t);
			  }
			else
			  {
			    vl=clean_up_vl(lr->vlist,1);
			    lr->vlist=NULL;
			  }
			break;
		      }
		  if(*mname->data=='D') /* DoInLayer, which returns layer, not fn results */
		    {
		      rm_lnd_all(resl);
		      resl=mk_head_lnd(NULL,vl,VARDLIST);
		    }
		  else /* add \4add_var_type_layer, since validator/generator might use it */
		    if(resl!=NULL)
		      {
			lr=my_malloc(sizeof(struct vardecl_listoflist));
			lr->ltype=DL_FREE;
			lr->vlist=vl;
			if((resl->attr==TWOLISTS)
			   &&(resl->next==NULL))
			  mk_set_lnd(resl,lr,VARDLIST);
			else
			  mk_set_lnd(mk_head_lnd(NULL,resl,TWOLISTS),lr,VARDLIST);
			resl=mk_head_lnd(resl,strdup("\4add_var_type_layer"),FUNCTION);		 
		      }
		}
	      else
		/* find our type layer and return it */
		{
		  for(tr=types;tr!=NULL;tr=tr->next)
		    if(tr->ltype==DL_RUNIN)
		      {
			struct type_listoflist * lr_t;
			if((lr_t=tr->next)!=NULL)
			  {
			    tl=tr->tlist;
			    *tr=*lr_t;
			    free(lr_t);
			  }
			else
			  {
			    tl=tr->tlist;
			    tr->tlist=NULL;
			  }
			break;
		      }
		  if(*mname->data=='D') /* DoInLayer, which returns layer, not fn results */
		    {
		      rm_lnd_all(resl);
		      resl=mk_head_lnd(NULL,tl,TYPELIST);
		    }
		  else /* add \4add_var_type_layer, since validator/generator might use it */
		    if(resl!=NULL)
		      {
			if((resl->attr==TWOLISTS)
			   &&(resl->next==NULL))
			  mk_set_lnd(resl,tl,TYPELIST);
			else
			  mk_set_lnd(mk_head_lnd(NULL,resl,TWOLISTS),tl,TYPELIST);
			resl=mk_head_lnd(resl,strdup("\4add_var_type_layer"),FUNCTION);		 
		      }
		}
	    }
	  else if((!strcmp(mname->data,"MkPointer"))
		  ||(!strcmp(mname->data,"MkArray")))
	    {
	      struct typerec * tr=NULL;

	      mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab));
	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META->%s needs at least 1 arg\n",mname->data);
		  return;
		}
	      else if(mname->next->attr!=TYPEDEFN)
		{
		  fprintf(stderr,"META->%s needs 1st arg to be type\n",mname->data);
		  return;
		}
	      else if(mname->next->data==NULL)
		{
		  fprintf(stderr,"META->%s needs at least 1 arg\n/* interpret_meta_code():mname->next->data==NULL !!! */",mname->data);
		  return;
		}

	      if(mname->data[2]=='P')
		{
		  if(mname->next->next!=NULL)
		    fprintf(stderr,"Warning: META->%s needs only 1 arg, other %d are ignored\n",mname->data,lnd_count(mname->next->next));
		}
	      else
		{
		  if(mname->next->next!=NULL)
		    fprintf(stderr,"Warning: META->%s: array w/o dimensions, treating as pointer\n",mname->data);
		  free(mname->data);
		  mname->data=strdup("MkPointer");
		}
		
	      if(types->tlist==NULL)
		{
		  types->tlist=my_malloc(sizeof(struct type_list));
		  types->tlist->next=NULL;
		  types->tlist->convert_lock=OFF;
		  types->tlist->type=my_malloc(sizeof(struct typerec));
		  set_typerec(types->tlist->type,4,Strdup(((struct typerec *)mname->next->data)->name),TYPEREFR,(mname->data[2]=='P')?POINTER:INDEX,__void__,NULL);
		  tr=types->tlist->type;
		}
	      else
		tr=install_type(types->tlist,4,Strdup(((struct typerec *)mname->next->data)->name),TYPEREFR,(mname->data[2]=='P')?POINTER:INDEX,__void__,NULL)->type;

	      tr->typeid=++global_type_id_count;

	      if(mname->data[2]=='P')
		tr->typebody.pointer_to=(struct typerec *)mname->next->data;
	      else
		{
		  listnode ltmp=mname->next->next;
		  int i=0;

		  tr->typebody.index.pointer_to=(struct typerec *)mname->next->data;
		  tr->typebody.index.size=lnd_count(mname->next->next)+1;
		  tr->typebody.index.dims=my_malloc(sizeof(int)*(tr->typebody.index.size));
		  
		  for(;(ltmp!=NULL)&&(i<tr->typebody.index.size);ltmp=ltmp->next,i++)
		    {
		      if(((ltmp->attr!=VARIABLE)
			  &&(ltmp->attr!=ASSOCVAR)
			  &&(ltmp->attr!=PARTOFOP))
			 ||(ltmp->data==NULL))
			{
			  fprintf(stderr,"META->%s: dimensions must be vars\n",mname->data);
			  tr->typebody.index.dims[i]=atoi(ltmp->data);		
			}
		      else	
			tr->typebody.index.dims[i]=atoi(ltmp->data);		
		    }
		}

	      resl=mk_head_lnd(NULL,tr,TYPEDEFN);
	    }
	  else if(!strcmp(mname->data,"MkModArg"))
	    {
	      mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab));
	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META->%s needs at least 1 arg\n",mname->data);
		  return;
		}
	      else if(((mname->next->attr!=VARIABLE)
		       &&(mname->next->attr!=ASSOCVAR)
		       &&(mname->next->attr!=PARTOFOP))
		      ||(mname->next->data==NULL))
		{
		  fprintf(stderr,"META->%s needs 1st arg to be type name\n",mname->data);
		  return;
		};

	      resl=mk_head_lnd(NULL,my_malloc(sizeof(struct typerec)),TYPEDEFN);

	      ((struct typerec *)resl->data)->name=strdup(mname->next->data);
	      ((struct typerec *)resl->data)->typeid=++global_type_id_count;
	      ((struct typerec *)resl->data)->typekind=MODIFARG;

	      if((mname->next=rm_cdr_next(mname->next))==NULL)
		{}
	      else if(mname->next->attr!=TYPEDEFN)
		{
		  fprintf(stderr,"META->%s needs 2st arg to be type\n",mname->data);
		  return;
		}
	      else
		{
		  struct type_list * tl=NULL;
		  int i=3;
		  ((struct typerec *)resl->data)->typebody.class_list=tl=my_malloc(sizeof(struct type_list));

		  tl->type=(struct typerec *)mname->next->data;
		  mname->next->data=NULL;

		  for(mname->next=rm_cdr_next(mname->next);mname->next!=NULL;mname->next=rm_cdr_next(mname->next),i++)
		    if(mname->next->attr!=TYPEDEFN)
		      fprintf(stderr,"META->%s needs arg #%d to be type\n",mname->data,i);
		    else
		      {
			tl->next=my_malloc(sizeof(struct type_list));
			tl=tl->next;
			tl->type=(struct typerec *)mname->next->data;
			mname->next->data=NULL;
		      }
		}
	    }
	  else if((!strcmp(mname->data,"MkClass"))
		  ||(!strcmp(mname->data,"MkUnion"))
		  ||(!strcmp(mname->data,"MkModif")))
	    {
	      struct vardecl_listoflist * lr=NULL;
	      struct vardecl_list * vl=NULL;
	      struct typerec * tr=NULL;
	      struct type_listoflist * tmptypelp=types;
	      struct type_list * modarg_end_ptr=NULL;

	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META->%s needs at least 1 arg\n",mname->data);
		  return;
		};
	      if(mname->next->attr==TWOLISTS)
		{
		  listnode ltmp;
		  if((ltmp=clean_up_mcode(line_meta_code((listnode)mname->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab)))!=NULL)
		    {
		      if(ltmp->next==NULL)
			{
			  mname->next->data=ltmp->data;
			  mname->next->attr=ltmp->attr;
			  free(ltmp);
			}
		      else
			mname->next->data=(char *)ltmp;
		    }
		  else
		    mname->next->data=NULL;
		}
	      
	      if(((mname->next->attr!=VARIABLE)
		  &&(mname->next->attr!=ASSOCVAR)
		  &&(mname->next->attr!=PARTOFOP))
		 ||(mname->next->data==NULL))
		{
		  fprintf(stderr,"META->%s needs 1st arg to be type name\n",mname->data);
		  return;
		};
	      
	      if(types->tlist==NULL)
		{
		  types->tlist=my_malloc(sizeof(struct type_list));
		  types->tlist->next=NULL;
		  types->tlist->convert_lock=OFF;
		  types->tlist->type=my_malloc(sizeof(struct typerec));
		  set_typerec(types->tlist->type,0,Strdup(mname->next->data),(mname->data[2]=='C')?CLASS:((mname->data[2]=='M')?ISMODIF:UNION),NONE,__void__,NULL);
		  tr=types->tlist->type;
		}
	      else
		tr=install_type(types->tlist,0,Strdup(mname->next->data),(mname->data[2]=='C')?CLASS:((mname->data[2]=='M')?ISMODIF:UNION),NONE,__void__,NULL)->type;
	      
	      if(tr->typekind!=ISMODIF)
		tr->typebody.class_def=my_malloc(sizeof(struct class_def));

	      mname->next=rm_cdr_next(mname->next);

	      if(mname->next->data!=NULL)
		{
		  if(mname->next->attr==TYPEDEFN)
		    {
		      if(tr->typekind!=ISMODIF)
			{
			  tr->typebody.class_def->top_class=my_malloc(sizeof(struct type_list));
			  tr->typebody.class_def->top_class->next=NULL;
			  tr->typebody.class_def->top_class->type=(struct typerec *)mname->next->data;
			}
		      else
			{
			  tr->typebody.modif_def.mod_args=my_malloc(sizeof(struct type_list));
			  tr->typebody.modif_def.mod_args->next=NULL;
			  tr->typebody.modif_def.mod_args->type=(struct typerec *)mname->next->data;
			};
		      mname->next->data=NULL;
		    }
		  else if(((mname->next->attr==VARIABLE)
			   ||(mname->next->attr==ASSOCVAR)
			   ||(mname->next->attr==PARTOFOP))
			  &&(tr->typekind==ISMODIF))
		    {
		      tr->typebody.modif_def.mod_args=my_malloc(sizeof(struct type_list));
		      tr->typebody.modif_def.mod_args->next=NULL;
		      tr->typebody.modif_def.mod_args->type=my_malloc(sizeof(struct typerec));
		      tr->typebody.modif_def.mod_args->type->name=strdup(mname->next->data);
		      tr->typebody.modif_def.mod_args->type->typeid=++global_type_id_count;
		      tr->typebody.modif_def.mod_args->type->typekind=MODIFARG;
		    }
		  else if(mname->next->attr==TWOLISTS)
		    {
		      if((mname->next->data=(char *)clean_up_mcode(line_meta_code((listnode)mname->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab)))!=NULL)
			{
			  struct type_list * tcls=NULL;

			  /* dummy node at the beginning */
			  if(tr->typekind!=ISMODIF)
			    tr->typebody.class_def->top_class=tcls=my_malloc(sizeof(struct type_list));
			  else
			    tr->typebody.modif_def.mod_args=tcls=my_malloc(sizeof(struct type_list));

			  tcls->next=NULL;
			  tcls->type=NULL;
			  
			  for(;mname->next->data!=NULL;mname->next->data=(char *)rm_cdr_next((listnode)mname->next->data))
			    if(((listnode)mname->next->data)->attr==TYPEDEFN)
			      {
				tcls->next=my_malloc(sizeof(struct type_list));
				tcls->next->type=(struct typerec *)((listnode)mname->next->data)->data;
				((listnode)mname->next->data)->data=NULL;
				tcls->next->next=NULL;
			      }
			    else
			      fprintf(stderr,"META->%s: %s must be a type or a list of types\n",(tr->typekind==ISMODIF)?"modif args":"top class",mname->data);

			  /* remove dummy node at the beginning */
			  if(tr->typekind!=ISMODIF)
			    {
			      tcls=tr->typebody.class_def->top_class;
			      tr->typebody.class_def->top_class=tcls->next;
			    }
			  else
			    {
			      tcls=tr->typebody.modif_def.mod_args;
			      tr->typebody.modif_def.mod_args=tcls->next;
			    };
			  free(tcls);
			}		    
		    }
		  else
		    fprintf(stderr,"META->%s: top class must be a type or a list of types\n",mname->data);
		}

	      if(tr->typekind!=ISMODIF)
		{
		  lr=my_malloc(sizeof(struct vardecl_listoflist));
	      
		  *lr=*vars;
		  vars->next=lr;
		  vars->vlist=NULL;
		  
		  vars->ltype=DL_RUNIN;
		}
	      else
		{
		  tmptypelp=my_malloc(sizeof(struct type_listoflist));
		  modarg_end_ptr=tmptypelp->tlist=tr->typebody.modif_def.mod_args;
		  for(;modarg_end_ptr->next!=NULL;modarg_end_ptr=modarg_end_ptr->next);
		  tmptypelp->next=types;
		};

	      resl=line_meta_code(mname->next->next,labels,vars,tmptypelp,dst,inl,ops,opspec,inl_lab);
	      mname->next->next=NULL;
	      if(tr->typekind==ISMODIF)
		{
		  if(modarg_end_ptr->next!=NULL)
		    /* if something was added to tmptypelp */
		    {
		      struct type_list * tmp_tl=types->tlist;

		      if(tmp_tl==NULL)
			types->tlist=modarg_end_ptr->next;
		      else
			{
			  for(;tmp_tl->next!=NULL;tmp_tl=tmp_tl->next);
			  tmp_tl->next=modarg_end_ptr->next;
			};
		      modarg_end_ptr->next=NULL;
		    };

		  resl=clean_up_mcode(resl);
		  if(resl==NULL)
		    fprintf(stderr,"META->%s: modif template type required\n",mname->data);
		  else if(resl->attr!=TYPEDEFN)
		    fprintf(stderr,"META->%s: 3rd arg must be modif template type\n",mname->data);
		  else if(resl->data==NULL)
		    fprintf(stderr,"META->%s: modif template type required\n",mname->data);
		  else
		    tr->typebody.modif_def.type=(struct typerec *)resl->data;
		  free(resl);
		  free(tmptypelp);
		}
	      else
		{
		  for(lr=vars;lr!=NULL;lr=lr->next)
		    if(lr->ltype==DL_RUNIN)
		      {
			struct vardecl_listoflist * lr_t;
			if((lr_t=lr->next)!=NULL)
			  {
			    vl=clean_up_vl(lr->vlist,1);
			    *lr=*lr_t;
			    free(lr_t);
			  }
			else
			  {
			    vl=clean_up_vl(lr->vlist,1);
			    lr->vlist=NULL;
			  }
			break;
		      }
		  
		  tr->typebody.class_def->vars=vl;
		  
		  if(tr->typekind==UNION)
		    {
		      for(;vl!=NULL;vl=vl->next)
			if(vl->var!=NULL)
			  if(vl->var->type!=NULL)
			    if(tr->size<vl->var->type->size)
			      tr->size=vl->var->type->size;
		    }
		  else
		    {
		      for(;vl!=NULL;vl=vl->next)
			if(vl->var!=NULL)
			  if(vl->var->type!=NULL)
			    tr->size+=vl->var->type->size;
		    };
		};

	      resl=mk_head_lnd(NULL,tr,TYPEDEFN);
	    }
	  else if(!strcmp(mname->data,"GetExpression"))	  
	    {
	      int change=0;
	      listnode dst=NULL;
	      
	      if(mname->next!=NULL)
		fprintf(stderr,"META->GetExpression takes no args\n");
      
	      /* read data into buffer */
	      dst=mk_head_lnd(NULL,NULL,PARTOFOP);

	      if(!(change=get_expression(global_buffers_lst->data,dst,ops,inl,opspec,0,types,vars)))
		{
		  fprintf(stderr,"META->GetExpression() : can't get this expression :\n%s\n",global_buffers_lst->data);
		  return;
		};

	      if((resl=op_to_function(rm_cdr_next(dst)))==NULL)
		{
		  fprintf(stderr,"META->GetExpression() : can't convert to function :\n%s\n",global_buffers_lst->data);
		  return;
		};
	      refresh_buffer(global_buffers_lst->data,change,STR_BUF_SIZE);
	    }
	  else if((!strcmp(mname->data,"MkFn"))
		  ||(!strcmp(mname->data,"MkFnI"))
		  ||(!strcmp(mname->data,"MkFnM"))
		  ||(!strcmp(mname->data,"MkFnF"))
		  ||(!strcmp(mname->data,"MkFnIF"))
		  ||(!strcmp(mname->data,"MkFnMF")))
	    {
	      struct vardecl_list * fnd=NULL;
	      struct typerec * fnd_tr,* fn_res;
	      struct fundef * fnd_ptr=NULL;
	      char local_buf[34];

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next==NULL)
		{
		  fprintf(stderr,"META %s: fn name needed\n",mname->data);
		  return;
		}

	      if(((mname->next->attr!=VARIABLE)
		  &&(mname->next->attr!=ASSOCVAR)
		  &&(mname->next->attr!=PARTOFOP))
		  ||(mname->next->data==NULL))
		{
		  fprintf(stderr,"META %s: 1st arg must be fn name\n",mname->data);
		  return;
		}

	      if(mname->next->next==NULL)
		{
		  fprintf(stderr,"META %s: 2nd arg must be result type\n",mname->data);
		  return;
		}

	      if((mname->next->next->attr!=TYPEDEFN)
		 ||(mname->next->next->data==NULL))
		{
		  fprintf(stderr,"META %s: 2nd arg must be a type\n",mname->data);
		  return;
		}

	      fn_res=(struct typerec *)mname->next->next->data;
	      mname->next->next->data=NULL;
	      mname->next->next=rm_cdr_next(mname->next->next);

	      if(mname->next->next==NULL)
		{
		  fprintf(stderr,"META %s: 3rd arg must be args list\n",mname->data);
		  return;
		}

	      if(mname->next->next->attr!=VARDLIST)
		{
		  fprintf(stderr,"META->%s needs 3rd arg to be var layer\n",mname->data);
		  return;
		};
	      
	      fnd_ptr=my_malloc(sizeof(struct fundef));
	      fnd_ptr->name=strdup(mname->next->data);
	      fnd_ptr->res_type=fn_res;
	      fnd_ptr->args=clean_up_vl((struct vardecl_list *)mname->next->next->data,1);
	      mname->next->next->data=NULL;

	      if(!strcmp(mname->data,"MkFn"))
		{
		  fnd_ptr->attr=IS_EXPR;
		  fnd_ptr->kind=is_normal;
		}
	      else if(!strcmp(mname->data,"MkFnF"))
		{
		  fnd_ptr->attr=IS_FEXPR;
		  fnd_ptr->kind=is_normal;
		}
	      else if(!strcmp(mname->data,"MkFnI"))
		{
		  fnd_ptr->attr=IS_EXPR;
		  fnd_ptr->kind=is_inline;
		}
	      else if(!strcmp(mname->data,"MkFnIF"))
		{
		  fnd_ptr->attr=IS_FEXPR;
		  fnd_ptr->kind=is_inline;
		}
	      else if(!strcmp(mname->data,"MkFnM"))
		{
		  fnd_ptr->attr=IS_EXPR;
		  fnd_ptr->kind=is_meta;
		}
	      else if(!strcmp(mname->data,"MkFnMF"))
		{
		  fnd_ptr->attr=IS_FEXPR;
		  fnd_ptr->kind=is_meta;
		}

	      memset(local_buf,0,sizeof(local_buf));
	      sprintf(local_buf,"\4tmp_fn_t%lx",++global_tmp_type);

	      if(types->tlist==NULL)
		{
		  types->tlist=my_malloc(sizeof(struct type_list));
		  types->tlist->next=NULL;
		  types->tlist->convert_lock=OFF;
		  types->tlist->type=my_malloc(sizeof(struct typerec));
		  set_typerec(types->tlist->type,sizeof(long),Strdup(local_buf),FUN_DEFN,NONE,__void__,NULL);
		  fnd_tr=types->tlist->type;
		}
	      else
		fnd_tr=install_type(types->tlist,sizeof(long),Strdup(local_buf),FUN_DEFN,NONE,__void__,NULL)->type;
	      
	      fnd_tr->typebody.fundef=fnd_ptr;

	      if(vars->vlist==NULL)
		vars->vlist=fnd=insert_var_decl(NULL,mname->next->data,fnd_tr,NULL,0);
	      else
		fnd=insert_var_decl(vars->vlist,mname->next->data,fnd_tr,NULL,0);
	      if(fnd!=NULL)
		if(fnd->var!=NULL)
		  fnd->var->attr=VAR_FUNC;

	      if((resl=mname->next->next->next)==NULL)
		{
		  printf("# META %s: empty def of %s treated as prototype\n",mname->data,mname->next->data);
		  if(fnd_ptr->kind!=is_normal)
		    fprintf(stderr,"META %s: warning: %s isn't regular fn\n",mname->data,mname->next->data);
		  fnd_ptr->kind=is_prototype;
		  fnd_tr->typekind=FUNPROTO;
		}
	      else
		{
		  if(resl->attr==CODEBLOCK)
		    {
		      if(fnd_ptr->kind!=is_normal)
			fprintf(stderr,"META %s: %s isn't regular fn, can't have regular def\nChanging to regular from this point\n",mname->data,mname->next->data);
		      fnd_ptr->def_to_use.name_in_code=resl->data;
		      resl->data=NULL;
		    } 
		  else 
		    {
		      struct inline_fndef * ifd=NULL;

		      ifd=my_malloc(sizeof(struct inline_fndef));
		      if(resl->attr==INLINFUN)
			{
			  listnode ltmp;
			  for(ltmp=(listnode)resl->data;ltmp!=NULL;)
			    {
			      if(ltmp->attr==VARDLIST)
				{
				  if(ifd->vars!=NULL)
				    {
				      fprintf(stderr,"META %s:Two var lists\n",mname->data);
				      ltmp=ltmp->next;
				    }
				  else
				    {
				      ifd->vars=(struct vardecl_list *)ltmp->data;
				      ltmp->data=NULL;
				      if(ltmp==(listnode)resl->data)
					resl->data=(char *)ltmp->next;
				      ltmp=rm_cdr_next(ltmp);
				    }
				}
			      else if(ltmp->attr==TYPELIST)
				{
				  if(ifd->types!=NULL)
				    {
				      fprintf(stderr,"META %s:Two var lists\n",mname->data);
				      ltmp=ltmp->next;
				    }
				  else
				    {
				      ifd->types=(struct type_list *)ltmp->data;
				      ltmp->data=NULL;
				      if(ltmp==(listnode)resl->data)
					resl->data=(char *)ltmp->next;
				      ltmp=rm_cdr_next(ltmp);
				    }
				}
			      else
				ltmp=ltmp->next;
			    }
			  ifd->body=(listnode)resl->data;
			  resl->data=NULL;			  
			}
		      else
			{
			  ifd->vars=NULL;
			  ifd->types=NULL;
			  ifd->body=resl;
			  mname->next->next->next=NULL;
			}
		      fnd_ptr->def_to_use.inline_fndef=ifd;
		      if(fnd_ptr->kind==is_normal)
			{
			  fprintf(stderr,"META %s: warning: %s can't be regular fn, making it inline\n",mname->data,mname->next->data);
			  fnd_ptr->kind=is_inline;
			};
		    }
		}

	      mname->next=clean_up_mcode(mname->next);
	      resl=mk_head_lnd(NULL,fnd->var,VARDECL);
	    }
	  else if((!strcmp(mname->data,"GetCodeBlock"))
	    ||(!strcmp(mname->data,"GetCodeBlockI")))
	    {
	      char buf[34],lab[34];
	      
	      if(mname->next!=NULL)
		fprintf(stderr,"META->%s takes no args\n",mname->data);
      
	      /* read data into buffer */
	      if(!strcmp(mname->data,"GetCodeBlockI"))
		{
		  listnode dst;

		  dst=mk_head_lnd(NULL,NULL,PARTOFOP);
		  if(!get_code_block(global_buffers_lst->data,dst,inl,ops,opspec,labels,inl_lab,vars,types,1))
		    {
		      fprintf(stderr,"META->GetCodeBlock() : can't get this expression :\n%s\n",global_buffers_lst->data);
		      return;
		    };
		  resl=mk_head_lnd(NULL,rm_cdr_next(dst),INLINFUN);
		}
	      else
		{
		  sprintf(buf,"lab%lx",global_label_count++);
		  printf("jmp %s\n",buf);
		  sprintf(lab,"lab%lx",global_label_count++);
		  printf("%s :\n",lab);
		  if(!get_code_block(global_buffers_lst->data,NULL,inl,ops,opspec,labels,inl_lab,vars,types,0))
		    {
		      fprintf(stderr,"META->GetCodeBlock() : can't get this expression :\n%s\n",global_buffers_lst->data);
		      return;
		    };
		  printf("retn\n%s :\n",buf);
		  resl=mk_head_lnd(NULL,strdup(lab),CODEBLOCK);
		}
	    }
	  else if((!strcmp(mname->data,"conc"))
		  ||(!strcmp(mname->data,"list")))

	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		{
		  if((mname->next->attr!=TWOLISTS)
		     &&(mname->next->attr!=FUNCAVAR))
		    resl=mname->next;
		  else
		    {
		      lnd_rapnde((listnode)mname->next->data,mname->next->next);
		      resl=(listnode)mname->next->data;
		      mname->next->data=NULL;
		    };
		};
	      if(!strcmp(mname->data,"list"))
		resl=mk_head_lnd(NULL,resl,TWOLISTS);
	      mname->next=NULL;
	    }
	  else if(!strcmp(mname->data,"slice"))
	    {
	      listnode lptr=NULL;
	      int from=-1,to=-1,i=0;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		{
		  if(mname->next->data!=NULL)
		    if(isnum(*mname->next->data))
		      from=atoi(mname->next->data);
		  if(mname->next->next!=NULL)
		    if(isnum(*mname->next->next->data))
		      to=atoi(mname->next->next->data);
		};
	      if((from==-1)||(to==-1))
		{
		  fprintf(stderr,"META->slice:parameters error\n");
		  return;
		};

	      lptr=mname->next->next->next;
	      for(i=0;(lptr!=NULL)&&(i<from);lptr=lptr->next)
		i++;
	      if(i<from)
		{
		  fprintf(stderr,"META->slice: can't slice %d - %d from %d members\n",from,to,i);
		  return;
		};
	      for(i=0;(lptr!=NULL)&&(i<to);lptr=lptr->next,i++)
		{
		  if(resl==NULL)
		    resl=mk_head_lnd(NULL,lptr->data,lptr->attr);
		  else
		    mk_set_lnd(resl,lptr->data,lptr->attr);
		  lptr->data=NULL;
		};
	      if(i<to)
		{
		  fprintf(stderr,"META->slice: can't slice %d - %d from %d members\n",from,to,i);
		  return;
		};
	    }
	  else if(!strcmp(mname->data,"decompose"))
	    {
	      char symarr[2]={0,0},* bptr;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		{
		  if(mname->next->data==NULL)
		  {
		    fprintf(stderr,"META->decompose requires an arg\n");
		    return;
		  };
		  for(bptr=mname->next->data;*bptr!=0;bptr++)
		    {
		      symarr[0]=*bptr;
		      if(resl==NULL)
			resl=mk_head_lnd(NULL,strdup(symarr),VARIABLE);
		      else
			mk_set_lnd(resl,strdup(symarr),VARIABLE);
		    };
		}
	      else
		{
		  fprintf(stderr,"META->decompose requires an arg\n");
		  return;
		};
	      mname->next=NULL;
	    }
	  else if(!strcmp(mname->data,"compose"))
	    {
	      char *dstarr=NULL,* bptr=NULL;
	      listnode lptr=NULL;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));
	      if(mname->next!=NULL)
		{
		  if(mname->next->data==NULL)
		  {
		    fprintf(stderr,"META->compose requires an arg\n");
		    return;
		  };
		  if(mname->next->attr==TWOLISTS)
		    lptr=(listnode)mname->next->data;
		  else
		    lptr=mname->next;
		};
	      if(lptr==NULL)
		{
		  fprintf(stderr,"META->compose requires an arg\n");
		  return;
		};
	      while((dstarr==NULL)&&(lptr!=NULL))
		{
		  if((lptr->attr!=VARIABLE)
		     &&(lptr->attr!=ASSOCVAR))
		    {
		      fprintf(stderr,"META->compose: wrong attr in list\n");
		      return;
		    };

		  dstarr=lptr->data;
		  lptr=lptr->next;
		};
	      for(;lptr!=NULL;lptr=lptr->next)
		if(lptr->data!=NULL)
		  {
		    if((lptr->attr!=VARIABLE)
		       &&(lptr->attr!=ASSOCVAR))
		      {
			fprintf(stderr,"META->compose: wrong attr in list\n");
			return;
		      };
		    bptr=my_malloc(strlen(dstarr)+strlen(lptr->data)+1);
		    strcpy(bptr,dstarr);
		    free(dstarr);
		    dstarr=bptr;
		    bptr=NULL;
		    strcat(dstarr,lptr->data);
		  };
	      mname->next=NULL;
	    }
	  else if(!strcmp(mname->data,"replace"))
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next==NULL)
		resl=NULL;
	      else if(mname->next->next==NULL)
		{
		  resl=mname->next;
		  mname->next=NULL;
		}
	      else if(mname->next->next->next==NULL)
		{
		  resl=mname->next;
		  mname->next=NULL;
		}
	      else
		{
		  listnode lx=NULL,ly=NULL;
		  resl=mname->next;
		  lx=mname->next->next;
		  ly=mname->next->next->next;

		  mname->next->next->next=NULL;
		  mname->next->next=NULL;
		  mname->next=NULL;

		  lnd_replace_x(resl,lx,ly,0);
		  clean_up_mcode_lst(resl=clean_up_mcode(resl));
		  if(resl!=NULL)
		    while((resl->attr==TWOLISTS)
			  &&(resl->next==NULL))
		      {
			clean_up_mcode_lst(lx=clean_up_mcode((listnode)resl->data));	
			free(resl);
			resl=lx;
		      }
		}
	    }
	  else if(!strcmp(mname->data,"funcall"))
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));
	      if(mname->next!=NULL)
		{
		  if((mname->next->attr!=TWOLISTS)
		     &&(mname->next->attr!=FUNCAVAR))
		    resl=mname->next;
		  else
		    {
		      lnd_rapnde((listnode)mname->next->data,mname->next->next);
		      resl=(listnode)mname->next->data;
		      mname->next->data=NULL;
		    };
		};
	      resl->attr=FUNCTION;
	      mname->next=NULL;
	    }
	  else if(!strcmp(mname->data,"setprop"))
	    {
	      struct vardecl_list * vsymb=NULL;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		{
		  if((mname->next->attr==TWOLISTS)
		     &&(mname->next->attr==FUNCAVAR))
		    {
		      fprintf(stderr,"META->setprop 1st arg should be symbol\n");
		      return;
		    };
		  if(mname->next->next==NULL)
		    {
		      fprintf(stderr,"META->setprop: not enough args\n");
		      return;
		    }
		  else if((mname->next->next->attr==TWOLISTS)
			  &&(mname->next->next->attr==FUNCAVAR))
		    {
		      fprintf(stderr,"META->setprop 2st arg should be symbol\n");
		      return;
		    };
		}
	      else
		{
		  fprintf(stderr,"META->setprop: not enough args\n");
		  return;
		};
	      if((vsymb=global_find_var_decl(mname->next->data,vars,1))==NULL)
		{
		  fprintf(stderr,"META->setprop: can't find var %s\n",mname->next->data);
		  return;
		};
	      if(vsymb->var->sym_prop==NULL)
		vsymb->var->sym_prop=mk_head_lnd(NULL,mk_head_lnd(mname->next->next->next,strdup(mname->next->next->data),VARIABLE),TWOLISTS);
	      else
		mk_set_lnd(vsymb->var->sym_prop,mk_head_lnd(mname->next->next->next,strdup(mname->next->next->data),VARIABLE),TWOLISTS);
	      mname->next->next->next=NULL;
	      rm_listnode(mcode);
	      if(mcode->data!=NULL)
		free(mcode->data);
	      mcode->data=NULL;
	      mcode->attr=PARTOFOP;
	      return;
	    }
	  else if(!strcmp(mname->data,"getprop"))
	    {
	      struct vardecl_list * vsymb=NULL;
	      listnode l=NULL;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		{
		  if((mname->next->attr==TWOLISTS)
		     &&(mname->next->attr==FUNCAVAR))
		    {
		      fprintf(stderr,"META->getprop 1st arg should be symbol\n");
		      return;
		    };

		  if(mname->next->next==NULL)
		    {
		      fprintf(stderr,"META->getprop: not enough args\n");
		      return;
		    }
		  else if((mname->next->next->attr==TWOLISTS)
			  &&(mname->next->next->attr==FUNCAVAR))
		    {
		      fprintf(stderr,"META->getprop 2st arg should be symbol\n");
		      return;
		    };
		}
	      else
		{
		  fprintf(stderr,"META->getprop: not enough args\n");
		  return;
		};
	      if((vsymb=global_find_var_decl(mname->next->data,vars,1))==NULL)
		{
		  fprintf(stderr,"META->getprop: can't find var %s\n",mname->next->data);
		  return;
		};
	      for(l=vsymb->var->sym_prop;l!=NULL;l=l->next)
		if(l->attr!=TWOLISTS)
		  fprintf(stderr,"Weird: in sym_prop attr != TWOLISTS\n");
		else if(!strcmp(((listnode)l->data)->data,mname->next->next->data))
		  break;
	      if(l!=NULL)
		resl=copylist(((listnode)l->data)->next);
	      rm_listnode(mcode);
	    }
	  else if(!strcmp(mname->data,"rmprop"))
	    {
	      struct vardecl_list * vsymb=NULL;
	      listnode l=NULL;

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next!=NULL)
		{
		  if((mname->next->attr==TWOLISTS)
		     &&(mname->next->attr==FUNCAVAR))
		    {
		      fprintf(stderr,"META->rmprop 1st arg should be symbol\n");
		      return;
		    };

		  if(mname->next->next==NULL)
		    {
		      fprintf(stderr,"META->rmprop: not enough args\n");
		      return;
		    }
		  else if((mname->next->next->attr==TWOLISTS)
			  &&(mname->next->next->attr==FUNCAVAR))
		    {
		      fprintf(stderr,"META->rmprop 2st arg should be symbol\n");
		      return;
		    };
		}
	      else
		{
		  fprintf(stderr,"META->rmprop: not enough args\n");
		  return;
		};
	      if((vsymb=global_find_var_decl(mname->next->data,vars,1))==NULL)
		{
		  fprintf(stderr,"META->rmprop: can't find var %s\n",mname->next->data);
		  return;
		};
	      for(resl=l=vsymb->var->sym_prop;l!=NULL;resl=l,l=l->next)
		if(l->attr!=TWOLISTS)
		  fprintf(stderr,"Weird: in sym_prop attr != TWOLISTS\n");
		else if(!strcmp(((listnode)l->data)->data,mname->next->next->data))
		  break;
	      if(l!=NULL)
		{
		  rm_lnd_all((listnode)l->data);
		  l->data=NULL;
		  if(resl==l)
		    vsymb->var->sym_prop=rm_cdr_next(l);
		  else
		    resl->next=rm_cdr_next(l);
		}
	      else
		{
		  fprintf(stderr,"META->rmprop:variable %s don't have property %s\n",vsymb->var->name,mname->next->next->data);
		  return;
		};
	    }
	  else if(!strcmp(mname->data,"quote"))
	    {
	      resl=mname->next;
	      mname->next=NULL;
	    }
	  else if(!strcmp(mname->data,"makemeta"))
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));
	      
	      resl=mname->next;
	      mname->next=NULL;
	      if(resl!=NULL)
		{
		  if(resl->next!=NULL)
		    resl=mk_head_lnd(NULL,resl,TWOLISTS);
		  resl=mk_head_lnd(mk_head_lnd(resl,strdup("META"),VARIABLE),strdup("\4objpart"),FUNCTION);
		}
	    }
	  else if(!strcmp(mname->data,"map"))
	    {
	      listnode argptr=NULL,reslptr=NULL;

	      reslptr=resl=mk_head_lnd(NULL,"\4prog",FUNCTION);

	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));
	      
	      if(mname->next==NULL)
		{
		  fprintf(stderr,"Not enough arguments for built-in META \"map\"\n");
		  return;
		};
	      if(mname->next->next==NULL)
		{
		  fprintf(stderr,"Not enough arguments for built-in META \"map\"\n");
		  return;
		};
	      if(mname->next->attr!=TWOLISTS)
		{
		  fprintf(stderr,"Built-in META \"map\" requires first arg to be function\n");
		  return;
		};
	      if(mname->next->data==NULL)
		{
		  fprintf(stderr,"Built-in META \"map\" first arg is empty !\n");
		  return;
		};
	      if((mname->next->next->attr!=VARIABLE)
		 &&(mname->next->next->attr!=ASSOCVAR))
		{
		  fprintf(stderr,"Built-in META \"map\" requires second arg to be variable\n");
		  return;
		};
	      /* interpret all var list and clean it */
	      clean_up_mcode_lst(mname->next->next->next=clean_up_mcode(line_meta_code(mname->next->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));
	      for(argptr=mname->next->next->next;argptr!=NULL;argptr=argptr->next)
		{
		  reslptr=mk_set_lnd(resl,copylist((listnode)mname->next->data),TWOLISTS);
		  reslptr=(listnode)reslptr->data;
		  lnd_replace(reslptr,mname->next->next->data,ASSOCVAR,argptr->data,argptr->attr,3,0);
		  lnd_replace(reslptr,mname->next->next->data,VARIABLE,argptr->data,argptr->attr,3,0);
		};
	    }
	  else if((!strcmp(mname->data,"NumAdd"))
		  ||(!strcmp(mname->data,"NumSub"))
		  ||(!strcmp(mname->data,"NumMul"))
		  ||(!strcmp(mname->data,"NumDiv")))
	    {
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      if(mname->next==NULL)
		fprintf(stderr,"%s requires 2 args",mname->data);
	      else if(mname->next->next==NULL)
		fprintf(stderr,"%s requires 2 args",mname->data);
	      else if(mname->next->data==NULL)
		fprintf(stderr,"%s requires 2 args",mname->data);
	      else if(mname->next->next->data==NULL)
		fprintf(stderr,"%s requires 2 args",mname->data);
	      else if(((mname->next->attr==VARIABLE)
		       ||(mname->next->attr==ASSOCVAR)
		       ||(mname->next->attr==PARTOFOP))
		      &&((mname->next->next->attr==VARIABLE)
			 ||(mname->next->next->attr==ASSOCVAR)
			 ||(mname->next->next->attr==PARTOFOP))
		      &&isnum(*mname->next->data)
		      &&isnum(*mname->next->next->data))
		{
		  long num1,num2,res;
		  char res_buf[32];

		  num1=atoi(mname->next->data);
		  num2=atoi(mname->next->next->data);
		  switch(mname->data[3])
		    {
		    case 'A':
		      res=num1+num2;
		      break;
		    case 'S':
		      res=num1-num2;
		      break;
		    case 'M':
		      res=num1*num2;
		      break;
		    case 'D':	
		      if(!num2)
			{
			  fprintf(stderr,"Zero division while calculating %s\n",mname->data);
			  res=0;
			}
		      else
			res=num1/num2;
		      break;
		    default:
		      fprintf(stderr,"Weird: impossible operation code\n");
		      abort();
		    };
		  memset(res_buf,0,sizeof(res_buf));
		  sprintf(res_buf,"%ld",res);
		  resl=mk_head_lnd(NULL,strdup(res_buf),VARIABLE);
		}
	      else
		{
		  /* TODO: replace _ with \4 
		     This allocates 7 byte string, for "\4Num"OPCODE */
		  resl=mk_head_lnd(mname->next,my_malloc(7),FUNCTION);
		  mname->next=NULL;
		  *resl->data='_';
		  strcat(resl->data,mname->data);
		}
	    }
	  else if(!strcmp(mname->data,"len"))
	    {
	      char buf[8];
	      
	      clean_up_mcode_lst(mname->next=clean_up_mcode(line_meta_code(mname->next,labels,vars,types,dst,inl,ops,opspec,inl_lab)));

	      sprintf(buf,"%d",lnd_count(mname->next)+1);
	      resl=mk_head_lnd(NULL,strdup(buf),VARIABLE);
	    }
	  else
	    {
	      fprintf(stderr,"META function %s unknown !!!\n",mname->data);
	      return;
	    };

	  rm_listnode(mcode);
	  if(mcode->data!=NULL)
	    free(mcode->data);
	  if(resl==NULL)
	    {
	      mcode->data=NULL;
	      mcode->attr=PARTOFOP;
	    }
	  else
	    {
	      *mcode=*resl;
	      free(resl);
	    };

	  return;
	};
      return;
    }
  for(l=mcode;l!=NULL;l=l->next)
    {
      listnode lt;
      switch(l->attr)
	{
	case TWOLISTS:
	case FUNCAVAR:
	  if(l->data==NULL)
	    break;
	  interpret_meta_code((listnode)l->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	  break;
	case FUNCTION:
	  interpret_meta_code(l,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	  l->next=clean_up_mcode(l->next);
	  clean_up_mcode_lst(l);
	  for(lt=l;lt!=NULL;lt=lt->next)
	    if(lt->attr==TWOLISTS)
	      {
		listnode ltmp;
		if((ltmp=(listnode)lt->data)!=NULL)
		  if((ltmp->attr!=FUNCTION)
		     &&(ltmp->attr!=FUNCAVAR))
		    {
		      lt->data=NULL;
		      lnd_rapnde(ltmp,lt->next);
		      *lt=*ltmp;
		      free(ltmp);
		    }
	      }
	default:
	  break; /* otherwise GNU C gives warnings */
	};
    };  
}

int exec_inline_func(struct fundef * fn,listnode args,listnode labels,struct vardecl_listoflist * vars,struct type_listoflist * types,listnode dst,listnode inl,defined_op ops,listnode opspec,listnode inl_lab)
{
  listnode l;
  struct vardecl_listoflist this_vars;
  struct type_listoflist this_types;
  struct vardecl_list * varind;
  if(fn==NULL)
    {
      fprintf(stderr,"exec_inline_func(): fn==NULL !\n");
      return 0;
    };
  if((fn->kind!=is_inline)
     &&(fn->kind!=is_meta))
    {
      fprintf(stderr,"exec_inline_func(): function \"%s\" is not inline or META !\n",fn->name);
      return 0;
    };
  if(fn->def_to_use.inline_fndef==NULL)
    {
      fprintf(stderr,"exec_inline_func(): in function \"%s\" inline_fndef==NULL !\n",fn->name);
      return 0;
    };
  printf("## Executing %s function %s\n",(fn->kind==is_inline)?"inline":"META",fn->name);
  this_vars.next=vars;
  this_types.next=types;
  this_vars.vlist=fn->def_to_use.inline_fndef->vars;
  this_types.tlist=fn->def_to_use.inline_fndef->types;
  
  for(l=fn->def_to_use.inline_fndef->body;l!=NULL;l=l->next)
    {
      listnode out,argind;
      if(l->attr==TWOLISTS)
	{
	  if(l->data==NULL)
	    continue;
	  else
	    out=copylist((listnode)l->data);
	}
      else
	{
	  fprintf(stderr,"exec_inline_func(): in function \"%s\" in body attr!=TWOLISTS !\n",fn->name);
	  return 0;
	};
      for(varind=fn->args,argind=args;(varind!=NULL)&(argind!=NULL);varind=varind->next,argind=argind->next)
	{
	  if(varind->var!=NULL)
	    {
	      if(varind->var->name!=NULL)
		{
		  void * repl=NULL;

		  if(argind->attr==TWOLISTS)
		    repl=copylist((listnode)argind->data);
		  else
		    repl=Strdup(argind->data);

		  lnd_replace(out,varind->var->name,ASSOCVAR,repl,argind->attr,2,0);
		  lnd_replace(out,varind->var->name,VARIABLE,repl,argind->attr,2,0);
		};
	    };
	};
      if(((void *)varind)!=((void *)argind))
	/* if one of the lists isn't NULL */
	{
	  fprintf(stderr,"exec_inline_func(): in function \"%s\"\n amount of actual arguments is %s than amount of formal params\n",fn->name,(argind==NULL)?"smaller":"greater");
	  rm_lnd_all(out);
	  return 0;
	};
      if(fn->kind==is_inline)
	{
	  mk_asm_output(out,labels,&this_vars,&this_types,dst,inl,ops,opspec,inl_lab,1);
	  rm_lnd_all(out);
	}
      else
	{
	  if(*out->data!=4)
	    /* if not a special function - that includes objpart - then just 
	       dump it out */
	    mk_asm_output(out,labels,&this_vars,&this_types,dst,inl,ops,opspec,inl_lab,1);
	  else if(!strcmp(out->data,"\4objpart"))
	    {
	      if(out->next->attr==TWOLISTS)
		mk_asm_output(out,labels,&this_vars,&this_types,dst,inl,ops,opspec,inl_lab,1);
	      else if(strcmp(out->next->data,"META"))
		mk_asm_output(out,labels,&this_vars,&this_types,dst,inl,ops,opspec,inl_lab,1);
	      else
		{
		  interpret_meta_code(out,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		  mk_asm_output(out,labels,&this_vars,&this_types,dst,inl,ops,opspec,inl_lab,1);
		};
	    }
	  else
	    mk_asm_output(out,labels,&this_vars,&this_types,dst,inl,ops,opspec,inl_lab,1);
	  rm_lnd_all(out);
	};
    };
  return 1;
}

