#define __STORE_GLOBVARS__

#include "include/glbtypes.h"
#include "include/glbproto.h"
#include "include/globvars.h"
#include <fcntl.h>
#include <unistd.h>

/******************************************************************************/


void clear_local_declarations(struct vardecl_list * vl,struct type_list * tl)
{
  struct vardecl_list * vl1;
  struct type_list * tl1;
  
  for(vl1=vl;vl!=NULL;vl1=vl)
    {
      vl=vl->next;
      if(vl1->var!=NULL)
	{
	  if(vl1->var->name!=NULL)
	    Free(vl1->var->name);
	  /*		if(vl1->var->type!=NULL)
			Free(vl1->var->type); */
	  if((vl1->var->attr!=FN_VAR)&(vl1->var->attr!=VFN_VAR))
	    if(vl1->var->var_data.defvalue!=NULL)
	      Free(vl1->var->var_data.defvalue);
	  Free(vl1->var);
	};
      Free(vl1);
    };
  for(tl1=tl;tl!=NULL;tl1=tl)
    {
      tl=tl->next;
	if(tl1->type!=NULL)
	  {
	    if(tl1->type->name!=NULL)
	      Free(tl1->type->name);
	    switch(tl1->type->typekind)
	      {
	      case CLASS:
	      case UNION:
		clear_local_declarations(tl1->type->typebody.class_def->vars,NULL);
		Free(tl1->type->typebody.class_def);
		break;
	      case ACTIONCLASS:
		/* clear_local_declarations(tl1->type->typebody.actionclass->vars,NULL);*/
		Free(tl1->type->typebody.actionclass);
		break;
	      case ISTYPEOF:
		rm_lnd_all(tl1->type->typebody.typeof);
		break;
	      default:
		break; 
	      };
	    Free(tl1->type);
	  };
	Free(tl1);
    };
}




int get_code_block(
char * instr,
listnode dst,
listnode inl,
defined_op ops,
listnode opspec,
listnode inl_lab,
listnode labels,
struct vardecl_listoflist * vars,
struct type_listoflist * types,
int mode
)
{
  /* 0 - "normal" mode, i.e. get code block and generate code
     1 - "do list" mode, i.e. get code block and put it into 'dst' instead of generating code
     2 - "actionclass" mode, i.e. don't create/erase local vars, similar to "do list" */
  struct vardecl_listoflist * this_vars;
  struct type_listoflist * this_types;
  
  char * str;
  int change=0;
  int was_inline=0;
  listnode l,l1,l2;/* ,labels; */
  char local_buf[34];
  
  /* labels=mk_set_lnd(NULL,NULL,LABELDEF); */
  
  str=instr;
  while (*str==32) str++;
  refresh_buffer(instr,str-instr,STR_BUF_SIZE);
  instr=str;
  
  if(*str!='{')
    {
      /*	(listnode) l->data=mk_set_lnd(NULL,NULL,0); // make it a sublist */
      
      l1=mk_set_lnd(NULL,NULL,VARIABLE);
      
      for(l2=inl;l2!=NULL;l2=l2->next)
	if(inline_op_recognize(instr,l1,(inline_op)l2->data,ops,inl,opspec,inl_lab,labels,vars,types,0,mode))
	  break;
      if(l2==NULL)
	{
	  rm_lnd_all(l1); /* remove l */
	  
	  if(mode==1)
	    change=get_expression(str,dst,ops,inl,opspec,0,types,vars); 
	  /* Just an operator */
	  else
	    {
	      l1=mk_set_lnd(NULL,NULL,VARIABLE);
	      change=get_expression(str,l1,ops,inl,opspec,0,types,vars);
	    };
	  if (!change)
	    {
	      if(!mode)
		rm_lnd_all(l1);
	      return 0;
	    };
	  refresh_buffer(instr,change,STR_BUF_SIZE);
	  if(!mode)
	    {
	      l1->next=op_to_function(l1->next);
	      mk_asm_output(l1->next,labels,vars,types,dst,inl,ops,opspec,inl_lab,1);
	      rm_lnd_all(l1);
	    };
	}
      else
	{
	  if(mode==1)
	    {
	      l=lnd_cdre(dst);
	      l->next=l1->next;/* skip junk at the beginning */
	      Free(l1);/* clear this junk */
	    };
	};
      return 1;
    };
  change=1; /*  *str='{' */
  
  if(mode==1)
    l=mk_set_lnd(dst,NULL,TWOLISTS);
  else
    dst=l=mk_set_lnd(NULL,NULL,TWOLISTS);
  
  refresh_buffer(instr,change,STR_BUF_SIZE);
  
  this_types=my_malloc(sizeof(struct type_listoflist));
  this_vars=my_malloc(sizeof(struct vardecl_listoflist));
  this_types->next=types;
  this_vars->next=vars;
  this_types->tlist=NULL;
  this_vars->vlist=NULL;
  
  while((!!change)||was_inline)
    {
      memset(local_buf,0,34);
      
      str=instr;
      
      while(*str==32) str++;
      refresh_buffer(instr,str-instr,STR_BUF_SIZE);
      
      str=get_variable_name(instr);
      
      strncpy(local_buf,instr,str-instr);
      
      change=get_opdef_def(instr,ops,inl,opspec,vars,types);
      
      if(!change)
	{
	  if((get_type_by_name(local_buf,NONE,this_types)!=NULL)
	     ||(get_type_by_name(local_buf,FUNC,this_types)!=NULL) /* actionclass */
	     ||(!Strcmp(local_buf,"typeof"))
	     ||(!Strcmp(local_buf,"struct"))
	     ||(!Strcmp(local_buf,"union"))
	     ||(!Strcmp(local_buf,"class"))
	     ||(!Strcmp(local_buf,"aclass"))
	     ||(!Strcmp(local_buf,"typedef"))
	     ||(!Strcmp(local_buf,"modif")))
	    
	    change=get_var_decl(instr,this_types,this_vars,labels,ops,inl,opspec,inl_lab,0,NULL);
	};
      
      l->data=(char *)mk_set_lnd(NULL,NULL,PARTOFOP);/* for AIX cc */
      
      for(l2=inl;!change&(l2!=NULL);l2=l2->next)
	{
	  was_inline=inline_op_recognize(instr,(listnode)l->data,(inline_op)l2->data,ops,inl,opspec,inl_lab,labels,this_vars,this_types,0,mode);
	  if(was_inline)
	    break;
	};
      
      if(!change&!was_inline)
	{
	  change=get_expression(instr,(listnode)l->data,ops,inl,opspec,0,this_types,this_vars);
	  if (change)
	    {
	      refresh_buffer(instr,change,STR_BUF_SIZE);	      
	      l1=op_to_function(((listnode) l->data)->next);
	      
	      if(!mode)
		{
		  mk_asm_output(l1,labels,this_vars,this_types,dst,inl,ops,opspec,inl_lab,1);
		  rm_lnd_all(l1);
		}
	      else
		{
		  l->next=mk_set_lnd(NULL,NULL,TWOLISTS);
		  Free((listnode) l->data);
		  l->data=(char *)l1;/* dumb AIX cc */
		  l=l->next;
		};
	    }
	  else /* if !change ... */
	    {
	      if(l->data!=NULL)
		Free(l->data);
	      l->data=NULL;
	      if (*str=='}')
		break;
	      else
		{
		  str=get_variable_name(instr);
		  while(*str==32) str++;
		  if (*str==':')
		    {
		      str++;		/* avoid ':' */
		      memset(local_buf,0,32);
		      for(change=str-instr;*(instr+change)==32;change--);
		      strncpy(local_buf,instr,change++);
		      printf("lab%s :  ## Label %s\n",get_local_label((char *)local_buf,labels,LABELDEF),local_buf);
		      refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		      str=instr;
		      continue; /* after label no comma */
		    }
		  else
		    {
		      clear_local_declarations(this_vars->vlist,this_types->tlist);
		      Free(this_vars);
		      Free(this_types);
		      return 0;
		    };
		};
	    };
	};
      
      for(str=instr;(!!*str)&(*str!=';')&(*str!='}');str++){};
      if(*str==';') str++;
      refresh_buffer(instr,str-instr,STR_BUF_SIZE);
    };
  
  if(!mode)
    clear_local_declarations(this_vars->vlist,this_types->tlist);
  else
    dst->next=mk_head_lnd(mk_head_lnd(dst->next,this_vars->vlist,VARDLIST),this_types->tlist,TYPELIST);
  
  Free(this_vars);
  Free(this_types);
  
  if(*instr=='}')
    refresh_buffer(instr,1,STR_BUF_SIZE);
  else
    return 0;
  if(!mode)
    rm_lnd_all(dst);
  
  return 1;
}


char * get_local_label(char * name, listnode labels,enum lnd_attr mode)
{
  listnode l;
  char local_buf[34];
  char * res=NULL;
  
  if (labels==NULL)
    return NULL;
  
  for(l=labels;l!=NULL;l=l->next)
    {
      if(l->attr==TWOLISTS)
	res=get_local_label(name,(listnode)l->data,PARTOFOP);
      /*don't replace*/
      else if(l->data != NULL)
	if(!Strcmp(((listnode)l->data)->data,name))
	  if(((listnode)l->data)->next != NULL )
	    res=((listnode)l->data)->next->data;
      if(res!=NULL)
	break;   /* known label */
    };
  
  if(l==NULL)  /* new label */
    {
      if(mode==0)
	return NULL; /* No replacing */
      if(labels->attr==TWOLISTS)
	return get_local_label(name,(listnode)labels->data,mode);/* NOW Replace */
      else
	l=mk_set_lnd(labels,NULL,mode);
      l->data=(char *)lnd_asapnde(NULL,name,PARTOFOP);/* dumb AIX cc */
    };
  
  if (((listnode)l->data)->next==NULL)
    {
      sprintf(local_buf,"%lX",global_label_count);
      l=lnd_asapnde((listnode)l->data,local_buf,PARTOFOP);
      global_label_count++;
      return l->data;
    };
  
  if((mode==LABELDEF)&(l->attr==LABELREQ))
    l->attr=LABELDEF;   /* The label is known now */
  
  return res;
}






void print_asm_output(listnode lst, listnode labels,struct vardecl_listoflist * vars, struct type_listoflist * types,listnode dst,listnode inl,defined_op ops,listnode opspec,listnode inl_lab)
{
   char local_buf[34];
   listnode l;
   unsigned long loc_tmp_count=0;
   
   if(lst==NULL)
     return;

   if(lst->attr==VARIABLE)
     {
	if(*lst->data==4)
	  printf("push word ptr %s\n",(lst->data+1));
	else if(isnum(*lst->data))
	  printf("mov ax, %s\npush ax\n",lst->data);
	else
	  printf("push word ptr v%s\n",lst->data);
	return;
     };

   if(lst->attr==TWOLISTS)
     {
	print_asm_output((listnode)lst->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	print_asm_output(lst->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	return;
     };

   if(lst->attr==CODEBLOCK)
     {
       printf("call %s\n",lst->data);
       return;
     }
   if (lst->attr!=FUNCTION)
     return;
   
   loc_tmp_count=global_tmp_var;
   global_tmp_var++;

   if(!Strcmp(lst->data,"\4add_var_type_layer"))
     {
       struct vardecl_listoflist * lvars=vars,*lv;	    
       struct type_listoflist * ltypes=types,*lt;
       listnode l_ltmp;
       
       printf("# Adding var/type layer ..\n");
       for(l_ltmp=lst->next->next;l_ltmp==NULL;l_ltmp=l_ltmp->next)
	 {
	   switch(l_ltmp->attr)
	     {
	     case TYPEDEFN:
	       lt=ltypes;
	       ltypes=my_malloc(sizeof(struct type_list));
	       ltypes->next=lt;
	       ltypes->tlist=(struct type_list *)(l_ltmp->data);
	       break;
	     case VARDLIST:
	       lv=lvars;
	       lvars=my_malloc(sizeof(struct vardecl_list));
	       lvars->next=lv;
	       lvars->vlist=(struct vardecl_list *)(l_ltmp->data);
	       break;
	     default:
	       break;
	     };
	 };
       print_asm_output((listnode)lst->next->data,labels,lvars,ltypes,dst,inl,ops,opspec,inl_lab);
       while(ltypes!=types)
	 {
	   lt=ltypes->next;
	   clear_local_declarations(NULL,ltypes->tlist);
	   free(ltypes);
	   ltypes=lt;
	 };
       while(lvars!=vars)
	 {
	   lv=lvars->next;
	   free(lvars);
	   clear_local_declarations(lvars->vlist,NULL);
	   lvars=lv;
	 };
       return;
     };

   
   if((!Strcmp(lst->data,"\4run_inline"))
      ||(!Strcmp(lst->data,"\4run_meta")))
     {
       exec_inline_func((struct fundef *)lst->next->data,lst->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
       return;
     };
   if(!Strcmp(lst->data,"\4prog"))
     {
       if(lst->next->attr==FUNCTION)
	 {
	   print_asm_output(lst->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	   return;
	 }
       for(l=lst->next;l!=NULL;l=l->next)
	 {
	   if(l->attr==TWOLISTS)
	     print_asm_output((listnode)l->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	   else if((l->data!=NULL)||(l->attr!=PARTOFOP))
	     fprintf(stderr,"print_asm_output():prog: l attr %d data %lx \n",l->attr,(unsigned long)l->data);
	 }
	return;
     };
   if(!Strcmp(lst->data,"\4lambda"))
     {
	printf("###LAMBDA HERE###\n");
	return;
     };
   if(!Strcmp(lst->data,"\4label"))
     {
	printf("lab%s :\n",get_local_label(lst->next->data,labels,LABELDEF));
	return;
     };
   
   if(!Strcmp(lst->data,"\4goto"))
     {
	printf("jmp lab%s\n",get_local_label(lst->next->data,labels,LABELREQ));
	return;
     };
   
   if(!Strcmp(lst->data,"\4ifjmp"))
     {
	printf("jz lab%s\n",get_local_label(lst->next->data,labels,LABELREQ));
	return;
     };
   
   if(!Strcmp(lst->data,"\4check"))
     {
	if(lst->next->attr==FUNCTION)
	  {
	    if(validate_function(lst->next,vars,types,labels,0)==NULL)
	       {
		  fprintf(stderr,"One of current inline's components (%s) have type mismatch !\n",lst->next->data);
		  return;
	       };
	     print_asm_output(lst->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	     printf("cmp word prt [bp+__FIRST_ARG_IN_HEADER], 0\n");
	  }
	else
	  printf("cmp word ptr %s,0\n",lst->next->data);
	return;
     };
   
   if(!Strcmp(lst->data,"\4runcode"))
     {
	printf("call %s\n",get_local_label(lst->next->data,labels,LABELREQ));
	return;
     };
   
   if(!Strcmp(lst->data,"\4vartypeif"))
     {
	if(lst->next->attr!=TYPEVARL)
	  printf("# print_asm_output():strange:\4vartypeif's 2nd arg have attr %d different from TYPEVARL\n",lst->next->attr);
	if(lst->next->data==NULL)
	  printf("# print_asm_output():strange:\4vartypeif's 2nd arg  == NULL\n");
	
	global_tmp_var++;
	sprintf(local_buf,"\4tmplab%lx",global_tmp_var);
	for(l=(listnode)lst->next->data;l!=NULL;l=l->next)
	  {
	     if(l->attr!=VARTYPEL)
	       printf("# print_asm_output():strange:\4vartypeif's 2nd arg's list member have attr %d different from VARTYPEL\n",lst->next->attr);
	     
	     if(((listnode)l->data)->attr==VARTYPEL)
	       printf("push [xt%s]\n",((struct typerec *)((listnode)l->data)->data)->typebody.var_type.var->name);
	     else
	       printf("push %ld #static type id\n",((struct typerec *)((listnode)l->data)->data)->typeid);
	     
	     if(((listnode)l->data)->next->attr==VARTYPEL)
	       printf("push [xt%s]\n",((struct typerec *)((listnode)l->data)->next->data)->typebody.var_type.var->name);
	     else
	       printf("push %ld #static type id\n",((struct typerec *)((listnode)l->data)->next->data)->typeid);
	     
	     printf("call x_dyn_type_conv\njnz lab%s\n",get_local_label(local_buf,labels,LABELREQ));
	  };
	printf("lab%s:\n",get_local_label(local_buf,labels,LABELDEF));
	print_asm_output((listnode)lst->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	return;
     };
   if(!Strcmp(lst->data,"\4vartypevalid"))
     {
       char lbuf[33];

       puts("print_asm_output(): Validator (Dumping list):");
       printlist2(lst,0,1);
       (*((char *)NULL))+=printf("\nCreating core dump:");

       global_tmp_var++;
       sprintf(local_buf,"\4tmplab%lx",global_tmp_var);
	
       global_tmp_var++;
       sprintf(lbuf,"\4tmplab%lx",global_tmp_var);

       print_asm_output((listnode)lst->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);

     };
   if(!Strcmp(lst->data,"\4tryvalid"))
     {
       char lbuf[33];
	
       global_tmp_var++;
       sprintf(local_buf,"\4tmplab%lx",global_tmp_var);
	
       global_tmp_var++;
       sprintf(lbuf,"\4tmplab%lx",global_tmp_var);
	

       for(l=((listnode)lst->next->data)->next;l!=NULL;l=l->next)
	 {
	   if(l->attr==TWOLISTS)
	     {
	       if(((listnode)l->data)->attr==FUNCTION)
		 {
		   if(!Strcmp(((listnode)l->data)->data,"\4vartypevalid"))
		     {
		       print_asm_output((listnode)((listnode)l->data)->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		       printf("jnz lab%s\n",get_local_label(local_buf,labels,LABELREQ));
		       print_asm_output(((listnode)l->data)->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		     }
		   else
		     {
		       sprintf(local_buf,"\4tmpvar%lX",loc_tmp_count);
		       printf("%s EQU [bp+%ld]\npush word ptr __asm_NULL\n",local_buf,loc_tmp_count);
		       print_asm_output((listnode)l->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		     };
		 }
	       else
		 print_asm_output((listnode)l->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		    
	       rm_lnd_all((listnode)l->data);
	       l->attr=ASSOCVAR;
	       l->data=NULL;
	     }
	   else if(*l->data==4)
	     printf("push word ptr [%s]\n",(l->data+1));
	   else if(isnum(*l->data))
	     printf("mov ax, %s\npush ax\n",l->data);
	   else
	     printf("push word ptr [v%s]\n",l->data);
	 };
       printf("call %s\n",((listnode)lst->next->data)->data);
       printf("jmp lab%s\nlab%s:\n",get_local_label(lbuf,labels,LABELREQ),get_local_label(local_buf,labels,LABELDEF));
       if(lst->next->next==NULL)
	 printf("jmp get_wrong_type_except\n");
       else
	 print_asm_output(lst->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);

       printf("lab%s:\n",get_local_label(lbuf,labels,LABELDEF));
       return;

     };
   if(!Strcmp(lst->data,"\4vartypetry"))
     {
	char lbuf[33];
	
	global_tmp_var++;
	sprintf(local_buf,"\4tmplab%lx",global_tmp_var);
	
	global_tmp_var++;
	sprintf(lbuf,"\4tmplab%lx",global_tmp_var);
	

	for(l=((listnode)lst->next->data)->next;l!=NULL;l=l->next)
	  {

	     if(l->attr==TWOLISTS)
	       {
		  if(((listnode)l->data)->attr==FUNCTION)
		    {
		       if(!Strcmp(((listnode)l->data)->data,"\4vartypearg"))
			 {
			    if(((listnode)l->data)->next->attr==VARTYPEL)
			      printf("push [xt%s]\n",((struct typerec *)((listnode)l->data)->next->data)->typebody.var_type.var->name);
			    else
			      printf("push %ld #static type id\n",((struct typerec *)((listnode)l->data)->next->data)->typeid);
			    
			    if(((listnode)l->data)->next->next->attr==VARTYPEL)
			      printf("push [xt%s]\n",((struct typerec *)((listnode)l->data)->next->next->data)->typebody.var_type.var->name);
			    else
			      printf("push %ld #static type id\n",((struct typerec *)((listnode)l->data)->next->next->data)->typeid);
			    print_asm_output(((listnode)l->data)->next->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
			    printf("call x_dyn_type_conv\njnz lab%s\n",get_local_label(local_buf,labels,LABELREQ));
			 }
		       else
			 {
			    sprintf(local_buf,"\4tmpvar%lX",loc_tmp_count);
			    printf("%s EQU [bp+%ld]\npush word ptr __asm_NULL\n",local_buf,loc_tmp_count);
			    print_asm_output((listnode)l->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
			 };
		    }
		  else
		    print_asm_output((listnode)l->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		    
		  rm_lnd_all((listnode)l->data);
		  l->attr=ASSOCVAR;
		  l->data=NULL;
	       }
	     else if(*l->data==4)
		 printf("push word ptr [%s]\n",(l->data+1));
	     else if(isnum(*l->data))
	       printf("mov ax, %s\npush ax\n",l->data);
	     else
	       printf("push word ptr [v%s]\n",l->data);
	  };
	printf("call %s\n",((listnode)lst->next->data)->data);
	printf("jmp lab%s\nlab%s:\n",get_local_label(lbuf,labels,LABELREQ),get_local_label(local_buf,labels,LABELDEF));
	if(lst->next->next==NULL)
	  printf("jmp get_wrong_type_except\n");
	else if(lst->next->next->next==NULL)
	  printf("jmp get_wrong_type_except\n");
	else
	  print_asm_output(lst->next->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);

	printf("lab%s:\n",get_local_label(lbuf,labels,LABELDEF));
	return;
     };
   if(!Strncmp(lst->data,"\4vartype",8))
     {
	if(lst->next->next->next->attr==FUNCTION)	
	  print_asm_output(lst->next->next->next,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	else if(lst->next->next->next->attr==TWOLISTS)
	  print_asm_output((listnode)lst->next->next->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	else
	  printf("push word ptr [v%s]\n",lst->next->next->next->data);
	
	if(lst->data[8]=='v')
	  printf("push [xt%s]\n",((struct typerec *)lst->next->data)->typebody.var_type.var->name);
	else
	  printf("push %ld #static type id\n",((struct typerec *)lst->next->data)->typeid);
	if(lst->data[9]=='v')
	  printf("push [xt%s]\n",((struct typerec *)lst->next->next->data)->typebody.var_type.var->name);
	else
	  printf("push %ld #static type id\n",((struct typerec *)lst->next->next->data)->typeid);
	
	printf("call x_dyn_type_conv\njz x_gen_except_wrong_type\n");
	return;
     };
   
   if(!Strcmp(lst->data,"\4objpart"))
     {
       if(lst->next->attr==TWOLISTS)
	 {
	   print_asm_output((listnode)lst->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	   printf("mov bx, word ptr [bp+__FIRST_ARG_IN_HEADER]\n");
	 }
       else if(!strcmp(lst->next->data,"META"))
	 {
	   return;
	 }
       else
	 printf("mov bx, o%s\n",lst->next->data);
       
       if(lst->next->next->attr!=TWOLISTS)
	 printf("push [bx+O%s]\n",lst->next->next->data);
       else
	 {
	   printf("push [bx] ; object itself as a first arg\n");
	   if(*((listnode)lst->next->next->data)->data==4)
	     {
	       print_asm_output((listnode)lst->next->next->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	       return;
	     };
	   for(l=((listnode)lst->next->next->data)->next;l!=NULL;l=l->next)
	     if(l->attr==TWOLISTS)
	       {
		 sprintf(local_buf,"\4tmpvar%lX",loc_tmp_count);
		 printf("%s EQU [bp+%ld]\npush word ptr __asm_NULL\n",local_buf,loc_tmp_count);
		 print_asm_output((listnode)l->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
		 rm_lnd_all((listnode)l->data);
		 l->attr=ASSOCVAR;
		 Strcpy(l->data,local_buf);
	       }
	     else
	       {
		 if(*l->data==4)
		   printf("push word ptr %s\n",(l->data+1));
		 else if(isnum(*l->data))
		   printf("mov ax, %s\npush ax\n",l->data);
		 else
		   printf("push word ptr v%s\n",l->data);
	       };
	   
	   if(*((listnode)lst->next->next->data)->data!=4)
	     printf("call [bx+O%s]\n",((listnode)lst->next->next->data)->data);
	   else
	     printf("call [bx+%s]\n",((listnode)lst->next->next->data)->data+2);
	 };
       return;
     };
   
   
   for(l=lst->next;l!=NULL;l=l->next)
     if(l->attr==TWOLISTS)
     {
	if(((listnode)l->data)->attr==FUNCTION)
	  {
	     sprintf(local_buf,"\4tmpvar%lX",loc_tmp_count);
	     printf("%s EQU [bp+%ld]\npush word ptr __asm_NULL\n",local_buf,loc_tmp_count);
	  };
	print_asm_output((listnode)l->data,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	rm_lnd_all((listnode)l->data);
	l->attr=ASSOCVAR;
	l->data=Strdup(local_buf);
     }
   else
     if(*l->data==4)
       printf("push word ptr [%s]\n",(l->data+1));
   else if(isnum(*l->data))
     printf("mov ax, %s\npush ax\n",l->data);
   else
     printf("push word ptr [v%s]\n",l->data);
  
   /* printf("push bp\nmov bp, sp\n"); */
   if(!Strncmp("\4_",lst->data,2))
     printf("call %s\n",lst->data+2);
   else
     printf("call _%s\n",lst->data);
   /* printf("mov sp, bp\npop bp\n"); */
}


struct typerec * mk_asm_output(listnode lst, listnode labels,struct vardecl_listoflist * vars, struct type_listoflist * types,listnode dst,listnode inl,defined_op ops,listnode opspec,listnode inl_lab,int fnlstflag)
     /* fnlstflag:
	0 - functions "put in" by meta calls
	1 - normal operation
	2 - meta error handling
      */
{
  struct typerec * res=NULL;
  
  lnd_attr_subst(lst,ASSOCVAR,VARIABLE);
  /* from this point ASSOCVAR and VARIABLE mean the same thing 
     AV-TODO: check if we actually need ASSOCVAR in op_recognize(), etc */


  for(;(fnlstflag!=3)&&(global_error_seq!=NULL);global_error_seq=rm_cdr_next(global_error_seq))
    {
      if(global_error_seq->attr!=TWOLISTS)
	fprintf(stderr,"mk_asm_output:global_error_seq->attr=%d!=TWOLISTS\n",global_error_seq->attr);
      else
	mk_asm_output((listnode)global_error_seq->data,labels,vars,types,dst,inl,ops,opspec,inl_lab,3);
    };

  for(;(fnlstflag==1)&&(global_exec_fn_seq!=NULL);global_exec_fn_seq=rm_cdr_next(global_exec_fn_seq))
    {
      if(global_exec_fn_seq->attr!=TWOLISTS)
	fprintf(stderr,"mk_asm_output:global_exec_fn_seq->attr=%d!=TWOLISTS\n",global_exec_fn_seq->attr);
      else
	mk_asm_output((listnode)global_exec_fn_seq->data,labels,vars,types,dst,inl,ops,opspec,inl_lab,0);
    };

  for(;(fnlstflag!=3)&&(global_error_seq!=NULL);global_error_seq=rm_cdr_next(global_error_seq))
    {
      if(global_error_seq->attr!=TWOLISTS)
	fprintf(stderr,"mk_asm_output:global_error_seq->attr=%d!=TWOLISTS\n",global_error_seq->attr);
      else
	mk_asm_output((listnode)global_error_seq->data,labels,vars,types,dst,inl,ops,opspec,inl_lab,3);
    };

  while(lst!=NULL)
    if((lst->attr==PARTOFOP)
       &&(lst->data==NULL))
      lst=lst->next;
    else
      break;
  if(lst==NULL)
    return NULL;

  interpret_meta_code(lst,labels,vars,types,dst,inl,ops,opspec,inl_lab);

  for(;(fnlstflag!=3)&&(global_error_seq!=NULL);global_error_seq=rm_cdr_next(global_error_seq))
    {
      if(global_error_seq->attr!=TWOLISTS)
	fprintf(stderr,"mk_asm_output:global_error_seq->attr=%d!=TWOLISTS\n",global_error_seq->attr);
      else
	mk_asm_output((listnode)global_error_seq->data,labels,vars,types,dst,inl,ops,opspec,inl_lab,3);
    };
  
   if(lst->attr==INLINFUN)
     {
       struct vardecl_listoflist l_vl;
       struct type_listoflist l_tl;
       listnode ltmp=NULL;

       l_vl.next=vars;
       l_tl.next=types;
       l_vl.vlist=NULL;
       l_tl.tlist=NULL;

       for(ltmp=(listnode)lst->data;ltmp!=NULL;ltmp=ltmp->next)
	 {
	   if(ltmp->attr==VARDLIST)
	     {
	       if(l_vl.vlist!=NULL)
		 fprintf(stderr,"mk_asm_output:Two var lists\n");
	       else
		 l_vl.vlist=(struct vardecl_list *)ltmp->data;
	     }
	   else if(ltmp->attr==TYPELIST)
	     {
	       if(l_tl.tlist!=NULL)
		 fprintf(stderr,"mk_asm_output:Two type lists\n");
	       else
		 l_tl.tlist=(struct type_list *)ltmp->data;
	     }
	 }
       for(ltmp=(listnode)lst->data;ltmp!=NULL;ltmp=ltmp->next)
	 if((ltmp->attr!=VARDLIST)
	    &&(ltmp->attr!=TYPELIST))
	   {
	     if((lst->attr!=VARDECL)
		&&(lst->attr!=TYPEDEFN))
	       {
		 if((res=validate_function((listnode)ltmp->data,&l_vl,&l_tl,labels,0))==NULL)
		   {
		     fprintf(stderr,"Types doesnt match, aborting !\n");
		     break;
		   }
		 else
		   print_asm_output((listnode)ltmp->data,labels,&l_vl,&l_tl,dst,inl,ops,opspec,inl_lab);
	       }
	   };
       /* now update types/vars */
       for(ltmp=(listnode)lst->data;ltmp!=NULL;ltmp=ltmp->next)
	 if(ltmp->attr==VARDLIST)
	   {
	     ltmp->data=(char *)l_vl.vlist;
	     break;
	   };
       for(ltmp=(listnode)lst->data;ltmp!=NULL;ltmp=ltmp->next)
	 if(ltmp->attr==TYPELIST)
	   {
	     ltmp->data=(char *)l_tl.tlist;
	     break;
	   };
     }
   else 
     {
       if(lst->attr!=CODEBLOCK)
	 if((lst->data!=NULL)||(lst->attr!=PARTOFOP)||(lst->next!=NULL))
	   if((lst->attr!=VARDECL)
	      &&(lst->attr!=TYPEDEFN))
	     {
	       if((res=validate_function(lst,vars,types,labels,0))==NULL)
		 {
		   fprintf(stderr,"Types doesnt match, aborting !\n");
		   return NULL;
		 };
	       print_asm_output(lst,labels,vars,types,dst,inl,ops,opspec,inl_lab);
	     }
     };

  for(;(fnlstflag!=3)&&(global_error_seq!=NULL);global_error_seq=rm_cdr_next(global_error_seq))
    {
      if(global_error_seq->attr!=TWOLISTS)
	fprintf(stderr,"mk_asm_output:global_error_seq->attr=%d!=TWOLISTS\n",global_error_seq->attr);
      else
	mk_asm_output((listnode)global_error_seq->data,labels,vars,types,dst,inl,ops,opspec,inl_lab,3);
    };

  for(;(fnlstflag==1)&&(global_exec_fn_seq!=NULL);global_exec_fn_seq=rm_cdr_next(global_exec_fn_seq))
    {
      if(global_exec_fn_seq->attr!=TWOLISTS)
	fprintf(stderr,"mk_asm_output:global_exec_fn_seq->attr=%d!=TWOLISTS\n",global_exec_fn_seq->attr);
      else
	mk_asm_output((listnode)global_exec_fn_seq->data,labels,vars,types,dst,inl,ops,opspec,inl_lab,0);
    };

  for(;(fnlstflag!=3)&&(global_error_seq!=NULL);global_error_seq=rm_cdr_next(global_error_seq))
    {
      if(global_error_seq->attr!=TWOLISTS)
	fprintf(stderr,"mk_asm_output:global_error_seq->attr=%d!=TWOLISTS\n",global_error_seq->attr);
      else
	mk_asm_output((listnode)global_error_seq->data,labels,vars,types,dst,inl,ops,opspec,inl_lab,3);
    };

  return res;
}








/*void var_name_cross_ref(listnode lst,listnode vars)
{
listnode l1;

if (lst==NULL) return ;

while((lst!=NULL))
	{
	if (lst->attr==ASSOCVAR)
		{
		for(l1=vars;l1->next!=NULL;l1=l1->next)
			if(!Strcmp(l1->data,lst->data))
				break; // already in the list 
		if ((l1->next==NULL)&(!!Strcmp(l1->data,lst->data)))
			{
			l1->next=mk_listnode(NULL);
			Memset(l1->next->data,0,34);
			Strcpy(l1->next->data,lst->data);
			l1->next->attr=VARIABLE;
			};
		};
	if ((lst->attr==TWOLISTS)||(lst->attr==FUNCAVAR))
		var_name_cross_ref((listnode) lst->data, vars);
	lst=lst->next;
	};
};*/
/*opdef_arr oda;*/

struct op_definition zzz;
struct op_definition inlinetest1;
struct op_definition inlinetest2;
struct op_definition jnk1;
struct op_definition jnk2;

defined_op d_op;
inline_op i_op;

listnode opclist;
int xx;

char inputstr[2*STR_BUF_SIZE];
char * istr,* ibuff;
listnode l1,l2,l3,l4;
struct typerec * intptr,* charptr,* xstrptr,* xclsptr,* dtypeptr;
int eof_flag=0;

int main(int argc,char ** argv)
{
  struct vardecl_listoflist vars;
  struct type_listoflist types;
  /****************************************************************************/
  struct fundef_list x,y;
  struct type_list main_type_list;
  struct type_list * tlptr;
  
  
  if(argc>1)
    {
      int newfd;
      if((newfd=open(argv[1],O_RDONLY))!=-1)
	{
	  close(0);
	  dup2(newfd,0);
	}
      else
	fprintf(stderr,"Can't open file %s !\n",argv[1]);
    }
     
     
  x.fundef=my_malloc(sizeof(struct fundef));
  /*y.fundef=my_malloc(sizeof(struct fundef));*/
  x.fundef->name="int";
  x.fundef->def_to_use.name_in_code="B_char_to_int";
  x.fundef->args=my_malloc(sizeof(struct vardecl_list));/*argdef));*/
  x.fundef->args->var=my_malloc(sizeof(struct var_decl));
  x.fundef->args->var->name="x";
  x.fundef->args->next=NULL;
  x.next=NULL;
  /*x.other=NULL;
    y.fundef->name="somekindofdata";
    y.fundef->args=my_malloc(sizeof(struct argdef));
    y.fundef->args->next=NULL;
    y.next=NULL;
    y.other=NULL; */
  main_type_list.next=NULL;
  main_type_list.convert_lock=OFF;
  main_type_list.type=my_malloc(sizeof(struct typerec));
  main_type_list.type->typekind=BUILT_IN;
  main_type_list.type->typemodf=NONE;
  main_type_list.type->typebody.built_in=_lpsdata;
  main_type_list.type->name="somekindofdata";
  main_type_list.type->typeconv=&y;
  main_type_list.type->size=10;
  /****************************************************************************/
  
  
  /*x.fundef->args->type=main_type_list.type;*/
  
  tlptr=install_type((struct type_list *)&main_type_list,1,(char *)"char",BUILT_IN,NONE,__char__,NULL);
  
  charptr=tlptr->type;
  
  x.fundef->args->var->type=tlptr->type;
  
  dtypeptr=install_type((struct type_list *)&main_type_list,1,"dtype",VAR_TYPE,NONE,__char__,NULL)->type;
  
  install_type((struct type_list *)&main_type_list,1,"type",VAR_TYPE,NONE,__char__,NULL);

  intptr=install_type((struct type_list *)&main_type_list,2,(char *)"int",BUILT_IN,NONE,__int___,(struct fundef_list *)&x)->type;
  
  install_type((struct type_list *)&main_type_list,1,(char *)"void",BUILT_IN,NONE,__void__,NULL);
  
  install_type((struct type_list *)&main_type_list,1,(char *)"void",BUILT_IN,POINTER,__void__,NULL);
  /*  
      tlptr=install_type((struct type_list *)&main_type_list,1,(char *)"xstr",STRUCT,NONE,__void__,NULL);
      tlptr->type->typebody.struct_def=my_malloc(sizeof(struct struct_def));
      tlptr->type->typebody.struct_def->tag="xstrtag";
      tlptr->type->typebody.struct_def->fields=my_malloc(sizeof(struct vardecl_list));
      tlptr->type->typebody.struct_def->fields->var=my_malloc(sizeof(struct var_decl));
      tlptr->type->typebody.struct_def->fields->var->name="xstrmem";
      tlptr->type->typebody.struct_def->fields->next=NULL;
      tlptr->type->typebody.struct_def->fields->var->type=intptr;
      
      xstrptr=tlptr->type;
  */
  /*----------------*/
  
  tlptr=install_type((struct type_list *)&main_type_list,1,"xcls",CLASS,NONE,__void__,NULL);
  tlptr->type->typebody.class_def=my_malloc(sizeof(struct class_def));
  tlptr->type->typebody.class_def->constructors=NULL;
  tlptr->type->typebody.class_def->destructors=NULL;
  tlptr->type->typebody.class_def->funcs=my_malloc(sizeof(struct fundef_list));
  tlptr->type->typebody.class_def->funcs->next=NULL;
  tlptr->type->typebody.class_def->vars=my_malloc(sizeof(struct vardecl_list));
  tlptr->type->typebody.class_def->vars->var=my_malloc(sizeof(struct var_decl));
  tlptr->type->typebody.class_def->vars->next=NULL;
  tlptr->type->typebody.class_def->vars->var->name="cmem";
  tlptr->type->typebody.class_def->vars->var->type=intptr;
 
  tlptr->type->typebody.class_def->top_class=my_malloc(sizeof(struct type_list));
  tlptr->type->typebody.class_def->top_class->next=NULL;
  tlptr->type->typebody.class_def->top_class->type=intptr;/*get_type_by_name("int",NONE,&main_type_list);*/
  
  xclsptr=tlptr->type;
  

  for(tlptr=(struct type_list *)&main_type_list;tlptr!=NULL;tlptr=tlptr->next)
    printf("Installed type %s : %d, convert lock is %s\n",(char *)tlptr->type->name,tlptr->type->typemodf,(tlptr->convert_lock==OFF)?"OFF":"ON");
  /*	while(kbhit()) getch();
	while(!kbhit());
	while(kbhit()) getch(); */
  
  
  d_op=&zzz;
  zzz.form="fx";
  zzz.defn=mk_head_lnd(mk_head_lnd(NULL,"xx",VARIABLE),"!",PARTOFOP);
  zzz.prec=550;
  zzz.attr=OPD_NONE;
  zzz.vars=NULL;
  zzz.prev=NULL;
  l1=mk_set_lnd(NULL,NULL,VARIABLE);
  get_function("not(xx)",l1,NULL,NULL,NULL,0,NULL,NULL);
  zzz.fdef.opdef=l1->next;
  Free(l1);
  
  zzz.next=my_malloc(sizeof(struct op_definition)); /* buffer - junk */
  zzz.next->next=NULL;
  zzz.next->form=NULL;
  zzz.next->defn=NULL;
  zzz.next->vars=NULL;
  zzz.next->prec=0;
  zzz.next->attr=STOP_XOP; /* Never match */
  zzz.next->prev=&zzz;
  zzz.next->fdef.opdef=NULL;
	
  
  i_op=&inlinetest1;
  inlinetest1.form="fxfc";
  inlinetest1.defn=mk_head_lnd(mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"cc",VARIABLE),"do",PARTOFOP),"xx",VARIABLE),"while",PARTOFOP);
  inlinetest1.prec=500;
  inlinetest1.attr=OPD_NONE;
  inlinetest1.prev=NULL;
  inlinetest1.fdef.inlfun=my_malloc(sizeof(struct inline_fun_rec));
  inlinetest1.fdef.inlfun->labels=mk_set_lnd(NULL,mk_set_lnd(NULL,"_start_",PARTOFOP),LABELREQ);
  mk_set_lnd(inlinetest1.fdef.inlfun->labels,mk_set_lnd(NULL,"_end_while_",PARTOFOP),LABELREQ);
  
  /*tmp	inlinetest1.fdef->args=my_malloc(sizeof(struct inline_varinfo));
    //tmp	inlinetest1.fdef->args->next=my_malloc(sizeof(struct inline_varinfo));
    //tmp	inlinetest1.fdef->args->next->next=NULL;
    //tmp	inlinetest1.fdef->args->times_used=1;
    //tmp	inlinetest1.fdef->args->next->times_used=1;
    //tmp	Strcpy(inlinetest1.fdef->args->name,"xx");
    //tmp	Strcpy(inlinetest1.fdef->args->next->name,"cc");*/
  
  inlinetest1.fdef.inlfun->args=insert_var_decl(NULL,"xx",intptr,NULL,0);
  insert_var_decl(inlinetest1.fdef.inlfun->args,"cc",NULL,NULL,0);
  inlinetest1.fdef.inlfun->subfunctions= &inlinetest2; /*NULL;*/
  inlinetest1.vars=inlinetest1.fdef.inlfun->args;
  
  inlinetest2.form="f";
  inlinetest2.defn=mk_head_lnd(NULL,"break",PARTOFOP);
  inlinetest2.prec=500;
  inlinetest2.attr=OPD_NONE;
  inlinetest2.prev=NULL;
  inlinetest2.fdef.inlfun=my_malloc(sizeof(struct inline_fun_rec));
  inlinetest2.fdef.inlfun->labels=NULL;
  inlinetest2.fdef.inlfun->args=NULL;	/*tmp*/
  inlinetest2.vars=NULL; 		/*tmp*/
  inlinetest2.fdef.inlfun->subfunctions=NULL;

  /*	inlinetest2.next=my_malloc(sizeof(inline_op)); // buffer - junk */
  inlinetest2.next=&jnk2;
  inlinetest2.next->next=NULL;
  inlinetest2.next->form=NULL;
  inlinetest2.next->defn=NULL;
  inlinetest2.next->prec=0;
  inlinetest2.next->attr=STOP_XOP; /* Never match */
  inlinetest2.next->prev=&inlinetest2;
  inlinetest2.next->fdef.inlfun=NULL;
  
  /*	inlinetest1.next=my_malloc(sizeof(inline_op)); // buffer - junk */
  inlinetest1.next=&jnk1;
  inlinetest1.next->next=NULL;
  inlinetest1.next->form=NULL;
  inlinetest1.next->defn=NULL;
  inlinetest1.next->prec=0;
  inlinetest1.next->attr=STOP_XOP; /* Never match */
  inlinetest1.next->prev=i_op;
  inlinetest1.next->fdef.inlfun=NULL;
  
  
  
  
  
  finstall_opd(d_op,"xfx",mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"part",VARIABLE),"->",PARTOFOP),"obj",VARIABLE),"\4objpart(obj,part)",NOTYPECK,6001);

  linstall_opd(d_op,"xf",mk_head_lnd(mk_head_lnd(NULL,"++",PARTOFOP),"xx",VARIABLE),mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"1",VARIABLE),"xx",VARIABLE),"NumAdd",FUNCTION),TWOLISTS),"META",VARIABLE),"\4objpart",FUNCTION),OPD_NONE,550);

  linstall_opd(d_op,"xf",mk_head_lnd(mk_head_lnd(NULL,"--",PARTOFOP),"xx",VARIABLE),mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"1",VARIABLE),"xx",VARIABLE),"NumSub",FUNCTION),TWOLISTS),"META",VARIABLE),"\4objpart",FUNCTION),OPD_NONE,550);

  linstall_opd(d_op,"xfx",mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"+",PARTOFOP),"xx",VARIABLE),mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"xx",VARIABLE),"NumAdd",FUNCTION),TWOLISTS),"META",VARIABLE),"\4objpart",FUNCTION),OPD_NONE,550);

  linstall_opd(d_op,"xfx",mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"-",PARTOFOP),"xx",VARIABLE),mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"xx",VARIABLE),"NumSub",FUNCTION),TWOLISTS),"META",VARIABLE),"\4objpart",FUNCTION),OPD_NONE,550);

  linstall_opd(d_op,"xfx",mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"*",PARTOFOP),"xx",VARIABLE),mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"xx",VARIABLE),"NumMul",FUNCTION),TWOLISTS),"META",VARIABLE),"\4objpart",FUNCTION),OPD_NONE,550);

  linstall_opd(d_op,"xfx",mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"/",PARTOFOP),"xx",VARIABLE),mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"xx",VARIABLE),"NumDiv",FUNCTION),TWOLISTS),"META",VARIABLE),"\4objpart",FUNCTION),OPD_NONE,550);

  finstall_opd(d_op,"fx",mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"*",PARTOFOP),"derefr(yy)",0,450);
  finstall_opd(d_op,"xfx",mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"==",PARTOFOP),"xx",VARIABLE),"iseq(xx,yy)",0,150);
  finstall_opd(d_op,"xfx",mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"=",PARTOFOP),"xx",VARIABLE),"assign1(dst,src)",0,150);
  finstall_opd(d_op,"xfx",mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,"yy",VARIABLE),"!=",PARTOFOP),"xx",VARIABLE),"isnoteq(xx,yy)",0,150);
  finstall_opd(d_op,"fx",mk_head_lnd(mk_head_lnd(NULL,"goto",PARTOFOP),"lab",VARIABLE),"\4goto(lab)",NOTYPECK,750);
  /*temp	finstall_opd(d_op,"xfx","xx += yy","sadd(xx,yy)",0,340);
    //temp	finstall_opd(d_op,"xfx","xx -= yy","ssub(xx,yy)",0,340);
    //	finstall_opd(d_op,"xfx","xx *= yy","smul(xx,yy)",0,350);
    //	finstall_opd(d_op,"xfx","xx /= yy","sdiv(xx,yy)",0,350);
    
    //	install_opd((defined_op) i_op,"fc","zzcode cc",0,550); */
  
  
  print_opd(d_op);
  
  printf("%d definitions\n",opdef_count(d_op));
  
  /*	printf("Variable cc used %d times in inline\n",get_inl_varinfo("cc",inlinetest1.fdef->args)); */
  vars.next=NULL;
  /*
    vars.vlist=my_malloc(sizeof(struct vardecl_list));
    vars.vlist->next=NULL;
    vars.vlist->var=my_malloc(sizeof(struct var_decl));
    vars.vlist->var->name="some_var";
    vars.vlist->var->type=intptr;//get_type_by_name("int",NONE,&main_type_list);
  */
  vars.vlist=NULL;
  types.next=NULL;
  types.tlist=&main_type_list;
  
  vars.vlist=insert_var_decl(NULL,"dtidvar",NULL,NULL,0);
  
  dtypeptr->typebody.var_type.var=vars.vlist->var;	
  
  intptr->typeconv=(struct fundef_list *)&x;
  
  strcpy(global_buf,"{\4goto(_end_while_)}");
  
  memcpy(inputstr,global_buf,STR_BUF_SIZE);
  global_bufptr+=STR_BUF_SIZE;
  l1=mk_set_lnd(NULL,NULL,VARIABLE);
  
  l2=mk_set_lnd(NULL,mk_set_lnd(NULL,NULL,LABELDEF),TWOLISTS);
  l3=mk_set_lnd(NULL,mk_set_lnd(NULL,NULL,LABELDEF),TWOLISTS);
  get_code_block(inputstr,l1,mk_set_lnd(NULL,NULL,INLINSUB),d_op,NULL,l2,l3,NULL,NULL,1);
  rm_lnd_all(l2);
  rm_last_node(l1);
  inlinetest2.fdef.inlfun->body=l1->next;
  
  global_bufptr=global_buf;
  strcpy(global_buf,"{\4label(_start_);\4check(xx);\4ifjmp(_end_while_);\4runcode(cc);\4goto(_start_);\4label(_end_while_)}");
  
  memcpy(inputstr,global_buf,STR_BUF_SIZE);
  global_bufptr+=STR_BUF_SIZE;
  l1->next=NULL;
  
  l2=mk_set_lnd(NULL,mk_set_lnd(NULL,NULL,LABELDEF),TWOLISTS);
  rm_lnd_all(l3);
  l3=mk_set_lnd(NULL,mk_set_lnd(NULL,NULL,LABELDEF),TWOLISTS);
  get_code_block(inputstr,l1,mk_set_lnd(NULL,NULL,INLINSUB),d_op,NULL,l2,l3,NULL,NULL,1);
  rm_lnd_all(l2);
  rm_last_node(l1);
  inlinetest1.fdef.inlfun->body=l1->next;
  
  printf("\n<=:");
  
  global_bufptr=global_buf;
  while((((*(global_bufptr++)=getchar())=='\n')?(eof_flag++):(eof_flag=0))!=2);
  *global_bufptr=0;
  for(global_bufptr=global_buf;*global_bufptr;global_bufptr++)
    *global_bufptr=((*global_bufptr=='\n')? ' ' : *global_bufptr);
  global_bufptr=global_buf;
  /*	global_bufptr+=STR_BUF_SIZE;*/ /* inputstr size shift */
  
  /*	memcpy(inputstr,global_buf,STR_BUF_SIZE);*/
  istr=create_new_buffer(NULL,STR_BUF_SIZE);
  /*	refresh_buffer(ibuff,STR_BUF_SIZE,STR_BUF_SIZE);
	istr=my_malloc(STR_BUF_SIZE);*/
  
  l4=mk_set_lnd(NULL,my_malloc(sizeof(struct fundef_list)),FUNCDEFN);
  ((struct fundef_list *)l4->data)->next=my_malloc(sizeof(struct fundef_list));
  ((struct fundef_list *)l4->data)->fundef=my_malloc(sizeof(struct fundef));
  ((struct fundef_list *)l4->data)->fundef->attr=IS_EXPR;
  ((struct fundef_list *)l4->data)->fundef->def_to_use.name_in_code=Strdup("do_add_one");
  ((struct fundef_list *)l4->data)->fundef->name=Strdup("inc1");/*"inc1";*/
  ((struct fundef_list *)l4->data)->fundef->res_type=intptr;
  ((struct fundef_list *)l4->data)->fundef->args=my_malloc(sizeof(struct vardecl_list));
  ((struct fundef_list *)l4->data)->fundef->args->var=my_malloc(sizeof(struct var_decl));
  ((struct fundef_list *)l4->data)->fundef->args->var->name="x";
  ((struct fundef_list *)l4->data)->fundef->args->var->type=intptr;
  ((struct fundef_list *)l4->data)->fundef->args->next=NULL;
  
  ((struct fundef_list *)l4->data)->next->next=NULL;
  ((struct fundef_list *)l4->data)->next->fundef=my_malloc(sizeof(struct fundef));
  ((struct fundef_list *)l4->data)->next->fundef->attr=IS_EXPR;
  ((struct fundef_list *)l4->data)->next->fundef->def_to_use.name_in_code=Strdup("do_assign1");
  ((struct fundef_list *)l4->data)->next->fundef->name="assign1";
  ((struct fundef_list *)l4->data)->next->fundef->res_type=intptr;
  ((struct fundef_list *)l4->data)->next->fundef->args=my_malloc(sizeof(struct vardecl_list));
  ((struct fundef_list *)l4->data)->next->fundef->args->var=my_malloc(sizeof(struct var_decl));
  ((struct fundef_list *)l4->data)->next->fundef->args->var->name="dst";
  ((struct fundef_list *)l4->data)->next->fundef->args->var->type=intptr;
  ((struct fundef_list *)l4->data)->next->fundef->args->next=NULL;
  
  xclsptr->typebody.class_def->funcs->fundef=my_malloc(sizeof(struct fundef));
  xclsptr->typebody.class_def->funcs->fundef->name="xcls";
  xclsptr->typebody.class_def->funcs->fundef->attr=IS_FEXPR;
  xclsptr->typebody.class_def->funcs->fundef->def_to_use.name_in_code=Strdup("code_xclsfunc1");
  xclsptr->typebody.class_def->funcs->fundef->res_type=charptr;
  xclsptr->typebody.class_def->funcs->fundef->args=my_malloc(sizeof(struct vardecl_list));
  xclsptr->typebody.class_def->funcs->fundef->args->var=my_malloc(sizeof(struct var_decl));
  xclsptr->typebody.class_def->funcs->fundef->args->var->name="xc";
  xclsptr->typebody.class_def->funcs->fundef->args->var->type=intptr;
  xclsptr->typebody.class_def->funcs->fundef->args->next=NULL;
  
  l1->next=NULL;
  l2=mk_set_lnd(NULL,mk_set_lnd(NULL,NULL,LABELDEF),TWOLISTS);
  if (!(xx=get_code_block(istr,l1,mk_set_lnd(NULL,i_op,INLINSUB),d_op,NULL,l2,l3,(struct vardecl_listoflist *) &vars, (struct type_listoflist *) &types,0)))
    printf("No compare\n");
  
  printf("\n%s was used as a string, %s left.\n%d definitions in base.\nThis is what function returned into the list :\n",inputstr,xx-strlen(inputstr)?(inputstr+xx):"nothing",opdef_count(d_op));
  
  /*	while(kbhit()) getch();
	//	while(!kbhit());
	//	while(kbhit()) getch();*/
  
  l1=l1->next;
  printlist2(l1,0,1);
  printf("Total %d listnodes.\n",lnd_count(l1));
  
  /*	while(kbhit()) getch();
	//	while(!kbhit());
	//	while(kbhit()) getch(); */
  
  printf("Labels left/resolved :\n->Inline:\n");
  printlist2(l2,0,1);
  printf("->Block:\n");
  printlist2(l3,0,1);
  rm_lnd_all(l3);
  rm_lnd_all(l2);
  
  /*	while(kbhit()) getch();
	//	while(!kbhit());
	//	while(kbhit()) getch(); */
  
  return 0;
}

