
#ifndef _GLOBAL_TYPES_H_MODULE_
#define _GLOBAL_TYPES_H_MODULE_

/**************************************************************************/

enum lnd_attr
{
  PARTOFOP=0,TWOLISTS,BRACKETT,VARIABLE,FUNCTION,
  ASSOCVAR,OPDEFPTR,FUNCAVAR,INLCBVAR,INLINSUB,
  LABELDEF,LABELREQ,FUNCDEFN,FUNDEFNL,INLINFUN,
  TYPEDEFN,TYPEVARL,VARTYPEL,TYPELIST,VARDLIST,
  RAWSTRING,VARDECL,CODEBLOCK
};

enum decl_layer_type
{
  DL_REGULAR=0,DL_FIXED,DL_CODEBL,DL_VALIDFN,DL_INLEXEC,DL_METAEXEC,DL_TYPEDEF,DL_RUNIN,DL_DUMMY,DL_COPY,DL_FREE
};

enum opdef_attr
{
  OPD_NONE=0,
  NOTYPECK,
  STOP_XOP=255
};

typedef struct _listnode_ * listnode;
struct _listnode_
{
  enum lnd_attr attr;
  listnode next;
  char * data;
};

/**************************************************************************/

#define PROBE_NEW_LND_OPDEF

typedef struct op_definition 
{
  struct op_definition * next,* prev;
  char * form;
  long opd_id;
  listnode defn;
  listnode opd_class;
  struct vardecl_list * vars;
  struct type_list * types;
  union
    {
      listnode opdef;
      struct inline_fun_rec * inlfun;
    } fdef;
  enum opdef_attr attr;
  int prec;
} * defined_op;

#define inline_op defined_op

typedef defined_op * opdef_arr;

typedef enum {eq,left,right,llong,rlong} cmp_str;

/**************************************************************************/

enum func_attr
{
  IS_EXPR,IS_FEXPR
};

enum typekind
{
  BUILT_IN,/*STRUCT,*/UNION,ENUM,CLASS,ACTIONCLASS,TYPEREFR,ISTYPEOF,SYMBREFR,
  ISMODIF,MODIFARG,VAR_TYPE,FUN_DEFN,FUNPROTO
};


enum typemodf
{
  NONE,POINTER,INDEX,REFERENCE,FUNC,LAZYEVAL,MODIFIED,APLMODLK,APLFIXLK
};

enum var_attr
{
  VAR_NORM,VMODFARG,VAR_FUNC,TYPE_VAR,FN_VAR,VFN_VAR,OPD_TYPE
};

enum tb_built_in {__int___,__char__,__list__,__str__,__long__,__double__,__void__,
__float__,_lpsdata};

enum err_type {ERR_FATAL,ERR_ERROR,ERR_WARNING,ERR_NOTICE};

union typebody
{
  enum tb_built_in built_in;
  struct fundef * fundef; 
  struct actionclass * actionclass;
  struct class_def * class_def;
  /*struct struct_def * struct_def;*/
   struct enum_def * enum_def;
   struct modif_def
   {
     struct type_list * mod_args;
     struct typerec * type;
   } modif_def;
   struct tb_index
     {
      struct typerec * pointer_to;
      int size;
      int * dims;
     } index;
   
   struct typerec * pointer_to;
   struct type_list * class_list;
   char * symbrefr;
   listnode typeof;
   struct
     {
	struct type_list * topclass;
	struct var_decl * var;
     } var_type;
};

struct typerec
{
  int size;
  char * name;
  unsigned long typeid;
  enum typekind typekind;
  enum typemodf typemodf;
  union typebody typebody;
  struct fundef_list * typeconv;
  listnode validate;
};

enum fundef_type {is_normal,is_inline,is_meta,is_virtual, is_prototype, is_actionclass};

struct fundef
{
  char * name;
  enum func_attr attr;
  enum fundef_type kind;
  union
  {
    char * name_in_code;
    struct inline_fndef * inline_fndef;
  } def_to_use;
  struct typerec * actionclass; /* combined action class */
  struct typerec * res_type;
  struct vardecl_list * args;
};

enum _state_ {ON,OFF};
enum funcall_arg {FC_VAR,FC_FUN};

struct type_list
{
  enum _state_ convert_lock;
  struct typerec * type;
  struct type_list * next;
};


struct fundef_list
{
  struct fundef * fundef;
  struct fundef_list * next;
};

/* struct field_def
{
char * name;
struct typerec * type;
struct field_def * next;
}; */

/* struct modif_def
{
struct type_list * top_class;
struct type_list * types;
struct code_block * code;
};
*/

/*
struct struct_def
{
int size;
int s_or_u;
char * tag;
struct vardecl_list * fields;
};
*/
/* struct union_def
{
int size;
char * tag;
struct field_def fields;
}; */

struct enum_def
{
  char * name;
  int * assoc_value;
  struct enum_def * next;
};

struct var_decl
{
   enum var_attr attr;
   char * name;
   struct typerec * type;
   listnode sym_prop;
   union
     {
	void * defvalue;
	struct fundef * fundef;
     } var_data;
};

struct vardecl_list
{
struct var_decl * var;
struct vardecl_list * next;
};

struct class_def
{
  /*  char * name;
      int size;*/
  int c_or_u;
  struct type_list * top_class;
  struct fundef_list * constructors;
  struct fundef_list * destructors;
  struct fundef_list * funcs;
  struct vardecl_list * vars;
  struct type_list * types;
  listnode variable_constructors;
};

struct funcall_list
{
struct fundef * function;
struct vardecl_list * args;
struct funcall_list * next;
};

struct code_block
{
struct vardecl_list * vars;
struct type_list * types;
listnode code;
};

struct actionclass
{
struct type_list * top_class;
struct fundef_list * local_funcs;
struct vardecl_list * args;
struct vardecl_list * ac_args;
struct vardecl_list * local_vars;
struct type_list * local_types;
struct typerec * res_type;
enum func_attr attr;
listnode body;
};

struct inline_fndef
{
struct vardecl_list * vars; 
struct type_list * types;
listnode body;
};


/*
struct struct_def_list
{
struct struct_def struct_def;
struct struct_def_list * next;
};
*/
/* struct union_def_list
{
struct union_def union_def;
struct union_def_list * next;
}; */

struct class_def_list
{
struct class_def class_def;
struct class_def_list * next;
};

struct actionclass_list
{
  struct actionclass actionclass;
  struct actionclass_list * next;
};

struct vardecl_listoflist
{
  enum decl_layer_type ltype;
  struct vardecl_list * vlist;
  struct vardecl_listoflist * next;
  listnode namespace;
};

struct type_listoflist
{
  enum decl_layer_type ltype;
  struct type_list * tlist;
  struct type_listoflist * next;
  listnode namespace;
};

/**************************************************************************/

struct inline_fun_rec
{
struct vardecl_list * args;
listnode body,labels;
inline_op subfunctions;
};
struct inline_varinfo
{
char name[33];
int times_used;
struct inline_varinfo * next;
};

/**************************************************************************/
#endif /* Global types */
