#include "include/glbtypes.h"
#include "include/glbproto.h"
#include "include/globvars.h"

int get_typeof_decl(
char * instr,
struct type_listoflist * tlist,
struct vardecl_listoflist * vlist,
defined_op d_ops,
listnode inl,
listnode opspec,
struct typerec * * res)
{
   struct vardecl_list * vars=NULL;
   char * str;
   char local_buf[34];
   listnode ltmp;
   int change=0;
   
   str=get_variable_name(instr);
   memset(local_buf,0,34);
   
   Strncpy(local_buf,instr,str-instr);
   if(Strcmp(local_buf,"typeof")) /* NOT "typeof" */
     return 0;

   change=str-instr;
   instr=str;
   ltmp=mk_set_lnd(NULL,NULL,VARIABLE);
   str+=get_expression(instr,ltmp,d_ops,inl,opspec,1,tlist,vlist);
   if(str==instr)
     {
	while(*str==32) str++;
	if(*str!='(')
	  {
	     printf("Error in \"typeof\" : no \'(\'\n");
	     return 0;
	  };
	str++;
	change+=str-instr;
	instr=str;
	
	str=get_variable_name(instr);
	memset(local_buf,0,34);
	Strncpy(local_buf,instr,str-instr);
	vars=global_find_var_decl((char *)local_buf,vlist,1);
	
	if(vars!=NULL)
	  *res=vars->var->type;
	else
	  printf("## Warning : variable %s isn't defined at this time !\n",local_buf);
	
	while(*str==32) str++;
	if(*str!=')')
	  {
	     printf("Error in \"typeof\" : no \')\'\n");
	     return 0;
	  };
	str++;
	
	rm_lnd_all(ltmp);
	
	if(vars!=NULL)
	  {
	     change+=str-instr;
	     return change;
	  }
	else
	  ltmp=mk_set_lnd(NULL,Strdup(local_buf),VARIABLE);
     }
   else
     {
	ltmp->next=op_to_function(ltmp->next);
	ltmp=rm_cdr_next(ltmp);
     };
   
   memset(local_buf,0,34);
   sprintf(local_buf,"\4tmptype%lx",global_tmp_type++);
   
   if(tlist->tlist==NULL)
     {
	tlist->tlist=my_malloc(sizeof(struct type_list));
	tlist->tlist->next=NULL;
	tlist->tlist->convert_lock=OFF;
	tlist->tlist->type=my_malloc(sizeof(struct typerec));
	set_typerec(tlist->tlist->type,4,Strdup(local_buf),ISTYPEOF,NONE,__void__,NULL);
	*res=tlist->tlist->type;
     }
   else
     *res=install_type(tlist->tlist,4,Strdup(local_buf),ISTYPEOF,NONE,__void__,NULL)->type;
   
   (*res)->typebody.typeof=ltmp;
   
   change+=str-instr;
   return change;
}




int get_var_decl(
char * instr,
struct type_listoflist * tlist,
struct vardecl_listoflist * vlist,
listnode labels,
defined_op d_ops,
listnode inl,
listnode opspec,
listnode inl_lab,
int mode,
/* 0 - normal, 1 - struct/union, 2 - class, 3 - getting "type" var 
4 - special for "::" (???), 5,6,7,8 - special for getting args of type1
9,10 - function arguments mode (9 if we DO need vars, 10 if we may skip vars),
11,12 - reserved in case we have "type" var as function argument */
int * changelen
)
{
   struct type_list * tl=NULL;
   struct vardecl_list * vars;
   int change=0;
   int chg=0;
   enum fundef_type fundef_type_flag=is_normal;
   char * str,* keep_instr;
   char tname[34],vname[34];
   enum typemodf tmodf;
   struct typerec * type1=NULL, * type2=NULL,* acls=NULL;
   listnode fn_constr=NULL,modif_lst=NULL,base_constr=NULL;
   struct fundef_list * fund_tmp;
   struct fundef * fund=NULL;
   char local_buf[34];
   struct typerec * tmptype=NULL;
   
   /* tl=tlist->tlist;*/
   vars=vlist->vlist;
   
   keep_instr=instr;

   do	/* loop to get modifiers */
     {
	str=get_variable_name(instr);
	memset(tname,0,34);
	
	tmodf=NONE;
	Strncpy(tname,instr,str-instr);
	
	if((!Strcmp(tname,"struct"))
	   ||(!Strcmp(tname,"union"))
	   ||(!Strcmp(tname,"class"))
	   ||(!Strcmp(tname,"aclass"))
	   ||(!Strcmp(tname,"typedef"))
	   ||(!Strcmp(tname,"modif")))
	  {
	     type1=get_new_type_declaration(instr,tlist,vlist,labels,d_ops,inl,opspec,inl_lab);
	     if(type1==NULL)
	       return 0;
	     str=instr;
	     while(*str==32) str++;
	     
	     if(!isidch(*str)) /* No variable after struct/union declaration */
	       return 1;
	  }
	else
	  if((type1=get_type_by_name(tname,NONE,tlist))==NULL)
	    if((type1=get_type_by_name(tname,FUNC,tlist))==NULL)
	  {
	     if(Strcmp(tname,"typeof")) /* NOT "typeof" */
	       {
		  printf("Type %s unknown\n",tname);
		  return 0;
	       }
	     else  /* "typeof" */
	       {
		  str=instr;
		  str+=get_typeof_decl(instr,tlist,vlist,d_ops,inl,opspec,&type1);
		  if(str==instr)
		    return 0;
	       };
	  };
	if(type1->typekind==ISMODIF)
	  {
	     while(*str==32) 
	       str++;

	     modif_lst=mk_head_lnd(modif_lst,type1,TYPEDEFN);
	     change+=str-instr;
	     instr=str;

	     if(*str=='<')
	       {
		  struct typerec * tmptype;
		  str++;

		  while(*str==' ') 
		    str++;

		  change+=str-instr;
		  instr=str;
		  modif_lst->attr=TWOLISTS;
		  modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
		  while((*str!='>')
			&&(!!*str))
		    {	
		       str+=get_type_from_code(instr,labels,tlist,vlist,",>",inl,d_ops,opspec,inl_lab,&tmptype);
		       if(str==instr)
			 {
			    fprintf(stderr,"get_var_decl():can't get modifier args\n");
			    rm_lnd_all(modif_lst);
			    return 0;
			 };
		       mk_set_lnd((listnode)modif_lst->data,tmptype,TYPEDEFN);

		       while(*str==' ') 
			 str++;
		       if(*str==',') 
			 str++;
		       while(*str==' ') 
			 str++;

		       change+=str-instr;
		       instr=str;
		    };
		  if(*str!='>') 
		    {
		       fprintf(stderr,"get_var_decl():error in modifier args\n");
		       rm_lnd_all(modif_lst);
		       return 0;
		    };
		  str++;
		  while(*str==' ') str++;
		  
		  if((mode==9)||(mode==10)) 
		    /* function, i.e. no guarantee that keep_instr
		     points to the beginning of the buffer */
		    {
		       change+=str-instr;
		       instr=str;
		    }
		  else
		    {
		       refresh_buffer(keep_instr,change+str-instr,STR_BUF_SIZE);
		       instr=str=keep_instr;
		    };
	       };
	  };
	if(*str=='(')
	  {
	     listnode mconstr;

	     if(!Strcmp(type1->name,"type"))
	       /* if it's "type" var we need to get 
		it's top classess separatelty */
	       break;

	     if(type1->typekind==ISMODIF) 
	       /* since I'm lazy this code would get constructors for both
		modifiers and regular types */
	       {
		  if(modif_lst->attr==TYPEDEFN)
		    {
		       modif_lst->attr=TWOLISTS;
		       modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
		    };
	       };
	     mconstr=mk_set_lnd((type1->typekind==ISMODIF)?((listnode)modif_lst->data):base_constr,mk_set_lnd(NULL,Strdup("\4objpart"),FUNCTION),TWOLISTS);
	     mk_set_lnd((listnode)mconstr->data,type1,TYPEDEFN);
	     
	     str+=get_function(str,(listnode)mk_set_lnd((listnode)mconstr->data,mk_head_lnd(NULL,NULL,FUNCTION),TWOLISTS)->data,d_ops,inl,opspec,1,tlist,vlist);
	     
	     if(str==instr)
	       {
		  printf("Error with %s constructor call !!!\n",(type1->typekind==ISMODIF)?"modifier":"base type");
		  rm_lnd_all(modif_lst);
		  if(type1->typekind!=ISMODIF)
		    rm_lnd_all(mconstr);
		  return 0;
	       };
	     ((listnode)((listnode)mconstr->data)->next->next->data)->data=Strdup(type1->name);
	     while(*str==' ') str++;
	     
	     if((mode==9)||(mode==10)) 
	       /* function, i.e. no guarantee that keep_instr
		points to the beginning of the buffer */
	       {
		  change+=str-instr;
		  instr=str;
	       }
	     else
	       {
		  refresh_buffer(keep_instr,change+str-instr,STR_BUF_SIZE);
		  instr=str=keep_instr;
	       };
	     
	     if(type1->typekind!=ISMODIF)
	       base_constr=mconstr;
	  };
	type1=apply_modifier(type1,modif_lst,&base_constr,tlist);
     }
   while(type1->typekind==ISMODIF);

   if((mode==9)||(mode==10))
     {
       if((type2=get_type_by_name("META_fn_arg_def_tmpl",NONE,tlist))!=NULL)
	 {
	      type2=eval_type_refr(type2,vlist,tlist,labels,0,NULL);
	      if(type2==NULL)
		{
		  fprintf(stderr,"Unresolvable META fn arg def template\n");
		  return 0;
		};

	      while((type2->typekind==TYPEREFR)&(type2->typemodf==NONE||type2->typemodf==MODIFARG))   
		type2=type2->typebody.pointer_to;
	      if(type2==NULL)
		{
		  fprintf(stderr,"Unresolvable META fn arg def template\n");
		  return 0;
		};
	      printf("META fn arg def template type: %s (%ld)\n",type2->name,type2->typeid);
	 };
     };
   
   type1=apply_modifier(type1,modif_lst,&base_constr,tlist);
   rm_lnd_all(modif_lst);
   modif_lst=NULL;
   
   if(!Strcmp(type1->name,"type"))
     {
	printf("## Dynamic type declaration ...\n");
	memset(vname,0,sizeof(vname));
	global_tmp_type++;
	sprintf(vname,"\4tmptype%lx",global_tmp_type);
	
	if(vars==NULL)
	  vlist->vlist=vars=insert_var_decl(NULL,(char *)vname,NULL,NULL,0);
	else
	  vars=insert_var_decl(vars,(char *)vname,NULL,NULL,0);
	
	if(tlist->tlist==NULL)
	  {
	     tlist->tlist=my_malloc(sizeof(struct type_list));
	     tlist->tlist->next=NULL;
	     tlist->tlist->convert_lock=OFF;
	     tlist->tlist->type=my_malloc(sizeof(struct typerec));
	     set_typerec(tlist->tlist->type,sizeof(long),Strdup(vname),VAR_TYPE,NONE,__void__,NULL);
	     type1=tlist->tlist->type;
	  }
	else
	  type1=install_type(tlist->tlist,sizeof(long),Strdup(vname),VAR_TYPE,NONE,__void__,NULL)->type;
	type1->typebody.var_type.var=vars->var;
	type1->typebody.var_type.topclass=NULL;
	vars->var->attr=TYPE_VAR;
	vars=vlist->vlist;
	while(*str==32) str++;
	refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	str=instr;
	if(*str=='(')
	  {
	     str++;
	     while(*str==' ') str++;
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;
	     
	     if(*str!=')')
	       {
		  type1->typebody.var_type.topclass=my_malloc(sizeof(struct type_list));
		  type1->typebody.var_type.topclass->next=NULL;
		  type1->typebody.var_type.topclass->type=NULL;
		  tl=type1->typebody.var_type.topclass;
	       }
	     else
	       printf("### Empty brackets ... Strange ...\n");
	     
	     while(*str!=')')
	       {
		  struct typerec * tmptype;
		  str+=get_type_from_code(instr,labels,tlist,vlist,",)",inl,d_ops,opspec,inl_lab,&tmptype);
		  if(instr==str)
		    {
		       fprintf(stderr,"Error getting top classes of type variable - can't get type from code\n");
		       return 0;
		    };
		  tl->type=tmptype;
		  if (*str==',')
		    {
		       str++;
		       while(*str==' ') str++;
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       tl->next=my_malloc(sizeof(struct type_list));
		       tl=tl->next;
		       tl->next=NULL;
		       tl->type=NULL;
		    };
	       };
	     str++;
	     while(*str==' ') str++;
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;
	  };
	
	mode=((mode==9)||(mode==10))?mode+2:3;
     };

   while(1)
     {
	type2=type1;
	
	while(*str==' ') str++;
	
	if((*str=='('))
	  {
	     if((mode==3)||(mode==11)||(mode==12))
	       {
		  printf("## conditional dynamic type \n");
		  exit(0);
	       }
	     else if(mode!=1)
	       mode=((mode==9)||(mode==10))?mode-2:mode+5; /* "special" mode to get args*/
	  };
	
	while(*str==' ') str++;
	change=str-instr;
	instr=str;
	str=get_variable_name(instr);
	while(*str==' ') str++;
	
	if(type2->typekind==ACTIONCLASS)
	  {
	     acls=type2;
	     
	     if(acls->typemodf==FUNC)
	       type2=acls->typebody.actionclass->res_type;
	  };
	
	while((*str!=',')&(*str!='[')&(((mode>=7)&(mode<=12))?(*str!=')'):(*str!=';')&(*str!='}')))
		{
		   
		   if(type2->typekind==ACTIONCLASS)
		     {
			acls=type2;
			
			if(acls->typemodf==FUNC)
			  type2=acls->typebody.actionclass->res_type;
		     };
		   
		   if((*str=='(')||((mode==0)&(*str==':')&(*(str+1)==':')))
		     /* If function ... */
		     {
			listnode inline_body=NULL;
			struct type_listoflist fnd_tll;
			if(mode==1)
			  {
			     fprintf(stderr,"Can't use functions insige struct or union !\n");
			     exit(1);
			  };
			if((mode==9)||(mode==10))
			  {
			     fprintf(stderr,"Can't declare functions inside function arg decl !\n");
			     exit(1);
			  };
			
			if((mode==0)&(*str==':')&(*(str+1)==':'))
			  {
			     str--;
			     while(*str==32) str--;
			     str++;
			     memset(local_buf,0,34);
			     strncpy(local_buf,instr,str-instr);
			     
			     if((tmptype=get_type_by_name(local_buf,NONE,tlist))==NULL)
			       {
				  printf("## Can't define member function of non-existent class %s !\n",local_buf);
				  return 0;
			       };
			     
				tmptype=eval_type_refr(tmptype,vlist,tlist,labels,0,NULL);
			     
			     if(tmptype==NULL)
			       {
				  fprintf(stderr,"Can't resolve reffered type %s !\n",local_buf);
				  exit(1);
			       };
			     
			     if(tmptype->typekind!=CLASS)
			       {
				  printf("## Type %s isn't a class - can't define member function !\n",tmptype->name);
			       };
			     
			     while(*str==32) str++;
			     str+=2; /* skip "::" */
			     while(*str==32) str++;
			     change+=str-instr;
			     instr=str;
			     mode=4; /* special mode, to parse the rest of fn; */
			  };
			fnd_tll.next=tlist;
			if(type2->typemodf==MODIFIED)
			  {
			    printf("# Function return type includes modifier ...\n"); 
			    fnd_tll.tlist=type2->typebody.class_def->top_class;
			  }
			else
			  fnd_tll.tlist=NULL;
			if((chg=test_get_fn_decl(instr,(type2->typemodf==MODIFIED)?&fnd_tll:tlist,vlist,labels,d_ops,inl,opspec,inl_lab,&fund))!=0)
			  {
			    /*			     if(fnlist->attr!=FUNCDEFN)
			       {
				  printf("Internal problem !\n");
				  exit(1);
				  };*/
			     
			     if(mode!=4)
			       { /* "normal" mode */
				 /* Normal mode should work fine for now
				  fund_tmp=((struct fundef_list *)fnlist->data);
				  fnlist->data=my_malloc(sizeof(struct fundef_list));
				  ((struct fundef_list *) fnlist->data)->next=fund_tmp;
				  ((struct fundef_list *) fnlist->data)->fundef=fund;
				 */
			       }
			     else
			       { /* "special" mode, member function */
				 /* This is broken as of 13:20 03/10/99 */
				  if((*fund->name=='~')&(!Strcmp(fund->name+1,tmptype->name)))
				    {
				       fund_tmp=tmptype->typebody.class_def->destructors;
				       tmptype->typebody.class_def->destructors=my_malloc(sizeof(struct fundef_list));
				       tmptype->typebody.class_def->destructors=fund_tmp;
				       tmptype->typebody.class_def->destructors->fundef=fund;
				    }
				  else if(!Strcmp(fund->name,tmptype->name))
				    {
				       fund_tmp=tmptype->typebody.class_def->constructors;
				       tmptype->typebody.class_def->constructors=my_malloc(sizeof(struct fundef_list));
				       tmptype->typebody.class_def->constructors=fund_tmp;
				       tmptype->typebody.class_def->constructors->fundef=fund;
				    }
				  else
				    {
				       fund_tmp=tmptype->typebody.class_def->funcs;
				       tmptype->typebody.class_def->funcs=my_malloc(sizeof(struct fundef_list));
				       tmptype->typebody.class_def->funcs=fund_tmp;
				       tmptype->typebody.class_def->funcs->fundef=fund;
				    };
			       };
			     fund->res_type=type2;
			     
			     if(acls!=NULL)
			       if(acls->typemodf!=FUNC) /* not function type */
				 fund->actionclass=acls;
			     
				/* TEMPORARY !!! */
			     if(mode!=2)
			       fund->def_to_use.name_in_code=fund->name;
			     else
			       {
				  memset(local_buf,0,34);
				  sprintf(local_buf,"\4_tfn%lx",global_tmp_fn++);
				  fund->def_to_use.name_in_code=Strdup(local_buf);
			       };
			     
			     str=instr+chg;
			     chg=0;
			     
			     change+=str-instr;
			     instr=str;
			     
			     /* str=get_variable_name(instr);
			      while(*str==32) str++; */
			     
			     printf("## Installed function %s\n",fund->name);



			     refresh_buffer(keep_instr,change,STR_BUF_SIZE);
			     if(*keep_instr=='{')
			       {
				  struct vardecl_listoflist local_vll;
				  struct type_listoflist * local_tlist;
				  
				  if(fund->actionclass!=NULL)
				    {
				      printf("# Function %s have actionclass %s\n",fund->name,fund->actionclass->name);
				      if(fund->res_type==fund->actionclass)
					fund->res_type=fund->actionclass->typebody.actionclass->res_type;
				      else if(!type_cmp(fund->res_type,fund->actionclass->typebody.actionclass->res_type))
					{
					  printf("Function return type doesn't match actionclass return type\n");
					  if(fund->res_type==NULL)
					    printf("Function return type is NULL\n");
					  else
					    printf("Function return type is (%ld) %s\n",fund->res_type->typeid,fund->res_type->name);
					  return 0;
					}
				      else
					{
					  printf("Return types seems to match ...\n");
					};
				    };

				  if((fundef_type_flag!=is_inline)
				     &&(fundef_type_flag!=is_meta))
				    {
				      memset(local_buf,0,34);
				      sprintf(local_buf,"tmplab%lx",global_label_count++);
				      printf("jmp %s\n",local_buf);
			
				       if(*fund->def_to_use.name_in_code!=4)
					 printf("_%s :\n",fund->def_to_use.name_in_code);
				       else
					 printf("%s :\n",fund->def_to_use.name_in_code+2);
				    };
				  if(acls!=NULL)
				    {
				       local_vll.next=my_malloc(sizeof(struct vardecl_listoflist));
				       local_vll.next->next=vlist;
				       local_vll.next->vlist=fund->args;
				       local_vll.vlist=acls->typebody.actionclass->local_vars;
				       local_tlist=my_malloc(sizeof(struct type_listoflist));
				       local_tlist->next=tlist;
				       local_tlist->tlist=acls->typebody.actionclass->local_types;
				    }
				  else
				    {
				       local_vll.next=vlist;
				       local_vll.vlist=fund->args;
				       local_tlist=tlist;
				    };
				  
				  if(!get_code_block(keep_instr,((fundef_type_flag==is_inline)||(fundef_type_flag==is_meta))?(inline_body=mk_head_lnd(NULL,NULL,PARTOFOP)):NULL,inl,d_ops,opspec,inl_lab,labels,&local_vll,local_tlist,((fundef_type_flag==is_inline)||(fundef_type_flag==is_meta))))
				    {
				       fprintf(stderr,"Error in function body !!!\n");
				       if(acls!=NULL)
					 {
					    Free(local_vll.next);
					    Free(local_tlist);
					 };
				       return 0;
				    };
				  if(acls!=NULL)
				    {
				       Free(local_vll.next);
				       Free(local_tlist);
				    };
				  if((fundef_type_flag!=is_inline)
				     &&(fundef_type_flag!=is_meta))
				    printf("%s : \n",local_buf);
					else 
				    {
				       printf("#Creating %s function\n",(fundef_type_flag==is_inline)?"inline":"META");
				 
				       if(inline_body->next==NULL)
					 fprintf(stderr,"get_var_decl(): empty body of %s function\n",(fundef_type_flag==is_inline)?"inline":"META");
				       else
					 {
					    fund->kind=fundef_type_flag;
					    fund->def_to_use.inline_fndef=my_malloc(sizeof(struct inline_fndef));
					    fund->def_to_use.inline_fndef->vars=NULL;
					    fund->def_to_use.inline_fndef->types=NULL;
					    fund->def_to_use.inline_fndef->body=NULL;
					    inline_body=rm_cdr_next(inline_body);
					    if(inline_body->attr==TYPELIST)
					      {
						 fund->def_to_use.inline_fndef->types=(struct type_list *)inline_body->data;
						 inline_body->data=NULL;
						 inline_body=rm_cdr_next(inline_body);
					      };
					    if(inline_body!=NULL)
					      if(inline_body->attr==VARDLIST)
					      {
						 fund->def_to_use.inline_fndef->vars=(struct vardecl_list *)inline_body->data;
						 inline_body->data=NULL;
						 inline_body=rm_cdr_next(inline_body);
					      };
					    fund->def_to_use.inline_fndef->body=inline_body;
					 };
				       inline_body=NULL;
				    };
			       };
			     
			     if(lookup_var_decl(fund->name,vlist->vlist,0)!=NULL)
			       {
				  printf("Can't define function %s, variable with the same name exists at this scope\n",fund->name);
				  return 0;
			       };
			     
			     if(acls!=NULL)
			       {
				  if(acls->typemodf==FUNC)
				    type2=acls;
			       };
			     
			     if(type2!=acls)
			       {
				  global_tmp_type++;
				  sprintf(vname,"\4tmptype%lx",global_tmp_type);
				  if(tlist->tlist==NULL)
				    {
				       tlist->tlist=my_malloc(sizeof(struct type_list));
				       tlist->tlist->next=NULL;
				       tlist->tlist->convert_lock=OFF;
				       tlist->tlist->type=my_malloc(sizeof(struct typerec));
				       set_typerec(tlist->tlist->type,sizeof(long),Strdup(vname),FUN_DEFN,NONE,__void__,NULL);
				       tmptype=tlist->tlist->type;
				    }
				  else
				    tmptype=install_type(tlist->tlist,sizeof(long),Strdup(vname),FUN_DEFN,NONE,__void__,NULL)->type;
				  
				  tmptype->typebody.fundef=fund;
				  /*				  tmptype->typebody.actionclass->res_type=type2;				  
								  tmptype->typebody.actionclass->attr=fund->attr;
								  tmptype->typebody.actionclass->args=fund->args; */
				  type2=tmptype;
			       };
			     
			     
			     if(vars==NULL)
			       vlist->vlist=vars=insert_var_decl(vars,fund->name,type2,NULL,0);
			     else
			       vars=insert_var_decl(vars,fund->name,type2,NULL,0);

			     vars->var->attr=(fundef_type_flag==is_virtual)?VFN_VAR:FN_VAR;
			     vars->var->var_data.fundef=fund;
			     
			     return 1 ;
			  };
			
			
			printf("# Functional constructor call !\n");
			
			if((mode>=5)&(mode<=8)) 
			  /* constructor of the first type */
			  tmptype=type1; /* to add to the list */
			else
			  {
			     tmodf=NONE;
			     
			     chg=get_variable(instr)-instr;
			     
			     memset(tname,0,34);
			     Strncpy(tname,instr,chg);
			     
			     if((tmptype=get_type_by_name(tname,NONE,tlist))==NULL)
			       tmptype=get_type_by_name(tname,FUNC,tlist);
			     if(tmptype!=NULL)				
			       if(tmptype->typekind==ACTIONCLASS)
			       {
				  printf("#### tmptype is action class !!!\n");
				  /*	acls=tmptype;
				   tmptype=NULL; */
			       };
			  };	
			
			fn_constr=mk_head_lnd(fn_constr,mk_set_lnd(NULL,Strdup("\4objpart"),FUNCTION),TWOLISTS);
			
			if(tmptype!=NULL) 
			  /* if this is a constructor of a specific type ... */
			  mk_set_lnd((listnode)fn_constr->data,tmptype,TYPEDEFN);
			else 
			  /* this is either a general constructor or a mistake ... */ 
			  mk_set_lnd((listnode)fn_constr->data,vname,VARIABLE);
			/*** Trick - I will put var name at "vname" later ***/
			
			mk_set_lnd((listnode)fn_constr->data,mk_set_lnd(NULL,NULL,FUNCTION),TWOLISTS);
			
			chg=get_function(str,(listnode)((listnode)fn_constr->data)->next->next->data,d_ops,inl,opspec,1,tlist,vlist);
			
			if(!chg)
			  {
			     printf("Error with functional constructor call !!!\n");
			     return 0;
			  };
			while(*(str+chg)==' ')
			  chg++;
			
			if((*(str+chg)==',')||(*(str+chg)==';'))
			  {
			     ((listnode)((listnode)fn_constr->data)->next->next->data)->data=Strdup(type2->name);
			     break;
			  };
		     }
		   
		   if((mode>=5)&(mode<=8))
		     mode=((mode==5)||(mode==6))?mode-5:mode+2;
		   else
		     {
			if ((*str=='*')||(*str=='&'))
			  {
			     switch(*str)
			       {
				case '*': tmodf=POINTER;break;
				case '&': tmodf=REFERENCE;break;
			       };
			     str++;while(*str==' ') str++;
			     type2=mk_ref_type_from_type(type2,tmodf,tlist,0); 
			     /* create or find reference type */
			     tmodf=NONE;
			     change+=str-instr;
			     instr=str;
			  }
			else /* Not any kind of '*' type modifier */
			  {
			     str--;
			     while((*str==' ')&(str>=instr)) str--;
			     if(*str!=' ') str++; /* go back for spaces */
			     
			     tmodf=NONE;
			     
			     memset(tname,0,34);
			     Strncpy(tname,instr,str-instr);
			     
			     if(!Strcmp(tname,"inline"))
			       {
				  printf("## Inline function\n");
				  fundef_type_flag=is_inline;
			       }
			     else if(!Strcmp(tname,"META"))
			       {
				  printf("## META function\n");
				  fundef_type_flag=is_meta;
			       }
			     else
			       {
				  if((tmptype=get_type_by_name(tname,NONE,tlist))==NULL)
				    if((tmptype=get_type_by_name(tname,FUNC,tlist))==NULL)
				    {
				       fprintf(stderr,"Type %s unknown\n",tname);
				       return 0;
				    };
				  
				  if(tmptype->typekind==ACTIONCLASS)
				    acls=tmptype;
				  else if(tmptype->typekind==ISMODIF)
				    {
				       modif_lst=mk_head_lnd(modif_lst,tmptype,TYPEDEFN);
				       
				       while(*str==' ') str++;
				       if(*str=='<')
					 {
					    struct typerec * ttype;
					    str++;
					    while(*str==' ') str++;
					    modif_lst->attr=TWOLISTS;
					    modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
					    change+=str-instr;
					    instr=str;
					    while((*str!='>')&(!!*str))
					      {	
						 str+=get_type_from_code(instr,labels,tlist,vlist,",>",inl,d_ops,opspec,inl_lab,&ttype);
						 if(str==instr)
						   {
						      fprintf(stderr,"get_var_decl():can't get modifier args\n");
						      rm_lnd_all(modif_lst);
						      return 0;
						   };
						 mk_set_lnd((listnode)modif_lst->data,ttype,TYPEDEFN);
						 while(*str==' ') str++;
						 if(*str==',') str++;
						 while(*str==' ') str++;
						 change+=str-instr;
						 instr=str;
					      };
					    if(*str!='>') 
					      {
						 fprintf(stderr,"get_var_decl():error in modifier args\n");
						 rm_lnd_all(modif_lst);
						 return 0;
					      };
					    str++;
					    while(*str==' ') str++;
					    change+=str-instr;
					    instr=str;
					 };
				       if(*str=='(')
					 {
					    listnode mconstr;
					    if(modif_lst->attr==TYPEDEFN)
					      {
						 modif_lst->attr=TWOLISTS;
						 modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
					      };
					    mconstr=mk_set_lnd((listnode)modif_lst->data,mk_set_lnd(NULL,Strdup("\4objpart"),FUNCTION),TWOLISTS);
					    mk_set_lnd((listnode)mconstr->data,tmptype,TYPEDEFN);
					    
					    str+=get_function(str,(listnode)mk_set_lnd((listnode)mconstr->data,mk_head_lnd(NULL,NULL,FUNCTION),TWOLISTS)->data,d_ops,inl,opspec,1,tlist,vlist);
					    
					    if(str==instr)
					      {
						 printf("Error with modifier constructor call !!!\n");
						 rm_lnd_all(modif_lst);
						 return 0;
					      };
					    ((listnode)((listnode)mconstr->data)->next->next->data)->data=Strdup(tmptype->name);
					    while(*str==' ') str++;
					    change+=str-instr;
					    instr=str;
					 };
				    }
				  else 
				    {
				       /* Apply modifiers before making subtype */
				       
				       tmptype=apply_modifier(tmptype,modif_lst,&fn_constr,tlist);
				       rm_lnd_all(modif_lst);
				       modif_lst=NULL;
				       
				       if((type2=mk_subtype_by_type(type2,tmptype,tlist,0))==NULL)
					 {
					    printf("Type %s unknown\n",tname);
					    return 0;
					 };
				    };
			       };
			  };
		     }; /* if mode!= 5-8 */
		   if(chg)
		     {
			((listnode)((listnode)fn_constr->data)->next->next->data)->data=Strdup(tname);
			while(*str==32) str++;
			str+=chg-1;
			chg=0;
		     };
		   while(*str==' ') str++;
		   change+=str-instr;
		   instr=str;
		   
		   str=get_variable_name(instr);
		   while(*str==32) str++;
		   
		};
	
	str=instr; /* the token was identifier ! */
	while (*str==' ') str++;
	change+=str-instr;
	instr=str;
	
	while(isidch(*str)) str++;
	
	memset(vname,0,34);

	if(str!=instr)
	  {	
	     Strncpy(vname,instr,str-instr);
	     change+=str-instr;
	     instr=str;
	     if((mode==10)||(mode==12))
	       mode--;
	  }
	else if((mode==10)||(mode==12))
	  {
	     global_tmp_var++;
	     sprintf(vname,"\4tmpvar%lx",global_tmp_var);
	     printf("## Anonymous function arg variable\n");
	  }
	else
	  {
	     printf("# can't declare anon var, \"mode\" is %d\n",mode); 
	     if(type2!=type1)
	       Free(type2);
	     Free(type1);
	     rm_lnd_all(modif_lst);
		return 0;
	  };
	
	if((acls!=NULL)&((mode==10)||(mode==12)))
	  type2=acls;
	else if(acls!=NULL)
		{
		   fund=my_malloc(sizeof(struct fundef));
		   fund->name=Strdup(vname);

		   if(*acls->name==4) /* temporary actionclass */
		     {
			fund->args=acls->typebody.actionclass->args;
			acls->typebody.actionclass->args=NULL;
			}
		   else
			fund->args=copy_vardecl_list(acls->typebody.actionclass->args);
		   
		   fund->attr=acls->typebody.actionclass->attr;
		   fund->kind=(acls->typemodf==FUNC)?is_virtual:is_actionclass;
		   fund->res_type=acls->typebody.actionclass->res_type;
		   

		   /* TEMPORARY */
		   fund->def_to_use.name_in_code=fund->name;
		   
		   
		   /*		   fund_tmp=(struct fundef_list *) fnlist->data;
		   fnlist->data = my_malloc(sizeof(struct fundef_list));
		   ((struct fundef_list *) fnlist->data)->next=fund_tmp;
		   ((struct fundef_list *) fnlist->data)->fundef=fund;*/
		   
		   if(vars==NULL)
		     vlist->vlist=vars=insert_var_decl(NULL,(char *)vname,acls,NULL,0);
		   else
		     vars=insert_var_decl(vlist->vlist,(char *)vname,acls,NULL,0);
		   
		   vars->var->attr=VAR_FUNC;
		   
		   printf("## %s %s variable %s installed\n",(acls->typemodf==FUNC)?"Function type":"Action class",acls->name,vname);
		   
		   if(!((mode>=9)&(mode<=12)))
		     acls=NULL;
		   
		   instr=str;
		   while(*str==32)
		     str++;
		   
		   if((mode>=9)&(mode<=12))
		     {
			change+=str-instr;
			instr=str;
			if(changelen==NULL)
			  printf("## get_var_decl():mode=%d & changelen = NULL !\n",mode);
			else
			  *changelen=change;
			
			return (*str==',')||(*str==')');
		     }
		   else if(*str!=',')
		     break;
		   else
		     {
			change+=str-instr+1;
			str++;
			instr=str;
		     };
		   continue;
		};
	
	if((type1->typekind==VAR_TYPE)&(type1==type2)&((mode==3)||(mode==11)||(mode==12)))
	  {
	     change-=str-instr; /* we'll move str ahead to skip spaces */
	     while(*str==' ') str++;
	     change+=str-instr; /* now the correct value of change */
	     
	     if(((mode==3)&(*str==';'))||((mode!=3)&((*str==',')||(*str==')'))))
	       {
		Free(type1->name);
		  type1->name=Strdup(vname);
		  Free(type1->typebody.var_type.var->name);
		  type1->typebody.var_type.var->name=Strdup(vname);
		  
/* 		  refresh_buffer(instr,change,STR_BUF_SIZE); */
		  return 1;
	       }
	     else if((mode==3)&(*str==','))
	       {
		  printf("# Need to duplicate types ...\n");
		  type2=my_malloc(sizeof(struct typerec));
		  *type2=*type1;
		  global_type_id_count++;
		  type2->typeid=global_type_id_count;
		  
		  if(vars==NULL)
		    vlist->vlist=vars=insert_var_decl(NULL,(char *)vname,NULL,NULL,0);
		  else
		    vars=insert_var_decl(vars,(char *)vname,NULL,NULL,0);
		  
		  type2->typebody.var_type.var=vars->var;
		  vars->var->attr=TYPE_VAR;
		  vars=vlist->vlist;
		  type2->name=Strdup(vname);
		  
		  change++; /* skip comma */
		  while(*(str+change)==' ') change++;
		  refresh_buffer(instr,change,STR_BUF_SIZE);
		  change=0;
		  str=instr;
		  continue;
	       }
	     else
	       {
		  fprintf(stderr,"Parse error:%s",str);
		  return 0;
	       }
	  };
	
	type2=apply_modifier(type2,modif_lst,&fn_constr,tlist);
	rm_lnd_all(modif_lst);
	modif_lst=NULL;

	while(*str==' ') str++;
	while(*str=='[')
	  {
	    int chg;
	    if((type2=mk_type_from_arr(str,type2,tlist,&chg))==NULL)
	       return 0;
	    str+=chg;
	    while(*str==' ') str++;
	  };
	
	change+=str-instr;
	instr=str;

	printf("# Declared variable %s of known type %s:%d\n",vname,type2->name,type2->typemodf);
	if(lookup_var_decl((char *)vname,vlist->vlist,1)==NULL)
	  {
	    struct vardecl_list * vptr;
	     printf("# Variable %s has no previous declaration\n",vname);
	     if(vars==NULL)
	       vptr=vlist->vlist=vars=insert_var_decl(vars,(char *)vname,type2,NULL,0);
	     else
	       vptr=insert_var_decl(vars,(char *)vname,type2,NULL,0);

	     if(acls==type2)
	       vptr->var->attr=VAR_FUNC;
	     else if((type2->typekind==FUN_DEFN)
		     ||(type2->typekind==FUNPROTO))
	       vptr->var->attr=VAR_FUNC;
	  }
	else
	  {
	     printf("Variable %s already defined !\n",vname);
	     return 0;
	  };
	
	if((fundef_type_flag==is_inline)||(fundef_type_flag==is_meta))
	  {
	     printf("Warning: variable %s have modifier \"%s\",which is applied only to functions\n",vname,(fundef_type_flag==is_inline)?"inline":"meta");
	     fundef_type_flag=is_normal;
	  };
	instr=str;
	
	while(*str==32)
	  str++;

	if((mode>=9)&(mode<=12))
	  {
	     change+=str-instr;
	     instr=str;
	     if(changelen==NULL)
	       printf("## get_var_decl():mode=%d & changelen = NULL !\n",mode);
	     else
	       *changelen=change;
	     return (*str==',')||(*str==')');
	  }
	
	
	if ((fn_constr!=NULL)||(base_constr!=NULL))
	  {
	     fn_constr=lnd_reverse_r(fn_constr);
	     fn_constr=lnd_rapnde(lnd_reverse_r(copylist(base_constr)),fn_constr);
	     while(fn_constr!=NULL)
	       {
		  if(fn_constr->attr!=TWOLISTS)
		    fprintf(stderr,"get_var_decl():fn_constr->attr==%d != TWOLISTS\n",fn_constr->attr);

		  if(((listnode)fn_constr->data)->next->attr==TYPEDEFN)
		    /* if this is a constructor of a specific type */
		    {
		       /* make it a call to "\4anchestor" */
		       ((listnode)fn_constr->data)->next->attr=TWOLISTS;
		       ((listnode)fn_constr->data)->next->data=(char *)mk_head_lnd(mk_head_lnd(mk_head_lnd(NULL,((listnode)fn_constr->data)->next->data,TYPEDEFN),Strdup(vname),VARIABLE),Strdup("\4anchestor"),FUNCTION);
		    }
		  else /* general constructor call */
		    ((listnode)fn_constr->data)->next->data=Strdup(vname);
		  
		  mk_asm_output((listnode)fn_constr->data,labels,vlist,tlist,NULL,inl,d_ops,opspec,inl_lab,1);
		  
		  fn_constr=rm_cdr_next(fn_constr);
	       };
	  }
	else if((type2->typekind==CLASS)&(*type2->name!=4))
	  {
	     /* Try default (empty) constructor like cls::cls() .
	      Temporary classes do not have it, but validate_function
	      would return success on validation, since it would count
	      the "constructor" as a special (prefixed by 4) function. */
	     
	     fn_constr=mk_set_lnd(NULL,Strdup("\4objpart"),FUNCTION);
	     mk_set_lnd(fn_constr,Strdup(vname),VARIABLE);
	     mk_set_lnd(fn_constr,mk_set_lnd(NULL,Strdup(type2->name),FUNCTION),TWOLISTS);
	     
	     if(validate_function(fn_constr,vlist,tlist,labels,1)!=NULL)
	       { /* Have constructor ! */
		  print_asm_output(fn_constr,labels,vlist,tlist,NULL,inl,d_ops,opspec,inl_lab);
	       };
	     rm_lnd_all(fn_constr);
	     fn_constr=NULL;
	  };
	
	if(*str!=',')
	  break;
	else
	  {
	     change+=str-instr+1;
	     str++;
	     instr=str;
	  };
     };
   
   refresh_buffer(keep_instr,change,STR_BUF_SIZE);
   return 1;
}



struct typerec * get_new_type_declaration(
char * instr,
struct type_listoflist * types,
struct vardecl_listoflist * vars,
listnode labels,
defined_op ops,
listnode inl,
listnode opspec,
listnode inl_lab
)
{
   char * str;
   enum {TK_UNDEF=0,TK_CLASS,TK_UNION,TK_TYPEDEF,TK_PTR,TK_MODIF,TK_ACLS} typeknd=0;
   /* type :0 - NONE, 1 - struct, 2 - union, 3 - typedef,
    4 - forward pointer to struct/union, 5 - class,6 - modifier,
    7 - action class */

   char local_buf[34];
   struct typerec * type=NULL, * type1=NULL;
   struct type_list * top_classes=NULL,* tcls1=NULL,* tclsptr=NULL;
   struct vardecl_list * vlst,* ac_args=NULL;
   struct typerec * ac_rest=NULL,* tmptype=NULL;
   struct vardecl_listoflist tmpvarll;
   struct type_listoflist * tmptypelp=types;
   enum typemodf tmodf;
   listnode modif_lst=NULL,acls_exec=NULL;
   int change=0;
   struct vardecl_list * acls_args=NULL;
   
   memset(local_buf,0,34);
   str=get_variable_name(instr);
   strncpy(local_buf,instr,str-instr);
   
   if(!Strcmp(local_buf,"union"))
     typeknd=TK_UNION;
   else if(!Strcmp(local_buf,"typedef"))
     typeknd=TK_TYPEDEF;
   else if(!Strcmp(local_buf,"class"))
     typeknd=TK_CLASS;
   else if(!Strcmp(local_buf,"modif"))
     typeknd=TK_MODIF;
   else if(!Strcmp(local_buf,"aclass"))
     typeknd=TK_ACLS;
   
   if((typeknd==TK_UNION)
      ||(typeknd==TK_CLASS)
      ||(typeknd==TK_ACLS))
     {
	while(*str==' ') str++;
	refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	str=instr;
	
	memset(local_buf,0,34);

	if((typeknd==TK_ACLS)
	   &&(*str=='('))
	  {
	     printf("# Getting top classes of the modifier\n");
	     str++;
	     while(*str==' ') str++;
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;

	     if(*str!=')')
	       {
		  top_classes=my_malloc(sizeof(struct type_list));
		  top_classes->next=NULL;
		  top_classes->type=NULL;
		  tclsptr=top_classes;
	       }
	     else
	       printf("### Empty brackets ... Strange ...\n");
	     
	     while(*str!=')')
	       {
		  struct typerec * tmptype;
		  str+=get_type_from_code(instr,labels,types,vars,",)",inl,ops,opspec,inl_lab,&tmptype);
		  if(instr==str)
		    {
		       fprintf(stderr,"Error getting top classes of %s - can't get type from code\n",local_buf);
		       return NULL;
		    };
		  tclsptr->type=tmptype;
		  if (*str==',')
		    {
		       str++;
		       while(*str==' ') str++;
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       tclsptr->next=my_malloc(sizeof(struct type_list));
		       tclsptr=tclsptr->next;
		       tclsptr->next=NULL;
		       tclsptr->type=NULL;
		    };
	       };
	     str++;
	     while(*str==' ') str++;
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;
	  };
	
	if(*str!='{')
	  {
	     str=get_variable_name(instr);
	     if(str==instr)
	       return NULL;
	     strncpy(local_buf,instr,str-instr);
	     while(*str==' ') str++;
	     if(typeknd==TK_ACLS)
	       /* actionclass must have res type */
	       {
		  while(1)
		    {
		       if((tmptype=get_type_by_name(local_buf,NONE,types))==NULL)
			 if((tmptype=get_type_by_name(local_buf,FUNC,types))==NULL)
			 {
			    fprintf(stderr,"get_new_type_declaration(): uncorrect type name %s for actionclass return type\n",local_buf);
			    return NULL;
			 };
		       
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       

		       
		       if(tmptype->typekind==ISMODIF)
			 {
			    modif_lst=mk_head_lnd(modif_lst,tmptype,TYPEDEFN);
			    
			    if(*str=='<')
			      {
				 struct typerec * ttype;
				 str++;
				 while(*str==' ') str++;
				 modif_lst->attr=TWOLISTS;
				 modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
				 refresh_buffer(instr,str-instr,STR_BUF_SIZE);
				 str=instr;
				 while((*str!='>')&(!!*str))
				   {	
				      str+=get_type_from_code(instr,labels,types,vars,",>",inl,ops,opspec,inl_lab,&ttype);
				      if(str==instr)
					{
					   fprintf(stderr,"get_new_type_decl():can't get modifier args\n");
					   rm_lnd_all(modif_lst);
					   return NULL;
					};
				      mk_set_lnd((listnode)modif_lst->data,ttype,TYPEDEFN);
				      while(*str==' ') str++;
				      if(*str==',') str++;
				      while(*str==' ') str++;
				      refresh_buffer(instr,str-instr,STR_BUF_SIZE);
				      str=instr;
				   };
				 if(*str!='>') 
				   {
				      fprintf(stderr,"get_new_type_declaration():error in modifier args\n");
				      rm_lnd_all(modif_lst);
				      return NULL;
				   };
				 str++;
				 while(*str==' ') str++;
				 refresh_buffer(instr,str-instr,STR_BUF_SIZE);
				 str=instr;
			      };
			 }
		       else
			 {
			    if(modif_lst!=NULL)
			      {
				 tmptype=apply_modifier(tmptype,modif_lst,NULL,types);
				 rm_lnd_all(modif_lst);
				 modif_lst=NULL;
			      };
			 };
		       
		       while((*str=='*')||(*str=='&'))
			 {
			    if((tmptype=mk_ref_type_from_type(tmptype,(*str=='*')?POINTER:REFERENCE,types,0))==NULL)
			      {
				 fprintf(stderr,"get_new_type_declaration():error creating reference type\n");
				 return NULL;
			      };
			    str++;
			    while(*str==' ') str++;
			    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
			    str=instr;
			 };
		       
		       str=get_variable_name(str);
		       memset(local_buf,0,sizeof(local_buf));
		       strncpy(local_buf,instr,str-instr);
		       while(*str==' ') str++;
		  
		       if((!*str)||(*str=='(')||(*str=='{'))
			 break;
		    };		  
		  if(modif_lst!=NULL)
		    {
		       tmptype=apply_modifier(tmptype,modif_lst,NULL,types);
		       rm_lnd_all(modif_lst);
		       modif_lst=NULL;
		    };
		  ac_rest=tmptype;
		  tmptype=NULL;
	       }
	     else if(*str=='*')
	       {
		  printf("# Forward of pointer to structural object\n");
		  str++;
		  while(*str==' ') str++;
		  refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		  str=instr;
		  
		  typeknd=TK_PTR;
	       };
	  }
	else
	  sprintf(local_buf,"\4tmp%s%lx",(typeknd==TK_UNION)?"union":"class",global_tmp_struct++);
	
	if(typeknd!=TK_PTR)
	  {
	     if((*str=='('))
	       {
		  struct vardecl_listoflist tmpvarll;
		  struct type_list * tclsptr;
		  switch(typeknd)
		    {
		     case TK_CLASS:
		       str++;
		       while(*str==' ') str++;
		       printf("## getting top classes of class %s\n",local_buf);
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       
		       if(*str!=')')
			 {
			    vlst=my_malloc(sizeof(struct vardecl_list));
			    vlst->next=NULL;
			    vlst->var=NULL;
			 }
		       else
			 printf("### Empty brackets ... Strange ...\n");
		       
		       while(*str!=')')
			 {
			    str+=get_type_from_code(instr,labels,types,vars,",)",inl,ops,opspec,inl_lab,&tmptype);
			    if(instr==str)
			      {
				 fprintf(stderr,"Error getting top classes of %s - can't get type from code\n",local_buf);
				 return NULL;
			      };
			    tclsptr->type=tmptype;
			    if (*str==',')
			      {
				 str++;
				 while(*str==' ') str++;
				 refresh_buffer(instr,str-instr,STR_BUF_SIZE);
				 str=instr;
				 tclsptr->next=my_malloc(sizeof(struct type_list));
				 tclsptr=tclsptr->next;
				 tclsptr->next=NULL;
				 tclsptr->type=NULL;
			      };
			 };
		       str++;
		       while(*str==' ') str++;
		       break;
		     case TK_ACLS:
		       acls_exec=mk_head_lnd(NULL,NULL,PARTOFOP);
		       printf("# Getting args of actionclass itself ...\n");
		       str++;
		       while(*str==' ') str++;
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;

		       if(*str!=')')
			 {
			    tmpvarll.vlist=acls_args;
			    tmpvarll.next=vars;
			 }
		       else
			 printf("### Empty brackets ... Strange ...\n");
		       
		       while(*str!=')')
			 {
			    int chg=0;

			    if(!get_var_decl(str,types,&tmpvarll,labels,ops,inl,opspec,inl_lab,9,&chg))
			      return NULL;
			    
			    str+=chg;
			    while(*str==' ') str++;
			    if(*str==',') str++;
			    while(*str==' ') str++;
			    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
			    str=instr;
			 };
		       str++;
		       while(*str==' ') str++;
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       acls_args=tmpvarll.vlist;

		       printf("# Getting action class prototype args ...\n");
		       str++;
		       while(*str==' ') str++;
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       
		       if(*str!=')')
			 {
			    tmpvarll.vlist=ac_args;
			    tmpvarll.next=vars;
			 }
		       else
			 printf("### Empty brackets ... Strange ...\n");
		       
		       while(*str!=')')
			 {
			    int chg=0;

			    if(!get_var_decl(str,types,&tmpvarll,labels,ops,inl,opspec,inl_lab,9,&chg))
			      return NULL;
			    
			    str+=chg;
			    while(*str==' ') str++;
			    if(*str==',') str++;
			    while(*str==' ') str++;
			    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
			    str=instr;
			 };
		       str++;
		       while(*str==' ') str++;
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       ac_args=tmpvarll.vlist;
		       tmptypelp=my_malloc(sizeof(struct type_listoflist)); 
		       tmptypelp->next=types;
		       tmptypelp->tlist=tcls1;
		       /* we need one more layer of temporary types */
		       break;
		     default:
		       printf("# Unexpected symbol \"(\" at \"get_new_type_declaration()\" !\n");
		       return NULL;
		    };
	       };
	     
	     if(*str!='{')
	       return NULL;
	     str++;
	     
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;
	  };
	
	if(types->tlist==NULL)
	  {
	     types->tlist=my_malloc(sizeof(struct type_list));
	     types->tlist->next=NULL;
	     types->tlist->convert_lock=OFF;
	     types->tlist->type=my_malloc(sizeof(struct typerec));
	     type=set_typerec(types->tlist->type,0,Strdup(local_buf),(typeknd==TK_UNION)?UNION:((typeknd==TK_MODIF)?ISMODIF:CLASS),NONE,__void__,NULL);
	     global_type_id_count++;
	     type->typeid=global_type_id_count;
	  }
	else
	  type=install_type(types->tlist,0,Strdup(local_buf),(typeknd==TK_UNION)?UNION:((typeknd==TK_MODIF)?ISMODIF:CLASS),NONE,__void__,NULL)->type;
	
	
	if(typeknd==TK_PTR)
	  {
	     type->typekind=SYMBREFR;
	     type->typebody.symbrefr=Strdup(local_buf);
	     type->typemodf=POINTER;
	     return type;
	  };
	
	if(typeknd==TK_ACLS) /* action class */
	  {
	     printf("# Creating action class decl\n");
	     type->typebody.actionclass=my_malloc(sizeof(struct actionclass));

	     
	     type->typebody.actionclass->args=ac_args;
	     type->typebody.actionclass->ac_args=acls_args;
	     type->typebody.actionclass->res_type=ac_rest;
	     /*		type->typebody.modif_def->args=NULL;*/
	     type->typebody.actionclass->top_class=top_classes; 
	     /* top_classes=NULL by default */
	     type->typekind=ACTIONCLASS;
	  }
	else if((typeknd==TK_CLASS)/* Class */
		||(typeknd==TK_UNION))/* Union */
	  {
	     type->typebody.class_def=my_malloc(sizeof(struct class_def));
	     type->typebody.class_def->constructors=NULL;
	     type->typebody.class_def->destructors=NULL;
	     type->typebody.class_def->top_class=top_classes; /* top_classes=NULL by default */
	     type->typebody.class_def->variable_constructors=NULL;
	     type->typebody.class_def->c_or_u=(typeknd==TK_CLASS);	     
	  };
	
	tmpvarll.next=vars;
	tmpvarll.vlist=NULL;
	
	while(1)
	  {
	     struct fundef * fund;
	
	     while(*str==32) str++;
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;
	     
	     if((typeknd==TK_CLASS)
		||(typeknd==TK_UNION)
		/*		||(typeknd==TK_MODIF) */
		||(typeknd==TK_ACLS)) 
		/* test for constructors/destructors */
	       
	       str+=test_get_constr_destr(instr,type,tmptypelp,vars,labels,ops,inl,opspec,inl_lab,&fund);
	     
	     if(str!=instr)
	       {
		  if((typeknd==TK_CLASS)
		     ||(typeknd==TK_UNION))
		    {
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       while(*str==32) str++;
		       if(*str=='{')
			 {
			    struct vardecl_listoflist local_vll;
		       
			    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
			    str=instr;
			    
			    memset(local_buf,0,34);
			    sprintf(local_buf,"tmplab%lx",global_label_count++);
			    printf("jmp %s\n",local_buf);
			    
			    if(*fund->def_to_use.name_in_code!=4)
			      printf("O%s :\n",fund->def_to_use.name_in_code);
			    else
			      printf("%s :\n",fund->def_to_use.name_in_code+2);
			    
			    local_vll.next=&tmpvarll;
			    local_vll.vlist=fund->args;
			    
			    if(!get_code_block(instr,NULL,inl,ops,opspec,inl_lab,labels,&local_vll,tmptypelp,0))
			      {
				 fprintf(stderr,"Error in function body !!!\n");
				 return 0;
			      };
			    printf("%s : \n",local_buf);
			 };
		    }
		  else if(typeknd==TK_ACLS)
		    {
		       printf("# Getting action class function\n");
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       str=instr;
		       while(*str==32) str++;
		       if(*str=='{')
			 {
			    struct vardecl_listoflist local_vll;
			    listnode tmpdst=mk_head_lnd(NULL,NULL,0);
			    
			    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
			    str=instr;
			    local_vll.next=&tmpvarll;
			    local_vll.vlist=fund->args;
			    
			    if(!get_code_block(instr,tmpdst,inl,ops,opspec,inl_lab,labels,&local_vll,tmptypelp,0))
			      {
				 fprintf(stderr,"Error in function body !!!\n");
				 return 0;
			      };
			 };
		    };
	       }
	     else
	       if(typeknd!=TK_ACLS)
		 {
		   if(!get_var_decl(instr,tmptypelp,&tmpvarll,labels,ops,inl,opspec,inl_lab,2,NULL))
		     /* Only class/modif can have subfuncs */
		     {
		       printf("Error in %s definition !\n",(typeknd==TK_CLASS)?"class":"union");
		       return NULL;
		     };
		 }
	       else /* if typeknd==TK_ACLS, i.e. if it is aclass */
		 {
		    str=get_variable_name(instr);
		    strncpy(local_buf,instr,str-instr);
		    str=instr;

		    if((get_type_by_name(local_buf,NONE,tmptypelp)!=NULL)
		       ||(get_type_by_name(local_buf,FUNC,tmptypelp)!=NULL) /* actionclass */
		       ||(!Strcmp(local_buf,"typeof"))
		       ||(!Strcmp(local_buf,"struct"))
		       ||(!Strcmp(local_buf,"union"))
		       ||(!Strcmp(local_buf,"class"))
		       ||(!Strcmp(local_buf,"aclass"))
		       ||(!Strcmp(local_buf,"typedef"))
		       ||(!Strcmp(local_buf,"modif")))
		      {
			if(!get_var_decl(instr,tmptypelp,&tmpvarll,labels,ops,inl,opspec,inl_lab,1,NULL))
			  {
			    fprintf(stderr,"Error in variable/type definition in actionclass !\n");
			    return NULL;
			  };
		      }
		    else
		      {
			struct vardecl_list * vindtmp=NULL;
			if(!get_code_block(instr,acls_exec,inl,ops,opspec,inl_lab,labels,&tmpvarll,tmptypelp,1))
			  {
			    rm_listnode(acls_exec);
			    fprintf(stderr,"Error in actionclass body !!!\n");
			    return NULL;
			  };

			if(validate_function(acls_exec->next,&tmpvarll,tmptypelp,labels,0)!=NULL)
			  {
			    printf("# Validated code !\n");
			    for(vindtmp=acls_args;vindtmp!=NULL;vindtmp=vindtmp->next)
			      if(vindtmp->var!=NULL)
				{
				  printf("# Replacing %s %s ...\n",(vindtmp->var->attr==VAR_FUNC)?"func":"var",vindtmp->var->name);
				  if(vindtmp->var->attr==VAR_FUNC)
				    {
				      listnode aclsrep=NULL;
				      int skiprep=0;
				      aclsrep=lnd_find(acls_exec->next,vindtmp->var->name,FUNCTION,skiprep);
				      if(aclsrep!=NULL)
					{
					  skiprep++;
					  for(;aclsrep!=NULL;aclsrep=lnd_find(acls_exec->next,vindtmp->var->name,FUNCTION,skiprep),skiprep++)
					    {
					      aclsrep->next=mk_head_lnd(NULL,mk_head_lnd(aclsrep->next,aclsrep->data,aclsrep->attr),TWOLISTS);
					      aclsrep->data=strdup("\4wrap_template_arg");
					    };
					};
				    }
				  else
				    {
				      lnd_replace(acls_exec->next,vindtmp->var->name,VARIABLE,mk_head_lnd(mk_head_lnd(NULL,strdup(vindtmp->var->name),VARIABLE),strdup("\4wrap_template_arg"),FUNCTION),TWOLISTS,3,0);
				    };
				};
			    print_asm_output(acls_exec->next,labels,&tmpvarll,tmptypelp,NULL,inl,ops,opspec,inl_lab);
			  }
			else
			  printf("Failed validating code !!!\n");
			rm_listnode(acls_exec);
		      };
		    str=instr;
		 };
	     while(*str==32) str++;
	     
	     if(*str=='}')
	       break;
	
	     if(*str!=';')
	       {
		  printf("Error in %s definition - \";\" expected !\n",(typeknd==TK_CLASS)?"structure":"union");
		  return NULL;
	       };
	     str++;
	     if(*str=='}')
	       break;
	  };
	
	while(*str==32) str++;
	
	if(*str!='}')
	  {
	     printf("Error - \'}\' expected !\n");
	     return NULL;
	  };
	str++;
	
	refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	str=instr;
	
	if((typeknd==TK_CLASS)
	   ||(typeknd==TK_UNION))
	  {
	     type->size=0;
	     for(vlst=tmpvarll.vlist;vlst!=NULL;vlst=vlst->next) 
	       /* Calculate size regarding is it struct or union !!! */
	       if(typeknd==TK_CLASS)
		 type->size+=vlst->var->type->size;
	       else if(type->size<vlst->var->type->size)
		 /* in case of union choose largest value */
		 type->size+=vlst->var->type->size;

	     type->typebody.class_def->vars=tmpvarll.vlist;
	     
	     /*	     type->typebody.class_def->funcs=(struct fundef_list *)ltmp->data;*/
	  }
	else if(typeknd==TK_ACLS) /* action class */
	  {
	     type->size=0;
	     for(vlst=tmpvarll.vlist;vlst!=NULL;vlst=vlst->next) 
	       type->size+=vlst->var->type->size;
	     type->typebody.actionclass->local_vars=tmpvarll.vlist;
	     type->typebody.actionclass->local_types=tmptypelp->tlist;
	     /*	     type->typebody.actionclass->local_funcs=(struct fundef_list *)ltmp->data;*/
	  };
     }
   else if((typeknd==TK_TYPEDEF)
	   ||(typeknd==TK_MODIF))
     {
       struct type_list * modarg_list_end=NULL;
	printf("# Parsing \"%s\" now !\n",(typeknd==TK_MODIF)?"modif":"typedef");
	tmptypelp=types;
	while(*str==32) 
	  str++;
	refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	str=instr;
	if((typeknd==TK_MODIF)
	   &&(*str=='('))
	  {
	    printf("# get_new_type_decl(): getting modif args ...\n");

	    str++;
	    while(*str==32) 
	      str++;
	    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	    str=instr;

	    if(*str!=')')
	      {
		tcls1=my_malloc(sizeof(struct type_list));  
		tcls1->next=NULL;
		tcls1->type=NULL;
		tclsptr=tcls1;
	      }
	    else
	      printf("### Empty brackets ... Strange ...\n");
	    
	    while(*str!=')')
	      {
		struct type_list * modarg_top=NULL;/*,*modarg_tptr=NULL;*/
		char buf[32];
		/*		listnode modif_lst=NULL;*/
			  
		tmptype=NULL;
		
		str=get_variable_name(instr);
		if(instr==str)
		  {
		    fprintf(stderr,"Error getting modif args - can't get name from code\n");
		    return NULL;
		  };
		    
		memset(buf,0,sizeof(buf));
		strncpy(buf,instr,str-instr);
		
		if((!Strcmp(buf,"struct"))
		   ||(!Strcmp(buf,"union"))
		   ||(!Strcmp(buf,"class"))
		   ||(!Strcmp(buf,"modif"))
		   ||(!Strcmp(buf,"acls"))
		   ||(!Strcmp(buf,"typedef"))
		   ||(get_type_by_name(buf,NONE,types)!=NULL)
		   ||(get_type_by_name(buf,FUNC,types)!=NULL))
		  {
		    str=instr+get_type_from_code(instr,labels,types,vars,NULL,inl,ops,opspec,inl_lab,&tmptype);
		    /* NULL as stop chars - gets all type-related tokens, stops on first non-type*/
		    if(tmptype==NULL)
		      {
			fprintf(stderr,"get_new_type_declaration(): when defining parent\nclasses of modifier args: Type %s unknown\n",buf);
			return NULL;
		      };
		    modarg_top=my_malloc(sizeof(struct type_list));
		    modarg_top->type=tmptype;
		    modarg_top->next=NULL;

		    while(*str==' ') str++;
		    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		    str=instr;

		    str=get_variable_name(instr);
		    if(instr==str)
		      {
			fprintf(stderr,"Error getting modif args - can't get name from code\n");
			return NULL;
		      };
		    
		    memset(buf,0,sizeof(buf));
		    strncpy(buf,instr,str-instr);
		
		  }
		else
		  modarg_top=NULL;

		tclsptr->type=my_malloc(sizeof(struct typerec));
		tclsptr->type->typemodf=NONE;
		tclsptr->type->typekind=MODIFARG;
		tclsptr->type->typeid=++global_type_id_count;
		tclsptr->type->name=strdup(buf);;

		tclsptr->type->typebody.class_list=modarg_top;
		    
		while(*str==' ') 
		  str++;
		refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		str=instr;
		    
		if (*str==',')
		  {
		    str++;
		    while(*str==' ') str++;
		    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		    str=instr;

		    tclsptr->next=my_malloc(sizeof(struct type_list));
		    tclsptr=tclsptr->next;
		    tclsptr->next=NULL;
		    tclsptr->type=NULL;
		  }
		else if(*str!=')')
		  fprintf(stderr,"Parse error at: \"%20s\"\n",str); 
	      };
	    str++;
	    while(*str==' ') str++;
	    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	    str=instr;

	    /* we need one more layer of temporary types */
	    tmptypelp=my_malloc(sizeof(struct type_listoflist)); 
	    tmptypelp->next=types;
	    tmptypelp->tlist=tcls1;

	    modarg_list_end=tclsptr; 
	    /* Save pointer to last arg type. Since we use tmptypelp as main type
	       list of list some types might be installed there. Therefore we need 
	       to remember the point where args end. */
	  };

	memset(local_buf,0,34);
	str=get_variable_name(instr);
	strncpy(local_buf,instr,str-instr);
	
	tmodf=NONE;
	     
	if(!Strcmp(local_buf,"typeof"))
	  {
	    str=instr;
	    str+=get_typeof_decl(instr,tmptypelp,vars,ops,inl,opspec,&type);
	    if(str==instr)
		    return NULL;
	    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	    str=instr;
	  }
	else if((!Strcmp(local_buf,"struct"))
		||(!Strcmp(local_buf,"union"))
		||(!Strcmp(local_buf,"class"))
		||(!Strcmp(local_buf,"modif"))
		||(!Strcmp(local_buf,"acls"))
		||(!Strcmp(local_buf,"typedef")))
	  {
	    type=get_new_type_declaration(instr,tmptypelp,vars,labels,ops,inl,opspec,inl_lab);
	    if(type==NULL)
	      {
		printf("Error in \"%s\" - error in declaration of %s \n",(typeknd==TK_MODIF)?"modif":"typedef",local_buf);
		return NULL;
	      };
	    str=instr;
	  }
	else
	  {
	    str=instr+get_type_from_code(instr,labels,tmptypelp,vars,NULL,inl,ops,opspec,inl_lab,&type);
	    if(type==NULL)
	      {
		printf("Error in \"%s\" - no such a type \"%s\"\n",(typeknd==TK_MODIF)?"modif":"typedef",local_buf);
		return NULL;
	      };
	  };
	     
	while(*str==32) str++;
	     
	refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	str=instr;
	
	str=get_variable_name(instr);
	while(*str==32) str++;
	
	while((*str!=',')&(*str!=';')
	      &(*str!='}')&(*str!='(')
	      &(!((*str==':')&(*(str+1)=='-'))))
	  {
	     
	     if ((*str=='*')||(*str=='&'))
	       {
		  switch(*str)
		    {
		     case '*': tmodf=POINTER;break;
		     case '&': tmodf=REFERENCE;break;
		    };
		  str++;
		  type=mk_ref_type_from_type(type,tmodf,types,1); 
		  /* CREATE (not find) new reference type */
		  
		  tmodf=NONE;
		  refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		  str=instr;
	       }
	     else /* Not any kind of '*' type modifier */
	       {
		  struct typerec * tmptype;
		  str--;
		  while((*str==32)&(str>=instr)) str--;
		  if(*str!=32) str++; /* go back for spaces */
		  
		  tmodf=NONE;
		  
		  memset(local_buf,0,34);
		  Strncpy(local_buf,instr,str-instr);
		  while(*str==32) str++;
		  
		  if((tmptype=get_type_by_name(local_buf,NONE,types))==NULL)
		    if((tmptype=get_type_by_name(local_buf,FUNC,types))==NULL)
		    {
		       fprintf(stderr,"Type %s unknown\n",local_buf);
		       return NULL;
		    };
		  
		  if(tmptype->typekind==ISMODIF)
		    {
		       modif_lst=mk_head_lnd(modif_lst,tmptype,TYPEDEFN);
		       
		       while(*str==32) str++;
		       if(*str=='<')
			 {
			    struct typerec * ttype;
			    str++;
			    while(*str==' ') str++;
			    modif_lst->attr=TWOLISTS;
			    modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
			    change+=str-instr;
			    instr=str;
			    while((*str!='>')&(!!*str))
			      {	
				str+=get_type_from_code(instr,labels,types,vars,",>",inl,ops,opspec,inl_lab,&ttype);
				 if(str==instr)
				   {
				      fprintf(stderr,"get_new_type_declaration():can't get modifier args\n");
				      rm_lnd_all(modif_lst);
				      return NULL;
				   };
				 mk_set_lnd((listnode)modif_lst->data,ttype,TYPEDEFN);
				 while(*str==' ') str++;
				 if(*str==',') str++;
				 while(*str==' ') str++;
				 change+=str-instr;
				 instr=str;
			      };
			    if(*str!='>') 
			      {
				 fprintf(stderr,"get_new_type_declaration():error in modifier args\n");
				 rm_lnd_all(modif_lst);
				 return NULL;
			      };
			    str++;
			    while(*str==' ') str++;
			    change+=str-instr;
			    instr=str;
			 };
		    };
		  
		  if((type1=mk_subtype_by_type(type,tmptype,types,0))==NULL)
		    {
		       if(*str!='(')
			 {
			    printf("Type %s unknown\n",local_buf);
			    return NULL;
			 }
		       else
			 break;
		    }
		  else
		    type=type1;
	       };
	     while(*str==32) str++;
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;
	     
	     if(*instr=='(') /* break here to get all "type-related" tokens */
	       break;
	     
	     str=get_variable_name(instr);
	     while(*str==32) str++;
	     
	  };
	
	change=0;
	type1=NULL;
	
	memset(local_buf,0,34);
	
	if(*str=='(')
	  {
	     char * str1=NULL;
	     struct vardecl_listoflist tmpvarll;
	     
	     if(*instr=='(') /* if there are no tokens which can be names */
	       {
		  str+=get_subtype_from_code(instr,type,labels,tmptypelp,vars,inl,ops,opspec,inl_lab,&str1,&type1);
		  
		  if(instr!=str)
		    {
		       while(*str==32) str++;
		       if(*str!='(')
			 str=instr;
		    };
		  if(instr!=str) /* functional brackets after this brackets */
		    {
		       refresh_buffer(instr,str-instr,STR_BUF_SIZE);
		       Strcpy(local_buf,str1); /* save str1 */
		       Free(str1); /* and free it's memory */
		    };
	       }
	     else
	       type1=NULL;
	     
	     if(instr!=str)
	       {
		  str=get_variable_name(instr);
		  memset(local_buf,0,34);
		  strncpy(local_buf,instr,str-instr);
		  refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	       };
	     
	     str=instr;
	     while(*str==' ')
	       str++;
	     

	     if(*str=='(')
	       {
		  str++;
		  while(*str==32)
		    str++;
	       };
	     
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;
	     
	     tmpvarll.next=NULL;
	     tmpvarll.vlist=NULL;
	     str1=(char *)(str=instr);
	     
	     while(1)
	       {
		  str=(char *)str1+get_fn_arg_decl(str,tmptypelp,&tmpvarll,labels,ops,opspec,inl,inl_lab,1);
		  
		  if((char *)str1==str)
		    {
		       printf("typedef - can't get arguments at actionclass declaration !");
		       return NULL;
		    };
		  
		  if((*str!=',')&(*str!=')'))
		    {
		       printf("typedef - unexpected symbol %c at actionclass declaration !",*str);
		       return NULL;
		    };
		  
		  if(*str==')')
		    break;
		  
		  str++;

		  while(*str==32)
		    str++;
		  
		  str1=(char *)str;
	       };
	     str++;
	     while(*str==32) str++;
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;

	     if(type1!=NULL) 
	       /* complex type in brackets - require structure manupulating */
	       {
		  struct typerec * type2;
		  type2=my_malloc(sizeof(struct typerec));
		  *type2=*type; /* full copy of memory image of "type" */
		  type=my_malloc(sizeof(struct typerec));

		  type->typekind=FUNPROTO;
		  type->typemodf=NONE;
		  type->typeconv=NULL;
		  type->typebody.fundef=my_malloc(sizeof(struct fundef));
		  type->typebody.fundef->res_type=type2;
		  type->typebody.fundef->args=tmpvarll.vlist;

		  global_type_id_count++;
		  type->typeid=global_type_id_count;
		  type=type1; /* actual final type */
	       }
	     else
	       {
		  type1=type;
		  type=my_malloc(sizeof(struct typerec));

		  type->typekind=FUNPROTO;
		  type->typemodf=NONE;
		  type->typeconv=NULL;
		  type->typebody.fundef=my_malloc(sizeof(struct fundef));
		  type->typebody.fundef->res_type=type1;
		  type->typebody.fundef->args=tmpvarll.vlist;

		  global_type_id_count++;
		  type->typeid=global_type_id_count;
	       };
	     
	     type->name=Strdup(local_buf);

	     while(*str==' ')
	       str++;

	     while(*str=='[')
	       {
		 int chg;
		 if((type=mk_type_from_arr(str,type,types,&chg))==NULL)
		   return NULL;
		 str+=chg;
		 while(*str==' ')
		   str++;
	       };

	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	     str=instr;

	     type1=(struct typerec *) types->tlist;
	     types->tlist=my_malloc(sizeof(struct type_list));
	     types->tlist->convert_lock=OFF;
	     types->tlist->type=type;
	     types->tlist->next=(struct type_list *) type1;
	     
	     return type;
	  }
	else
	  {
	     str=get_variable_name(instr);
	     
	     memset(local_buf,0,34);
	     strncpy(local_buf,instr,str-instr);
	     refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	  };
	
	if(*type->name!=4)
	  {
	     if(types->tlist==NULL)
	       {
		  types->tlist=my_malloc(sizeof(struct type_list));
		  types->tlist->next=NULL;
		  types->tlist->convert_lock=OFF;
		  types->tlist->type=my_malloc(sizeof(struct typerec));
		  type1=set_typerec(types->tlist->type,0,Strdup(local_buf),TYPEREFR,NONE,__void__,NULL);
		  global_type_id_count++;
		  type1->typeid=global_type_id_count;
	       }
	     else
	       type1=install_type(types->tlist,0,Strdup(local_buf),TYPEREFR,NONE,__void__,NULL)->type;
	     
	     if(type1==NULL)
	       return NULL;
	     
	     if(typeknd==TK_MODIF)
	       {
		 printf("# get_new_type_declaration(): creating new modif ...\n");
		 type1->typekind=ISMODIF;
		 if(tmptypelp==types)
		   type1->typebody.modif_def.mod_args=NULL;
		 else if(tmptypelp==NULL)
		   {
		     printf("# get_new_type_declaration(): tmptypelp == NULL !\n");
		     type1->typebody.modif_def.mod_args=NULL;
		   }
		 else
		   {
		     type1->typebody.modif_def.mod_args=tmptypelp->tlist;
		     free(tmptypelp);

		     /* now since we used tmptypelp as main type list of list
			something else (f.e. class def) might be installed 
			after args. We keep end of args in "modarg_list_end" */

		     if(modarg_list_end!=NULL)
		       {
			 /* first apend all not-args to types->tlist */
			 if(types->tlist==NULL)
			   types->tlist=modarg_list_end->next;
			 else
			   {
			     for(tclsptr=types->tlist;tclsptr->next!=NULL;tclsptr=tclsptr->next);
			     tclsptr->next=modarg_list_end->next;
			   };
			 /* now truncate arg list to make sure it has only args */
			 modarg_list_end->next=NULL;
		       };
		   };
		   type1->typebody.modif_def.type=type;		 
		   type=type1;
	       }
	     else
	       {
		 type1->typebody.pointer_to=type;
		 type=type1;
	       }	     	     
	  }
	else /*   *type->name==4, i.e. temporary type */
	  {
	     if(type->name!=NULL)
	       Free(type->name);
	     type->name=my_malloc(strlen(local_buf));
	     Strcpy(type->name,local_buf);
	  };
	for(str=instr;*str==' ';str++);
	refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	str=instr;
	if((*str==':')||(*(str+1)=='-'))
	  {
	    struct vardecl_listoflist loc_vll;
	    listnode validator=NULL;
	    for(str+=2;*str==' ';str++);
	    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	    loc_vll.next=vars;
	    loc_vll.vlist=insert_var_decl(NULL,type->name,type,NULL,0);
	    validator=mk_head_lnd(NULL,NULL,PARTOFOP);
	    str=instr+get_expression(instr,validator,ops,inl,opspec,0,types,&loc_vll);
	    
	    if(instr==str)
	    {
	      fprintf(stderr,"Can\'t get validator of type %s\n",type->name);
	      free(type);
	      rm_lnd_all(validator);
	      return NULL;
	    };
	    while(*str==' ') str++;
	    refresh_buffer(instr,str-instr,STR_BUF_SIZE);
	    type->validate=op_to_function(rm_cdr_next(validator));

	  };
     }
   else
     {
	printf("Whoops - problem in \"get_new_type_declaration()\" !!!\n");
	return NULL;
     };
   
   return type;
}


int get_type_from_code(
char * instr,
listnode labels,
struct type_listoflist * tlist,
struct vardecl_listoflist * vlist,
char * stopchars, 
/* characters on which to stop. If NULL function stops when first  non-type token is found. */
listnode inl,defined_op d_ops,
listnode opspec,
listnode inl_lab,
struct typerec ** res)
{
  struct vardecl_list * vars;
  int change=0;
  char * str;
  char tname[34],vname[34];
  enum typemodf tmodf;
  struct typerec * type=NULL;
  listnode modif_lst=NULL;
  
  do	/* loop to get modifiers */
    {
      str=get_variable_name(instr);
      memset(tname,0,34);
      
      tmodf=NONE;
      Strncpy(tname,instr,str-instr);

      if((!Strcmp(tname,"struct"))
	 ||(!Strcmp(tname,"union"))
	 ||(!Strcmp(tname,"typedef"))
	 ||(!Strcmp(tname,"class"))
	 ||(!Strcmp(tname,"modif")))
	{
	  type=get_new_type_declaration(instr,tlist,vlist,labels,d_ops,inl,opspec,inl_lab);
	  
	  if(type==NULL)
	    return 0;
	  str=instr;
	  while(*str==32) str++;
	  
	  if(stopchars!=NULL)
	    if(strchr(stopchars,*str)!=NULL) /* No variable after struct/union declaration */
	      {
		*res=type;
		return str-instr;
	      };
	}
      else
	if((type=get_type_by_name(tname,NONE,tlist))==NULL)
	  {
	    if(Strcmp(tname,"typeof")) /* NOT "typeof" */
	      {
		printf("## Type %s unknown\n",tname);
		return 0;
	      }
	    else  /* "typeof" */
	      {
		str=instr;
		str+=get_typeof_decl(instr,tlist,NULL,NULL,NULL,NULL,&type);
		if(str==instr)
		  return 0;
	      };
	  };
      
      if(type->typekind==ISMODIF)
	{
	  while(*str==32) str++;
	  modif_lst=mk_head_lnd(modif_lst,type,TYPEDEFN);
	  change+=str-instr;
	  instr=str;
	  if(*str=='<')
	    {
	      struct typerec * tmptype;
	      str++;
	      while(*str==' ') str++;
	      change+=str-instr;
	      instr=str;
	      modif_lst->attr=TWOLISTS;
	      modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
	      while((*str!='>')&(!!*str))
		{	
		  str+=get_type_from_code(instr,labels,tlist,vlist,",>",inl,d_ops,opspec,inl_lab,&tmptype);
		  if(str==instr)
		    {
		      fprintf(stderr,"get_type_from_code():can't get modifier args\n");
		      rm_lnd_all(modif_lst);
		      return 0;
		    };
		  mk_set_lnd((listnode)modif_lst->data,tmptype,TYPEDEFN);
		  while(*str==' ') str++;
		  if(*str==',') str++;
		  while(*str==' ') str++;
		  change+=str-instr;
		  instr=str;
		};
	      if(*str!='>') 
		{
		  fprintf(stderr,"get_type_from_code():error in modifier args\n");
		  rm_lnd_all(modif_lst);
		  return 0;
		};
	      str++;
	      while(*str==' ') str++;
	      
	      change+=str-instr;
	      instr=str;
	    };
	};
    }
  while(type->typekind==ISMODIF);
  
  type=apply_modifier(type,modif_lst,NULL,tlist);
  rm_lnd_all(modif_lst);
  modif_lst=NULL;
  
  if(!Strcmp(type->name,"type"))
    {
      printf("## Dynamic type declaration ...\n");
      memset(vname,0,sizeof(vname));
      global_tmp_type++;
      sprintf(vname,"\4tmptype%lx",global_tmp_type);
      
      if(vars==NULL)
	vlist->vlist=vars=insert_var_decl(NULL,(char *)vname,NULL,NULL,0);
      else
	vars=insert_var_decl(vars,(char *)vname,NULL,NULL,0);
      
      if(tlist->tlist==NULL)
	{
	  tlist->tlist=my_malloc(sizeof(struct type_list));
	  tlist->tlist->next=NULL;
	  tlist->tlist->convert_lock=OFF;
	  tlist->tlist->type=my_malloc(sizeof(struct typerec));
	  set_typerec(tlist->tlist->type,sizeof(long),Strdup(vname),VAR_TYPE,NONE,__void__,NULL);
	  type=tlist->tlist->type;
	}
      else
	type=install_type(tlist->tlist,sizeof(long),Strdup(vname),VAR_TYPE,NONE,__void__,NULL)->type;
      
      type->typebody.var_type.var=vars->var;
      vars->var->attr=TYPE_VAR;
      vars=vlist->vlist;
    };
  
  while(*str==32) str++;
  change=str-instr;
  instr=str;
  
  while((stopchars!=NULL)?(strchr(stopchars,*str)==NULL):1)
    {
      if ((*str=='*')||(*str=='&'))
	{
	  switch(*str)
	    {
	    case '*': tmodf=POINTER;break;
	    case '&': tmodf=REFERENCE;break;
	    };
	  str++;
	  type=mk_ref_type_from_type(type,tmodf,tlist,0); /* create or find reference type */
	  tmodf=NONE;
	  change+=str-instr;
	  instr=str;
	}
      else /* Not any kind of '*' type modifier */
	{
	  struct typerec * tmptype;

	  str=get_variable_name(instr);
	  tmodf=NONE;
	  memset(tname,0,34);
	  Strncpy(tname,instr,str-instr);
	  
	  if((tmptype=get_type_by_name(tname,NONE,tlist))==NULL)
	    if((tmptype=get_type_by_name(tname,FUNC,tlist))==NULL)
	      {
		if(stopchars==NULL)
		  break;
		else
		  {
		    fprintf(stderr,"Type %s unknown\n",tname);
		    return 0;
		  };
	      };
	  
	  if(tmptype->typekind==ISMODIF)
	    {
	      modif_lst=mk_head_lnd(modif_lst,tmptype,TYPEDEFN);
	      
	      while(*str==32) str++;
	      if(*str=='<')
		{
		  struct typerec * ttype;
		  str++;
		  while(*str==' ') str++;
		  modif_lst->attr=TWOLISTS;
		  modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
		  change+=str-instr;
		  instr=str;
		  while((*str!='>')&(!!*str))
		    {	
		      str+=get_type_from_code(instr,labels,tlist,vlist,",>",inl,d_ops,opspec,inl_lab,&ttype);
		      if(str==instr)
			{
			  fprintf(stderr,"get_type_from_code():can't get modifier args\n");
			  rm_lnd_all(modif_lst);
			  return 0;
			};
		      mk_set_lnd((listnode)modif_lst->data,ttype,TYPEDEFN);
		      while(*str==' ') str++;
		      if(*str==',') str++;
		      while(*str==' ') str++;
		      change+=str-instr;
		      instr=str;
		    };
		  if(*str!='>') 
		    {
		      fprintf(stderr,"get_type_from_code():error in modifier args\n");
		      rm_lnd_all(modif_lst);
		      return 0;
		    };
		  str++;
		  while(*str==' ') str++;
		  change+=str-instr;
		  instr=str;
		};
	    }
	  else
	    {
	      tmptype=apply_modifier(tmptype,modif_lst,NULL,tlist);
	      rm_lnd_all(modif_lst);
	      modif_lst=NULL;
	      
	      if((type=mk_subtype_by_type(type,tmptype,tlist,0))==NULL)
		{
		  fprintf(stderr,"get_type_from_code():cant's create new type %s !\n",tname);
		  return 0;
		};
	    };
	};
      
      change+=str-instr;
      instr=str;
      
    };
  
  *res=type;
  
  return change;
}

int get_subtype_from_code(
char * instr,
struct typerec * basetype,
listnode labels,
struct type_listoflist * tlist,
struct vardecl_listoflist * vlist,
listnode inl,defined_op d_ops,
listnode opspec,
listnode inl_lab,
char * * res_name,
struct typerec * * res_type)
{
int change=0;
char * str;
char tname[34];
enum typemodf tmodf=NONE;
struct typerec * type=basetype;
listnode modif_lst=NULL;

while(*str==32) str++;
if(*str!='(')
	return 0;
str++;
while(*str==32) str++;
change=instr-str;
instr=str;
str=get_variable(instr);
while(*str==32) str++;

while((!!*str)&(*str!=')'))
	{
	if ((*str=='*')||(*str=='&'))
		{
		switch(*str)
			{
			case '*': tmodf=POINTER;break;
			case '&': tmodf=REFERENCE;break;
			};
		str++;
		type=mk_ref_type_from_type(type,tmodf,tlist,0); /* create or find reference type */
		tmodf=NONE;
		change+=str-instr;
		instr=str;
		}
	else /* Not any kind of '*' type modifier */
		{
		struct typerec * tmptype;

		tmodf=NONE;
		memset(tname,0,34);
		Strncpy(tname,instr,str-instr);

		if((tmptype=get_type_by_name(tname,NONE,tlist))==NULL)
			if((tmptype=get_type_by_name(tname,FUNC,tlist))==NULL)
				{
				fprintf(stderr,"Type %s unknown\n",tname);
				return 0;
				};

		if(tmptype->typekind==ISMODIF)
			{
			modif_lst=mk_head_lnd(modif_lst,tmptype,TYPEDEFN);

			while(*str==32) str++;
			if(*str=='<')
				{
				struct typerec * ttype;
				str++;
				while(*str==' ') str++;
				modif_lst->attr=TWOLISTS;
				modif_lst->data=(char *)mk_head_lnd(NULL,modif_lst->data,TYPEDEFN);
				change+=str-instr;
				instr=str;
				while((*str!='>')&(!!*str))
					{	
					str+=get_type_from_code(instr,labels,tlist,vlist,",>",inl,d_ops,opspec,inl_lab,&ttype);
					if(str==instr)
						{
						fprintf(stderr,"get_type_from_code():can't get modifier args\n");
						rm_lnd_all(modif_lst);
						return 0;
						};
					mk_set_lnd((listnode)modif_lst->data,ttype,TYPEDEFN);
					while(*str==' ') str++;
					if(*str==',') str++;
					while(*str==' ') str++;
					change+=str-instr;
					instr=str;
					};
				if(*str!='>') 
					{
					fprintf(stderr,"get_type_from_code():error in modifier args\n");
					rm_lnd_all(modif_lst);
					return 0;
					};
				str++;
				while(*str==' ') str++;
				change+=str-instr;
				instr=str;
				};
			}
		else
			{
			tmptype=apply_modifier(tmptype,modif_lst,NULL,tlist);
			rm_lnd_all(modif_lst);
			modif_lst=NULL;

			if((type=mk_subtype_by_type(type,tmptype,tlist,0))==NULL)
				{
				fprintf(stderr,"get_subtype_from_code():cant's create new type %s !\n",tname);
				return 0;
				};
			};
		};

	change+=str-instr;
	instr=str;

	};

if(*str!=')')
	return 0;

str++;
change+=str-instr;
str--;
while(*str==32)str--;
str++;
memset(tname,0,34);
Strncpy(tname,instr,str-instr);
*res_name=Strdup(tname);
*res_type=type;

return change;
}
