#include "include/glbtypes.h"
#include "include/glbproto.h"
#include "include/globvars.h"



void apply_modif_fix_tref(
struct typerec * type,
struct typerec * xtype,
struct typerec * ntype,
struct type_listoflist * types)
     /* function recurses thru class/func types and replaces any refs to xtype into refs to ntype.
	Called from apply_modif_rec() */

{
  struct vardecl_list * vl_i=NULL;
  struct type_list * tl_i=NULL;
  enum typemodf save_tm;

  if(type==NULL)
    return;

  if(type->typemodf==APLFIXLK)
    return;

  if(type->typekind==TYPEREFR)
    {
      if(type->typebody.pointer_to==xtype)
	type->typebody.pointer_to=ntype;
      else
	apply_modif_fix_tref(type->typebody.pointer_to,xtype,ntype,types);

      return;
    }
  if((type->typekind!=CLASS)
     &&(type->typekind!=UNION)
     &&(type->typekind!=FUN_DEFN)
     &&(type->typekind!=FUNPROTO))
    return;
  
  save_tm=type->typemodf;
  type->typemodf=APLFIXLK;

  if((type->typekind==CLASS)
     ||(type->typekind==UNION))
    {
      /* go thru var list of class. If found xtype replace it with ntype */
      for(vl_i=type->typebody.class_def->vars;vl_i!=NULL;vl_i=vl_i->next)
	if(vl_i->var!=NULL)
	  {
	    if(vl_i->var->type==xtype)
	      vl_i->var->type=ntype;
	    else
	      apply_modif_fix_tref(vl_i->var->type,xtype,ntype,types);
	  }

      /* Go thru types of our class */
      for(tl_i=type->typebody.class_def->types;tl_i!=NULL;tl_i=tl_i->next)
	  if(tl_i->type!=xtype)
	      tl_i->type=ntype;
	    else
	      apply_modif_fix_tref(tl_i->type,xtype,ntype,types);

      /* Same for top classess list */
      for(tl_i=type->typebody.class_def->top_class;tl_i!=NULL;tl_i=tl_i->next)
	  if(tl_i->type!=xtype)
	      tl_i->type=ntype;
	    else
	      apply_modif_fix_tref(tl_i->type,xtype,ntype,types);
    }
  else
    {

      /* go thru args of fn def. If found xtype replace it with ntype */
      for(vl_i=type->typebody.fundef->args;vl_i!=NULL;vl_i=vl_i->next)
	if(vl_i->var!=NULL)
	  {
	    if(vl_i->var->type==xtype)
	      vl_i->var->type=ntype;
	    else
	      apply_modif_fix_tref(vl_i->var->type,xtype,ntype,types);
	  }

      /* Fix res type ... */
      if(type->typebody.fundef->res_type==xtype)
	type->typebody.fundef->res_type=ntype;
      else
	apply_modif_fix_tref(type->typebody.fundef->res_type,xtype,ntype,types);

      /* ... and action class */
      if(type->typebody.fundef->actionclass==xtype)
	type->typebody.fundef->actionclass=ntype;
      else
	apply_modif_fix_tref(type->typebody.fundef->actionclass,xtype,ntype,types);
    };

  type->typemodf=save_tm;
  return;
}



struct typerec * apply_modif_rec(
struct typerec * type,
struct type_list * args,
listnode modlst,
struct type_listoflist * types)
     /* function recurses thru class/func types and seeks anyting based on modif args types.
	If it finds anything it clones it's current argument and replaces modif args to their
	substitutes */

{
  int applied=0;  /* applied flag */ 
  struct typerec * res=type, * tmptype=NULL;
  struct vardecl_list * vl_i=NULL,* keep_vl=NULL;
  struct type_list * tl_i=NULL,* keep_tl=NULL;
  enum typemodf save_tm;
  listnode modl_i=NULL;

  if(type==NULL)
    return NULL;

  if(type->typemodf==APLMODLK)
    return type;

  for(tl_i=args,modl_i=modlst;(tl_i!=NULL)&&(modl_i!=NULL);tl_i=tl_i->next,modl_i=modl_i->next)
    if(modl_i->attr!=TYPEDEFN)
      fprintf(stderr,"apply_modif_rec():modl_i->attr=%d != TYPEDEFN\n",modl_i->attr);
    else if(type->typeid==tl_i->type->typeid)
      return (struct typerec *)modl_i->data;

  if((modl_i==NULL)!=(tl_i==NULL))
    fprintf(stderr,"apply_modif_rec(): modl_i=0x%lx tl_i=0x%lx\n",(long unsigned)modl_i,(long unsigned)tl_i);
      
  if(type->typekind==TYPEREFR)
    {
      tmptype=apply_modif_rec(type->typebody.pointer_to,args,modlst,types);

      if(tmptype==type->typebody.pointer_to)
	return type;

      res=my_malloc(sizeof(struct typerec));
      *res=*type;
      
      res->typeid=++global_type_id_count;
      res->name=strdup(type->name);
      res->typebody.pointer_to=tmptype;
      
      return res;
    }
  if((type->typekind!=CLASS)
     &&(type->typekind!=UNION)
     &&(type->typekind!=FUN_DEFN)
     &&(type->typekind!=FUNPROTO))
    return type;
  
  save_tm=type->typemodf;
  type->typemodf=APLMODLK;

  if((type->typekind==CLASS)
     ||(type->typekind==UNION))
    {
      /* make a copy of var list and go thru it to the end. If found modif arg type replace it
	 and set applied=1 */
      for(keep_vl=vl_i=copy_vardecl_list(type->typebody.class_def->vars);vl_i!=NULL;vl_i=vl_i->next)
	if(vl_i->var!=NULL)
	  if(vl_i->var->type!=NULL)
	    if((tmptype=apply_modif_rec(vl_i->var->type,args,modlst,types))!=vl_i->var->type)
	      {
		vl_i->var->type=tmptype;
		applied=1;
	      };

      /* If applied == 0 check if modif arg types are our top classes */
      for(tl_i=args;(!applied)&&(tl_i!=NULL);tl_i=tl_i->next)
	if(tl_i->type!=NULL)
	  if(check_top_class(type,tl_i->type->typeid))
	    applied=1;

      /* If applied == 0 check if modif arg types are top classes of our type list */
      for(tl_i=args;(!applied)&&(tl_i!=NULL);tl_i=tl_i->next)
	for(keep_tl=type->typebody.class_def->types;(!applied)&&(keep_tl!=NULL);keep_tl=keep_tl->next)
	  if(tl_i->type!=NULL)
	    if(check_top_class(keep_tl->type,tl_i->type->typeid))
	      applied=1;
      
      /* if applied still == 0 type is independent from all modif args. Delete
	 copied var decl list and return original type */
      if(!applied)
	{
	  destroy_vardecl_list(keep_vl);
	  type->typemodf=save_tm;
	  return type;
	}
      else
	/* if this type depends on modif args ... */
	{
	  /* create new type */
	  res=my_malloc(sizeof(struct typerec));
	  *res=*type;
	  res->typeid=++global_type_id_count;
	  res->name=strdup(type->name);

	  res->typebody.class_def=my_malloc(sizeof(struct class_def));
	  *(res->typebody.class_def)=*(type->typebody.class_def);

	  res->typebody.class_def->vars=keep_vl;

	  /* dummy node */
	  res->typebody.class_def->types=my_malloc(sizeof(struct type_list));
	  
	  /* Copy internal types list */

	  for(keep_tl=type->typebody.class_def->types,tl_i=res->typebody.class_def->types;keep_tl!=NULL;keep_tl=keep_tl->next,tl_i=tl_i->next)
	    {
	      tl_i->next=my_malloc(sizeof(struct type_list));
	      tl_i->next->convert_lock=OFF;
	      tl_i->next->type=apply_modif_rec(keep_tl->type,args,modlst,types);
	    };

	  /* Copy top classess list in the same way. Be cheap and dirty, use the same
	     dummy node */

	  res->typebody.class_def->top_class=res->typebody.class_def->types;
	  res->typebody.class_def->types=res->typebody.class_def->top_class->next;
	  res->typebody.class_def->top_class->next=NULL;
	  
	  for(keep_tl=type->typebody.class_def->top_class,tl_i=res->typebody.class_def->top_class;keep_tl!=NULL;keep_tl=keep_tl->next,tl_i=tl_i->next)
	    {
	      tl_i->next=my_malloc(sizeof(struct type_list));
	      tl_i->next->convert_lock=OFF;
	      tl_i->next->type=apply_modif_rec(keep_tl->type,args,modlst,types);
	    };
	  
	  /* now free the dumy node */
	  tl_i=res->typebody.class_def->top_class->next;
	  free(res->typebody.class_def->top_class);
	  res->typebody.class_def->top_class=tl_i;	  	  
	};
    }
  else
    {
      /* make a copy of var list and go thru it to the end. If found modif arg type replace it
	 and set applied=1 */

      for(keep_vl=vl_i=copy_vardecl_list(type->typebody.fundef->args);vl_i!=NULL;vl_i=vl_i->next)
	if(vl_i->var!=NULL)
	  if(vl_i->var->type!=NULL)
	    if((tmptype=apply_modif_rec(vl_i->var->type,args,modlst,types))!=vl_i->var->type)
	      {
		vl_i->var->type=tmptype;
		applied=1;
	      };

      /* If applied == 0 check if modif arg types are our top classes */
      for(tl_i=args;(!applied)&&(tl_i!=NULL);tl_i=tl_i->next)
	if(tl_i->type!=NULL)
	  {
	    if(check_top_class(type->typebody.fundef->res_type,tl_i->type->typeid))
	      applied=1;
	    if(check_top_class(type->typebody.fundef->actionclass,tl_i->type->typeid))
	      applied=1;
	  }
      /* if applied still == 0 type is independent from all modif args. Delete
	 copied var decl list and return original type */
      if(!applied)
	{
	  destroy_vardecl_list(keep_vl);
	  type->typemodf=save_tm;
	  return type;
	}
      else
	/* if this type depends on modif args ... */
	{
	  /* create new type */
	  res=my_malloc(sizeof(struct typerec));
	  *res=*type;
	  res->typeid=++global_type_id_count;
	  res->name=strdup(type->name);

	  res->typebody.fundef=my_malloc(sizeof(struct fundef));
	  *(res->typebody.fundef)=*(type->typebody.fundef);

	  res->typebody.fundef->args=keep_vl;
	  res->typebody.fundef->res_type=apply_modif_rec(res->typebody.fundef->res_type,args,modlst,types);
	  res->typebody.fundef->actionclass=apply_modif_rec(res->typebody.fundef->actionclass,args,modlst,types);

	};
    };

  res->typemodf=type->typemodf=save_tm;
  /* fix references to itself inside type */
  apply_modif_fix_tref(type,type,res,types);
  return res;
}

struct typerec * apply_modifier(
struct typerec * type,
listnode modif,
listnode * std_constr,
struct type_listoflist * types)
{
  struct type_list * argptr=NULL,* tl=NULL;
  listnode modptr=NULL;
  if(modif==NULL)
    return type;
  if(type==NULL)
    return NULL;

  if((modif->next==NULL)
     &&(modif->attr==TWOLISTS))
    modif=(listnode)modif->data;

  if(modif->attr==TYPEDEFN)
    if(type==(struct typerec *)modif->data)
      modif=modif->next;

  printf(" -- Entered apply_modifier() ---\n");
  printf("\"type\" : name=\"%s\" typeid=%ld\n",type->name,type->typeid); 
  printlist2(modif,0,0);

  if(type->typekind!=ISMODIF)
    return type;
  if(type->typebody.modif_def.type==NULL)
    {
      fprintf(stderr,"apply_modifier(): broken modif def !!!\n");
      return NULL;
    };
  
  for(argptr=type->typebody.modif_def.mod_args,modptr=modif;(argptr!=NULL)&&(modptr!=NULL);argptr=argptr->next,modptr=modptr->next)
    if(argptr->type==NULL)
      fprintf(stderr,"apply_modifier(): in modif arg list argptr->type == NULL\n");
    else if(argptr->type->typekind!=MODIFARG)
      fprintf(stderr,"apply_modifier(): in modif arg type \"%s\" id %ld typekind=%d != MODIFARG\n",argptr->type->name,argptr->type->typeid,argptr->type->typekind);
    else if(modptr->attr!=TYPEDEFN)
      fprintf(stderr,"apply_modifier(): in \"modif\" list attr=%d != TYPEDEFN\n",modptr->attr);
    else if(modptr->data==NULL)
      fprintf(stderr,"apply_modifier(): in \"modif\" list \"data\" = NULL\n");
    else if(argptr->type->typebody.class_list!=NULL)
      {
	for(tl=argptr->type->typebody.class_list;tl!=NULL;tl=tl->next)
	  if(tl->type==NULL)
	    fprintf(stderr,"apply_modifier(): in top class of arg type \"%s\" id %ld \"type\"==NULL\n",argptr->type->name,argptr->type->typeid);
	  else if(!check_top_class((struct typerec *)modptr->data,tl->type->typeid))
	    fprintf(stderr,"Base type \"%s\" id %ld of modif arg \"%s\" id %ld doesn't match actual arg \"%s\" id %ld\n",
		    tl->type->name,tl->type->typeid,
		    argptr->type->name,argptr->type->typeid,
		    ((struct typerec *)modptr->data)->name,
		    ((struct typerec *)modptr->data)->typeid);
	    
      }

  return apply_modif_rec(type->typebody.modif_def.type,type->typebody.modif_def.mod_args,modif,types);

}

int check_top_class(
struct typerec * type,
unsigned long top_cl_id)
/* checks wether type with id top_cl_id is a top class of "type" */
{
struct type_list * tl;

   if(type==NULL)
     return 0;
   if(type->typeid==top_cl_id)
     return 1;
   while((type->typekind==TYPEREFR)&(type->typemodf==NONE))
     type=type->typebody.pointer_to;
   if(type->typeid==top_cl_id)
     return 1;
   if((type->typekind!=CLASS)&(type->typekind!=ISMODIF)&(type->typekind!=MODIFARG))
     return 0;
   
   tl=(type->typekind==MODIFARG)?type->typebody.class_list:type->typebody.class_def->top_class;
   while(tl!=NULL)
     {
	if(tl->type!=NULL)
	  if(tl->type->typeid==top_cl_id)
	    return 1;
	if(check_top_class(tl->type,top_cl_id))
	  return 1;
	else
	  tl=tl->next;
     }
   return 0;
}


struct typerec * get_type_by_id_local(long type_id, struct type_list * tll)
{
  while(tll!=NULL)
    {
      if(tll->type!=NULL)
	if(tll->type->typeid==type_id)
	  return tll->type;
      tll=tll->next;
    };
  return NULL;
}

struct typerec * get_type_by_id(long type_id, struct type_listoflist * tll)
{
struct typerec * res;

while(tll!=NULL)
	{
	  if((res=get_type_by_id_local(type_id,tll->tlist))!=NULL)
	    return res;
	  tll=tll->next;
	};
return NULL;
}



struct typerec * get_type_by_name_local(char * name,enum typemodf tm, struct type_list * tll)
{
  while(tll!=NULL)
    {
      if(tll->type!=NULL)
	if(tll->type->typemodf==tm)
	  {
	    if(name==NULL)
	      return tll->type;
	    if(tll->type->name!=NULL)
	      if(!Strcmp(name,tll->type->name))
		return tll->type;
	  }
      tll=tll->next;
    };
  return NULL;
}

struct typerec * get_type_by_name(char * name,enum typemodf tm, struct type_listoflist * tll)
{
struct typerec * res;

while(tll!=NULL)
	{
	  if((res=get_type_by_name_local(name,tm,tll->tlist))!=NULL)
	    return res;
	  tll=tll->next;
	};
return NULL;
}


struct typerec * get_type_by_name_skip(long skip_id,char * name,enum typemodf tm, struct type_listoflist * tll)
{
struct type_list * tl;

   while(tll!=NULL)
     {
	tl=tll->tlist;
	while(tl!=NULL)
	  {        /* if "name" == NULL then look only on modifier-used to find modifiers types */
	     if(tl->type!=NULL)
	       if(((name==NULL)?1:!Strcmp(name,tl->type->name))&(tl->type->typemodf==tm))
	       {
		  if(!skip_id)
		    break;
		  else
		    if(tl->type->typeid==skip_id)
		      skip_id=0;
	       };
	     tl=tl->next;
	  };
	if(tl!=NULL)
	  break;
	tll=tll->next;
     };
   
   if (tl==NULL)
     return NULL;
   return tl->type;
}



void * set_typerec(
struct typerec * tr,
int size,
char * name,
enum typekind typekind,
enum typemodf typemodf,
enum tb_built_in builtintb,
struct fundef_list * typeconv)
{
tr->size=size;
tr->name=name;
tr->typekind=typekind;
tr->typemodf=typemodf;
tr->typebody.built_in=builtintb;
tr->typeconv=typeconv;
return tr;
}

struct type_list * install_type(
struct type_list * tl,
int size,
char * name,
enum typekind typekind,
enum typemodf typemodf,
enum tb_built_in typebody,
struct fundef_list * typeconv)
{
while(tl->next!=NULL)
	{
	if(tl->next->type!=NULL)
		if((!Strcmp(name,tl->next->type->name))&(tl->next->type->typemodf==typemodf))
			{
			   if(typekind!=ISMODIF) 
			     /* there can be more than one modif with same name */
			     { 
				printf("Type %s already exist !!! Replacing ...\n",name);
				break;
			     };
			};
	tl=tl->next;
	};
if(tl->next==NULL)
	{
	tl->next=my_malloc(sizeof(struct type_list));
	tl->next->next=NULL;
	tl->next->type=my_malloc(sizeof(struct typerec));
	};

set_typerec(tl->next->type,size,name,typekind,typemodf,typebody,typeconv);
global_type_id_count++;
tl->next->type->typeid=global_type_id_count;
tl->next->convert_lock=OFF;
return tl->next;
}

struct type_listoflist * get_typedef_layer(struct typerec * tr,struct type_listoflist * tll)
{
  struct type_list * tl=NULL;
  
  if(tr==NULL)
    return NULL;

  while((tll!=NULL)&&(tl!=NULL))
    {
      tl=tll->tlist;
      while(tl!=NULL)
	{
	  if(tl->type!=NULL)
	    if(tl->type->typeid==tr->typeid)
	      return tll;
	  tl=tl->next;
	};
      tll=tll->next;
    }
  return NULL;
}

struct vardecl_listoflist * get_vardecl_layer(struct var_decl * vd,struct vardecl_listoflist * vll)
{
  struct vardecl_list * vl=NULL;
  
  if(vd==NULL)
    return NULL;

  while(vll!=NULL)
    {
      vl=vll->vlist;
      while(vl!=NULL)
	{
	  if(vl->var!=NULL)
	    if(vl->var==vd)
	      return vll;
	  vl=vl->next;
	};
      vll=vll->next;
    }
  return NULL;
}



