#include "include/glbtypes.h"
#include "include/glbproto.h"
#include "include/globvars.h"

cmp_str str_cmp(char * s1,char * s2)
{
  while(!!*s1&!!*s2&(*s1==*s2)&(*s1!=32)) 
    {
      s1++;
      s2++;
    };
  if (*s1==*s2) 
    return eq;
  if (!*s1) 
    return rlong;
  if (!*s2) 
    return llong;
  if (*s1>*s2) 
    return left;
  return right;
}

char * next_token1(char * str)
{
  int level=0;
  while(*str==32) 
    str++;
  while(!(((!*str)||(*str==32))&!level))
    {
      if (*str=='(') 
	level++;
      if (*str==')') 
	level--;
      str++;
    }
  /* while(*str==32) str++; */
  return str;
}

char * next_token(char * str)
{
  while(*str==32)
    str++;
  while(!((!*str)||(*str==32)))	
    str++;
  /* while(*str==32) str++; */
  return str;
}

/*********************  Gets variable  ***********************************/

char * get_variable(char * str)
{
  while(*str==32) 
    str++;
  while(isidch(*str)) 
    str++;
  return str;
}


/********************* End get_variable **********************************/

char * get_variable_name(char * str)
{
  while(*str==32) 
    str++;

  if (!isalpha(*str)&(*str!='_')&(*str!=4))
    return str; /* not an identifier */
  else
    str++;

  while(isidch(*str)) 
    str++;
  return str;
}

int insert_spaces(char * src,char *dst)
     /* Separates special chars by spaces */
{
  while (*src)	
    {
      if (isalnum(*src)!=isalnum(*(src-1)))
	{	
	  *dst=32;
	  dst++;
	};
      *dst++=*src++;
    }
  *dst=0;  
  return 0;
}

/****************************************************************/
/*
char * get_var_cp(char * str,listnode l)
{
  int ll=0;
  while(*str==32) str++;
  while(isalnum(*str))
    {
      *((l->data)+ll)=*str;
      ll++;
      str++;
    };
  while(*str==32) str++;
  return str;
}
*/
/**** Gets string BEGINING with Nth token. String DOESN'T ENDS AFTER TOKEN *****/

char * get_nth_token(int n,char * str)
{
  int i;
  while(*str==32) 
    str++;
  for(i=1;i<n;i++)
    {
      while(!(!*str)&(*str!=' ')) 
	str++;
      while(*str==32) 
	str++;
    };
  return str;
}

/*************************** End get_nth_token ************************************/

int refresh_buffer(char * buffer,int howmuch,int bufsize)
{
  if ((!howmuch)||(!bufsize)) 
    return 0;
  if(global_buffers_lst!=NULL)
    {
      if(global_buffers_lst->data!=current_global_buffer)
	{
	  int i;
	  i=strlen(global_buffers_lst->data);
	  if(i>=howmuch)
	    {
	      memcpy(buffer,buffer+howmuch,bufsize-howmuch);
	      memcpy(buffer+bufsize-howmuch,global_buffers_lst->data,howmuch);
	      if(i==howmuch)
		global_buffers_lst=rm_cdr_next(global_buffers_lst);
	      else
		memcpy(global_buffers_lst->data,global_buffers_lst->data+howmuch,i-howmuch);
	    }
	  else
	    {
	      memcpy(buffer,buffer+i,bufsize-i);
	      memcpy(buffer+bufsize-i,global_buffers_lst->data,i);
	      global_buffers_lst=rm_cdr_next(global_buffers_lst);
	      /* recursively shift buffers */
	      refresh_buffer(buffer,howmuch-i,bufsize);
	    };
	}
      else   /* if global_buffers_lst->data==current_global_buffer ...*/
	{
	  memcpy(buffer,buffer+howmuch,bufsize-howmuch);
	  /*
	    memcpy(buffer+bufsize-howmuch,global_buffers_lst->data,howmuch);
	    memcpy(global_buffers_lst->data,global_buffers_lst->data+howmuch,bufsize-howmuch);
	  */
	  memcpy(buffer+bufsize-howmuch,global_bufptr,howmuch);
	  global_bufptr+=howmuch;
	};
    }
  else
    {
      memcpy(buffer,buffer+howmuch,bufsize-howmuch);
      memcpy(buffer+bufsize-howmuch,global_bufptr,howmuch);
      global_bufptr+=howmuch;
    };
  return howmuch;
}

int normalize_buffer(char * bufptr,int bufsize)
{
  int howmuch;
  if((global_buffers_lst==NULL)||(current_global_buffer==NULL))
    return 0;
  
  howmuch=bufsize-(bufptr-current_global_buffer);
  
  if(global_buffers_lst->data!=current_global_buffer)
    {
      int i;
      i=strlen(global_buffers_lst->data);
      if(i>=howmuch)
	{
	  memcpy(bufptr,global_buffers_lst->data,howmuch);
	  if(i==howmuch)
	    global_buffers_lst=rm_cdr_next(global_buffers_lst);
	  else
	    memcpy(global_buffers_lst->data,global_buffers_lst->data+howmuch,i-howmuch);
	}
      else
	{
	  memcpy(bufptr,global_buffers_lst->data,i);
	  global_buffers_lst=rm_cdr_next(global_buffers_lst);
	  /* recursively shift buffers */
	  normalize_buffer(bufptr+i,bufsize);
	};
    }
  else 
    {
      memcpy(bufptr,global_bufptr,howmuch);
      global_bufptr+=howmuch;
    };
  return howmuch;
}

int put_back_in_buffer(char * str,int bufsize)
{
  int i=0,j=0;

  if(!bufsize)
    return 0;
  if(str==NULL)
    return 0;
  if(!(j=strlen(str)))
    return 0;

  if((i=bufsize-strlen(global_buffers_lst->data))>0)
    /* if there is some space at the beginning of the buffer */
    {
      i=(i<j?i:j);
      /* i is amount to be copied, which is either string length, or, if string
	 is bigger than amout of space avail. in the buffer, that amount of space */
      memmove(global_buffers_lst->data+i,global_buffers_lst->data,strlen(global_buffers_lst->data));
      memcpy(global_buffers_lst->data,str,i);
      /* use all that space up to the beginning */
      /* set pointer at beginning, indicating full buffer */
      j-=i;
      /* j is the remaining string */
    };
  if(j)
    /* if string is not yet empty */
    {
      char * newbuf=NULL;
      if((newbuf=my_malloc(bufsize))==NULL)
	return 0;
      global_buffers_lst=mk_head_lnd(global_buffers_lst,newbuf,PARTOFOP);
      /* make new empty buffer */
      return put_back_in_buffer(str+j,bufsize);
      /* recursively put the rest of the string */
    }
  return 1;
}

char * create_new_buffer(char * bufptr,int bufsize)
{
  char * newbuf;
  if (!bufsize) 
    return NULL;
  if((newbuf=my_malloc(bufsize))==NULL)
    return NULL;
  if(bufptr!=NULL)
    {
      memcpy(newbuf,bufptr,bufsize-(bufptr-current_global_buffer));
      memcpy(newbuf+bufsize-(bufptr-current_global_buffer),global_bufptr,bufptr-current_global_buffer);
      global_bufptr+=bufptr-current_global_buffer;
    }
  else
    {
      memcpy(newbuf,global_bufptr,bufsize);
      global_bufptr+=bufsize;
    };
  global_buffers_lst=mk_head_lnd(global_buffers_lst,newbuf,PARTOFOP);
  return current_global_buffer=newbuf;
}
