Attribute VB_Name = "modLayeredWindow"
Option Explicit

Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" _
    (ByVal hWnd As Long, ByVal nIndex As Long) As Long
Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" _
    (ByVal hWnd As Long, ByVal nIndex As Long, _
    ByVal dwNewLong As Long) As Long
Public Const GWL_STYLE = (-16)
Public Const GWL_EXSTYLE = (-20)
'Requires Windows 2000 or later:
Public Const WS_EX_LAYERED = &H80000

Public Type POINTAPI
    x As Long
    y As Long
End Type
Public Type SIZE
    cx As Long
    cy As Long
End Type

Public Type BLENDFUNCTION
    BlendOp As Byte
    BlendFlags As Byte
    SourceConstantAlpha As Byte
    AlphaFormat As Byte
End Type
'//
'// currentlly defined blend function
'//

Public Const AC_SRC_OVER = &H0

'//
'// alpha format flags
'//
Public Const AC_SRC_ALPHA = &H1
Public Const AC_SRC_NO_PREMULT_ALPHA = &H1
Public Const AC_SRC_NO_ALPHA = &H2
Public Const AC_DST_NO_PREMULT_ALPHA = &H10
Public Const AC_DST_NO_ALPHA = &H20

Declare Function SetLayeredWindowAttributes Lib "user32" _
    (ByVal hWnd As Long, ByVal crKey As Long, _
    ByVal bAlpha As Byte, ByVal dwFlags As Long) As Long
Public Const LWA_COLORKEY = &H1
Public Const LWA_ALPHA = &H2

Declare Function UpdateLayeredWindow Lib "user32" _
    (ByVal hWnd As Long, ByVal hdcDst As Long, pptDst As Any, _
    psize As Any, ByVal hdcSrc As Long, _
    pptSrc As Any, crKey As Long, _
    ByVal pblend As Long, ByVal dwFlags As Long) As Long
Public Const ULW_COLORKEY = &H1
Public Const ULW_ALPHA = &H2
Public Const ULW_OPAQUE = &H4


Public Function IsLayeredWindow(ByVal hWnd As Long) As Boolean
    Dim l As Long

    l = GetWindowLong(hWnd, GWL_EXSTYLE)
    If (l And WS_EX_LAYERED) = WS_EX_LAYERED Then
        IsLayeredWindow = True
    Else
        IsLayeredWindow = False
    End If
End Function

Public Sub SetLayeredWindow(ByVal hWnd As Long, _
ByVal bIsLayered As Boolean)
    Dim l As Long

    l = GetWindowLong(hWnd, GWL_EXSTYLE)

    If bIsLayered = True Then
        l = l Or WS_EX_LAYERED
    Else
        l = l And Not WS_EX_LAYERED
    End If
    SetWindowLong hWnd, GWL_EXSTYLE, l
End Sub


