/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
AUTOR           : Juan C. Martnez
PROGRAMA        : BOTXTPOP.PRG
DESCRIPCION     : Clase para manejar botones creados con la clase TBotonTxt
                  como si se tratara de un men pop-up
FECHA           : 20 / 11 / 96
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

//FICHEROS DE CABECERA
#include 'Common.ch'
#include '1stClass.ch'
#include 'InKey.ch'
#include 'llibg.ch'

#define  K_FIN_ASCII        255  // ltimo cdigo de tecla ASCII

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
CLASS TBTxtPopUp

    VAR aoBtnHandler    
    VAR lNeedAdjust     
    VAR nCoordX 
    VAR nCoordY 
    VAR nElement    

    MESSAGE AddButton   METHOD AddButton
    MESSAGE AddItem     METHOD AddItem
    MESSAGE Adjust      METHOD Adjust
    MESSAGE Display     METHOD Display
    MESSAGE Down        METHOD Down
    MESSAGE Exec        METHOD Exec
    MESSAGE Init        METHOD Init
    MESSAGE Up          METHOD Up



ENDCLASS

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Init( nCorX, nCorY )

::aoBtnHandler  := {}
::lNeedAdjust   := TRUE
::nCoordX       := Col2Pxl (nCorX )
::nCoordY       := Row2Pxl( nCorY )
::nElement          := 1

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD AddButton( oBoton ) CLASS TBTxtPopUp

AAdd( ::aoBtnHandler, oBoton )
RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD AddItem( cTexto, bAccion ) CLASS TBTextPopUp

local nCoordX   := X2Col( ::nCoordX )
local nCoordY   := Y2Row( ::nCoordY )
local oBoton    := TBotonTxt():New( nCoordX, nCoordY )

oBoton:AddText( cTexto )
oBoton:bAccion  := bAccion

::AddButton( oBoton )
::nCoordY := oBoton:nCoordInf + 1

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Adjust() CLASS TBTxtPopUp

local nInd
local nMaxLength := 0

for nInd := 1 to Len( ::aoBtnHandler )
    nMaxLength := Max( nMaxLength, ::aoBtnHandler[ nInd ]:nCoordDer )

next

for nInd := 1 to Len( ::aoBtnHandler )
    ::aoBtnHandler[ nInd ]:nCoordDer := nMaxLength

next

lNeedAdjust := FALSE

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Display() CLASS TBTxtPopUp

local aoBtnHandler  := ::aoBtnHandler
local nCont
local nElement      := ::nElement

if ::lNeedAdjust
    ::Adjust()

endif

FOR nCont := 1 TO Len( aoBtnHandler )
    aoBtnHandler[ nCont ]:Display( FALSE )

NEXT

aoBtnHandler[ nElement]:Display( TRUE )

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Down()

::aoBtnHandler[ ::nElement ]:Display( FALSE )

::nElement ++

if ::nElement > Len( ::aoBtnHandler )
    ::nElement := 1
endif

::aoBtnHandler[ ::nElement ]:Display( TRUE )

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Exec()

local aItems
local cKey
local nInd
local nKey

::nElement  := 1

::aoBtnHandler[ ::nElement ]:Display( TRUE )

while TRUE


    nKey := InKey( 0 )

    do case
        case nKey == K_ESC
            exit

        case nKey == K_RETURN
            ::aoBtnHandler[ ::nElement ]:Exec()

        case nKey == K_UP
            ::Up()

        case nKey ==K_DOWN
            ::Down()

        case nKey == K_LEFT
            ::Up()

        case nKey == K_RIGHT
            ::Down()

        case ( nKey > K_SPACE .and. nKey < K_FIN_ASCII )
            cKey := Upper( Chr( nKey ) )

            for nInd := 1 to Len ( ::aoBtnHandler )
                if Upper (::aoBtnHandler[ nInd ]:cHotKey ) == cKey
                    ::aoBtnHandler[ ::nElement ]:Display( FALSE )
                    ::nElement := nInd
                    ::aoBtnHandler[ ::nElement ]:Display( TRUE )
                    ::aoBtnHandler[ ::nElement ]:Exec()

                endif

            next


    endcase

    Keyboard( Chr( 0 ) )

enddo

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Up()

::aoBtnHandler[ ::nElement ]:Display( FALSE )

::nElement --

if ::nElement < 1
    ::nElement :=  Len( ::aoBtnHandler )

endif

::aoBtnHandler[ ::nElement ]:Display( TRUE )

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

