/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
AUTOR           : Juan C. Martnez
PROGRAMA        : BOTCLA2.PRG
DESCRIPCION     : Ejemplo de pruebas de TBotonBmp y TToolBar
FECHA           : 09 / 12 / 96
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#include "llibg.ch"

FUNCTION Start()

LOCAL oToolBar

MHide()
CLS
SET CURSOR OFF

//Ponemos en modo grfico 640x480 16 colores
gMode( LLG_VIDEO_VGA_640_480_16)

// Creamos nuestra barra de botones y les agregamos las distintas opciones
oToolBar := TToolBar( ):New( 20, 5 )
oToolBar:AddItem( "BMPOKUP.BMP", "BMPOKDEF.BMP", "BMPOKDN.BMP", "O", { || Aviso( "Ok" ) } )
oToolBar:AddItem( "BMPCANUP.BMP", "BMPCANDF.BMP", "BMPCANDN.BMP", "C", { || Aviso( "cancelar" ) } )
oToolBar:AddItem( "BMPNOUP.BMP", "BMPNODEF.BMP", "BMPNODN.BMP", "N", { || Aviso( "no" ) } )
oToolBar:AddItem( "BMPREPUP.BMP", "BMPREPDF.BMP", "BMPREPDN.BMP","R", { || Aviso( "repetir" ) } )
oToolBar:AddItem( "BMPEXIUP.BMP", "BMPEXIDF.BMP", "BMPEXIDN.BMP", "E", { || __Quit() } )

while .t.
	WallPaper("STEPS.BMP")
	oToolBar:Display()
	oToolBar:Exec()

enddo

mShow()
Return

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
Function WallPaper( cFileName )

// Esta funcin carga cFileName .BMP y cubre la pantalla

// Obtenemos las coordenadas mximas en modo grfico
local  nNeedX  := gMode()[LLG_MODE_GRAPH_COL]
local  nNeedY  := gMode()[LLG_MODE_GRAPH_ROW]

//Creamos un puntero a memoria donde guardaremos la referencia al .BMP cargado
local  aBmp    := {}

local  nPaintX := 0
local  nPaintY := 0

//Cargamos el archivo cFileName
aBmp := gBmpLoad(cFileName)


if !Empty( aBmp )   //Si el BMP se carg correctamente

    while nPaintY <= nNeedY // Mientras no se complete el llenado vertical         

    while nPaintX <= nNeedX  // Mientras no se complete el llenado horizontal

          // Mostrar el BMP
          gBmpDisp(aBmp,nPaintX,nPaintY)

          //Correr la coordenada X el largo del BMP
          nPaintX += aBmp[LLG_BMP_X]

       enddo

       //Reajustar la coordenada X
       nPaintX := 0

       //Mover la coordenada Y la altura del BMP
       nPaintY += aBmp[LLG_BMP_Y]

    enddo

endif


RETURN (NIL)


/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
Function Aviso ( cParam )

MessageBox( "Eliji " + cParam )

return

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
Function MessageBox( cMensaje )

// Crea una caja del tipo Alert() pero con efecto 3-D

local  aMensajes := {}
local  cOpcion   := "&Acepta"
local  nAlto
local  nAncho
local  nIzqBoton
local  nLargoMens
local  nLargoBoton
local  nLeft
local  nSupBoton
local  nTop
local  oBoton
local  xSaveScr

SetCursor( 0 )

nLargoMens := 0             // Longitud mxima del mensaje

while Len( cMensaje ) > 0

   if ( nI := At( ';',cMensaje ) ) == 0

    // Guarda el mensaje en aMensajes
      AAdd( aMensajes, cMensaje )
      cMensaje := ''

   else
    //Hace un parsing del mensaje al :
      AAdd( aMensajes, Left( cMensaje, nI-1 ) )
      cMensaje := Right( cMensaje, Len( cMensaje ) - nI )

   endif

   nLargoMens := Max( nLargoMens, Len( ATail( aMensajes ) ) )

enddo

nAncho   := nLargoMens + 11
nAlto    := 6 + Len( aMensajes )

nTop     := Int( ( MaxRow() + 1 - nAlto ) / 2 )
nLeft    := Int( ( MaxCol() + 1 - nAncho ) / 2 )

nLargoBoton := Len( StrTran( cOpcion, "&" ) )
nIzqBoton   := Int( ( MaxCol() + 1 - nLargoBoton ) / 2 ) //+ 3
nSupBoton   := nTop + nAlto  -2  //- ( FONT_SIZE_Y + 1 )

// Guarda la pantalla bajo la caja
xSaveScr := SaveScreen( nTop,nLeft,nTop+nAlto,nLeft+nAncho )

//Dibuja la caja con efecto 3-D
DispBox( nTop,nLeft,nTop+nAlto,nLeft+nAncho,LLG_BOX_GRAY_SQUARE )

//Muestra un icono
gBmpDisp( gBmpLoad( "DIA_STOP.BMP" ) , ;
                  ( nLeft+4 )*FONT_SIZE_X , ;
                  ( nTop+2 )*FONT_SIZE_Y  )

//Muestra el mensaje
for nI := 1 to Len( aMensajes )

    DevPos( nTop+2+nI, nLeft + 6 + Int(( nAncho-4-LEN( aMensajes[nI] )) /2 ))
    DevOut( aMensajes[nI],"N+/W" )

next

//Crear un objeto botn
oBoton := TBotonTxt():New( nIzqBoton, nSupBoton )
oBoton:AddText( cOpcion )
oBoton:Display()
Inkey( 0 )

//Restaurar la pantalla
RestScreen( nTop,nLeft,nTop+nAlto,nLeft+nAncho,xSaveScr )

RETURN NIL

