/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
AUTOR           : Juan C. Martnez                                             /
PROGRAMA        : TBOTONTXT.PRG
DESCRIPCION     : Clase para crear push buttons grficos
FECHA           : 09 / 12 / 96
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

//FICHEROS DE CABECERA
#include 'LlibG.ch'
#include 'Common.ch'
#include '1stClass.ch'

CLASS TBotonBmp

	VAR aBmpDef			// Array devuelto por la funcin gBmpLoad()
    VAR aBmpDwn         // Array devuelto por la funcin gBmpLoad()
    VAR aBmpUp          // Array devuelto por la funcin gBmpLoad()
    VAR bAccion         // Code block a ejecutar cuando se pulse el botn
    VAR cHotKey			// HotKey del Botn
    VAR nCoordDer       // Coordenada derecha del botn
    VAR nCoordInf       // Coordenada inferior del botn
    VAR nCoordIzq       // Coordenada izquierda del botn
    VAR nCoordSup       // Coordenada superior del botn
    VAR nOrden
    VAR xCargo			// Por si acaso

    MESSAGE Display     METHOD Display
    MESSAGE DisplayDwn	METHOD DisplayDwn
    MESSAGE Exec        METHOD Exec
    MESSAGE Init        METHOD Init

ENDCLASS

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
METHOD Init( nCoordX, nCoordY, cBmpUp, cBmpDef, cBmpDwn, cHotKey ) CLASS TBotonBmp

// Metodo constructor de la clase

// nCoordX -> Coordenada izquierda en nmero de filas/columnas
// nCoordY -> Coordenada izquierda en nmero de filas/columnas
// cBmpUp   -> Arcihvo .BMP que se mostrar cuando el botn no est pulsado
//				ni seleccionado
// cBmpDef	-> Arcihvo .BMP que se mostrar cuando el botn est selleccionado
//				pero no est pulsado
// cBmpDwn  -> Arcihvo .BMP que se mostrar cuando el botn est pulsado

::bAccion := { || .T. }

// La funcin gBmpLoad() devuelve un array con un puntero a la regin del
// VMM que contiene el archivo BMP.

::aBmpUp	:= gBmpLoad( cBmpUp )
::aBmpDef	:= gBmpLoad( cBmpDef)
::aBmpDwn   := gBmpLoad( cBmpDwn )

//Calcula las coordenadas superior e izquierda en pixels,
//usando las pseudo-funciones Row2Pxl() y Col2Pxl() definidas en LLIBG.CH

::nCoordIzq     := Col2Pxl( nCoordX )
::nCoordSup     := Row2Pxl( nCoordY )

// Los dos primeros elementos del array contienen la altura y el ancho
// del BMP en pixeles.
// Con esta informacin podemos calcular la altura y el ancho de nuestros
// botones.
// Utilizamos las constantes pre-definidas LLG_BMP_X y LLG_BMP_Y, definidas
// en LLIBG.CH

::nCoordDer := ::nCoordIzq + ::aBmpUp[ LLG_BMP_X ] - 1
::nCoordInf := ::nCoordSup + ::aBmpUp[ LLG_BMP_Y ] - 1

::cHotKey	:= Upper( cHotKey )

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
METHOD DisplayDwn() CLASS TBotonBmp

// Muestra el botn pulsado

gBmpDisp( ::aBmpDwn, ;
          ::nCoordIzq, ;
          ::nCoordSup )

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Exec() CLASS TBotonBmp

// Ejecuta el codeblock asociado al botn

Eval( ::bAccion )

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
METHOD Display( lSelect ) CLASS TBotonBmp

// Muestra el botn

// La variable lSelect determina si se muestra el botn como seleccionado o no
// Por defecto vale FALSE  => botn no seleccionado

DEFAULT lSelect TO FALSE

if lSelect
    gBmpDisp( ::aBmpDef, ;
              ::nCoordIzq, ;
              ::nCoordSup )

else
    gBmpDisp( ::aBmpUp, ;
              ::nCoordIzq, ;
              ::nCoordSup )

endif

RETURN Self