/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
AUTOR           : Juan C. Martnez
PROGRAMA        : TBOTONTXT.PRG
DESCRIPCION     : Clase para crear push buttons grficos
FECHA           : 20 / 11 / 96
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

//FICHEROS DE CABECERA
#include 'LlibG.ch'
#include 'Common.ch'
#include '1stClass.ch'

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
CLASS TBotonTxt

    VAR bAccion			// Code Block asociado al botn
    VAR cHotKey			// HotKey del Botn
    VAR cLeyenda		// Texto a mostrar en el botn
    VAR nClrFndo        // Color del fondo cuando el botn no est seleccionado
    VAR nClrFndHi		// Color del fondo cuando el botn est seleccionado
    VAR nClrHtKy        // Color del hotkey cuando el botn no est seleccionado
    VAR nClrHtKyHi      // Color del hotkey cuando el botn est seleccionado
    VAR nClrTxtHi		// Color del texto cuando el botn no est seleccionado
    VAR nClrTxtLo       // Color del texto cuando el botn est seleccionado
    VAR nCoordDer       // Coordenada derecha del botn
    VAR nCoordInf       // Coordenada inferior del botn
    VAR nCoordIzq       // Coordenada izquierda del botn
    VAR nCoordSup       // Coordenada superior del botn
    VAR nDx             // Coordenadas dentro del botn donde se mostrar
    VAR nDY				// el texto
    VAR nPosHot         // Posicin del Hot Key dentro de la leyenda
    VAR xCargo			// Por si acaso

    MESSAGE AddText     METHOD AddText
    MESSAGE Display     METHOD Display
    MESSAGE DrawText    METHOD DrawText
    MESSAGE Exec        METHOD Exec
    MESSAGE Frame       METHOD Frame
    MESSAGE Init        METHOD Init

ENDCLASS

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Init( nCordX, nCordY ) CLASS TBotonTxt

// Mtodo cosntructor de la clase

::bAccion       := { || .T. }
::nClrFndo		:= LLG_CLR_CYAN
::nClrFndHi     := LLG_CLR_RED
::nClrHtKy      := LLG_CLR_WHITE
::nClrHtKyHi    := LLG_CLR_YELLOW
::nClrTxtLo     := LLG_CLR_BR_WHITE
::nClrTxtHi     := LLG_CLR_BR_WHITE

//Calcula las coordenadas inferior, superior e izquierda y las corordenadas
//donde se va a mostrar el texto en pixels, usando las pseudo-funciones
//Row2Pxl() y Col2Pxl() definidas en LLIBG.CH

::nCoordInf     := Row2Pxl( nCordY ) + FONT_SIZE_Y - 1
::nCoordIzq     := Col2Pxl( nCordX )
::nCoordSup     := Row2Pxl( nCordY )
::nDx           := ::nCoordIzq + ( FONT_SIZE_X / 2 ) + 1
::nDy           := ::nCoordInf - FONT_SIZE_Y + 1

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD AddText( cTexto ) CLASS TBotonTxt

// Agrega el texto al botn, determinndo cual es el HotKey

LOCAL cHotKey 	:= SubStr( cTexto, At( "&", cTexto ) + 1, 1 )
LOCAL nPosHot 	:= At( "&", cTexto ) - 1
LOCAL cLeyenda 	:= StrTran( cTexto, "&" )

::nPosHot 	:= nPosHot * FONT_SIZE_X
::cLeyenda  := cLeyenda

//Calcula la coordenada derecha en funcin de la longitud del texto
//a mostrar
::nCoordDer := ::nCoordIzq + ( Len( cLeyenda ) + 1 ) * FONT_SIZE_X - 1
::cHotKey   := cHotKey

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Display( lActivo ) CLASS TBotonTxt

// Muestra el botn. El color con que se lo va a mostrar depende del
// parmetro lActivo

::Frame( lActivo )
::DrawText( lActivo )

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD DrawText( lActivo ) CLASS TBotonTxt

// Dibuja el texto. El color con que se lo va a mostrar depende del
// parmetro lActivo

LOCAL cHotKey		:= ::cHotKey
LOCAL cLeyenda      := ::cLeyenda
LOCAL nClrFnd       := ::nClrFndo
LOCAL nClrFndHi     := ::nClrFndHi
LOCAL nClrHtKy
LOCAL nClrTxt
LOCAL nDx           := ::nDx
LOCAL nDy           := ::nDy
LOCAL nDyHot        := ::nDy
LOCAL nPosHot       := ::nPosHot
LOCAL nDxHot        := nDx + nPosHot


DEFAULT lActivo TO FALSE

nClrHtKy  := If( !lActivo, ::nClrHtKy, ::nClrHtKyHi )
nClrTxt   := If( !lActivo, ::nClrTxtLo, ::nClrTxtHi )

gWriteAt( nDx, ;
		  nDy, ;
		  cLeyenda, ;
		  nClrTxt, ;
		  LLG_MODE_SET )

gWriteAt( nDxHot , ;
	      nDyHot,;
	      cHotKey, ;
	      nClrHtKy, ;
	      LLG_MODE_SET )

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Exec()

// Evala el codeblock asaociado al botn

Eval( ::bAccion )

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Frame( lActivo )

// Dibuja la caja del botn. El color con que se lo va a mostrar depende del
// parmetro lActivo


LOCAL nClrFondo
LOCAL nCoordDer := ::nCoordDer
LOCAL nCoordInf := ::nCoordInf
LOCAL nCoordIzq := ::nCoordIzq
LOCAL nCoordSup := ::nCoordSup

DEFAULT lActivo TO FALSE

nClrFondo := If( lActivo , ::nClrFndo, ::nClrFndHi )

gFrame( nCoordIzq			,;
        nCoordSup			,;
        nCoordDer			,;
        nCoordInf			,;
        nClrFondo			,;
        LLG_CLR_BLACK 		,;
        LLG_CLR_BR_WHITE	,;
        1, 1, 1, 1			,;
        LLG_MODE_SET )

return Self


/**************************************/