/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
AUTOR           : Juan C. Martnez
PROGRAMA        : TTOOLBAR.PRG
DESCRIPCION     : Clase para manejar botones creados con la clase TBotonBmp
                  como si se tratara de una tool-bar
FECHA           : 09 / 12 / 96
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

//FICHEROS DE CABECERA
#include 'Common.ch'
#include '1stClass.ch'
#include 'InKey.ch'
#include 'LLibG.ch'

#define  K_FIN_ASCII       255      // ltimo cdigo de tecla ASCII
#define  K_CLIC_OUT      -9999      // click fuera de un push-button
#define  K_LEFT_BTN     -10000      // se puls el botn izquierdo del mouse

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
CLASS TToolBar

    VAR aoBtnHandler
    VAR nCantBotones
    VAR nCoordX
    VAR nCoordY
    VAR nElement

    MESSAGE AddButton   METHOD AddButton
    MESSAGE AddItem     METHOD AddItem
    MESSAGE ApplyKey    METHOD ApplyKey
    MESSAGE Display     METHOD Display
    MESSAGE Exec        METHOD Exec
    MESSAGE FindButton  METHOD FindButton
    MESSAGE Init        METHOD Init
    MESSAGE MInkey      METHOD MInkey
    MESSAGE MouseClk    METHOD MouseClk
    MESSAGE MouseInBtn  METHOD MouseInBtn
    MESSAGE ToRight     METHOD ToRight
    MESSAGE ToLeft      METHOD ToLeft


ENDCLASS

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Init( nCorX, nCorY ) CLASS TToolBar

// Mtodo constructor de la clase

::aoBtnHandler  := {}
::nCantBotones  := 0
::nCoordX       := Col2Pxl( nCorX )
::nCoordY       := Row2Pxl( nCorY )
::nElement      := 1

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD AddButton( oBoton ) CLASS TToolBar

// Agrega un objeto botn al array de objetos botn.

AAdd( ::aoBtnHandler, oBoton )

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD AddItem( cBmpUp, cBmpDef, cBmpDwn, cHotKey, bAccion )

// Agrega un botn a la barra

local nCoordX   := X2Col( ::nCoordX )
local nCoordY   := Y2Row( ::nCoordY )
local oBoton    := TBotonBMP():New( nCoordX, ;
                                    nCoordY, ;
                                    cBmpUp,  ;
                                    cBmpDef, ;
                                    cBmpDwn, ;
                                    cHotKey )

::nCantBotones ++
oBoton:bAccion := bAccion
oBoton:nOrden  := ::nCantBotones

::AddButton( oBoton )
::nCoordX := oBoton:nCoordDer + FONT_SIZE_X

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD ApplyKey( nKey ) CLASS TToolBar

// Analiza las teclas pulsadas por el usuario

local aoBtnHandler  := ::aoBtnHandler
local cKey          := Chr( nKey )
local nIndx     := 0
local nReturn       := nKey

// Determinar si la tecla pulsada corresponde a un hot-key

if aoBtnHandler <> NIL

    nIndx := AScan( aoBtnHandler, ;
                 { |x| x:cHotKey == cKey } )

    if nIndx # 0

        mHide( )

        ::nElement := nIndx

          aoBtnHandler[ nIndx ]:DisplayDwn()

      // Esperar 4/18 de segundo antes de liberar el botn
      Tone( 0,4 )

        aoBtnHandrler[ nIndex]:Display( TRUE )

    endif

endif

return nKey

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Display() CLASS TToolBar

// Muestra la barra de botones

local aoBtnHandler  := ::aoBtnHandler
local nCont
local nElement      := ::nElement

FOR nCont := 1 TO Len( aoBtnHandler )
    aoBtnHandler[ nCont ]:Display( FALSE )

NEXT

aoBtnHandler[ nElement]:Display( TRUE )

RETURN Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD Exec() CLASS TToolBar

//Analiza las teclas pulsadas por el usuario o las pulsaciones de los botones //del mouse, actuando en consecuencia

local aItems
local cKey
local nInd
local nKey

::nElement  := 1

::aoBtnHandler[ ::nElement ]:Display( TRUE )

while TRUE

    nKey := ::MInKey( 0 )

        do case
            case nKey == K_ESC
                    exit

        case nKey == K_CLIC_OUT 

            // pulsamos el botn derecho del mouse...

        case nKey == K_LEFT_BTN .or. nKey == K_RETURN
                    ::aoBtnHandler[ ::nElement ]:Exec()

        case nKey == K_RIGHT .or. nKey == K_DOWN
                    ::ToRight()

        case nKey == K_LEFT .or. nKey == K_UP
                    ::ToLeft()
    
          //se determina si se puls el hotkey
        case ( nKey > K_SPACE .and. nKey < K_FIN_ASCII )
            cKey := Upper( Chr( nKey ) )

            for nInd := 1 to Len ( ::aoBtnHandler )
                if Upper (::aoBtnHandler[ nInd ]:cHotKey ) == cKey
                    ::aoBtnHandler[ ::nElement ]:Display( FALSE )
                            ::nElement := nInd
                    ::aoBtnHandler[ ::nElement ]:Display( TRUE )
                    ::aoBtnHandler[ ::nElement ]:DisplayDwn()
                Tone( 0,4 )
                    ::aoBtnHandler[ ::nElement ]:Display( TRUE )
                         ::aoBtnHandler[ ::nElement ]:Exec()

            endif

        next
    
    endcase

        Keyboard( Chr( 0 ) )

enddo

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD FindButton( nMouseX, nMouseY ) CLASS TToolBar

// Determina si se pic el mouse sobre un botn

local aoBtnHandler  := ::aoBtnHandler
local nI            := 0                        // Contador para el loop
local nMaxButton    := Len( aoBtnHandler )      // Cantidad de botones
local nHitButton    := 0                        // Posicin del botn picado

for nI := 1 to nMaxButton

    if ::MouseInBtn( aoBtnHandler[ nI ], nMouseX, nMouseY )
    
        //Si se pic el mouse dentro de un botn
        nHitButton := nI
        exit
    endif

next

//Devolver NIL, o el objeto TBotonBmp correspondiente al botn picado
Return ( if( nHitButton == 0, NIL, aoBtnHandler[ nHitButton ] ) )

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD MInkey( nSegundos ) CLASS TToolBar

//Genera el estado de espera

local aMouseState   :=  MState( )           // Array con los estados del mouse
local aoBtnHandler  := ::aoBtnHandler
local lLeft         := .F.              // Botn izquierdo del mouse                                // pulsado
local lRight        := .F.              // Botn derecho del mouse pulsado
local nReturn       :=  0               // Valor de retorno
local nTime         :=  0               // Controlador de tiempo

// Mostrar el cursor del mouse
MShow( )

// Esperar por una tecla o accin del mouse
if nSegundos == NIL

    // Si se puls el botn izquierdo
    if aMouseState[LLM_STATE_LEFT] == LLM_BUTTON_DOWN

            // Aplicar accin del mouse al push-button
            nReturn := ::MouseClk( aMouseState )

    else    // Recibir el teclazo, si lo hubo y aplicarlo al push-button

            nReturn := ::ApplyKey( InKey() )

    endif

else                      // esperar por un teclazo del usuario, que se haya
                          // pulsado el botn izquierdo o que hayan pasado los
                          // nSegundos

   nTime := Seconds( )     // Inicializar el controlador de tiempo

   while (  nReturn := InKey( ) ) == 0 .and. ;
         !( lLeft := ( aMouseState[LLM_STATE_LEFT] == LLM_BUTTON_DOWN ) ) .and. ;
         !(  lRight:= ( aMouseState[LLM_STATE_RIGHT] == LLM_BUTTON_DOWN ) ) .and.;
         Iif ( nSegundos > 0,  ( Seconds( ) - nTime ) < nSegundos, .T. )

    aMouseState := mState()

   enddo

   if lLeft               // Se puls el botn izquierdo
                          // Aplicar la accin del mouse al push-button
    nReturn := ::MouseClk( aMouseState )

   elseif lRight          // Se puls el botn derecho

      nReturn := K_CLIC_OUT

   elseif nReturn <> 0    // se puls una tecla

      nReturn := ::ApplyKey( nReturn )

   endif

endif

// Ocultar el cursor del mouse
mHide( )

return ( nReturn )

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD MouseClk( aMouseState ) CLASS TToolBar

// Aplical la accin del mouse al botn en cuestin, simulando que se lo puls

local aoBtnHandler  := ::aoBtnHandler
local nReturn       :=  0
local oHitButton        

mHide()

// Busca en la lista de botoones
if ( oHitButton := ::FindButton( aMouseState[ LLM_STATE_X ],;
                                 aMouseState[ LLM_STATE_Y ] ) ) == NIL

    nReturn := 0            // No encontr el botn

else                        // Simular la pulsacin del botn

    mHide()
    oHitButton:DisplayDwn() // Mostrarlo pulsado

    Tone( 0,4 )             // Esperar 4/18 de segundo antes de liberar el                  // botn

    oHitButton:Display( FALSE )

        ::nElement := oHitButton:nOrden

        nReturn := K_LEFT_BTN

    mShow()

endif

return ( nReturn )

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD MouseInBtn( oBoton, nMouseX, nMouseY ) CLASS TToolBar

// Devuelve TRUE si el puntero del mouse est dentro de un botn

   RETURN( nMouseX >= oBoton:nCoordIzq .and. ;
           nMouseY >= oBoton:nCoordSup .and. ;
           nMouseX <= oBoton:nCoordDer .and. ;
           nMouseY <= oBoton:nCoordInf )

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD ToRight() CLASS TToolBar

::aoBtnHandler[ ::nElement ]:Display( FALSE )

::nElement ++

if ::nElement > Len( ::aoBtnHandler )
    ::nElement := 1

endif

::aoBtnHandler[ ::nElement ]:Display( TRUE )

return Self

/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

METHOD ToLeft() CLASS TToolBar

::aoBtnHandler[ ::nElement ]:Display( FALSE )

::nElement --

if ::nElement < 1
    ::nElement := Len( ::aoBtnHandler )

endif

::aoBtnHandler[ ::nElement ]:Display( TRUE )

return Self

/*::::Fin Fuente 2::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

