#!/usr/local/bin/perl
##############################################################################
# Copyright: Binny V Abraham 2004-2005                                       #
# If you want to use this script, Leave this message here                    #
##############################################################################
# Contact me At binnyva@hotmail.com                                          #
# Or At http://www.geocities.com/binnyva                                     #
##############################################################################
# Name Of Script : Guest Book                                                #
# Version        : 1.01.A                                                    #
# This script is to collect visitor information from the public and store    #
# in a file for your viewing.                                                #
# This script also includes a self created acknowledgment page.              #
# It is essential to have the form to which this file should be linked.      #
# Without it, this script will not function.                                 #
# guestbook.html is the file that takes in the info and passes it to the     #
# script                                                                     #
#                                                                            #
# Get more Perl scripts from http://www.geocities.com/binnyva/code/perl      #
##############################################################################
# use strict;

# Set Variables
my $guestfile = "guest.html";# Guest Book info storing file
my $seperator = "-";         # Date separator (9'-'10..)

# Get input
my $value;
#Get the input
if ($ENV{REQUEST_METHOD} eq 'POST') {
	read(STDIN, $value, $ENV{CONTENT_LENGTH});
} else {
	$value = $ENV{QUERY_STRING};
}


# Take time to make things happen
my ($mday, $mon, $year) = (localtime(time))[3,4,5];
$mon += 1;
$year += 1900;
my $date = "$mday$seperator$mon$seperator$year";

# Convert Hex code to English. And removing unwanted things
$value =~ s/%(..)/pack("c", hex($1))/ge;
$value =~ s/name\=//gi;
$value =~ s/email\=//gi;
$value =~ s/loc\=//gi;
$value =~ s/comments\=//gi;
$value =~ s/rating\=//gi;
$value =~ s/strength\=//gi;
$value =~ s/\+/ /gi;
$value =~ s/\n/<BR>/gi;

# Split the name-value pairs
my @pairs = split(/&/, $value);

my $pair;
my %FORM;
# Get the input into a hash.
foreach $pair (@pairs) {
   my ($name, $value) = split(/=/, $pair);

   # Making the input English. And removing unwanted things
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

   $FORM{$name} = $value;
}


# If some fields are not filled, then those must be replaced by a space
$FORM{'name'} = "&nbsp;" unless $FORM{'name'};
$FORM{'email'} = "&nbsp;" unless $FORM{'email'};
$FORM{'loc'} = "&nbsp;" unless $FORM{'loc'};
$FORM{'comments'} = "&nbsp;" unless $FORM{'comments'};
$FORM{'rating'} = " - " unless $FORM{'rating'};
$FORM{'strength'} = " - " unless $FORM{'strength'};

# Open Guest Book File
open (FILE, "$guestfile") || print "Can't open $guestfile: $!\n";
my @LINES=<FILE>;
close(FILE);
my $SIZE=@LINES;

# Open Guest Book File and inputing the content on top
open (FILE, ">$guestfile") || print "Can't open $guestfile: $!\n";
for (my $i = 0; $i <= $SIZE; $i++)
 {
 $_=$LINES[$i];
 if (/<!--top-->/) 
  {
  print FILE "<!--top-->\n";
  print FILE "<tr><td class=name>$FORM{'name'}</td><td>$FORM{'email'}</td><td class=loc>$FORM{'loc'}</td><td>$FORM{'rating'}</td><td>$FORM{'strength'}</td><td noWrap>$date</td></tr>\n";
  print FILE "<tr><td colspan=6 class=comments>$FORM{'comments'}</td></tr>\n";
  }
 else 
  {
  print FILE $_;
  }
 }
close (FILE);

# Print out the Acknowledgement
print "Content-Type: text/html\n\n";
print "<html>\n<head>\n<title>Thank You</title>\n</head>\n<body>\n";
print "<h1 align=center>Guest Book Entry Confirmed</h1>\n";
print "Dear $FORM{'name'},<BR>Thank You for filling out our Guest Book. I appreciate this effort ";
print "in your part.<br><br>\n<table>\n";
print "<tr><td>Name</td><td>$FORM{'name'}</td></tr>\n<tr><td>E Mail</td><td><a href='mailto:$FORM{'email'}'>$FORM{'email'}</a></td></tr>\n<tr><td>Location</td><td>$FORM{'loc'}</td></tr>\n";
print "<tr><td>Comments</td><td>$FORM{'comments'}</td></tr>\n</table>\n";
if($FORM{'$rating'} > 6) {print "<br><br>And thank you for giving this site a high rating of $FORM{'rating'}\n";}
print "<br><br>Yours Faithfully,<br>Binny<br>\n";
print "<br><br>\n<a href=guest.html>View Guest Book</a><br>\nTo add your name to the Guest Book click <a href=/guestbook.html>here</a>.\n";
print "\n</body>\n</html>";