import java.rmi.*;
import java.rmi.server.*;
import java.sql.Date;
import java.util.*;

/**
 * Class: AgenziaClient
 */

public class AgenziaClient {

  /**
   * Shows menu:<br><br>
   * 1. Make booking<br> 
   * 2. Show hotels<br>
   * 3. Unbook<br>
   * 4. Show bookings of a customer<br>
   * 5. Show all bookings of a Hotel<br>
   * 6. Show all available rooms<br>
   * 7. Show all available rooms with price lower then ...<br>
   * 0. Exit<br>
   */

  public static void main(String argv[]) {
    StringTokenizer t;
    int l;
    String[] buf = new String[100];
    String temp;
    int i;
    int N=10;
    System.setSecurityManager(new RMISecurityManager());
    String name = "//viper:7676/Touring";
    System.out.println("Looking up " + name + "...");
    AgenziaServer atour = null;
    try 
      {
	atour = (AgenziaServer)Naming.lookup(name);
      }
    catch (Exception e)
      {
	System.out.println (" sbaglio subito " +e);
      }

    while (N!=0) {
      System.out.println();
      System.out.println("1. Make booking");
      System.out.println("2. Show hotels");
      System.out.println("3. Unbook");
      System.out.println("4. Show bookings of a customer");
      System.out.println("5. Show all bookings of a Hotel");
      System.out.println("6. Show all available rooms ");
      System.out.println("7. Show all available rooms with price lower then ...");
      System.out.println("0. Exit ");
      System.out.println();
      System.out.print("Make your choice ... ");
      
      N = Console.readInt();

      switch(N){
	
      case 1:         
        String hotel=new String();
	int room;
	String idCustomer=new String(); 
	Date begin=new Date(0);
	Date end=new Date(0);
	long key = 0;

	while(key==0){
	  
	  System.out.print("Hotel: ");
	  hotel = Console.readString();
	  
	  System.out.print("room = ");
	  room=Console.readInt();

	  System.out.print("idClient = ");
	  idCustomer=Console.readString();
	  
	  System.out.print("Begin date = ");
	  begin=Console.readDate();
	  
	  System.out.print("End date = ");
	  end=Console.readDate();
	  
	  try
	    {
	      key=atour.book (hotel,room,idCustomer,begin,end);
	      if(key==0)
		{
		  System.out.println("\nNot a valid request:");
		  System.out.println("\t* dates not valid or");
		  System.out.println("\t* room already booked\n");
		}
	    }
	  catch (RemoteException e)
	    { 
	      System.out.println ("Fucked up on book"+e);
	    }        
	}
	System.out.println("\nYour key is: "+key);
	System.out.println("(sign it on a piece of paper and DON'T loose it !!)");
	break;

      case 2:
	try 
	  {	
	    buf=atour.allHotels();
	  }  
	catch (RemoteException e)
	  { 
	    System.out.println (e);
	  }        

	i=0;
	if (buf[i]!=null)
	  {
	    Console.writeTable("Name:32:Room:8:Price:16",buf,":");
	  }
	else
	  {
	    System.out.println("Empty database ...");
	  }
	break;
	
      case 3:
	System.out.print("Key = ");
	try 
	  {	
	    if (atour.unbook(Console.readLong()))
	      System.out.println("O.K.");
	    else
	      System.out.println("Something wrong. Retry (or go to ClubMed).");
	  }
	catch (RemoteException e)
	  { 
	    System.out.println (e);
	  }        
	break;
	
      case 4:
	System.out.print("Customer: ");
	
	try 
	  {
	    buf=atour.showBookingsCustomer(Console.readString());
	  }
	catch (RemoteException e)
	  { 
	    System.out.println (e);
	  }        
	
	i=0;
	if (buf[i]!=null)
	{
	  Console.writeTable("Name:32:Room:8:Key:16:BeginDate:11:EndDate:10",buf,":");
	}
	else
	  {
	    System.out.println("None ...");
	  }
	break;
	
      case 5:
	System.out.print("Hotel: ");
	try
	  {
	    buf=atour.showBookingsHotel(Console.readString());
	  }
	catch (RemoteException e)
	  { 
	    System.out.println (e);
	  }        

	i=0;
	if (buf[i]!=null)
	  {
	    Console.writeTable("Room:8:idClient:32:BeginDate:11:EndDate:10",buf,":");
	  }
	else
	  {
	    System.out.println("Not even a booking ...");
	  }
	break;

    case 6:
     
      System.out.print("Begin date: ");
      Date date_begin= Console.readDate();
      System.out.print("End date: ");
      Date date_end= Console.readDate();
      try
	{  
	  buf=atour.showAllAvailable(date_begin, date_end);
	}
      catch (RemoteException e)
	{ 
	  System.out.println ("go to ClubMed "+e);
	}        
   
	  i=0;
      if (buf[i]!=null)
	{
	  Console.writeTable("Hotel:32:Room:8:Price:16",buf,":");
	}
      else
	{
	  System.out.println("Sorry ... no rooms available");
	}
      break;

      case 7:
	System.out.print("Begin date: ");
	date_begin= Console.readDate();
	System.out.print("End date: ");
	date_end= Console.readDate();
	System.out.print("Price= ");
	long price= Console.readLong();
	try
	  {
	    buf=atour.showAllAvailable(date_begin,date_end,price);
	  }
	catch (RemoteException e)
	  { 
	    System.out.println ("go to ClubMed "+e);
	  }        
	
	i=0;
	if (buf[i]!=null)
	  {
	  Console.writeTable("Hotel:32:Room:8:Price:16",buf,":");
	  }
	else
	  {
	    System.out.println("Sorry ... no rooms available");
	  }
      }//closes switch
    }//closes while(N!=0)
  }//closes main
}










