import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import java.io.*;
import java.sql.*;

/**
 * Class: AgenziaServerImpl<br>
 *
 * Note: the use of semaphore free is purely didactic. 
 * 
 *
 **/

public class AgenziaServerImpl 
extends UnicastRemoteObject
implements AgenziaServer {
  
  //-------Global Variables-------------------

  private String url = "jdbc:odbc:fra";
  private Connection con;
  private Statement stmt;
  private long booking_key;
  private boolean free = true;
  private static boolean DEBUG = true;
 
  //--(CONSTRUCTOR)----------------------------

  /**
   * Creates the link of AgenziaImpl to the postgres DataBase and initializes the booking key value
   * <font size=-1><br><br>
   * SQL statement:<br><br>
   * select max(booking_key) as maxBook from bookings<br><br>
   * </font>
   * @exception RemoteException RMI initialization failed
   * @exception java.lang.ClassNotFoundException driver for interact with 
   * postgres:fra database not found           
   */
  
  public AgenziaServerImpl() throws RemoteException, ClassNotFoundException  
    { 
       super();
       
       try 
       	 {
	   Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
	   
	 } 
       catch(java.lang.ClassNotFoundException e)
	 {
	   System.err.print("ClassNotFoundException: "); 
	   System.err.println(e.getMessage());
	 }
       try 
	 {
	   Statement stm; 
	   con = DriverManager.getConnection(url,"fra", "myPassword");
	   stm = con.createStatement(); 
	   
	   // check all booking keys to be sure that the new one is bigger

	   ResultSet rs = stm.executeQuery("select max(booking_key) " + 
					   "as maxBook " +
					   "from bookings;");
	   rs.next();
	   booking_key = rs.getLong("maxBook");
	   stm.close();
	   con.close();
	 }
       catch (SQLException ex) 
	 {
	   System.err.println("SQLException: " + ex.getMessage());
	 }
       if(DEBUG)
	 {
	   System.out.println("ServerImpl created...");
    	 }
    }

  //====(METHODS)=========================================
  
  //-------------ALL HOTELS----------------------------- 
  /**
   * Returns all entries in the hotels table
   * <font size=-1><br><br>
   * SQL statement: <BR><br>
   * select name, room, price from hotels order by name,room<BR><BR>
   * </font>
   * @return String[] - name:room:price
   */
  
  public synchronized String[] allHotels() 
    { 
      String[] buffer = new String[100];
      try 
	{
	  con = DriverManager.getConnection(url,"fra", "myPassword");
	  stmt = con.createStatement(); 
	  while(free==false)
	    {
	      try
		{
		  wait();
		}
	      catch(InterruptedException e)
		{
		  System.out.println("Interrupted exception: "+e);
		}
	    }
	  free=false;
	  
	  ResultSet rs = stmt.executeQuery("select name, " + 
					   "room, price " +
					   "from Hotels " +
					   "order by name,room;");
	  free=true;
	  notifyAll();
	  int i=0;
	  while (rs.next())
	    {
	      buffer[i] = rs.getString("NAME");
	      buffer[i] +=":";
	      buffer[i] += rs.getString("Room");
	      buffer[i] +=":";
	      buffer[i] += rs.getString("Price");
	      i++;
	    }
	  
	  stmt.close();
	  con.close();
	}
      catch (SQLException ex) 
	{
	  System.err.println("SQLException: " + ex.getMessage());
	}
      if(DEBUG)
	{
	  System.out.println("Method allHotels invocated successfully...");
	}
      return buffer;
    } 
  
  //--------------------------------BOOK-----------------------------------
  /** 
   * insert line in the bookings table with the id (key) from the hotels 
   * table (cheking the date)
   * <font size=-1><br><br>
   * SQL statements:<br><br>
   * select * from hotels where upper(name)='idHotel' and room=room<br><br>
   * select * from hotels, bookings where idroom=id and not(('begin'>date_end)
   * or (date_begin>'end')) <br><br>
   * insert into bookings values(id,'idCustomer', booking_key, 
   * begin, end) <br><br>
   * update hotels set requests=requests+1 where id=id <br><br>
   * </font>
   * @param idHotel name of the hotel
   * @param room room number
   * @param idCustomer name of the customer
   * @param begin begin date of the period
   * @param end end date of the period
   * @return long - booking number
   */
  
  public synchronized long book(String idHotel, int room, String idCustomer, Date begin, Date end)
   {
     if(DEBUG)
       {
	 System.out.println("Method book with parameters: "+idHotel+","+room+","+idCustomer+","+begin+","+end);
       }
     try 
       {
	 con = DriverManager.getConnection(url,"fra", "myPassword");
	 stmt = con.createStatement();
	 while(free==false)
	   {
	     try
	       {
		 wait();
	       }
	     catch(InterruptedException e)
	       {
		 System.out.println("Interrupted exception: "+e);
	       }
	   }
	 free=false;
	 ResultSet rs = stmt.executeQuery("select * from hotels where "+
					  "upper(name)='"+idHotel.trim().toUpperCase()+"' and "+
					  "room="+String.valueOf(room)+";");
         stmt.close();
	 stmt = con.createStatement();
         if((rs.next())&&(begin.before(end)))
	   {
	     booking_key++;
	     long id = rs.getLong("id");
	     rs = stmt.executeQuery("select * from hotels,bookings where "+
				    "idroom="+String.valueOf(id)+" and "+
				    "not(('"+begin.toString()+"'>date_end)or"+
				    "('"+end.toString()+"'<date_begin));");
	     stmt.close();
	     if(!rs.next())
	       {
		 stmt = con.createStatement();
		 stmt.executeUpdate("insert into bookings values("+
				    String.valueOf(id)+","+
				    "'"+idCustomer.trim()+"',"+
				    String.valueOf(booking_key)+","+
				    "'"+begin.toString()+"',"+
				    "'"+end.toString()+"');"+
				    "update hotels set requests=requests+1 "+
				    "where id="+String.valueOf(id)+";");
		 stmt.close();
		 con.close();
	       }
	     else
	       {
		 free=true;
		 notifyAll();
		 if(DEBUG)
		   {
		     System.out.println("...invocated UNsuccessfully...");
		   }
		 return 0;
	       }
	   }
	 else
	   {
	     free=true;
	     notifyAll();
	     if(DEBUG)
	       {
		 System.out.println("...invocated UNsuccessfully...");
	       }
	     return 0;
	   }
       }
     catch (SQLException ex) 
       {
	 System.err.println("SQLException: " + ex.getMessage());
       }
     free=true;
     notifyAll();
     if(DEBUG)
       {
	 System.out.println("...invocated successfully...");
       }
     return booking_key;
   }

  //----------------------UNBOOK-----------------------------------------
  /**
   * Drop the line from the bookings table with the specified booking_key
   * <font size=-1><br><br>
   * SQL statements:<br><br>
   * select idroom from bookings where booking_key=bookNumber<br><br>
   * delete from bookings where booking_number=bookNumber<br><br>
   * update hotels set requests=requests-1 where id=idroom<br><br>
   * </font>
   * @param bookNumber booking key
   * @return boolean:<br>
   * &nbsp&nbsp <b>true</b> if the tables were successfully updated <br>
   * &nbsp&nbsp else <b>false</b>
   * @see book
   */
  
  public synchronized boolean unbook(long bookNumber)
    {
      if(DEBUG)
	{
	  System.out.println("Method unbook with parameter: "+bookNumber);
	}
      try 
	{
	  con = DriverManager.getConnection(url,"fra", "myPassword");
	  stmt = con.createStatement();
	  while(free==false)
	    {
	      try
		{
		  wait();
		}
	      catch(InterruptedException e)
		{
		  System.out.println("Interrupted exception: "+e);
		}
	    }
	  free=false;
	  ResultSet rs = stmt.executeQuery("select idroom from bookings where "+
					   "booking_key="+String.valueOf(bookNumber)+";");
	  stmt.close();
	  stmt = con.createStatement();
	  if(rs.next())
	    {
	      long id = rs.getLong("idroom");
	      stmt.executeUpdate("delete from bookings where "+
				 "booking_key="+String.valueOf(bookNumber)+";"+
				 "update hotels set requests=requests-1 "+
				 "where id="+String.valueOf(id)+";");
	      stmt.close();
	      con.close();
	    }
	  else
	    {
	      System.out.println("Cannot process request (user error)");
	      free=true;
	      notifyAll();
	      return false;
	    }
	}
      catch (SQLException ex) 
	{
	  System.err.println("SQLException: " + ex.getMessage());
	  free=true;
	  notifyAll();
	  return false;
	}
      free=true;
      notifyAll();
      if(DEBUG)
	{
	  System.out.println("...invocated successfully...");
	}
      return true;
    }
  
  //----------------SHOW BOOKINGS OF A CUSTOMER---------------------------
  /**
   * Select all bookings in the bookings table with the given customer_id
   * <font size=-1><br><br>
   * SQL statement:<br><br>
   * select name, room, booking_key, date_begin, date_end from hotels,
   * bookings where id=idroom and upper(id_customer)='idCustomer'
   * order by name, room <br><br>
   * </font>
   * @param idCustomer name of the customer
   * @return String[] - name:room:booking_key:date_begin:date_end
   */

  public synchronized String[] showBookingsCustomer (String idCustomer)
    {
      String[] buffer = new String[100];
      if(DEBUG)
	{
	  System.out.println("Method showBookingsCustomer with parameter: "+idCustomer);
	}
      try 
	{
	  con = DriverManager.getConnection(url,"fra", "myPassword");
	  stmt = con.createStatement(); 
	  while(free==false)
	    {
	      try
		{
		  wait();
		}
	      catch(InterruptedException e)
		{
		  System.out.println("Interrupted exception: "+e);
		}
	    }
	  free=false;
	  ResultSet rs = stmt.executeQuery("select name, " + 
					   "room,  " +
					  "booking_key, " +
					   "date_begin, " +
					   "date_end " +
					   "from Hotels,bookings "+
					   "where id=idroom and "+
					   "upper(id_customer) = '" + idCustomer.trim().toUpperCase() + "' " + 
					   "order by name,room;");
	  free=true;
	  notifyAll();
	  int i=0;
	  while (rs.next())
	    {
	      buffer[i] = rs.getString("NAME");
	      buffer[i] +=":";
	      buffer[i] += rs.getString("room"); 
	      buffer[i] +=":";
	      buffer[i] += rs.getString("booking_key");
	      buffer[i] +=":";
	      buffer[i] += rs.getString("date_begin");
	      buffer[i] +=":";
	      buffer[i] += rs.getString("date_end");
	      i++;
	   } 
	  stmt.close();
	  con.close();
	}
      catch (SQLException ex) 
	{
	  System.err.println("SQLException: " + ex.getMessage());
	}
      if(DEBUG)
       {
	 System.out.println(" ...invocated successfully...");
       }
      return buffer;
    }
  
  //---------------SHOW BOOKINGS OF A HOTEL----------------------------------
  /**
   * Select from bookingsTable the rows whose name in hotels match the given Hotel
   * <font size=-1><br><br>
   * SQL statement: <br><br>
   * select room, id_customer, date_begin, date_end from hotels, bookings
   * where id=idroom and upper(name)='idHotel' order by id_customer, room<br><br>
   * </font>
   * @param idHotel name of the hotel
   * @return String[] - room:id_customer:date_begin:date_end
   */

  public synchronized String[] showBookingsHotel (String idHotel)
    {    
      if(DEBUG)
	{
	  System.out.println("Method showBookingsHotel with parameter: "+idHotel);
	}
      String[] buffer = new String[100];
      try 
       {
	 con = DriverManager.getConnection(url,"fra", "myPassword");
	 stmt = con.createStatement(); 
	 while(free==false)
	   {
	     try
	       {
		 wait();
	       }
	     catch(InterruptedException e)
	       {
		 System.out.println("Interrupted exception: "+e);
	       }
	   }
	 free=false;
	 ResultSet rs = stmt.executeQuery("select room,  " +
					  "id_customer, " +
					  "date_begin, " +
					  "date_end " +
					  "from Hotels,Bookings "+
					  "where id=idroom and "+
					  "upper(name) = '" + idHotel.trim().toUpperCase() + "' " + 
					  "order by id_customer,room;");
	 free=true;
	 notifyAll();
	 int i=0;
	 while (rs.next())
	   {
	     buffer[i] = rs.getString("room"); 
	     buffer[i] +=":";
	     buffer[i] += rs.getString("id_customer");
	     buffer[i] +=":";
	     buffer[i] += rs.getString("date_begin");
	     buffer[i] +=":";
	     buffer[i] += rs.getString("date_end");
 	     i++;
	   } 
	 stmt.close();
	 con.close();
       }
      catch (SQLException ex) 
	{
	  System.err.println("SQLException: " + ex.getMessage());
	}
      if(DEBUG)
	{
	  System.out.println("...invocated successfully...");
	}      
     return buffer;
    } 
  
  //------------SHOW ALL ROOMS AVAILABLE AT THE AGENCY---------------
  /**
   * Selects all the unbooked rooms from the Hotels table and the, in the given period, 
   * available rooms from the booking table 
   * <font size=-1><br><br>
   * SQL statement:<br><br>
   * select id, name, room, price, requests, count(*) as free 
   * from hotels, bookings where (idroom=id and ('date_begin'>date_end or 
   * date_begin>'date_end')) or (requests=0) group by id, name, room, price, requests
   * order by name, price, room<br><br>
   * </font>
   * @param date_begin beginning date of period
   * @param date_end end date of period
   * @return String[] - name:room:price  
   */

  public synchronized String[] showAllAvailable (Date date_begin, Date date_end)
    {
      if(DEBUG)
	{
	  System.out.println("Method showAllAvailable with parameters: "+date_begin.toString()+","+date_end.toString());
	}
      String[] buffer = new String[100];
      int r,f;
      if(date_begin.after(date_end))
	{
	  if(DEBUG)
	    {
	      System.out.println("...invocated with wrong dates...");
	    }
	  return buffer; 
	}
      try 
	{
	  con = DriverManager.getConnection(url,"fra", "myPassword");
	  stmt = con.createStatement(); 
	  while(free==false)
	    {
	      try
		{
		  wait();
	       }
	      catch(InterruptedException e)
		{
		  System.out.println("Interrupted exception: "+e);
		}
	    }
	  free=false;
	  ResultSet rs = stmt.executeQuery("select id, name,  " +
					   "room, price, requests, "+
					   "count(*) as free " +
					   "from Hotels,bookings "+
					   "where (idroom=id and " +
					   "('"+date_begin.toString()+"'>date_end or "+
					   "'"+date_end.toString()+"'<date_begin)) "+
					   "or (requests=0) "+
					   "group by id,name,room,price,requests "+
					   "order by name,price,room;");
	  free=true;
	  notifyAll();
	  int i=0;
	  while (rs.next())
	    {
	      r=rs.getInt("requests");
	      f=rs.getInt("free");
	      if((r==0)||(r!=0&&r==f))
		{
		  buffer[i] = rs.getString("name"); 
		  buffer[i] +=":";
		  buffer[i] += rs.getString("room");
		  buffer[i] +=":";
		  buffer[i] += rs.getString("price");
		  i++;
		}
	    } 
	  stmt.close();
	  con.close();
	}
      catch (SQLException ex) 
	{
	  System.err.println("SQLException: " + ex.getMessage());
	}
      if(DEBUG)
	{
	  System.out.println("...invocated successfully...");
	}
      return buffer; 
    }
  
  //-----------SHOW ALL ALVAILABLE ROOMS BELOW A GIVEN PRICE-------------
  /** 
   * Same as showAllAvailable with boudary for the price
   * <font size=-1><br><br>
   * SQL statement:<br><br>
   * select id, name, room, price, requests, count(*) as free 
   * from hotels, bookings where (idroom=id and ('date_begin'>date_end or 
   * date_begin>'date_end')) or (requests=0) and maxPrice>price
   * group by id, name, room, price, requests order by name, price, room<br><br>
   * </font>
   * @see showAllAvailable
   * @param date_begin beginning date of period
   * @param date_end end date of period
   * @param price all rooms below this price
   * @return String[] - name:room:price  
   */

  public synchronized String[] showAllAvailable (Date date_begin,Date date_end, long maxPrice)
    {
      String[] buffer = new String[100];
      int r,f;
      if(DEBUG)
	{
	  System.out.println("Method showAllAvailable with parameters: "+date_begin.toString()+","+date_end.toString()+","+maxPrice);
	}

      if(date_begin.after(date_end))
	{
	  if(DEBUG)
	    {
	      System.out.println("...invocated with wrong dates...");
	    }
	  return buffer; 
	}

      try 
	{
	  con = DriverManager.getConnection(url,"fra", "myPassword");
	  stmt = con.createStatement(); 
	  while(free==false)
	    {
	      try
		{
		  wait();
		}
	      catch(InterruptedException e)
		{
		  System.out.println("Interrupted exception: "+e);
		}
	    }
	  free=false;
	  ResultSet rs = stmt.executeQuery("select id, name,  " +
					   "room, price, requests, "+
					   "count(*) as free " +
					   "from Hotels,bookings "+
					   "where (idroom=id and " +
					   "('"+date_begin.toString()+"'>date_end or "+
					   "'"+date_end.toString()+"'<date_begin)) "+
					   "or (requests=0) "+
					   "group by id,name,room,price,requests "+
					   "order by name,price,room;");
	  free=true;
	  notifyAll();
	  int i=0;
	  while (rs.next())
	    {
	      r=rs.getInt("requests");
	      f=rs.getInt("free");
	      if((r==0)||(r!=0&&r==f))
		{
		  buffer[i] = rs.getString("name"); 
		  buffer[i] +=":";
		  buffer[i] += rs.getString("room");
		  buffer[i] +=":";
		  buffer[i] += rs.getString("price");
		  i++;
		}
	    } 
	  stmt.close();
	  con.close();
	}
      catch (SQLException ex) 
	{
	  System.err.println("SQLException: " + ex.getMessage());
	}
      if(DEBUG)
	{
	  System.out.println("...invocated successfully...");
	}      
      return buffer;  
    }
  
  //----------*MAIN*----------------------------
  /**
   * Registers to RMIregistry on socket 7676 as <b>Touring</b>
   */

  public static void main(String argv[]) {
    try {
      // Register an instance of AgenziaServerImpl with the
      // RMI Naming service

      String name = "//localhost:7676/Touring";
      System.out.println("Registering AgenziaServerImpl as \""
                         + name + "\"");
      // create the Agenzia object
      AgenziaServerImpl ag = new AgenziaServerImpl();
      Naming.rebind(name, ag );
      System.out.println("Remote touring ready...");
    }
    catch (Exception e) {
      System.out.println("Caught exception while registering: "
                         + e);
    }
  }
}













