/**
* Console input utility methods for reading
* in a string, integer and a real number
* Uses the System.in.read function
*/

import java.util.*;
import java.sql.Date;

public class Console
{ 
   /**
    * read a string from the console. 
    * @return the input string 
    */
    
   public static String readString()
   {
      char c;
      boolean done = false;
      String s = "";

      //ensures that the system output stream buffer is emptied
      System.out.flush();

      try
      {
        while(!done)
        {
          c = (char)System.in.read();
          if(c == '\n')
            done = true;
          else
            s += c;
        }
      }catch(java.io.IOException e){
        System.out.println(e.toString());
	done = true;
      }
      return s.trim();
    }

  
   /**
    * read an integer from the console. 
    * @return the input value as an int
    */
    
   public static int readInt()
   {  
      while(true)
      {  
         try
         {  
           //calls this class' readString, gets rid of white space
           //then converts the string to an integer
           return Integer.parseInt(readString());
         } catch(NumberFormatException e){  
           System.out.println("Input Error. Please try again!");
         }
      }
   }

   /**
    * read a floating point number from the console. 
    * @return the input value as a double
    */
    
   public static double readDouble()
   {  
      while(true)
      {  
         try
         {  
           //calls this class' readString, gets rid of white space
           //then converts the string to an double
           return Double.valueOf(readString()).doubleValue();
         } catch(NumberFormatException e){  
           System.out.println("Input Error. Write a Number. Please try again!");
         }
      }
   }   
   
  /**
   * read a long format integer number from the console. 
   * @return the input value as a double
   */

  public static long readLong()
   {  
      while(true)
      {  
         try
         {  
           //calls this class' readString, gets rid of white space
           //then converts the string to a double
           return Long.parseLong(readString());
         } catch(NumberFormatException e){  
           System.out.println("Input Error. Write a number. Please try again!");
         }
      }
   }

   /**
    * read a sql-format date from the console. 
    * @return the input value as a double
    */

  public static Date readDate()
    {
      while(true)
	{  
	  try
	    {  
	      //calls this class' readString, gets rid of white space
	      //then converts the string to a java.sql.Date
	      return Date.valueOf(readString());
	    } 
	  catch(Exception e)
	    {  
	      System.out.println("Input Error. Write on form yy-mm-dd. Please try again!");
	    }
	}
    }

   /**
    * write a table to the console. 
    * @param header table header with format: field1:length1:field2:length2:...
    * @param rows table rows with format: field1:field2:...
    * @param delim delimiter for fields, for example ":" 
    * @return void (prints to the screen) 
    */

  public static void writeTable(String header,String[] rows,String delim)
    {
      StringTokenizer t;
      String temp,temp1=" ";
      int[] lengths=new int[20];
      int i=0;
      int j,k=0,l=0;
      t=new StringTokenizer(header,delim);
      while(t.hasMoreTokens())
	{
	  temp=t.nextToken();
	  if(i%2==0)
	    {
	      System.out.print(temp);
	      temp1=temp;
	    }
	  else
	    {
	      lengths[k]=Integer.parseInt(temp);
	      l+=lengths[k];
	      for(j=0;j<lengths[k]-temp1.length();j++)System.out.print(" ");
	      k++;
	    }
	  i++;
	}
      System.out.println();
      for(j=0;j<l;j++)System.out.print("-");
      System.out.println();
      i=0;
      while(rows[i]!=null)
	{
	  t=new StringTokenizer(rows[i],delim);
	  k=0;
	  while(t.hasMoreTokens())
	    {
	      temp=t.nextToken();
	      System.out.print(temp);
	      for(j=0;j<lengths[k]-temp.length();j++)System.out.print(" ");
	      k++;
	    }
	  System.out.println();
	  i++;
	}
    }
}



