
' SCENERY 2.0 (1996-1997)
' 
' Copyright (C) 1996-97, SEAV Softwares
'
' This program written by Eugene Villar a.k.a SEAV (evillar@iname.com).
' Visit my web site at http://www.geocities.com/eavillar
'
' This program generates day and night scenes of a single landscape. The
' pictures shifts to different times of the day through elaborate linear
' transformations of the palette.
'

' [ INITIALIZATION ]

' ---------------------------------------------------------- Declarations ---

   '                                             Declare default data type 
   DEFINT A-Z

   '                                     Declare subroutines and functions 
   DECLARE SUB PAL.SET.COLOR (Col%, Red%, Green%, Blue%)
   DECLARE SUB DELAY (Secs!)
   DECLARE SUB PAL.SHIFT (Iters%)

   '                                                     Declare constants 
   CONST False = 0
   CONST True = NOT False

' ------------------------------------------------------- Display Message ---
   CLS
   PRINT "SCENERY 2.0"
   PRINT
   PRINT "Keys:"
   PRINT "  1,2,3,4,5,6,7,8,9,0,-,=    Display different times"
   PRINT "  Q,W,E                      Run through day and night at diff. speeds"
   PRINT "  Tab                        Switch on/off the lamppost"
   PRINT "  Esc                        Quit"
   PRINT
   PRINT "Press any key to start."
   PRINT
   IN$ = INPUT$(1)


' ------------------------------------------------------------- Load Data ---

   '                                                      Global variables 
   DIM SHARED RunThru
   DIM SHARED LampPost, LampB
   DIM SHARED Time, TimeB, TimeB2

   '                                                     Lamppost schedule 
   DIM SHARED LampSched(1 TO 12)

   FOR I = 1 TO 12
      READ LampSched(I)
   NEXT

   '                                                          Palette data 
   TYPE PaletteType
      R AS INTEGER
      G AS INTEGER
      B AS INTEGER
   END TYPE

   DIM SHARED Palet(1 TO 12, 1 TO 11) AS PaletteType, Misc(16 TO 74) AS PaletteType
  
   FOR I = 1 TO 12
      FOR II = 1 TO 11
         READ Palet(I, II).R
         READ Palet(I, II).G
         READ Palet(I, II).B
      NEXT
   NEXT
   FOR I = 16 TO 74
      READ Misc(I).R
      READ Misc(I).G
      READ Misc(I).B
   NEXT

   '                                                            Stars data 
   TYPE StarsType
      X AS INTEGER
      Y AS INTEGER
      Col AS INTEGER
   END TYPE

   DIM Star(6 TO 10, 1 TO 15) AS StarsType

   FOR I = 6 TO 10
      FOR S = 1 TO 15
         READ Star(I, S).X
         READ Star(I, S).Y
         READ Star(I, S).Col
      NEXT
   NEXT


' [ EXECUTION ]

' ----------------------------------------------------- Initialize screen ---

   '                                                   Enter graphics mode 
   SCREEN 13
   FOR I = 1 TO 13
      PAL.SET.COLOR I, 0, 0, 0
   NEXT
   PAL.SET.COLOR 15, 63, 63, 63

   '                                                          Draw picture 
   DEF SEG = &HA000
   BLOAD "SCENERY.GFX"
   DEF SEG
   CIRCLE (55, 37), 7, 14, , , 1 / 5: LINE (48, 37)-(62, 37), 14


' ------------------------------------------------------------- Main loop ---

   ' Initial values
   LampPost = False
   Time = 1   '10:00am
   TimeB = 8  '12:00pm (for fadein from black effect)
   ChangePeriod = 20

   DO
      '                                                  Shift to new time 
      IF Time <> TimeB THEN
        
         ' Print runthru mode
         IF RunThru THEN
            COLOR 15
            LOCATE 1, 31
            PRINT "Run Mode"
         ELSE
            LOCATE 1, 31
            PRINT "        "
         END IF

         ' Erase miscellaneous objects (when they have faded away)
         SELECT CASE TimeB2
         CASE 1                                 ' Clouds
            DRAW "c1bm82,80r2f2rfer3e2r3f2rfere2r3fe4re2r3fre2r4frerf3rf2e2f4uhdf"
            DRAW "u2huhhlhl3hu2huhhuh3lhl3glgglggluhhl3ggd2llggu2huh3lhl3glg3dllggddgd3fdllggdbe4br4p1,1"
            DRAW "bm319,99u15l3gllgglg5dgd3llhl3gllg2r25bup1,1"
            DRAW "c2bdbfnd19l26dllglggdggd3ffdl3gllgglggdnr42bep2,2"'
            DRAW "c3blbg2gddgd3fd2r9fr9fr8fr9fr7u14l44bdp3,3"
        
         CASE 4                                 ' Sun
            PAINT (260, 50), 1, 1
        
         CASE 6 TO 10                           ' Stars
            FOR S = 1 TO 15
               X1 = Star(TimeB2, S).X
               Y1 = Star(TimeB2, S).Y
               DEF SEG = &HA000
               PSET (X1, Y1), PEEK(Y1 * 320& + X1 + 1)
               DEF SEG
            NEXT
        
         CASE 11                                ' Moon
            PAINT (250, 110), 2, 2
         END SELECT

         ' Draw misc. objects and set palette for fading-in of objects
         LOCATE 1: COLOR 15
         SELECT CASE Time
         CASE 1
            PRINT " 10:00 am"
            PAL.SET.COLOR 16, Palet(TimeB, 1).R, Palet(TimeB, 1).G, Palet(TimeB, 1).B
            PAL.SET.COLOR 17, Palet(TimeB, 2).R, Palet(TimeB, 2).G, Palet(TimeB, 2).B
            PAL.SET.COLOR 18, Palet(TimeB, 3).R, Palet(TimeB, 3).G, Palet(TimeB, 3).B
            DRAW "c16bm82,80r2f2rfer3e2r3f2rfere2r3fe4re2r3fre2r4frerf3rf2e2f4uhdf"
            DRAW "c16u2huhhlhl3hu2huhhuh3lhl3glgglggluhhl3ggd2llggu2huh3lhl3glg3dllggddgd3fdllggdbe4br4p16,16"
            DRAW "bm319,99u15l3gllgglg5dgd3llhl3gllg2r25bup16,16"
            DRAW "c17bdbfnd19l26dllglggdggd3ffdl3gllgglggdnr42bep17,17"'
            DRAW "c18blbg2gddgd3fd2r9fr9fr8fr9fr7u14l44bdp18,18"
         CASE 2
            PRINT " 12:00 nn"
         CASE 3
            PRINT "  2:00 pm"
         CASE 4
            PRINT "  4:00 pm"
            FOR Col = 19 TO 21
               PAL.SET.COLOR Col, Palet(TimeB, 1).R, Palet(TimeB, 1).G, Palet(TimeB, 1).B
            NEXT
            CIRCLE (260, 50), 9, 19: PAINT (260, 50), 19, 19
            CIRCLE (260, 50), 8, 20: PAINT (260, 50), 20, 20
            CIRCLE (260, 50), 7, 21: PAINT (260, 50), 21, 21
         CASE 5
            PRINT "  6:00 pm"
         CASE 6 TO 10
            SELECT CASE Time
            CASE 6: PRINT "  8:00 pm"
            CASE 7: PRINT " 10:00 pm"
            CASE 8: PRINT " 12:00 mn"
            CASE 9: PRINT "  2:00 am"
            CASE 10: PRINT "  4:00 am"
            END SELECT
           
            ColOffset = Time * 10 - 35
            FOR Col = ColOffset TO ColOffset + 7
               PAL.SET.COLOR Col, Palet(TimeB, 1).R, Palet(TimeB, 1).G, Palet(TimeB, 1).B
            NEXT
            PAL.SET.COLOR ColOffset + 8, Palet(TimeB, 2).R, Palet(TimeB, 2).G, Palet(TimeB, 2).B
            PAL.SET.COLOR ColOffset + 9, Palet(TimeB, 3).R, Palet(TimeB, 3).G, Palet(TimeB, 3).B
            FOR S = 1 TO 15
               PSET (Star(Time, S).X, Star(Time, S).Y), Star(Time, S).Col + ColOffset - 1
            NEXT

         CASE 11
            PRINT "  6:00 am"
            FOR Col = 19 TO 24
               PAL.SET.COLOR Col, Palet(TimeB, 2).R, Palet(TimeB, 2).G, Palet(TimeB, 2).B
            NEXT
            CIRCLE (250, 110), 7, 22, 5.64, 2.5
            DRAW "c22bm257,112ggllhllhhlh3br2p22,22"
            DRAW "c23bm257,112ggllhllhhlh3br2 c24bm254,111rglhrurgl2hhlflu3rhgbgh"
         CASE 12
            PRINT "  8:00 am"
         END SELECT
        
         ' Get default lamppost mode (on or off)
         LampPost = LampSched(Time)
        
         ' Shift images
         PAL.SHIFT ChangePeriod
         IF RunThru THEN DELAY ChangePeriod / 80
        
         ' Save previous times
         TimeB2 = TimeB
         TimeB = Time
     
      ELSEIF LampPost <> LampB THEN
        
         ' Switch lamppost
         IF LampPost THEN
            PAL.SET.COLOR 12, 15, 15, 15
            PAL.SET.COLOR 13, 21, 21, 21
            PAL.SET.COLOR 14, 63, 63, 63
         ELSE
            PAL.SET.COLOR 12, Palet(Time, 11).R, Palet(Time, 11).G, Palet(Time, 11).B
            PAL.SET.COLOR 13, Palet(Time, 10).R, Palet(Time, 10).G, Palet(Time, 10).B
            PAL.SET.COLOR 14, 0, 0, 0
         END IF
      END IF
  
      ' Save previous condition of lamppost
      LampB = LampPost
  
      '                                                             Inputs 
      IF RunThru THEN
         ' Continue runthru
         Time = Time + 1
         IF Time = 13 THEN Time = 1
      ELSE
         ChangePeriod = 20

         IN$ = UCASE$(INPUT$(1))
           
         ' Analyze input
         SELECT CASE ASC(IN$)
         CASE 49 TO 57                 ' 1 to 9
            Time = VAL(IN$)
         CASE 48                       ' 0
            Time = 10
         CASE 45                       ' -
            Time = 11
         CASE 61                       ' =
            Time = 12
         CASE 27                       ' ESC
            EXITS = 1
         CASE 9                        ' TAB
            LampPost = NOT LampPost
         CASE 81, 87, 69               ' Q, W, E
            RunThru = True
            Time = Time + 1
            IF Time = 13 THEN Time = 1
            IF IN$ = "Q" THEN
               ChangePeriod = 200
            ELSEIF IN$ = "W" THEN
               ChangePeriod = 50
            ELSE
               ChangePeriod = 10
            END IF
         END SELECT
      END IF

   LOOP UNTIL EXITS = 1

' -------------------------------------------------------- End of program ---
   SCREEN 0
   WIDTH 80
  
   END


' [ DATA ]

' ----------------------------------------------------- Lamppost Schedule ---
   DATA 0,0,0,0,-1,-1,-1,-1,-1,-1,0,0

' ------------------------------------------------------------ Color Data ---

   '                                         Color of scene at diff. times 
   '10A
   DATA 35, 43, 61,   38, 45, 63,   41, 51, 63,   0,  11, 0
   DATA 0,  15, 0,    22, 12, 0,    16, 9,  0,    11, 6,  0
   DATA 53, 53, 53,   20, 20, 20,   15, 15, 15
   '12N
   DATA 34, 45, 63,   37, 47, 63,   40, 53, 63,   0,  10, 0
   DATA 0,  17, 0,    21, 12, 0,    15, 10, 0,    10, 7,  0
   DATA 55, 55, 55,   21, 21, 21,   15, 15, 15
   '2P
   DATA 37, 43, 61,   38, 43, 61,   39, 43, 61,    0,  11, 0
   DATA 0,  14, 0,    19, 12, 0,    12, 6,  0,     8,  4,  0
   DATA 52, 52, 52,   20, 20, 20,   15, 15, 15
   '4P
   DATA 36, 43, 61,   36, 43, 60,   36, 43, 59,    0,  9,  0
   DATA 0,  12, 0,    18, 10, 0,    12, 6,  0,     8,  4,  0
   DATA 52, 52, 50,   19, 19, 18,   15, 15, 15
   '6P
   DATA 51, 25, 0,    56, 34, 0,    61, 61, 0,     0,  4,  0
   DATA 0,  7,  0,    10, 7,  0,    9,  6,  0,     8,  5,  0
   DATA 33, 33, 27,   10, 10, 8,    6,  6,  6
   '8P
   DATA 1,  0,  8,    0,  2,  10,   0,  3,  12,    0,  0,  0
   DATA 0,  1,  0,    3,  2,  0,    2,  1,  0,     0,  0,  0
   DATA 6,  6,  6,    1,  1,  1,    0,  0,  0
   '10P
   DATA 1,  0,  7,    0,  2,  8,    0,  3,  9,    0,  0,  0
   DATA 0,  1,  0,    2,  2,  0,    2,  1,  0,    0,  0,  0
   DATA 5,  5,  5,    1,  1,  1,    0,  0,  0
   '12M
   DATA 1,  0,  6,    0,  1,  7,    0,  2,  8,    0,  1,  1
   DATA 0,  0,  0,    2,  2,  2,    1,  1,  2,    0,  0,  0
   DATA 6,  6,  8,    1,  1,  3,    0,  0,  0
   '2A
   DATA 1,  0,  7,    0,  2,  8,    0,  3,  9,    0,  1,  1
   DATA 0,  0,  0,    1,  1,  6,    1,  1,  3,    0,  0,  1
   DATA 8,  8,  12,   0,  2,  5,    0,  0,  1
   '4A
   DATA 1,  0,  8,    0,  1,  9,    0,  2,  10,    0,  2,  1
   DATA 0,  0,  0,    0,  1,  8,    0,  0,  3,     0,  0,  0
   DATA 8,  8,  13,   0,  2,  6,    0,  0,  2
   '6A
   DATA 15, 15, 31,   14, 14, 26,   13, 13, 24,    0,  6,  0
   DATA 0,  7,  0,    16, 12, 0,    13, 9,  0,     10, 6,  0
   DATA 41, 41, 41,   10, 10, 10,   8,  8,  8
   '8A
   DATA 33, 39, 55,   32, 38, 54,   31, 37, 53,    0,  8,  0
   DATA 0,  11, 0,    25, 15, 0,    17, 11, 0,     11, 7,  0
   DATA 47, 47, 47,   15, 15, 15,   11, 11, 11

   '                                       Colors of miscellaneous objects 
   DATA 63, 63, 63,   63, 63, 63,   63, 63, 63:  'CLOUDS
   DATA 45, 48, 61,   54, 56, 61,   63, 63, 52:  'SUN
   DATA 63, 63, 63,   30, 30, 40,   45, 45, 45:  'MOON
   DATA 63, 63, 63,   45, 55, 60,   50, 50, 55:  'STARS
   DATA 49, 45, 40,   40, 32, 30,   20, 20, 20
   DATA 25, 25, 25,   35, 38, 39,   59, 59, 45
   DATA 31, 35, 31
   DATA 63, 63, 63,   45, 55, 60,   50, 50, 55
   DATA 49, 45, 40,   40, 32, 30,   20, 20, 20
   DATA 25, 25, 25,   35, 38, 39,   62, 55, 63
   DATA 52, 50, 46
   DATA 63, 63, 63,   45, 55, 60,   50, 50, 55
   DATA 49, 45, 40,   40, 32, 30,   20, 20, 20
   DATA 25, 25, 25,   35, 38, 39,   38, 48, 48
   DATA 35, 38, 40
   DATA 63, 63, 63,   45, 55, 60,   50, 50, 55
   DATA 49, 45, 40,   40, 32, 30,   20, 20, 20
   DATA 25, 25, 25,   35, 38, 39,   42, 42, 42
   DATA 55, 50, 53
   DATA 63, 63, 63,   45, 55, 60,   50, 50, 55
   DATA 49, 45, 40,   40, 32, 30,   20, 20, 20
   DATA 25, 25, 25,   35, 38, 39,   35, 39, 41
   DATA 58, 58, 49

   '                                                       Stars positions 
   '8pm
   DATA 10, 20, 1,   20, 40, 2,   40, 69, 7,   50, 79, 3,   70, 31, 4
   DATA 90, 45, 2,   120,34, 8,   123,57, 3,   167,36, 5,   218,93, 8
   DATA 234,88, 4,   250,45, 1,   283,127,10,  300,10, 7,   305,115,9
   '10pm
   DATA 5,  78, 4,   23, 57, 8,   43, 60, 7,   63, 62, 2,   134,70, 3
   DATA 140,24, 5,   172,10, 2,   204,45, 6,   235,55, 1,   239,90, 6
   DATA 267,32, 8,   290,15, 4,   291,113,9,   300,77, 2,   310,120,10
   '12mn
   DATA 7,  44, 2,   22, 68, 3,   62, 65, 8,   69, 8,  4,   102,51, 5
   DATA 115,75, 3,   140,14, 2,   163,67, 4,   175,43, 6,   228,108,9
   DATA 237,92, 5,   240,69, 2,   263,10, 1,   270,124,10,  285,65, 4
   '2am
   DATA 45, 21, 3,   89, 67, 7,   93, 75, 5,   134,10, 2,   178,20, 3
   DATA 190,23, 6,   231,20, 8,   232,89, 3,   256,45, 2,   278,15, 1
   DATA 290,103,9,   302,124,10,  305,123,10,  308,54, 4,   317,95, 8
   '4am
   DATA 7,  24, 1,   22, 10, 4,   62, 45, 7,   69, 55, 1,   102,70, 4
   DATA 140,44, 2,   172,68, 5,   204,65, 8,   235,12, 2,   239,51, 5
   DATA 247,78, 3,   253,41, 6,   293,124,10,  301,40, 3,   302,119,9

'
' A subroutine that stops program execution until Secs! seconds have elapsed.
'
SUB DELAY (Secs!)
  
   Final! = TIMER + Secs!
   IF Final! >= 86400 THEN Final! = Final! - 86400
   DO
      Current! = TIMER
   LOOP UNTIL Current! >= Final! AND ABS(Final! - Current!) < 1000

END SUB

SUB NOTES

'Picture file is "SCENE.GFX"

'COLOR ATTRIBUTES
'  1-3:   Sky
'  4-5:   Greenery
'  6-8:   Hills
'  9-11:  Road, lamppost
'  12-13: Lighted parts of road
'  14:    Lamppost light (bulb area)
'  15:    Message (Always white)
'  16-18: Clouds              Sky #1,2,3
'  19-21: Sun                 Sky #1
'  22-24: Moon                Sky #2
'  25-34: Stars 8pm           last two color numbers for each set
'  35-44: Stars 10pm          of star colors are for sky #2 and sky #3
'  45-54: Stars 12mn
'  55-64: Stars 2am
'  65-74: Stars 4am

'Sun is displayed at 4:00pm
'Stars from 8:00pm till 4:00am
'Moon at 6:00am
'Clouds at 10:00am
'Lamppost is on from 6:00pm till 4:00am (default)

END SUB

'
' Sort of a function that substitutes QBasic's PALETTE command with a
' much faster procedure
'
'    COL - the color attribute to change
'    RED - red color intensity
'  GREEN - green color intensity
'   BLUE - blue color intensity
'          Color intensities must be an integer within the range of 0 to 63.
'
SUB PAL.SET.COLOR (Col, Red, Green, Blue)
  
   'Send the color change instruction to ports
   OUT &H3C8, Col
   OUT &H3C9, Red
   OUT &H3C9, Green
   OUT &H3C9, Blue

END SUB

'
' A procedure which changes the scene from the previous time to the new time
' by shifting the palette of objects on the screen
'
SUB PAL.SHIFT (Iters)

   ' Loop for palette shift
   FOR I = 0 TO Iters
  
      ' Get other linear coefficient (J) for linear transformation
      '  (I * OldValue + J * NewValue) / (I + J) = IntermediateValue
      J = Iters - I

      ' Jump shifting if key is pressed; end runthru
      IF LEN(INKEY$) THEN
         I = Iters
         J = 0
         RunThru = False
         LOCATE 1, 31
         PRINT "        "
      END IF
  
      ' Wait for vertical retrace
      WAIT &H3DA, 8
      WAIT &H3DA, 8, 8
  
      ' Shift scene colors
      FOR Col = 1 TO 11
         RN = (I * Palet(Time, Col).R + J * Palet(TimeB, Col).R) \ Iters
         GN = (I * Palet(Time, Col).G + J * Palet(TimeB, Col).G) \ Iters
         BN = (I * Palet(Time, Col).B + J * Palet(TimeB, Col).B) \ Iters
         PAL.SET.COLOR Col, RN, GN, BN
      NEXT
  
      ' Fade in miscellaneous objects
      SELECT CASE Time
      CASE 1
         ' Fade in clouds
         FOR Col = 16 TO 18
            RN = (I * Misc(Col).R + J * Palet(TimeB, Col - 15).R) \ Iters
            GN = (I * Misc(Col).G + J * Palet(TimeB, Col - 15).G) \ Iters
            BN = (I * Misc(Col).B + J * Palet(TimeB, Col - 15).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
     
      CASE 4
         ' Fadein sun
         FOR Col = 19 TO 21
            RN = (I * Misc(Col).R + J * Palet(TimeB, 1).R) \ Iters
            GN = (I * Misc(Col).G + J * Palet(TimeB, 1).G) \ Iters
            BN = (I * Misc(Col).B + J * Palet(TimeB, 1).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
  
      CASE 6 TO 10
         ' Fadein stars
         ColOffset = Time * 10 - 35
         FOR Col = ColOffset TO ColOffset + 7
            RN = (I * Misc(Col).R + J * Palet(TimeB, 1).R) \ Iters
            GN = (I * Misc(Col).G + J * Palet(TimeB, 1).G) \ Iters
            BN = (I * Misc(Col).B + J * Palet(TimeB, 1).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
         Col = ColOffset + 8
         RN = (I * Misc(Col).R + J * Palet(TimeB, 2).R) \ Iters
         GN = (I * Misc(Col).G + J * Palet(TimeB, 2).G) \ Iters
         BN = (I * Misc(Col).B + J * Palet(TimeB, 2).B) \ Iters
         PAL.SET.COLOR Col, RN, GN, BN
         Col = ColOffset + 9
         RN = (I * Misc(Col).R + J * Palet(TimeB, 3).R) \ Iters
         GN = (I * Misc(Col).G + J * Palet(TimeB, 3).G) \ Iters
         BN = (I * Misc(Col).B + J * Palet(TimeB, 3).B) \ Iters
         PAL.SET.COLOR Col, RN, GN, BN
     
      CASE 11
         ' Fadein moon
         FOR Col = 22 TO 24
            RN = (I * Misc(Col).R + J * Palet(TimeB, 2).R) \ Iters
            GN = (I * Misc(Col).G + J * Palet(TimeB, 2).G) \ Iters
            BN = (I * Misc(Col).B + J * Palet(TimeB, 2).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
     
      END SELECT

      ' Fadeout miscellaneous objects
      SELECT CASE TimeB
      CASE 1
         ' Fadeout clouds
         FOR Col = 16 TO 18
            RN = (I * Palet(Time, Col - 15).R + J * Misc(Col).R) \ Iters
            GN = (I * Palet(Time, Col - 15).G + J * Misc(Col).G) \ Iters
            BN = (I * Palet(Time, Col - 15).B + J * Misc(Col).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
     
      CASE 4
         ' Fadeout sun
         FOR Col = 19 TO 21
            RN = (I * Palet(Time, 1).R + J * Misc(Col).R) \ Iters
            GN = (I * Palet(Time, 1).G + J * Misc(Col).G) \ Iters
            BN = (I * Palet(Time, 1).B + J * Misc(Col).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
     
      CASE 6 TO 10
         ' Fadeout stars
         ColOffset = TimeB * 10 - 35
         FOR Col = ColOffset TO ColOffset + 7
            RN = (I * Palet(Time, 1).R + J * Misc(Col).R) \ Iters
            GN = (I * Palet(Time, 1).G + J * Misc(Col).G) \ Iters
            BN = (I * Palet(Time, 1).B + J * Misc(Col).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
         Col = ColOffset + 8
         RN = (I * Palet(Time, 2).R + J * Misc(Col).R) \ Iters
         GN = (I * Palet(Time, 2).G + J * Misc(Col).G) \ Iters
         BN = (I * Palet(Time, 2).B + J * Misc(Col).B) \ Iters
         PAL.SET.COLOR Col, RN, GN, BN
         Col = ColOffset + 9
         RN = (I * Palet(Time, 3).R + J * Misc(Col).R) \ Iters
         GN = (I * Palet(Time, 3).G + J * Misc(Col).G) \ Iters
         BN = (I * Palet(Time, 3).B + J * Misc(Col).B) \ Iters
         PAL.SET.COLOR Col, RN, GN, BN
     
      CASE 11
         ' Fadeout moon
         FOR Col = 22 TO 24
            RN = (I * Palet(Time, 2).R + J * Misc(Col).R) \ Iters
            GN = (I * Palet(Time, 2).G + J * Misc(Col).G) \ Iters
            BN = (I * Palet(Time, 2).B + J * Misc(Col).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
     
      END SELECT
  
      ' Shift lighted parts of road if lamp is off
      IF LampPost = False AND LampB = False THEN
         FOR Col = 12 TO 13
            RN = (I * Palet(Time, 23 - Col).R + J * Palet(TimeB, 23 - Col).R) \ Iters
            GN = (I * Palet(Time, 23 - Col).G + J * Palet(TimeB, 23 - Col).G) \ Iters
            BN = (I * Palet(Time, 23 - Col).B + J * Palet(TimeB, 23 - Col).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
         PAL.SET.COLOR 14, 0, 0, 0
      END IF
  
      ' Fadein lamppost light
      IF LampPost = True AND LampB = False THEN
         FOR Col = 12 TO 13
            RN = (I * (Col * 6 - 57) + J * Palet(TimeB, 23 - Col).R) \ Iters
            GN = (I * (Col * 6 - 57) + J * Palet(TimeB, 23 - Col).G) \ Iters
            BN = (I * (Col * 6 - 57) + J * Palet(TimeB, 23 - Col).B) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
         CN = INT(I / Iters * 63)
         PAL.SET.COLOR 14, CN, CN, CN
      END IF
  
      ' Fadeout lamppost light
      IF LampPost = False AND LampB = True THEN
         FOR Col = 12 TO 13
            RN = (I * Palet(Time, 23 - Col).R + J * (Col * 6 - 57)) \ Iters
            GN = (I * Palet(Time, 23 - Col).G + J * (Col * 6 - 57)) \ Iters
            BN = (I * Palet(Time, 23 - Col).B + J * (Col * 6 - 57)) \ Iters
            PAL.SET.COLOR Col, RN, GN, BN
         NEXT
         CN = INT(I / Iters * -63 + 63)
         PAL.SET.COLOR 14, CN, CN, CN
      END IF

   NEXT
  
   ' End runthru if a key is pressed
   IF LEN(INKEY$) > 0 AND RunThru = True THEN
      RunThru = False
      LOCATE 1, 31
      PRINT "        "
   END IF

END SUB

