;CODED BY : DA.MoRZ
;EMAIL: p_mdriyaz@hotmail.com



;BOOT.ASM

.386
_TEXT SEGMENT PUBLIC USE16
ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT, GS:_TEXT

ORG 0

;jmp code
db 0EBh,3ch,90h

;BPB block
OEMname db       	  	   'eX-OS   '
bytesPerSector dw          0200h
sectPerCluster db          01h
reservedSectors dw         0001h
numFAT db                  02h
numRootDirEntries dw       00e0h
numSectors dw              0b40h
mediaType db               240d
numFATsectors dw           0009h
sectorsPerTrack dw         0012h
numHeads dw                0002h
numHiddenSectors dd        00000000h
numSectorsHuge dd          00000000h
driveNum db                00h
reserved db                00h
signature db               29h
volumeID dd                00000000h
volumeLabel db             'eX-OS  BOOT'
fileSysType db             'FAT12 '
db 20h,20h

db 0EAh
dw OFFSET entry,7c0h

entry:

;initializations
push 	CS
pop  	DS
xor	ax,ax
push	ax
pop	ES
mov	ax,2000h
push	ax
pop	GS

;load root dir
mov	ax,020eh
mov	bx,1000h
mov	cx,0002h
mov	dx,0100h
int	13h

;load	fat
mov	ax,0209h
mov	bx,3000h
mov	cx,0002h
mov	dx,0000h
int	13h

;search for splash image
mov	si,OFFSET ossplash
mov	bp,0700h
call	search

;set graphics mode
mov	ah,00h
mov	al,13h
int 	10h

mov	bp,0000h;file loading offset
mov	ax,ES:[0700h]
call	loadfile

;arange bytes in order

mov	cx,0c8h;200
mov	bx,09fh;159
mov	bp,bx
mov	dx,0a0h;160
mov	di,0

putagain:
push	bx
mov	bx,dx
mov	al,gs:[bx]
pop	bx
xchg	BYTE PTR gs:[bx],al
push	bx
mov	bx,dx
mov	BYTE PTR gs:[bx],al
pop	bx
sub	bx,di
cmp	bx,0
jz	putdone
add	bx,di
dec	bx
inc	dx
jmp	putagain

putdone:
dec	cx
jz	putimage
mov	bx,bp
add	bx,140h;320
mov	bp,bx
mov	dx,bx
inc	dx
add	di,140h;320
jmp	putagain

putimage:
mov	si,0fa00h
mov	di,0h
mov	ax,0a000h
push	ax
pop	es

nagainn:
mov	al,gs:[si]
mov	BYTE PTR es:[di],al
inc	di
dec	si
jnz	nagainn

kernel:
xor	ax,ax
push	ax
pop	es

;search for next kernel image
mov	si,OFFSET kernelpt
mov	bp,0700h
call	search

;segment where the file is loaded
mov	ax,1000h
push	ax
pop	gs

mov	bp,0000h;file loading offset
mov	ax,ES:[0700h]
call	loadfile

mov	ah,86h
mov	cx,01eh
mov	dx,0ffffh
int	15h

mov	ax,1000h
push 	ax
mov	ax,0000h
push	ax
retf

stop_:
jmp	stop_


;;
;;
;Routines;
;;
;;

;routine to search file in root directory
search:

mov	cx,0e0h
mov	di,1000h
mov	bx,1020h
mov	dx,si

compare:
mov	al,ES:[di]
cmp	al,BYTE PTR DS:[si]

jz	incr
mov	si,dx
dec	cx
jz	nothng
mov	di,bx
add	bx,20h	
jmp	compare

incr:
inc	si
inc	di
mov	al,DS:[si]
or	al,al
jnz	compare

;store cluster number in [bp]
sub	bx,6h
mov	cx,bx
mov	bx,ES:[bx]
mov	WORD PTR ES:[bp],bx

add	cx,2h
add	bp,2h
mov	bx,cx
mov	bx,ES:[bx]
mov	WORD PTR ES:[bp],bx

add	cx,2h
add	bp,2h
mov	bx,cx
mov	bx,ES:[bx]
mov	WORD PTR ES:[bp],bx

jmp	searchover

nothng:
jmp	stop_

searchover:
ret


;perform lba to chs conversion
lbachs:
push	ax
push	bx
push	cx
push	dx
push	bp

mov	bx,ax

mov	cl,12h
div	cl
mov	cl,ah

inc	cl;sector

and	ah,0h
mov	dl,2h
div	dl

mov	dh,ah;head

mov	dl,24h
mov	ax,bx
div	dl

mov	ch,al;cylinder

mov	ax,0201h
pop	bx

mov	dl,0h

push	es
push	gs
pop	es
pop	gs

int	13h

push	es
push	gs
pop	es
pop	gs

pop	dx
pop	cx
pop	bx
pop	ax

ret

loadfile:

doagain:
sub	ax,2h
add	ax,21h

call	lbachs
add	bp,200h

sub	ax,21h
add	ax,2h

mov	dx,3h
mul	dx	
mov	bx,2h
div	bx
add	ax,3000h

push	bx
mov	bx,ax
mov	ax,ES:[bx]
pop	bx

cmp	dx,0h
jz	whole
shr	ax,04h
jmp	shdone

whole:
and	ah,0fh

shdone:
cmp	ax,0ff8h
jae	stopdata

jmp	doagain

stopdata:
ret

;messages to be displayed
ossplash db "OSSPLASHRAW",0
kernelpt db "KERNELPTIMG",0

org 01feh    
dw 0AA55h  
_Text ENDS
END
