#########################################
# PART TWO OF THE                       #
# PE Tools - a toolkit to extend the    #
# possibilities of the sharp 1403(H)    #
# author   : Puehringer Edgar           #
# date     : 17.11.2000                 #
# assembler: PockASM 1.0                #
#########################################

        ORG  &82A8		# 33448 = next free address after 
				# PE Tools part one
# CPU registers

REG_I	EQU  &00              # index register
REG_J   EQU  &01              # index register
REG_A   EQU  &02              # accumulator
REG_B   EQU  &03              # accumulator
REG_XL  EQU  &04              # LSB of adress pointer
REG_XH  EQU  &05              # MSB of adress pointer
REG_YL  EQU  &06              # LSB of adress pointer
REG_YH  EQU  &07              # MSB of adress pointer
REG_K	EQU  &08              # counter
REG_L	EQU  &09              # counter
REG_M	EQU  &0A              # counter
REG_N	EQU  &0B              # counter

#########################################
# SOUND                                 #
# Create some noise with the beeper     #
#                                       #
#########################################

FREQ:   DW 0
DURAT:  DW 0
SOUND:	LIDP FREQ		# Load the freq in B,A
	LII  &01
	LP   REG_A
        MVWD

	LP   REG_L		# L is &01 if A ^ &02 # 0
	ANIM &00
	ORMA
	ANIM &02
	EXAM
	RC
	SR
	EXAM
	LP   REG_M		# M is &01 if A ^ &01 # 0
	ANIM &00
	ORMA
	ANIM &01
	RC			# B,A >> 2:
	EXAB
	SR			# Shift B
	EXAB
	SR			# Shift A
	EXAB
	SR			# Shift B
	EXAB
	SR			# Shift A
	LP   REG_K		# A --> K
	EXAM

	LP   REG_L		# L --> A
	LDM
	LP   REG_N		# A (L) --> N
	EXAM
	LP   REG_M		# M --> A
	LDM
	LP   REG_N		# N (L) ^ A (M) --> N
	ANMA

	LP   REG_L		# L --> A
	LDM
	LP   REG_M		# A (L) v M --> M
	ORMA

	LP   REG_K		# Restore K
	LDM

	LP   REG_L		# A + L --> L
	ADM
	LP   REG_M		# A + M --> M
	ADM
	LP   REG_N		# A + N --> N
	ADM
	# Now set the wait operation parameters
	LP   REG_K
	LDM
	LIDP CPOS1+1
	STD
	LP   REG_L
	LDM
	LIDP CPOS2+1
	STD
	LP   REG_M
	LDM
	LIDP CPOS3+1
	STD
	LP   REG_N
	LDM
	LIDP CPOS4+1
	STD

	LIDP DURAT		# Load the duration in A
	LDD
	LP   REG_I		# and move it to I
	EXAM

	# If freq < 52, go on, else do a duration liniarization
        LP   REG_K
	LDM
	CPIA 52               # K < 52 ?
JR62S:	JRCP CHKI-JR62S-1

	# Move content of K to M
	LP   REG_K
	LDM
	LP   REG_M
	EXAM

	LP   REG_XL		# 153 - (K >> 1) --> X
	LIA  153
	EXAM
	LP   REG_K
	LDM
	RC
	SR
	LP   REG_XL
	SBM
	INCP
	RA
	EXAM

	LP   REG_I		# I --> Y
	LDM
	LP   REG_YL
	EXAM
	INCP
	RA
	EXAM

	CALL MULT		# multiply !

	# Make a left shift of L,K and use L as result
	# This is equal to a division by 128
	LP   REG_K
	LDM
	SL
	INCP
	LDM
	SL
	LP   REG_I
	EXAM

CHKI:	LP   REG_I
	LDM
	CPIA 0			# I = 0 ?
JR63S:	JRNZP CPOS1-JR63S-1
	INCI

CPOS1:	WAIT &00		# 6 + Par. 1
CPOS2:	WAIT &00		# 6 + Par. 2
	LIP  &5F		# 4
SNDOP:	ORIM &10		# 4
	OUTC			# 2
CPOS3:	WAIT &00		# 6 + Par. 1
CPOS4:	WAIT &00		# 6 + Par. 2
	ANIM &EF		# 4
	OUTC			# 2
	TEST &02		# 4
JR60S:	JRZM JR60S-CPOS1+1	# 7 (taken)
	DECI			# 51 + 4*Par.
JR61S:	JRNZM JR61S-CPOS1+1	# do the loop
	RTN
	NOPW			# Reserve instructions for
        NOPW			# future releases
        NOPW
        NOPW
        NOPW

#########################################
# MULT                                  #
# 16 bit multiplikation                 #
#                                       #
# input XH,XL: Factor 1                 #
# input YH,YL: Factor 2                 #
#                                       #
# output K,L: Result                    #
#########################################

MULT:	LIB  &10		# Number of loop counts
        RA			# Initialize
        LP   REG_K		# K
        LII  &01		# and
        FILM			# L
JR78E:	LP   REG_K		# Write #0
        LDM			# to the first bit
	RC			# of
	SL			# K
	EXAM			# The 7th bit is now in the carry
	INCP			# Write carry
	LDM			# to first bit of L
	SL			# The 7th bit is now
	EXAM			# in the carry
JR75S:	JRCP JR75E-JR75S-1	# Jump to end, if carry = 1
	RC			# Write #0
        LP   REG_XL		# to the first bit
        LDM			# of
	SL			# XL
	EXAM			# The 7th bit is now in the carry
	INCP			# Write carry
	LDM			# to first of XH
	SL			# The 7th bit is now
	EXAM			# in the carry
JR76S:	JRNCP JR76E-JR76S-1	# Jump if carry = 0
	RC			# Write #0 to carry
	LP   REG_YL
	LDM
	LP   REG_K		# Add
	ADM
	LP   REG_YH
	LDM			# Write the result to K
	LP   REG_L		# and L
	ADCM
JR77S:	JRCP JR75E-JR77S-1	# Jump to end, if carry = 1
JR76E:	DECB			# B = B-1
JR78S:	JRNZM JR78S-JR78E+1	# if B is not zero, do the loop
JR75E:	RTN
	NOPW			# Reserve instructions for
        NOPW			# future releases
        NOPW
        NOPW
        NOPW

#########################################
# SOUND ON/OFF                          #
# enables/disables sound output of the  #
# SOUND routine                         #
#                                       #
# The routine has two entry points:     #
# - SNDON: enable sound output          #
# - SNDOF: disable sound output         #
#########################################

SNDON:	LP   REG_XL		
	LIA  &61		# Opcode of 'ORIM'
	EXAM
	LP   REG_XH
	LIA  &10
	EXAM
JR80S:	JRP  SNDOO-JR80S-1
SNDOF:	LP   REG_XL		
	LIA  &60		# Opcode of 'ANIM'
	EXAM
	LP   REG_XH
	LIA  &EF
	EXAM
SNDOO:	LP   REG_XL             # Copy 2 bytes from registers
	LIDP SNDOP              # to the memory location of
	LII  &01		# of sound routine
	EXWD
	RTN
	NOPW			# Reserve instructions for
        NOPW			# future releases
        NOPW
        NOPW
        NOPW
