From: Lord Crc <lordcrc@hotmail.com>
Newsgroups: borland.public.delphi.graphics
Subject: Re: Curved line
Date: Sat, 05 May 2001 00:56:22 +0200
Message-ID: <45b6ft4dl5fcisotl2idcae21hg32jc27t@4ax.com>
References: <3af2da1c_1@dnews>
X-Newsreader: Forte Agent 1.8/32.548
MIME-Version: 1.0
Content-Type: text/plain; charset=ISO-8859-1
Content-Transfer-Encoding: 8bit
NNTP-Posting-Host: 212.45.165.37
X-Trace: dnews 989017030 212.45.165.37 (4 May 2001 15:57:10 -0700)
Lines: 71
Path: dnews
Xref: dnews borland.public.delphi.graphics:38593

On Fri, 4 May 2001 17:30:11 +0100, "Chris Bell" <cbell@metastorm.com>
wrote:

>Hi all
>
>I know 3 points in a curved line and I'd like to draw the line to join them.
>I've looked at the TCanvas methods, but none of them seem to be ideal. I
>presume I can do it some how with Arc, but anybody know how I translate from
>my three points to the required parameters?

i use something that i know as a cubic spline/curve (if someone know a
more correct name, please let me know :)

it goes something like this:

procedure DrawCubicCurve(Canvas: TCanvas; 
  const Points: array of TPoint; Steps: cardinal);

  function Interpolate(const p1, p2, p3, p4: TPoint; 
    t: single): TPoint;
    
    function cubic(v1, v2, v3, v4, t: single): single;
    begin
      result:= v2 + t*((-v1 + v3) +
       t*((2*v1 - 2*v2 + v3 - v4) + 
       t*(-v1 + v2 - v3 + v4)));
    end;
  begin
    Result.x:= round(cubic(p1.x, p2.x, p3.x, p4.x, t));
    Result.y:= round(cubic(p1.y, p2.y, p3.y, p4.y, t));
  end;

var
  i, s: integer;
  p, p1, p2, p3, p4: TPoint;
begin
  if Length(Points) < 2 then
    exit;

  Canvas.MoveTo(Points[0].x, Points[0].y);

  p2:= Points[0];
  p3:= Points[0];
  p4:= Points[1];

  for i:= 0 to High(Points)-1 do
  begin
    p1:= p2;
    p2:= p3;
    p3:= p4;
    if i+2 < Length(Points) then
      p4:= Points[i+2];

    for s:= 1 to Steps do
    begin
      p:= Interpolate(p1, p2, p3, p4, s / Steps);

      Canvas.LineTo(p.x, p.y);
    end;
  end;
end;


It accepts from 2 points and upwards, and it will interpolate through
all the vertices (unlike say bezier type curves). The more steps you
use the smoother it will be. I assume you could try to apply some sort
of automatic calculation of the number of steps required based on the
distance and angle between the next and the previous point, but this
works for me :)

- Asbjrn