unit MainUnit;

(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Graphics32
 *
 * The Initial Developer of the Original Code is
 * Alex A. Denisov
 *
 * Portions created by the Initial Developer are Copyright (C) 2000-2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** *)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  GR32, GR32_Image, GR32_Layers, GR32_Polygons, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Image: TImage32;
    Panel1: TPanel;
    Antialiase: TCheckBox;
    Label1: TLabel;
    LineAlpha: TScrollBar;
    Label2: TLabel;
    FillAlpha: TScrollBar;
    FillMode: TRadioGroup;
    Button1: TButton;
    BitmapList: TBitmap32List;
    Memo1: TMemo;
    Memo2: TMemo;
    SplineCurve: TCheckBox;
    SplineSteps: TScrollBar;
    GroupBox1: TGroupBox;
    ThickOutline: TCheckBox;
    LineThickness: TScrollBar;
    AntialiasMode: TRadioGroup;
    Label3: TLabel;
    PixelRaster: TScrollBar;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ImageMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
    procedure ImageResize(Sender: TObject);
    procedure ParamsChanged(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    Polygon: TPolygon32;
    CurvePolygon: TPolygon32;
    Outline: TPolygon32;
    UseOutlinePoly: Boolean;
    LineSize: Single;
    procedure Build;
    procedure Draw;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Draw;
begin
  Image.Bitmap.BeginUpdate;
  Image.Bitmap.Clear(clWhite32);
  Image.Bitmap.Draw(50, 50, BitmapList.Bitmaps[0].Bitmap);
  Polygon.Antialiased := Antialiase.Checked;
  Polygon.AntialiasMode := TAntialiasMode(AntialiasMode.ItemIndex);

  if UseOutlinePoly then
  begin
    Outline.Antialiased := Antialiase.Checked;
    Outline.AntialiasMode := TAntialiasMode(AntialiasMode.ItemIndex);
  end;

  if FillMode.ItemIndex = 0
  then Polygon.FillMode := pfAlternate
  else Polygon.FillMode := pfWinding;

  if SplineCurve.Checked
  then begin
    // draw spline curve
    CurvePolygon := Polygon.Curve (SplineSteps.Position);
    CurvePolygon.DrawFill(Image.Bitmap, SetAlpha(clGreen32, FillAlpha.Position));
    if UseOutlinePoly
    then Outline.DrawFill(Image.Bitmap, SetAlpha(clBlack32, LineAlpha.Position))
    else CurvePolygon.DrawEdge(Image.Bitmap, SetAlpha(clBlack32, LineAlpha.Position));
  end
  else begin
    // draw normal polygon
    Polygon.DrawFill(Image.Bitmap, SetAlpha(clGreen32, FillAlpha.Position));

    if UseOutlinePoly
    then Outline.DrawFill(Image.Bitmap, SetAlpha(clBlack32, LineAlpha.Position))
    else Polygon.DrawEdge(Image.Bitmap, SetAlpha(clBlack32, LineAlpha.Position));
  end;

  Image.Bitmap.EndUpdate;
  Image.Bitmap.Changed;
  Image.Refresh;   // force repaint
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Image.SetupBitmap;
  Polygon := TPolygon32.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Outline.Free;
  Polygon.Free;
end;

procedure TForm1.ImageMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
begin
  case Button of
    mbLeft: begin
              if PixelRaster.Position > 1 then begin
                X := Trunc(X div PixelRaster.Position) * PixelRaster.Position;
                Y := Trunc(Y div PixelRaster.Position) * PixelRaster.Position;
              end;
              Polygon.Add(FixedPoint(X, Y));
            end;
    mbMiddle: Polygon.DeleteLastPoint;
    mbRight:  Polygon.Clear;
  end;
  Build;
  Draw;
end;

procedure TForm1.ImageResize(Sender: TObject);
begin
  Image.SetupBitmap;
  Build;
  Draw;
end;

procedure TForm1.ParamsChanged(Sender: TObject);
begin
  AntialiasMode.Enabled := Antialiase.Checked and ThickOutline.Checked;
  SplineCurve.Caption := Format ('Spline Curve (%d)', [splineSteps.Position]);
  Label1.Caption := Format ('Line Opacity (%d)', [LineAlpha.Position]);
  Label2.Caption := Format ('Fill Opacity (%d)', [FillAlpha.Position]);
  Label3.Caption := Format ('Pixel Raster (%d)', [PixelRaster.Position]);
  UseOutlinePoly := ThickOutline.Checked;
  LineSize := LineThickness.Position / 10;
  Build;
  Draw;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Polygon.NewLine;
end;

procedure TForm1.Build;
var
  TmpPoly, tmp2Poly: TPolygon32;
begin
  Outline.Free;
  Outline := nil;

  if UseOutlinePoly then
  begin
    if SplineCurve.Checked
    then begin
      Tmp2Poly := Polygon.Curve (SplineSteps.Position);
      TmpPoly := Tmp2Poly.Outline;
      TmpPoly.Closed := true;
      if high(tmpPoly.points[0]) > 1
      then TmpPoly.Add (TmpPoly.Points[1][1]);

      Tmp2Poly.Free;
    end else TmpPoly := Polygon.Outline;
    Outline := TmpPoly.Grow(Fixed(LineSize / 2), 0.5);
    Outline.FillMode := pfWinding;
    TmpPoly.Free;
    ThickOutline.Caption := Format ('enable (%.1f)', [LineSize])
  end
  else ThickOutline.Caption := 'enable (1)';
end;

end.
