//////////////////////////////////////////////////
// EASIM project
// easim.draw.AddLinkControl
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

import javax.swing.JOptionPane;

public class AddLinkControl implements Control
{
	public void mousePressed(Frame frame, int x, int y) {
		Node node = frame.field.getNode(x, y);
		if (frame.selectedNode == null) {
			frame.selectedNode = node;
			frame.panel.repaint();
		}
		else {
			if (node == null) {
				frame.selectedNode = null;
				frame.panel.repaint();
			}
			else if (! frame.selectedNode.equals(node)) {
				Link link = new Link();
				link.lineStyle = frame.lineStyle.toString();
     		link.thickness = frame.thickness;
     		link.arrow = frame.arrow.toString();
				boolean added = frame.field.addLink(link, frame.selectedNode.id, node.id);
				if (added) {
					frame.panel.repaint();
					link.label = (String)JOptionPane.showInputDialog(
						frame, "Label", "Add Link",
						JOptionPane.QUESTION_MESSAGE, null, null, null);
				}
				frame.selectedNode = null;
				frame.panel.repaint();
			}
		}
	}

	public void mouseMoved(Frame frame, int x, int y) {
		AddNodeControl.mouseMoved2(frame, x, y);
	}

	public void mouseDragged(Frame frame, int x, int y) {
		AddNodeControl.mouseDragged2(frame, x, y);
	}
}
