//////////////////////////////////////////////////
// EASIM project
// easim.draw.EditLinkControl
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

public class EditLinkControl implements Control
{

  private String menu;

  public EditLinkControl(String menu) {
    this.menu = menu;
  }

	public void mousePressed(Frame frame, int x, int y) {
		Node node = frame.field.getNode(x, y);
		if (frame.selectedNode == null) {
			frame.selectedNode = node;
			frame.panel.repaint();
		}
		else {
			if (node == null) {
				frame.selectedNode = null;
				frame.panel.repaint();
			}
			else if (! frame.selectedNode.equals(node)) {
				Link link = frame.field.getLink(frame.selectedNode.id, node.id);
				if (link != null) {
          if (menu.equals("Edit Link Line Style")) {
            Setting.LineStyle lineStyle = SettingMenu.lineStyle(frame, "Edit Link " + link.label);
            if (lineStyle != null) link.lineStyle = lineStyle.toString();
          }
          else if (menu.equals("Edit Link Label")) {
            String label = EditNodeControl.getInput(frame, "Edit Link " + link.label, "Link Label", link.label);
            if (label != null) link.label = label;
          }
          else if (menu.equals("Edit Link Thickness")) {
            int thickness = SettingMenu.thickness(frame, "Edit Link " + link.label);
            if (thickness != -1) link.thickness = thickness;
          }
          else if (menu.equals("Edit Link Arrow")) {
            Setting.Arrow arrow = SettingMenu.arrow(frame, "Edit Link " + link.label);
            if (arrow != null) link.arrow = arrow.toString();
          }
				}
				frame.selectedNode = null;
				frame.panel.repaint();
			}
		}
	}

	public void mouseMoved(Frame frame, int x, int y) {
		AddNodeControl.mouseMoved2(frame, x, y);
	}

	public void mouseDragged(Frame frame, int x, int y) {
		AddNodeControl.mouseDragged2(frame, x, y);
	}
}
