//////////////////////////////////////////////////
// EASIM project
// easim.draw.EditMenu
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

import javax.swing.JMenu;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.ButtonGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EditMenu extends JMenu
{
	private Frame frame;
	private JCheckBoxMenuItem addNode;
	private JCheckBoxMenuItem addLink;
	private JCheckBoxMenuItem removeNode;
	private JCheckBoxMenuItem removeLink;
	private JMenu editNode;
	private JCheckBoxMenuItem editNodePosition;
	private JCheckBoxMenuItem editNodeSize;
	private JCheckBoxMenuItem editNodeLabel;
	private JCheckBoxMenuItem editNodeLineStyle;
	private JCheckBoxMenuItem editNodeThickness;
	private JMenu editLink;
	private JCheckBoxMenuItem editLinkLabel;
	private JCheckBoxMenuItem editLinkLineStyle;
	private JCheckBoxMenuItem editLinkThickness;
	private JCheckBoxMenuItem editLinkArrow;

	public EditMenu(Frame frame) {
		super("Edit");
		this.frame = frame;
		this.addNode = new JCheckBoxMenuItem("Add Node");
		this.addLink = new JCheckBoxMenuItem("Add Link");
		this.removeNode = new JCheckBoxMenuItem("Remove Node");
		this.removeLink = new JCheckBoxMenuItem("Remove Link");
		this.editNode = new JMenu("Edit Node");
	  this.editNodePosition = new JCheckBoxMenuItem("Edit Node Position");
	  this.editNodeSize = new JCheckBoxMenuItem("Edit Node Size");
	  this.editNodeLabel = new JCheckBoxMenuItem("Edit Node Label");
	  this.editNodeLineStyle = new JCheckBoxMenuItem("Edit Node Line Style");
	  this.editNodeThickness = new JCheckBoxMenuItem("Edit Node Thickness");
    this.editNode.add(this.editNodePosition);
    this.editNode.add(this.editNodeSize);
    this.editNode.add(this.editNodeLabel);
    this.editNode.add(this.editNodeLineStyle);
    this.editNode.add(this.editNodeThickness);
		this.editLink = new JMenu("Edit Link");
		this.editLinkLabel = new JCheckBoxMenuItem("Edit Link Label");
		this.editLinkLineStyle = new JCheckBoxMenuItem("Edit Link Line Style");
		this.editLinkThickness = new JCheckBoxMenuItem("Edit Link Thickness");
		this.editLinkArrow = new JCheckBoxMenuItem("Edit Link Arrow");
    this.editLink.add(this.editLinkLabel);
    this.editLink.add(this.editLinkLineStyle);
    this.editLink.add(this.editLinkThickness);
    this.editLink.add(this.editLinkArrow);
		this.add(this.addNode);
		this.add(this.addLink);
		this.add(this.removeNode);
		this.add(this.removeLink);
		this.add(this.editNode);
		this.add(this.editLink);
		ButtonGroup group = new ButtonGroup();
		group.add(this.addNode);
		group.add(this.addLink);
		group.add(this.removeNode);
		group.add(this.removeLink);
		group.add(this.editNodePosition);
		group.add(this.editNodeSize);
		group.add(this.editNodeLabel);
		group.add(this.editNodeLineStyle);
		group.add(this.editNodeThickness);
		group.add(this.editLinkLabel);
		group.add(this.editLinkLineStyle);
		group.add(this.editLinkThickness);
		group.add(this.editLinkArrow);
		this.addNode.setSelected(true);
		this.addNode.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (addNode.isSelected()) {
					addNode();
				}
			}
		});
		this.addLink.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (addLink.isSelected()) {
					addLink();
				}
			}
		});
		this.removeNode.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (removeNode.isSelected()) {
					removeNode();
				}
			}
		});
		this.removeLink.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (removeLink.isSelected()) {
					removeLink();
				}
			}
		});
		this.editNodePosition.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editNodePosition.isSelected()) {
					editNode(editNodePosition.getText());
				}
			}
		});
		this.editNodeSize.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editNodeSize.isSelected()) {
					editNode(editNodeSize.getText());
				}
			}
		});
		this.editNodeLabel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editNodeLabel.isSelected()) {
					editNode(editNodeLabel.getText());
				}
			}
		});
		this.editNodeLineStyle.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editNodeLineStyle.isSelected()) {
					editNode(editNodeLineStyle.getText());
				}
			}
		});
		this.editNodeThickness.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editNodeThickness.isSelected()) {
					editNode(editNodeThickness.getText());
				}
			}
		});
		this.editLinkLabel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editLinkLabel.isSelected()) {
					editLink(editLinkLabel.getText());
				}
			}
		});
		this.editLinkLineStyle.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editLinkLineStyle.isSelected()) {
					editLink(editLinkLineStyle.getText());
				}
			}
		});
		this.editLinkThickness.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editLinkThickness.isSelected()) {
					editLink(editLinkThickness.getText());
				}
			}
		});
		this.editLinkArrow.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (editLinkArrow.isSelected()) {
					editLink(editLinkArrow.getText());
				}
			}
		});
	}
	
	private void addNode() {
		this.frame.selectedNode = null;
		this.frame.control = new AddNodeControl();
		this.frame.panel.repaint();
	}

	private void addLink() {
		this.frame.selectedNode = null;
		this.frame.control = new AddLinkControl();
		this.frame.panel.repaint();
	}

	private void removeNode() {
		this.frame.selectedNode = null;
		this.frame.control = new RemoveNodeControl();
		this.frame.panel.repaint();
	}

	private void removeLink() {
		this.frame.selectedNode = null;
		this.frame.control = new RemoveLinkControl();
		this.frame.panel.repaint();
	}

	private void editNode(String menu) {
		this.frame.selectedNode = null;
		this.frame.control = new EditNodeControl(menu);
		this.frame.panel.repaint();
	}

	private void editLink(String menu) {
		this.frame.selectedNode = null;
		this.frame.control = new EditLinkControl(menu);
		this.frame.panel.repaint();
	}

}