//////////////////////////////////////////////////
// EASIM project
// easim.draw.EditNodeControl
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

import javax.swing.JOptionPane;

public class EditNodeControl implements Control
{

  private String menu;

  public EditNodeControl(String menu) {
    this.menu = menu;
  }

	public void mousePressed(Frame frame, int x, int y) {
		Node node = frame.field.getNode(x, y);
		if (node == null) return;
		frame.selectedNode = node;
		frame.panel.repaint();
    if (menu.equals("Edit Node Position")) {
      while (true) {
        x = node.x;
        y = node.y;
        String pos = getInput(frame, "Edit Node " + node.label, "Position", x + "," + y);
        if (pos == null) break;
        String[] poss = pos.split(",");
        if (poss.length != 2) continue;
        try {
          x = Integer.parseInt(poss[0]);
          y = Integer.parseInt(poss[1]);
        } catch (NumberFormatException ex) {
          continue;
        }
        if (x < 0 || x > frame.field.width) continue;
        if (y < 0 || y > frame.field.height) continue;
        node.x = x;
        node.y = y;
        break;
      }
    }
    else if (menu.equals("Edit Node Size")) {
      int size = SettingMenu.nodeSize(frame, "Edit Node " + node.label);
      if (size != -1) node.size = size;
    }
    else if (menu.equals("Edit Node Label")) {
      String label = getInput(frame, "Edit Node " + node.label, "Node Label", node.label);
      if (label != null) node.label = label;
    }
    else if (menu.equals("Edit Node Line Style")) {
      Setting.LineStyle lineStyle = SettingMenu.lineStyle(frame, "Edit Node " + node.label);
      if (lineStyle != null) node.lineStyle = lineStyle.toString();
    }
    else if (menu.equals("Edit Node Thickness")) {
      int thickness = SettingMenu.thickness(frame, "Edit Node " + node.label);
      if (thickness != -1) node.thickness = thickness;
    }
		frame.selectedNode = null;
		frame.panel.repaint();
	}

	public void mouseMoved(Frame frame, int x, int y) {
		AddNodeControl.mouseMoved2(frame, x, y);
	}

	public void mouseDragged(Frame frame, int x, int y) {
		AddNodeControl.mouseDragged2(frame, x, y);
	}

	public static String getInput(Frame frame, String title, String text, String value) {
		return (String)JOptionPane.showInputDialog(
			frame, text, title,
			JOptionPane.QUESTION_MESSAGE, null, null, value);
	}

}
