//////////////////////////////////////////////////
// EASIM project
// easim.draw.Field
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

import java.util.HashSet;
import java.util.HashMap;
import java.util.Iterator;
import java.awt.Graphics;
import java.awt.Color;

public class Field
{
	public static final int MIN_NODE_SIZE = 9;
	public static final int MAX_NODE_SIZE = 100;

	public static final int MAX_THICKNESS = 7;

	public int width;

	public int getWidth() {
		return this.width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int height;

	public int getHeight() {
		return this.height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	protected HashMap nodes = new HashMap();

	public HashMap getNodes() {
		return this.nodes;
	}

	public void setNodes(HashMap nodes) {
		this.nodes = nodes;
	}

	protected HashMap links = new HashMap();

	public HashMap getLinks() {
		return this.links;
	}

	public void setLinks(HashMap links) {
		this.links = links;
	}

	public boolean addNode(Node node) {
		if (this.nodes.get(node.id) != null) return false;
		this.nodes.put(node.id, node);
		return true;
	}

	public Node getNode(int x, int y) {
		Node best = null;
		int bestDis2 = Integer.MAX_VALUE;
    Iterator it = this.nodes.values().iterator();
    while (it.hasNext()) {
		  Node node = (Node)it.next();
			int dx = node.x - x;
			int dy = node.y - y;
			int dis2 = dx * dx + dy * dy;
			int r2 = node.size * node.size;
			if (dis2 < r2 && dis2 < bestDis2) {
				best = node;
				bestDis2 = dis2;
			}
		}
		return best;
	}

	public Node getNode(String id) {
		return (Node)this.nodes.get(id);
	}

	public HashSet getAllNodes() {
		return new HashSet(this.nodes.values());
	}

	public Node removeNode(String id) {
		Node node = (Node)this.nodes.remove(id);
		if (node == null) return null;
		HashSet links = new HashSet(this.links.keySet());
    Iterator it = links.iterator();
    while (it.hasNext()) {
      String link = (String)it.next();
			String[] nodes = link.split("-");
			if (nodes[0].equals(node.id) || nodes[1].equals(node.id)) {
				this.links.remove(link);
			}
		}
		return node;
	}

	public boolean addLink(Link link, String node1, String node2) {
		if (node1.equals(node2)) return false;
		if (node1.compareTo(node2) > 0) {
			String temp = node1;
			node1 = node2;
			node2 = temp;
		}
		String name = node1 + "-" + node2;
		if (this.links.containsKey(name)) return false;
		this.links.put(name, link);
		return true;
	}

	public Link removeLink(String node1, String node2) {
		if (node1.compareTo(node2) > 0) {
			String temp = node1;
			node1 = node2;
			node2 = temp;
		}
		String name = node1 + "-" + node2;
		return (Link)this.links.remove(name);
	}

	public Link getLink(String node1, String node2) {
		if (node1.compareTo(node2) > 0) {
			String temp = node1;
			node1 = node2;
			node2 = temp;
		}
		String name = node1 + "-" + node2;
		return (Link)this.links.get(name);
	}

	public void paint(Graphics graphics) {
    Painter.paint(graphics, this);
	}

}
