//////////////////////////////////////////////////
// EASIM project
// easim.draw.FieldPanel
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

import javax.swing.JPanel;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class FieldPanel extends JPanel
{
	private Frame frame;

	public FieldPanel(Frame frame) {
		this.frame = frame;
		this.setupMouseEventHandlers();
	}

	public void paint(Graphics graphics) {
		this.frame.field.width = this.getWidth();
		this.frame.field.height = this.getHeight();
		this.frame.field.paint(graphics);
		if (this.frame.selectedNode != null) {
			Painter.paint(graphics, this.frame.selectedNode, Color.RED);
		}
	}

	private void setupMouseEventHandlers() {
		this.addMouseListener(new MouseListener() {
			public void mouseClicked(MouseEvent e) {
			}
			public void mouseEntered(MouseEvent e) {
			}
			public void mouseExited(MouseEvent e) {
			}
			public void mousePressed(MouseEvent e) {
				if (e.getButton() == MouseEvent.BUTTON1) {
					frame.control.mousePressed(frame, e.getX(), e.getY());
				}
			}
			public void mouseReleased(MouseEvent e)	 {
			}	
		});
		this.addMouseMotionListener(new MouseMotionListener() {
			public void mouseDragged(MouseEvent e) {
				frame.control.mouseDragged(frame, e.getX(), e.getY());
			}
			public void mouseMoved(MouseEvent e) {
				frame.control.mouseMoved(frame, e.getX(), e.getY());
			}
		});
	}
}
