//////////////////////////////////////////////////
// EASIM project
// easim.draw.Frame
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.Dimension;
import java.util.HashSet;
import java.io.IOException;

public class Frame extends JFrame
{
	public Field field = new Field();
	public Control control = new AddNodeControl();
	public FieldPanel panel;
	public Setting.NodeLabels nodeLabels = Setting.NodeLabels.NUMBERS;
	public Setting.LineStyle lineStyle = Setting.LineStyle.SOLID_LINE;
	public int nodeSize = Field.MIN_NODE_SIZE;
	public Setting.Arrow arrow = Setting.Arrow.NONE;
	public int thickness = 1;
	public Node selectedNode;

	public Frame() {
		JMenuBar menuBar = new JMenuBar();
		this.setJMenuBar(menuBar);
		menuBar.add(new FileMenu(this));
		menuBar.add(new EditMenu(this));
		menuBar.add(new SettingMenu(this));
		this.panel = new FieldPanel(this);
		this.panel.setPreferredSize(new Dimension(600, 400));
		this.setTitle("NetDraw");
		this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(this.panel, BorderLayout.CENTER);
		this.pack();
		this.setVisible(true);
	}

	public void setField(Field field) {
		this.selectedNode = null;
		this.field = field;
		this.panel.setPreferredSize(new Dimension(this.field.width, this.field.height));
		this.pack();
		this.validate();
		this.panel.repaint();
	}

	public void setField(String file) throws IOException {
		this.setField(FileMenu.openXML(file));
	}

	public static void main(String[] args) throws IOException {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
		}
		Frame frame = new Frame();
		if (args.length != 0) {
			frame.setField(args[0]);
		}
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
}
