//////////////////////////////////////////////////
// EASIM project
// easim.draw.Line
// 6/7/2007 4:26 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

public class Line
{
	int	object_code = 2;		//(always 2)
	int sub_type = 1;		//(1: polyline
					// 2: box
					// 3: polygon
					// 4: arc-box)
					// 5: imported-picture bounding-box)
	int line_style;		// (2/0) (enumeration type)
	int thickness = 1;		//(1/80 inch)
	int pen_color = 0;		//(enumeration type, pen color)
	int fill_color = 7;		//(enumeration type, fill color)
	int depth = 800;			//(enumeration type)
	int pen_style = 1;		//(pen style, not used)
	int area_fill = -1;		//(enumeration type, -1 = no fill)
	double style_val = 1.0;		//(1/80 inch)
	int join_style = 0;		//(enumeration type)
	int cap_style = 0;		//(enumeration type, only used for POLYLINE)
	int radius = 12;			//(1/80 inch, radius of arc-boxes)
	int forward_arrow = 0;		//(0: off, 1: on)
	int backward_arrow = 0;		//(0: off, 1: on)
	int npoints = 2;			//(number of points in line)
	int x1;
	int y1;
	int x2;
	int y2;

/*
2 1 2 1 0 0 100 1 -1  1.00 0 0 12 0 0 2
       -900 1125 1350 1125
2 1 0 1 0 0 100 1 -1  6.40 0 0 12 0 0 2
       -450 1800 1800 1800
2 1 0 2 0 0 100 1 -1  6.40 0 0 12 0 0 2
       0 2362 2137 2362
*/

	public Line(int x1, int y1, int x2, int y2) {
		this.x1 = x1;
		this.y1 = y1;
		this.x2 = x2;
		this.y2 = y2;
		if (this.x1 > this.x2) {
			this.x1 = x2;
			this.y1 = y2;
			this.x2 = x1;
			this.y2 = y1;
		}
		else if (this.x1 == this.x2) {
			if (this.y1 > this.y2) {
				this.x1 = x2;
				this.y1 = y2;
				this.x2 = x1;
				this.y2 = y1;
			}
		}
	}

	public String toString() {
		return
			this.object_code + " " +
			this.sub_type + " " +
			this.line_style + " " +
			this.thickness + " " +
			this.pen_color + " " +
			this.fill_color + " " +
			this.depth + " " +
			this.pen_style + " " +
			this.area_fill + " " +
			this.style_val + " " +
			this.join_style + " " +
			this.cap_style + " " +
			this.radius + " " +
			this.forward_arrow + " " +
			this.backward_arrow + " " +
			this.npoints + "\r\n       " + 
      (this.forward_arrow == 1 ? "  1 1 1.0 8.00 12.00\r\n" : "") +
      (this.backward_arrow == 1 ? "  1 1 1.0 8.00 12.00\r\n" : "") +
			this.x1 + " " +
			this.y1 + " " +
			this.x2 + " " +
			this.y2;
	}

}