//////////////////////////////////////////////////
// EASIM project
// easim.draw.Oval
// 6/7/2007 4:26 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

public class Oval
{
	int object_code = 1;		//(always 1)
	int sub_type = 1;		//(1: ellipse defined by radiuses
					// 2: ellipse defined by diameters
					// 3: circle defined by radius
					// 4: circle defined by diameter)
	int line_style;		// (1/0) (enumeration type)
	int thickness = 1;		//(1/80 inch)
	int pen_color = 0;		//(enumeration type, pen color)
	int fill_color;		// (4/7) (enumeration type, fill color)
	int depth;			// (888/<)(enumeration type)
	int pen_style = 1;		//(pen style, not used)
	int area_fill;		// (-1/20) (enumeration type, -1 = no fill)
	double style_val = 6.40;		//(1/80 inch)
	int direction = 1;		//(always 1)
	int angle = 0;			//(radians, the angle of the x-axis)
	int center_x;	//(Fig units)
	int center_y;	//(Fig units)
	int radius_x;	//(Fig units)
	int radius_y;	//(Fig units)
	int start_x;	//(Fig units; the 1st point entered)
	int start_y;	//(Fig units; the 1st point entered)
	int end_x;		//(Fig units; the last point entered)
	int end_y;		//(Fig units; the last point entered)

/*
1 1 2 1 0 0 100 1 -1  1.00 1 0.0 -1181 2081 225 225 -1406 1856 -956 2306
1 1 1 1 0 7 899 1 20  1.00 1 0.0 4500 4695 360 360 4140 4335 4860 5055
1 1 0 1 0 7 899 1 20  1.00 1 0.0 6750 6045 360 360 6390 5685 7110 6405
1 1 0 1 0 4 899 1 30  1.00 1 0.0 9225 6945 360 360 8865 6585 9585 7305
*/

	// general setting
	public Oval(int x, int y, int radius) {
		this.center_x = x;
		this.center_y = y;
		this.radius_x = radius;
		this.radius_y = radius;
		this.start_x = x - radius;
		this.start_y = y - radius;
		this.end_x = x + radius;
		this.end_y = y + radius;
	}

	// trajectory
	public void setTrajectory() {
		this.line_style = 2;
		this.fill_color = 0;
		this.depth = 800;
		this.area_fill = -1;
    thickness = 3;
	}

	// invisible node
	public void setDotted(int depth) {
		this.line_style = 1;
		this.fill_color = 7;
		this.depth = depth;
		this.area_fill = 20;
	}

	// static node
	public void setWhite(int depth) {
		this.line_style = 0;
		this.fill_color = 7;
		this.depth = depth;
		this.area_fill = 20;
	}

	// mobile node
	public void setRed(int depth) {
		this.line_style = 0;
		this.fill_color = 4;
		this.depth = depth;
		this.area_fill = 30;
	}

	public String toString() {
		return
			this.object_code + " " +
			this.sub_type + " " +
			this.line_style + " " +
			this.thickness + " " +
			this.pen_color + " " +
			this.fill_color + " " +
			this.depth + " " +
			this.pen_style + " " +
			this.area_fill + " " +
			this.style_val + " " +
			this.direction + " " +
			this.angle + " " +
			this.center_x + " " +
			this.center_y + " " +
			this.radius_x + " " +
			this.radius_y + " " +
			this.start_x + " " +
			this.start_y + " " +
			this.end_x + " " +
			this.end_y;
	}

}
