//////////////////////////////////////////////////
// EASIM project
// easim.draw.Polygon
// 6/7/2007 4:26 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

public class Polygon
{
	int	object_code = 2;		//(always 2)
	int sub_type = 3;		//(1: polyline
					// 2: box
					// 3: polygon
					// 4: arc-box)
					// 5: imported-picture bounding-box)
	int line_style = 0;		// 1: dash line
	int thickness = 1;		//(1/80 inch)
	int pen_color = 0;		//4:red, 10:blue, 15:green
	int fill_color = 0;		//(enumeration type, fill color)
	int depth = 800;			//(enumeration type)
	int pen_style = 1;		//(pen style, not used)
	int area_fill = -1;		//(enumeration type, -1 = no fill)
	double style_val = 6.40;		//(1/80 inch)
	int join_style = 0;		//(enumeration type)
	int cap_style = 0;		//(enumeration type, only used for POLYLINE)
	int radius = 12;			//(1/80 inch, radius of arc-boxes)
	int forward_arrow = 0;		//(0: off, 1: on)
	int backward_arrow = 0;		//(0: off, 1: on)
	int npoints;			//(number of points in line)
	int [][] points;

/*
2 1 2 1 0 0 100 1 -1  1.00 0 0 12 0 0 2
       -900 1125 1350 1125
2 1 0 1 0 0 100 1 -1  6.40 0 0 12 0 0 2
       -450 1800 1800 1800
2 1 0 2 0 0 100 1 -1  6.40 0 0 12 0 0 2
       0 2362 2137 2362

2 3 1 3 4 0 100 1 -1  6.40 0 0 12 0 0 5
       7650 2700 9675 2700 9450 4275 7875 4275
       7650 2700
2 3 0 1 0 0 100 1 -1  6.40 0 0 12 0 0 4
       2475 2250 5175 3150 3375 4950 2475 2250


2 1 0 1 4 0 100 1 -1  6.40 0 0 12 0 0 2 // red
2 1 0 1 10 0 100 1 -1  6.40 0 0 12 0 0 2 // blue
2 1 0 1 15 0 100 1 -1  6.40 0 0 12 0 0 2 // green
*/

	public Polygon(int[][] points) {
		this.npoints = points.length;
		this.points = points;
	}

	// trajectory
	public void setDotted() {
		this.line_style = 2;
		this.fill_color = 0;
		this.depth = 800;
		this.area_fill = -1;
    thickness = 3;
	}

	public String toString() {
		String buf = 
			this.object_code + " " +
			this.sub_type + " " +
			this.line_style + " " +
			this.thickness + " " +
			this.pen_color + " " +
			this.fill_color + " " +
			this.depth + " " +
			this.pen_style + " " +
			this.area_fill + " " +
			this.style_val + " " +
			this.join_style + " " +
			this.cap_style + " " +
			this.radius + " " +
			this.forward_arrow + " " +
			this.backward_arrow + " " +
			this.npoints;
		int count = 0;
		for (int i = 0; i < points.length; ++ i) {
			if (count == 0) buf += "\r\n       ";
			buf += " " + points[i][0] + " " + points[i][1];
			++ count;
			if (count == 4) count = 0;
		}
		return buf;
	}

}