//////////////////////////////////////////////////
// EASIM project
// easim.draw.RemoveLinkControl
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

public class RemoveLinkControl implements Control
{
	public void mousePressed(Frame frame, int x, int y) {
		Node node = frame.field.getNode(x, y);
		if (frame.selectedNode == null) {
			frame.selectedNode = node;
			frame.panel.repaint();
		}
		else {
			if (node == null) {
				frame.selectedNode = null;
				frame.panel.repaint();
			}
			else if (! frame.selectedNode.equals(node)) {
				Link link = frame.field.removeLink(frame.selectedNode.id, node.id);
				if (link == null) {
					frame.selectedNode = node;
				}
				else {
					frame.selectedNode = null;
				}
				frame.panel.repaint();
			}
		}
	}

	public void mouseMoved(Frame frame, int x, int y) {
		AddNodeControl.mouseMoved2(frame, x, y);
	}

	public void mouseDragged(Frame frame, int x, int y) {
		AddNodeControl.mouseDragged2(frame, x, y);
	}
}
