//////////////////////////////////////////////////
// EASIM project
// easim.draw.Setting
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

import java.awt.Color;

public class Setting
{

  public static final String FONT = "Courier New";

	public static class LineStyle {
    private String lineStyle;
    public LineStyle(String lineStyle) {
      this.lineStyle = lineStyle;
    }
		public static final LineStyle SOLID_LINE = new LineStyle("SOLID_LINE");
		public static final LineStyle DASH_LINE = new LineStyle("DASH_LINE");
		public static final LineStyle DOTTED_LINE = new LineStyle("DOTTED_LINE");
		public Color getColor() {
      if (this == SOLID_LINE) return Color.BLACK;
      if (this == DASH_LINE) return Color.BLUE;
      if (this == DOTTED_LINE) return Color.GREEN;
      return null;
		}
		public static LineStyle getValue(String name) {
      if (name.equals("SOLID_LINE")) return SOLID_LINE;
      if (name.equals("DASH_LINE")) return DASH_LINE;
      if (name.equals("DOTTED_LINE")) return DOTTED_LINE;
			return null;
		}
    public String toString() {
      return lineStyle;
    }
    public static LineStyle[] values() {
      return new LineStyle[] {SOLID_LINE, DASH_LINE, DOTTED_LINE};
    }
	}

	public static class NodeLabels
  {
		public static final NodeLabels NUMBERS = new NodeLabels();
		public static final NodeLabels ALPHABET = new NodeLabels();
    public static NodeLabels[] values() {
      return new NodeLabels[] {NUMBERS, ALPHABET};
    }
    public String toString() {
      if (this == NUMBERS) return "NUMBERS";
      if (this == ALPHABET) return "ALPHABET";
      return null;
    }
  }

	public static class Arrow
  {
		public static final Arrow NONE = new Arrow();
		public static final Arrow ARROW1 = new Arrow();
		public static final Arrow ARROW2 = new Arrow();
		public static final Arrow ARROW_BOTH = new Arrow();
    public static Arrow[] values() {
      return new Arrow[] {NONE, ARROW1, ARROW2, ARROW_BOTH};
    }
    public String toString() {
      if (this == NONE) return "NONE";
      if (this == ARROW1) return "ARROW1";
      if (this == ARROW2) return "ARROW2";
      if (this == ARROW_BOTH) return "ARROW_BOTH";
      return null;
    }
  }

}
