//////////////////////////////////////////////////
// EASIM project
// easim.draw.SettingMenu
// 6/7/2007 3:03 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SettingMenu extends JMenu
{
	private Frame frame;
	private JMenuItem lineStyle;
	private JMenuItem nodeLabels;
	private JMenuItem nodeSize;
	private JMenuItem thickness;
	private JMenuItem arrow;

	public SettingMenu(Frame frame) {
		super("Setting");
		this.frame = frame;
		this.lineStyle = new JMenuItem("Line Style : " + this.frame.lineStyle);
		this.nodeLabels = new JMenuItem("Node Labels : " + this.frame.nodeLabels);
		this.nodeSize = new JMenuItem("Node Size : " + this.frame.nodeSize);
		this.thickness = new JMenuItem("Thickness : " + this.frame.thickness);
		this.arrow = new JMenuItem("Arrow : " + this.frame.arrow);
		this.add(this.lineStyle);
		this.add(this.nodeLabels);
		this.add(this.nodeSize);
		this.add(this.thickness);
		this.add(this.arrow);
		this.lineStyle.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				lineStyle();
			}
		});
		this.nodeLabels.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				nodeLabels();
			}
		});
		this.nodeSize.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				nodeSize();
			}
		});
		this.thickness.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				thickness();
			}
		});
		this.arrow.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				arrow();
			}
		});
	}

	private void lineStyle() {
		Setting.LineStyle lineStyle = lineStyle(this.frame, "Setting");
		if (lineStyle == null) return;
		this.frame.lineStyle = lineStyle;
		this.lineStyle.setText("Line Style : " + this.frame.lineStyle);
		this.frame.validate();
	}

	private void nodeLabels() {
		Setting.NodeLabels nodeLabels = nodeLabels(this.frame, "Setting");
		if (nodeLabels == null) return;
		this.frame.nodeLabels = nodeLabels;
		this.nodeLabels.setText("Node Labels : " + this.frame.nodeLabels);
		this.frame.validate();
	}

	private void nodeSize() {
		int nodeSize = nodeSize(this.frame, "Setting");
		if (nodeSize == -1) return;
		this.frame.nodeSize = nodeSize;
		this.nodeSize.setText("Node Size : " + this.frame.nodeSize);
		this.frame.validate();
	}

	private void thickness() {
		int thickness = thickness(this.frame, "Setting");
		if (thickness == -1) return;
		this.frame.thickness = thickness;
		this.thickness.setText("Thickness : " + this.frame.thickness);
		this.frame.validate();
	}

	private void arrow() {
		Setting.Arrow arrow = arrow(this.frame, "Setting");
		if (arrow == null) return;
		this.frame.arrow = arrow;
		this.arrow.setText("Line Style : " + this.frame.arrow);
		this.frame.validate();
	}

	public static Setting.LineStyle lineStyle(Frame frame, String title) {
		return (Setting.LineStyle)JOptionPane.showInputDialog(
			frame, "Line Style", title,
			JOptionPane.QUESTION_MESSAGE, null, Setting.LineStyle.values(), null);
	}

	public static Setting.NodeLabels nodeLabels(Frame frame, String title) {
		return (Setting.NodeLabels)JOptionPane.showInputDialog(
			frame, "Node Labels", title,
			JOptionPane.QUESTION_MESSAGE, null, Setting.NodeLabels.values(), null);
	}

	public static int nodeSize(Frame frame, String title) {
		Integer[] sizes = new Integer[Field.MAX_NODE_SIZE - Field.MIN_NODE_SIZE + 1];
		for (int i = 0; i < sizes.length; ++ i) {
			sizes[i] = new Integer(Field.MIN_NODE_SIZE + i);
		}
		Integer size = (Integer) JOptionPane.showInputDialog(
			frame, "Node Size", title,
			JOptionPane.QUESTION_MESSAGE, null, sizes, null);
		if (size == null) return -1;
		return size.intValue();
	}

	public static int thickness(Frame frame, String title) {
		Integer[] thicknesses = new Integer[Field.MAX_THICKNESS];
		for (int i = 0; i < thicknesses.length; ++ i) {
			thicknesses[i] = new Integer(i + 1);
		}
		Integer thickness = (Integer) JOptionPane.showInputDialog(
			frame, "Ring Thickness", title,
			JOptionPane.QUESTION_MESSAGE, null, thicknesses, null);
		if (thickness == null) return -1;
		return thickness.intValue();
	}

	public static Setting.Arrow arrow(Frame frame, String title) {
		return (Setting.Arrow)JOptionPane.showInputDialog(
			frame, "Arrow", title,
			JOptionPane.QUESTION_MESSAGE, null, Setting.Arrow.values(), null);
	}
}