//////////////////////////////////////////////////
// EASIM project
// easim.draw.Text
// 6/7/2007 4:26 PM
// Cong Liu
// gzcong@gmail.com

// Copyright (C) 2007
// All rights reserved.
// Refer to LICENSE of JIST (Java In Simulation Time) for terms and conditions of use.

package easim.draw;

public class Text
{
	int object = 4; 			//(always 4)
	int sub_type = 0;		//(0: Left justified
					     //1: Center justified
					     //2: Right justified)
	int color = 0;			//(enumeration type)
	int depth;			//(enumeration type)
	int pen_style = 1;		//(enumeration , not used)
	int font = 12;	//Courier		//(enumeration type)
	int font_size; 		//(font size in points)
	int angle = 0;			//(radians, the angle of the text)
	int font_flags = 4;		//(bit vector)
	int height;			//(Fig units)
	int length;			//(Fig units)
	int x;
	int y;			//(Fig units, coordinate of the origin
					// of the string.  If sub_type = 0, it is
					// the lower left corner of the string.
					// If sub_type = 1, it is the lower
					// center.  Otherwise it is the lower
					// right corner of the string.)
	String string;		//(ASCII characters; starts after a blank
					// character following the last number and
					// ends before the sequence '\001'.  This
					// sequence is not part of the string.
					// Characters above octal 177 are
					// represented by \xxx where xxx is the
					// octal value.  This permits fig files to
					// be edited with 7-bit editors and sent
					// by e-mail without data loss.
					// Note that the string may contain '\n'.)

	public Text(int x, int y, String string, int font_size, int stringWidth, int depth) {
		this.x = x;
		this.y = y;
		this.string = string + "\\001";
		this.font_size = font_size;
		this.height = - font_size;
		this.length = stringWidth;
		this.depth = depth;
	}

	public String toString() {
		return
			this.object + " " +
			this.sub_type + " " +
			this.color + " " +
			this.depth + " " +
			this.pen_style + " " +
			this.font + " " +
			(double)this.font_size + " " +
			this.angle + " " +
			this.font_flags + " " +
			this.height + " " +
			this.length + " " +
			this.x + " " +
			this.y + " " +
			this.string;
	}

}
