#pragma num_alias_table_entries	14

mtimer repeating ms_timer = 1000;

IO_4 input totalcount mux io_count;
IO_5 input bit io_speed_negative;
IO_6 input bit io_speed_positive;

IO_0 output bit io_direct;
IO_1 output pulsewidth clock(7) io_PWM;
IO_2 output bit net_monitor;

network input SNVT_switch nvimotorspeed;

network output SNVT_switch nvomotorspeed;
network output SNVT_count nvocount;

unsigned int PWM = 0;
unsigned int direct = 0;
signed int motor_speed = 0;

//Counting the motor speed per 1 second.
when(timer_expires(ms_timer)) 			
{
	nvocount = io_in(io_count);
}


//Input a value and state at Network Browse to control the motor speed and direction.
when(nv_update_occurs(nvimotorspeed))		
{
	direct = nvimotorspeed.state;
	if(direct == 0)
	{
		motor_speed = nvimotorspeed.value / 2;
		PWM = motor_speed * 255 / 100;
	}
	else
	{
		motor_speed = -(nvimotorspeed.value / 2);
		PWM = -motor_speed * 255 / 100;
	}
	io_out(net_monitor, 1);
	io_out(io_direct, direct);
	io_out(io_PWM, PWM);
	nvomotorspeed.state = nvimotorspeed.state;
	nvomotorspeed.value = nvimotorspeed.value;
}


//When direction is positive,the motor is speed up.
//When direction is negative,the motor is slow down.
//When the speed is maximum, the motor speed is constant.
when(io_changes(io_speed_positive) to 0)
{
	nvimotorspeed.state = 0;
	nvimotorspeed.value = 0;
	io_out(net_monitor, 0);
	if (motor_speed < 75)
	{
		motor_speed = motor_speed + 25;
		if (motor_speed >= 0)
		{	
			PWM = motor_speed * 255 / 100;
			io_out(io_direct, 0);
			io_out(io_PWM, PWM);
			nvomotorspeed.value = motor_speed * 2;
			nvomotorspeed.state = 0;
		}
		else
		{
			PWM = -motor_speed * 255 / 100;
			io_out(io_direct, 1);
			io_out(io_PWM, PWM);
			nvomotorspeed.value = -motor_speed * 2;
			nvomotorspeed.state = 1;	
		}
	}
	else
	{
		motor_speed = 100;
		PWM = 255;
		io_out(io_direct, 0);	
		io_out(io_PWM, PWM);
		nvomotorspeed.value = motor_speed * 2;
		nvomotorspeed.state = 0;
	}
}


//When direction is negative,the motor is speed up.
//When direction is positive,the motor is slow down.
//When the speed is maximum, the motor speed is constant.
when(io_changes(io_speed_negative) to 0)
{
	nvimotorspeed.state = 0;
	nvimotorspeed.value = 0;
	io_out(net_monitor, 0);
	if(motor_speed > -75)
	{
		motor_speed = motor_speed - 25;
		if(motor_speed >= 0)
		{	
			PWM = motor_speed * 255 / 100;
			io_out(io_direct, 0);
			io_out(io_PWM, PWM);
			nvomotorspeed.value = motor_speed * 2;
			nvomotorspeed.state = 0;
		}
		else
		{
			PWM = -motor_speed * 255 / 100;
			io_out(io_direct, 1);
			io_out(io_PWM, PWM);	
			nvomotorspeed.value = -motor_speed * 2;
			nvomotorspeed.state = 1;	
		}
	}
	else
	{
		motor_speed = -100;
		PWM = 255;
		io_out(io_direct, 1);	
		io_out(io_PWM, PWM);
		nvomotorspeed.value = -motor_speed * 2;
		nvomotorspeed.state = 1;
	}
}