/*----------------------------------------------------------------------------------+
|                                                                                   |
|          Interfacing the DS1620 for AT89C52 that via the comport control          |
|                                                                                   |
|                                                                                   |
| Name: DemoMain.c                                                                  |
| Purpose:                                                                          |
|    Interfacing the DS1620 via the comport, measure temperature form -55 to +125   | 
|    This note introduces the software for interfacing a 8052 microcontroller to the|
|    DS1620 digital temperature sensor. The DS1620 communicates via a 3-wire serial |
|    digital interface. Software code is provide that reads the DS1620 temperaure   |
|    register and calculates high-resolution results.                               |
|                                                                                   |
| By Dillian Wong, last modify data 4/10/03                                         |
+----------------------------------------------------------------------------------*/

/*____________ I N C L U D E S ____________________________________________________*/

#include <reg51.h>
#include <stdio.h>
#include "DS1620\DS1620.h"
#include "rPrintf\rprintf.h"


/*____________ M A I N  P R O G R A M ______________________________________________*/

char code menu[] = // menu of programmer
	"\n--Digital Thermometer-2-"
	"\ns set temperature "
	"\nr read temperature"
	"\nh read TH"
	"\nl read TL"
	;

// com port with 9600 baud with crystal 11.0592MHz.
void init_uart(void)
{
	SCON  = 0x50;		        
    TMOD |= 0x20;               
    TH1   = 253;                
    TR1   = 1;                 
    TI    = 1; 
}

void main(void)
{
	int i;
	char cmd;		// selection 
	float fh;		// high temperature limit
	float fl;		// low temperature limit

	init_uart();	// utilize rs232 port

	printf(menu);
	while(1){
		printf( "\n[Enter selection:] " );
		scanf("%c", &cmd);
		switch(cmd)
		{
			case 's':
						// enter higher limit.
						printf("\nEnter Higher Temperature limit  :");
					 	scanf("%f",&fh);
						while(fh>125)
						{
							printf("\nhigh temperature limited to +125! ");
							printf("\nEnter Higher Temperature limit again :");
							scanf("%f",&fh);
						}
						// enter lower limit.
						printf("Enter Lower Temperture limit  :");
						scanf("%f",&fl);
						while(fl<-55)
						{
							printf("\nLower temperature limited to -55");
							printf("\nEnter Lower Temperture limit again :");
							scanf("%f",&fl);
						}
						// start setting.
						printf("\nstart program Ds1620\n");						
						ds1620_init(fh,fl);
						printf("\nSet Temperature complete!");					
					
						break;
			case 'r':
						for(i=0;i<200;i++);
						printf("\nCurrent temperature is: ");
						printf("%f",ds1620_ReadTemperature());
						break;
			case 'h':
						for(i=0;i<200;i++);					
						printf("\nHigh temperature limit: %f",ds1620_ReadTH());
						break;
			case 'l':
						for(i=0;i<200;i++);
						printf("\nLow temperature limit: %f",ds1620_ReadTL());
						break;
			case '?':
						printf(menu);
						break;
			default:
						printf("\nInvilad key!");
						break;
		}
	
	
	}

}


